/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.util;

import com.intellij.codeInsight.folding.impl.FoldingUtil;
import com.intellij.diff.util.DiffDrawUtil;
import com.intellij.diff.util.DiffLineSeparatorRenderer;
import com.intellij.diff.util.DiffUtil;
import com.intellij.diff.util.LineRange;
import com.intellij.diff.util.TextDiffType;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.ex.util.EditorUtil;
import com.intellij.openapi.editor.impl.Interval;
import com.intellij.openapi.ui.GraphicsConfig;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.util.IntPair;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.GraphicsUtil;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Stroke;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.JComponent;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class DiffDividerDrawUtil {
    public static final BasicStroke BOLD_DOTTED_STROKE = new BasicStroke(2.3f, 0, 0, 10.0f, new float[]{2.0f, 2.0f}, 0.0f);

    @NotNull
    public static Graphics2D getDividerGraphics(@NotNull Graphics g, @NotNull Component divider, @NotNull Component base) {
        if (g == null) {
            DiffDividerDrawUtil.$$$reportNull$$$0(0);
        }
        if (divider == null) {
            DiffDividerDrawUtil.$$$reportNull$$$0(1);
        }
        if (base == null) {
            DiffDividerDrawUtil.$$$reportNull$$$0(2);
        }
        int width = divider.getWidth();
        int editorHeight = base.getHeight();
        int dividerOffset = divider.getLocationOnScreen().y;
        int editorOffset = base.getLocationOnScreen().y;
        Graphics2D graphics2D = (Graphics2D)g.create(0, editorOffset - dividerOffset, width, editorHeight);
        if (graphics2D == null) {
            DiffDividerDrawUtil.$$$reportNull$$$0(3);
        }
        return graphics2D;
    }

    public static void paintSeparators(@NotNull Graphics2D gg, int width, @NotNull Editor editor1, @NotNull Editor editor2, @NotNull DividerSeparatorPaintable paintable) {
        if (gg == null) {
            DiffDividerDrawUtil.$$$reportNull$$$0(4);
        }
        if (editor1 == null) {
            DiffDividerDrawUtil.$$$reportNull$$$0(5);
        }
        if (editor2 == null) {
            DiffDividerDrawUtil.$$$reportNull$$$0(6);
        }
        if (paintable == null) {
            DiffDividerDrawUtil.$$$reportNull$$$0(7);
        }
        ReadAction.run(() -> {
            List<DividerSeparator> polygons = DiffDividerDrawUtil.createVisibleSeparators(editor1, editor2, paintable, gg.getClipBounds());
            GraphicsConfig config = GraphicsUtil.setupAAPainting((Graphics)gg);
            for (DividerSeparator polygon : polygons) {
                polygon.paint(gg, width);
            }
            config.restore();
        });
    }

    public static void paintPolygons(@NotNull Graphics2D gg, int width, @NotNull Editor editor1, @NotNull Editor editor2, @NotNull DividerPaintable paintable) {
        if (gg == null) {
            DiffDividerDrawUtil.$$$reportNull$$$0(8);
        }
        if (editor1 == null) {
            DiffDividerDrawUtil.$$$reportNull$$$0(9);
        }
        if (editor2 == null) {
            DiffDividerDrawUtil.$$$reportNull$$$0(10);
        }
        if (paintable == null) {
            DiffDividerDrawUtil.$$$reportNull$$$0(11);
        }
        DiffDividerDrawUtil.paintPolygons(gg, width, true, editor1, editor2, paintable);
    }

    public static void paintPolygons(@NotNull Graphics2D gg, int width, boolean curved, @NotNull Editor editor1, @NotNull Editor editor2, @NotNull DividerPaintable paintable) {
        if (gg == null) {
            DiffDividerDrawUtil.$$$reportNull$$$0(12);
        }
        if (editor1 == null) {
            DiffDividerDrawUtil.$$$reportNull$$$0(13);
        }
        if (editor2 == null) {
            DiffDividerDrawUtil.$$$reportNull$$$0(14);
        }
        if (paintable == null) {
            DiffDividerDrawUtil.$$$reportNull$$$0(15);
        }
        ReadAction.run(() -> {
            List<DividerPolygon> polygons = DiffDividerDrawUtil.createVisiblePolygons(editor1, editor2, paintable, gg.getClipBounds());
            GraphicsConfig config = GraphicsUtil.setupAAPainting((Graphics)gg);
            for (DividerPolygon polygon : polygons) {
                polygon.paint(gg, width, curved);
            }
            config.restore();
        });
    }

    @NotNull
    private static List<DividerPolygon> createVisiblePolygons(@NotNull Editor editor1, @NotNull Editor editor2, @NotNull DividerPaintable paintable, @NotNull Rectangle paintedArea) {
        if (editor1 == null) {
            DiffDividerDrawUtil.$$$reportNull$$$0(16);
        }
        if (editor2 == null) {
            DiffDividerDrawUtil.$$$reportNull$$$0(17);
        }
        if (paintable == null) {
            DiffDividerDrawUtil.$$$reportNull$$$0(18);
        }
        if (paintedArea == null) {
            DiffDividerDrawUtil.$$$reportNull$$$0(19);
        }
        if (editor1.isDisposed() || editor2.isDisposed()) {
            List<DividerPolygon> list = Collections.emptyList();
            if (list == null) {
                DiffDividerDrawUtil.$$$reportNull$$$0(20);
            }
            return list;
        }
        IntPair yRange = new IntPair(paintedArea.y, paintedArea.y + paintedArea.height);
        DividerPaintableHandlerImpl handler = new DividerPaintableHandlerImpl(editor1, editor2, yRange);
        paintable.process(handler);
        List<DividerPolygon> list = handler.getPolygons();
        if (list == null) {
            DiffDividerDrawUtil.$$$reportNull$$$0(21);
        }
        return list;
    }

    @ApiStatus.Internal
    public static boolean isIntervalFolded(@NotNull Editor editor, int startLine, int endLine) {
        if (editor == null) {
            DiffDividerDrawUtil.$$$reportNull$$$0(22);
        }
        TextRange range = DiffUtil.getLinesRange(editor.getDocument(), startLine, endLine);
        return FoldingUtil.isTextRangeFolded((Editor)editor, (TextRange)range);
    }

    @NotNull
    private static List<DividerSeparator> createVisibleSeparators(@NotNull Editor editor1, @NotNull Editor editor2, @NotNull DividerSeparatorPaintable paintable, @NotNull Rectangle paintedArea) {
        if (editor1 == null) {
            DiffDividerDrawUtil.$$$reportNull$$$0(23);
        }
        if (editor2 == null) {
            DiffDividerDrawUtil.$$$reportNull$$$0(24);
        }
        if (paintable == null) {
            DiffDividerDrawUtil.$$$reportNull$$$0(25);
        }
        if (paintedArea == null) {
            DiffDividerDrawUtil.$$$reportNull$$$0(26);
        }
        if (editor1.isDisposed() || editor2.isDisposed()) {
            List<DividerSeparator> list = Collections.emptyList();
            if (list == null) {
                DiffDividerDrawUtil.$$$reportNull$$$0(27);
            }
            return list;
        }
        ArrayList<DividerSeparator> separators = new ArrayList<DividerSeparator>();
        IntPair yRange = new IntPair(paintedArea.y, paintedArea.y + paintedArea.height);
        LineRange leftInterval = DiffDividerDrawUtil.getPaintedInterval(editor1, yRange);
        LineRange rightInterval = DiffDividerDrawUtil.getPaintedInterval(editor2, yRange);
        int height1 = editor1.getLineHeight();
        int height2 = editor2.getLineHeight();
        EditorColorsScheme scheme = editor1.getColorsScheme();
        paintable.process((line1, line2, isHovered) -> {
            if (leftInterval.start > line1 + 1 && rightInterval.start > line2 + 1) {
                return true;
            }
            if (leftInterval.end < line1 && rightInterval.end < line2) {
                return false;
            }
            separators.add(DiffDividerDrawUtil.createSeparator(editor1, editor2, line1, line2, height1, height2, isHovered, scheme));
            return true;
        });
        ArrayList<DividerSeparator> arrayList = separators;
        if (arrayList == null) {
            DiffDividerDrawUtil.$$$reportNull$$$0(28);
        }
        return arrayList;
    }

    @ApiStatus.Internal
    public static int getEditorTopOffset(@NotNull Editor editor) {
        JComponent header;
        if (editor == null) {
            DiffDividerDrawUtil.$$$reportNull$$$0(29);
        }
        int headerOffset = (header = editor.getHeaderComponent()) == null ? 0 : header.getHeight();
        return -editor.getScrollingModel().getVerticalScrollOffset() + headerOffset;
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    private static DiffDrawUtil.MarkerRange getDividerMarkerPaintRange(@NotNull Editor editor, int startLine, int endLine) {
        if (editor == null) {
            DiffDividerDrawUtil.$$$reportNull$$$0(30);
        }
        @NotNull @Nullable Pair pair1 = EditorUtil.logicalLineToYRange((Editor)editor, (int)startLine);
        @NotNull @Nullable Pair pair2 = startLine == endLine ? pair1 : EditorUtil.logicalLineToYRange((Editor)editor, (int)(endLine - 1));
        int startOffset = ((Interval)pair1.first).intervalStart();
        int endOffset = ((Interval)pair2.first).intervalEnd();
        return new DiffDrawUtil.MarkerRange(startOffset, endOffset);
    }

    @NotNull
    private static DividerSeparator createSeparator(@NotNull Editor editor1, @NotNull Editor editor2, int line1, int line2, int height1, int height2, boolean isHovered, @Nullable EditorColorsScheme scheme) {
        if (editor1 == null) {
            DiffDividerDrawUtil.$$$reportNull$$$0(31);
        }
        if (editor2 == null) {
            DiffDividerDrawUtil.$$$reportNull$$$0(32);
        }
        int topOffset1 = DiffDividerDrawUtil.getEditorTopOffset(editor1);
        int topOffset2 = DiffDividerDrawUtil.getEditorTopOffset(editor2);
        int start1 = DiffDrawUtil.lineToY(editor1, line1) + topOffset1;
        int start2 = DiffDrawUtil.lineToY(editor2, line2) + topOffset2;
        return new DividerSeparator(start1, start2, start1 + height1, start2 + height2, isHovered, scheme);
    }

    @ApiStatus.Internal
    @NotNull
    public static LineRange getPaintedInterval(@NotNull Editor editor, @NotNull IntPair yRange) {
        int yEnd;
        int visibleAreaYOffset;
        int yStart;
        if (editor == null) {
            DiffDividerDrawUtil.$$$reportNull$$$0(33);
        }
        if (yRange == null) {
            DiffDividerDrawUtil.$$$reportNull$$$0(34);
        }
        if ((yStart = (visibleAreaYOffset = editor.getScrollingModel().getVerticalScrollOffset()) + yRange.first) >= (yEnd = visibleAreaYOffset + yRange.second)) {
            return new LineRange(0, 0);
        }
        LineRange lineRange = (LineRange)ReadAction.compute(() -> {
            LogicalPosition position1 = editor.xyToLogicalPosition(new Point(0, yStart));
            LogicalPosition position2 = editor.xyToLogicalPosition(new Point(0, yEnd));
            return new LineRange(position1.line, position2.line);
        });
        if (lineRange == null) {
            DiffDividerDrawUtil.$$$reportNull$$$0(35);
        }
        return lineRange;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 20, 21, 27, 28, 35 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "g";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "divider";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "base";
                break;
            }
            case 3: 
            case 20: 
            case 21: 
            case 27: 
            case 28: 
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/diff/util/DiffDividerDrawUtil";
                break;
            }
            case 4: 
            case 8: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "gg";
                break;
            }
            case 5: 
            case 9: 
            case 13: 
            case 16: 
            case 23: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor1";
                break;
            }
            case 6: 
            case 10: 
            case 14: 
            case 17: 
            case 24: 
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor2";
                break;
            }
            case 7: 
            case 11: 
            case 15: 
            case 18: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "paintable";
                break;
            }
            case 19: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "paintedArea";
                break;
            }
            case 22: 
            case 29: 
            case 30: 
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "yRange";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/diff/util/DiffDividerDrawUtil";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getDividerGraphics";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "createVisiblePolygons";
                break;
            }
            case 27: 
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "createVisibleSeparators";
                break;
            }
            case 35: {
                objectArray = objectArray2;
                objectArray2[1] = "getPaintedInterval";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getDividerGraphics";
                break;
            }
            case 3: 
            case 20: 
            case 21: 
            case 27: 
            case 28: 
            case 35: {
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "paintSeparators";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "paintPolygons";
                break;
            }
            case 16: 
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "createVisiblePolygons";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "isIntervalFolded";
                break;
            }
            case 23: 
            case 24: 
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "createVisibleSeparators";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "getEditorTopOffset";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "getDividerMarkerPaintRange";
                break;
            }
            case 31: 
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "createSeparator";
                break;
            }
            case 33: 
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "getPaintedInterval";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 20, 21, 27, 28, 35 -> new IllegalStateException(string);
        };
    }

    public static interface DividerSeparatorPaintable {
        public void process(@NotNull Handler var1);

        public static interface Handler {
            public boolean process(int var1, int var2, boolean var3);
        }
    }

    public static interface DividerPaintable {
        public void process(@NotNull Handler var1);

        public static interface Handler {
            public boolean process(int var1, int var2, int var3, int var4, @NotNull TextDiffType var5);

            public boolean processResolvable(int var1, int var2, int var3, int var4, @NotNull TextDiffType var5, boolean var6);

            public boolean processExcludable(int var1, int var2, int var3, int var4, @NotNull TextDiffType var5, boolean var6, boolean var7);

            public boolean processAligned(int var1, int var2, int var3, int var4, @NotNull TextDiffType var5);
        }
    }

    @ApiStatus.Internal
    public static class DividerPaintableHandlerImpl
    implements DividerPaintable.Handler {
        private final Editor myEditor1;
        private final Editor myEditor2;
        private final LineRange myLeftInterval;
        private final LineRange myRightInterval;
        private final List<DividerPolygon> myPolygons;

        @ApiStatus.Internal
        public DividerPaintableHandlerImpl(@NotNull Editor editor1, @NotNull Editor editor2, @NotNull IntPair yRange) {
            if (editor1 == null) {
                DividerPaintableHandlerImpl.$$$reportNull$$$0(0);
            }
            if (editor2 == null) {
                DividerPaintableHandlerImpl.$$$reportNull$$$0(1);
            }
            if (yRange == null) {
                DividerPaintableHandlerImpl.$$$reportNull$$$0(2);
            }
            this.myPolygons = new ArrayList<DividerPolygon>();
            this.myEditor1 = editor1;
            this.myEditor2 = editor2;
            this.myLeftInterval = DiffDividerDrawUtil.getPaintedInterval(editor1, yRange);
            this.myRightInterval = DiffDividerDrawUtil.getPaintedInterval(editor2, yRange);
        }

        @NotNull
        public List<DividerPolygon> getPolygons() {
            List<DividerPolygon> list = this.myPolygons;
            if (list == null) {
                DividerPaintableHandlerImpl.$$$reportNull$$$0(3);
            }
            return list;
        }

        @Override
        public boolean process(int startLine1, int endLine1, int startLine2, int endLine2, @NotNull TextDiffType type) {
            if (type == null) {
                DividerPaintableHandlerImpl.$$$reportNull$$$0(4);
            }
            return this.process(startLine1, endLine1, startLine2, endLine2, new DefaultPainter(type));
        }

        @Override
        public boolean processResolvable(int startLine1, int endLine1, int startLine2, int endLine2, @NotNull TextDiffType type, boolean resolved) {
            if (type == null) {
                DividerPaintableHandlerImpl.$$$reportNull$$$0(5);
            }
            return this.process(startLine1, endLine1, startLine2, endLine2, new ResolvablePainter(type, resolved));
        }

        @Override
        public boolean processExcludable(int startLine1, int endLine1, int startLine2, int endLine2, @NotNull TextDiffType type, boolean excluded, boolean skipped) {
            if (type == null) {
                DividerPaintableHandlerImpl.$$$reportNull$$$0(6);
            }
            return this.process(startLine1, endLine1, startLine2, endLine2, new ExcludablePainter(type, excluded, skipped));
        }

        @Override
        public boolean processAligned(int startLine1, int endLine1, int startLine2, int endLine2, @NotNull TextDiffType type) {
            if (type == null) {
                DividerPaintableHandlerImpl.$$$reportNull$$$0(7);
            }
            if (type == TextDiffType.INSERTED || type == TextDiffType.DELETED) {
                return this.process(startLine1, endLine1, startLine2, endLine2, new DefaultPainter(type), true);
            }
            return this.process(startLine1, endLine1, startLine2, endLine2, type);
        }

        private boolean process(int startLine1, int endLine1, int startLine2, int endLine2, @NotNull Painter painter) {
            if (painter == null) {
                DividerPaintableHandlerImpl.$$$reportNull$$$0(8);
            }
            return this.process(startLine1, endLine1, startLine2, endLine2, painter, false);
        }

        private boolean process(int startLine1, int endLine1, int startLine2, int endLine2, @NotNull Painter painter, boolean withAlignedHeight) {
            if (painter == null) {
                DividerPaintableHandlerImpl.$$$reportNull$$$0(9);
            }
            if (this.myLeftInterval.start > endLine1 && this.myRightInterval.start > endLine2) {
                return true;
            }
            if (this.myLeftInterval.end < startLine1 && this.myRightInterval.end < startLine2) {
                return false;
            }
            DividerPolygon polygon = DividerPaintableHandlerImpl.createPolygon(this.myEditor1, this.myEditor2, startLine1, endLine1, startLine2, endLine2, painter);
            if (withAlignedHeight && polygon != null) {
                polygon = polygon.withAlignedHeight();
            }
            ContainerUtil.addIfNotNull(this.myPolygons, (Object)polygon);
            return true;
        }

        @Nullable
        private static DividerPolygon createPolygon(@NotNull Editor editor1, @NotNull Editor editor2, int startLine1, int endLine1, int startLine2, int endLine2, @NotNull Painter painter) {
            boolean isFolded;
            if (editor1 == null) {
                DividerPaintableHandlerImpl.$$$reportNull$$$0(10);
            }
            if (editor2 == null) {
                DividerPaintableHandlerImpl.$$$reportNull$$$0(11);
            }
            if (painter == null) {
                DividerPaintableHandlerImpl.$$$reportNull$$$0(12);
            }
            int topOffset1 = DiffDividerDrawUtil.getEditorTopOffset(editor1);
            int topOffset2 = DiffDividerDrawUtil.getEditorTopOffset(editor2);
            boolean isFolded1 = DiffDividerDrawUtil.isIntervalFolded(editor1, startLine1, endLine1);
            boolean isFolded2 = DiffDividerDrawUtil.isIntervalFolded(editor2, startLine2, endLine2);
            boolean bl = isFolded = isFolded1 && isFolded2;
            if (isFolded && !painter.isAlwaysVisible()) {
                return null;
            }
            DiffDrawUtil.MarkerRange range1 = isFolded1 ? DiffDividerDrawUtil.getDividerMarkerPaintRange(editor1, startLine1, endLine1) : DiffDrawUtil.getGutterMarkerPaintRange(editor1, startLine1, endLine1);
            DiffDrawUtil.MarkerRange range2 = isFolded2 ? DiffDividerDrawUtil.getDividerMarkerPaintRange(editor2, startLine2, endLine2) : DiffDrawUtil.getGutterMarkerPaintRange(editor2, startLine2, endLine2);
            return new DividerPolygon(range1.y1 + topOffset1, range2.y1 + topOffset2, range1.y2 + topOffset1, range2.y2 + topOffset2, painter.getFillColor(editor2, isFolded), painter.getBorderColor(editor2, isFolded), painter.isDottedBorder());
        }

        @NotNull
        private static TextDiffType correctType(@NotNull TextDiffType type, boolean isFolded) {
            if (type == null) {
                DividerPaintableHandlerImpl.$$$reportNull$$$0(13);
            }
            if (isFolded && (type == TextDiffType.DELETED || type == TextDiffType.INSERTED)) {
                TextDiffType textDiffType = TextDiffType.MODIFIED;
                if (textDiffType == null) {
                    DividerPaintableHandlerImpl.$$$reportNull$$$0(14);
                }
                return textDiffType;
            }
            TextDiffType textDiffType = type;
            if (textDiffType == null) {
                DividerPaintableHandlerImpl.$$$reportNull$$$0(15);
            }
            return textDiffType;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 3, 14, 15 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "editor1";
                    break;
                }
                case 1: 
                case 11: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "editor2";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "yRange";
                    break;
                }
                case 3: 
                case 14: 
                case 15: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/diff/util/DiffDividerDrawUtil$DividerPaintableHandlerImpl";
                    break;
                }
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 13: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "type";
                    break;
                }
                case 8: 
                case 9: 
                case 12: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "painter";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/diff/util/DiffDividerDrawUtil$DividerPaintableHandlerImpl";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getPolygons";
                    break;
                }
                case 14: 
                case 15: {
                    objectArray = objectArray2;
                    objectArray2[1] = "correctType";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 3: 
                case 14: 
                case 15: {
                    break;
                }
                case 4: 
                case 8: 
                case 9: {
                    objectArray = objectArray;
                    objectArray[2] = "process";
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "processResolvable";
                    break;
                }
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "processExcludable";
                    break;
                }
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "processAligned";
                    break;
                }
                case 10: 
                case 11: 
                case 12: {
                    objectArray = objectArray;
                    objectArray[2] = "createPolygon";
                    break;
                }
                case 13: {
                    objectArray = objectArray;
                    objectArray[2] = "correctType";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 3, 14, 15 -> new IllegalStateException(string);
            };
        }

        @ApiStatus.Internal
        public static class DefaultPainter
        implements Painter {
            private final TextDiffType myType;

            @ApiStatus.Internal
            public DefaultPainter(@NotNull TextDiffType type) {
                if (type == null) {
                    DefaultPainter.$$$reportNull$$$0(0);
                }
                this.myType = type;
            }

            @Override
            @Nullable
            public Color getFillColor(@NotNull Editor editor, boolean isFolded) {
                if (editor == null) {
                    DefaultPainter.$$$reportNull$$$0(1);
                }
                return DividerPaintableHandlerImpl.correctType(this.myType, isFolded).getColor(editor);
            }

            @Override
            @Nullable
            public Color getBorderColor(@NotNull Editor editor, boolean isFolded) {
                if (editor == null) {
                    DefaultPainter.$$$reportNull$$$0(2);
                }
                return null;
            }

            @Override
            public boolean isDottedBorder() {
                return false;
            }

            @Override
            public boolean isAlwaysVisible() {
                return true;
            }

            @Override
            @NotNull
            public TextDiffType getType() {
                TextDiffType textDiffType = this.myType;
                if (textDiffType == null) {
                    DefaultPainter.$$$reportNull$$$0(3);
                }
                return textDiffType;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n) {
                    default -> 3;
                    case 3 -> 2;
                }];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "type";
                        break;
                    }
                    case 1: 
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "editor";
                        break;
                    }
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/diff/util/DiffDividerDrawUtil$DividerPaintableHandlerImpl$DefaultPainter";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/diff/util/DiffDividerDrawUtil$DividerPaintableHandlerImpl$DefaultPainter";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getType";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "<init>";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray;
                        objectArray[2] = "getFillColor";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray;
                        objectArray[2] = "getBorderColor";
                        break;
                    }
                    case 3: {
                        break;
                    }
                }
                String string = String.format(v0, objectArray);
                throw switch (n) {
                    default -> new IllegalArgumentException(string);
                    case 3 -> new IllegalStateException(string);
                };
            }
        }

        @ApiStatus.Internal
        public static interface Painter {
            @Nullable
            public Color getFillColor(@NotNull Editor var1, boolean var2);

            @Nullable
            public Color getBorderColor(@NotNull Editor var1, boolean var2);

            public boolean isDottedBorder();

            public boolean isAlwaysVisible();

            @NotNull
            public TextDiffType getType();
        }

        @ApiStatus.Internal
        public static class ResolvablePainter
        implements Painter {
            private final TextDiffType myType;
            private final boolean myResolved;

            @ApiStatus.Internal
            public ResolvablePainter(@NotNull TextDiffType type, boolean resolved) {
                if (type == null) {
                    ResolvablePainter.$$$reportNull$$$0(0);
                }
                this.myType = type;
                this.myResolved = resolved;
            }

            @Override
            @Nullable
            public Color getFillColor(@NotNull Editor editor, boolean isFolded) {
                if (editor == null) {
                    ResolvablePainter.$$$reportNull$$$0(1);
                }
                return !this.myResolved ? DividerPaintableHandlerImpl.correctType(this.myType, isFolded).getColor(editor) : null;
            }

            @Override
            @Nullable
            public Color getBorderColor(@NotNull Editor editor, boolean isFolded) {
                if (editor == null) {
                    ResolvablePainter.$$$reportNull$$$0(2);
                }
                return this.myResolved ? DividerPaintableHandlerImpl.correctType(this.myType, isFolded).getColor(editor) : null;
            }

            @Override
            public boolean isDottedBorder() {
                return this.myResolved;
            }

            @Override
            public boolean isAlwaysVisible() {
                return !this.myResolved;
            }

            @Override
            @NotNull
            public TextDiffType getType() {
                TextDiffType textDiffType = this.myType;
                if (textDiffType == null) {
                    ResolvablePainter.$$$reportNull$$$0(3);
                }
                return textDiffType;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n) {
                    default -> 3;
                    case 3 -> 2;
                }];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "type";
                        break;
                    }
                    case 1: 
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "editor";
                        break;
                    }
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/diff/util/DiffDividerDrawUtil$DividerPaintableHandlerImpl$ResolvablePainter";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/diff/util/DiffDividerDrawUtil$DividerPaintableHandlerImpl$ResolvablePainter";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getType";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "<init>";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray;
                        objectArray[2] = "getFillColor";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray;
                        objectArray[2] = "getBorderColor";
                        break;
                    }
                    case 3: {
                        break;
                    }
                }
                String string = String.format(v0, objectArray);
                throw switch (n) {
                    default -> new IllegalArgumentException(string);
                    case 3 -> new IllegalStateException(string);
                };
            }
        }

        @ApiStatus.Internal
        public static class ExcludablePainter
        implements Painter {
            private final TextDiffType myType;
            private final boolean myExcluded;
            private final boolean mySkipped;

            @ApiStatus.Internal
            public ExcludablePainter(@NotNull TextDiffType type, boolean excluded, boolean skipped) {
                if (type == null) {
                    ExcludablePainter.$$$reportNull$$$0(0);
                }
                this.myType = type;
                this.myExcluded = excluded;
                this.mySkipped = skipped;
            }

            @Override
            @Nullable
            public Color getFillColor(@NotNull Editor editor, boolean isFolded) {
                if (editor == null) {
                    ExcludablePainter.$$$reportNull$$$0(1);
                }
                return this.myExcluded ? DividerPaintableHandlerImpl.correctType(this.myType, isFolded).getIgnoredColor(editor) : DividerPaintableHandlerImpl.correctType(this.myType, isFolded).getColor(editor);
            }

            @Override
            @Nullable
            public Color getBorderColor(@NotNull Editor editor, boolean isFolded) {
                if (editor == null) {
                    ExcludablePainter.$$$reportNull$$$0(2);
                }
                return this.myExcluded ? DividerPaintableHandlerImpl.correctType(this.myType, isFolded).getColor(editor) : null;
            }

            @Override
            public boolean isDottedBorder() {
                return false;
            }

            @Override
            public boolean isAlwaysVisible() {
                return !this.mySkipped;
            }

            @Override
            @NotNull
            public TextDiffType getType() {
                TextDiffType textDiffType = this.myType;
                if (textDiffType == null) {
                    ExcludablePainter.$$$reportNull$$$0(3);
                }
                return textDiffType;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n) {
                    default -> 3;
                    case 3 -> 2;
                }];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "type";
                        break;
                    }
                    case 1: 
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "editor";
                        break;
                    }
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/diff/util/DiffDividerDrawUtil$DividerPaintableHandlerImpl$ExcludablePainter";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/diff/util/DiffDividerDrawUtil$DividerPaintableHandlerImpl$ExcludablePainter";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getType";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "<init>";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray;
                        objectArray[2] = "getFillColor";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray;
                        objectArray[2] = "getBorderColor";
                        break;
                    }
                    case 3: {
                        break;
                    }
                }
                String string = String.format(v0, objectArray);
                throw switch (n) {
                    default -> new IllegalArgumentException(string);
                    case 3 -> new IllegalStateException(string);
                };
            }
        }
    }

    public static class DividerSeparator {
        private final int myStart1;
        private final int myStart2;
        private final int myEnd1;
        private final int myEnd2;
        private final boolean myIsHovered;
        @Nullable
        private final EditorColorsScheme myScheme;

        public DividerSeparator(int start1, int start2, int end1, int end2, boolean isHovered, @Nullable EditorColorsScheme scheme) {
            this.myStart1 = start1;
            this.myStart2 = start2;
            this.myEnd1 = end1;
            this.myEnd2 = end2;
            this.myIsHovered = isHovered;
            this.myScheme = scheme;
        }

        public void paint(Graphics2D g, int width) {
            DiffLineSeparatorRenderer.drawConnectorLine(g, 0, width, this.myStart1, this.myStart2, this.myEnd1 - this.myStart1, this.myIsHovered, this.myScheme);
        }

        public String toString() {
            return "<" + this.myStart1 + ", " + this.myEnd1 + " : " + this.myStart2 + ", " + this.myEnd2 + "> ";
        }
    }

    public static class DividerPolygon {
        private final int myStart1;
        private final int myStart2;
        private final int myEnd1;
        private final int myEnd2;
        @Nullable
        private final Color myFillColor;
        @Nullable
        private final Color myBorderColor;
        private final boolean myDottedBorder;

        public DividerPolygon(int start1, int start2, int end1, int end2, @Nullable Color fillColor, @Nullable Color borderColor, boolean dottedBorder) {
            this.myStart1 = start1;
            this.myStart2 = start2;
            this.myEnd1 = end1;
            this.myEnd2 = end2;
            this.myFillColor = fillColor;
            this.myBorderColor = borderColor;
            this.myDottedBorder = dottedBorder;
        }

        public void paint(Graphics2D g, int width, boolean curve) {
            int endY2;
            int startY2;
            int endY1;
            int startY1;
            if (this.myEnd1 - this.myStart1 < 2) {
                startY1 = this.myStart1 - 1;
                endY1 = this.myStart1;
            } else {
                startY1 = this.myStart1;
                endY1 = this.myEnd1 - 1;
            }
            if (this.myEnd2 - this.myStart2 < 2) {
                startY2 = this.myStart2 - 1;
                endY2 = this.myStart2;
            } else {
                startY2 = this.myStart2;
                endY2 = this.myEnd2 - 1;
            }
            Stroke oldStroke = g.getStroke();
            if (this.myDottedBorder) {
                g.setStroke(BOLD_DOTTED_STROKE);
            }
            DividerPolygon.drawTrapezium(g, width, startY1, endY1, startY2, endY2, this.myFillColor, this.myBorderColor, curve);
            g.setStroke(oldStroke);
        }

        private static void drawTrapezium(@NotNull Graphics2D g, int width, int startY1, int endY1, int startY2, int endY2, @Nullable Color fillColor, @Nullable Color borderColor, boolean curve) {
            if (g == null) {
                DividerPolygon.$$$reportNull$$$0(0);
            }
            if (curve) {
                DiffDrawUtil.drawCurveTrapezium(g, 0, width, startY1, endY1, startY2, endY2, fillColor, borderColor);
            } else {
                DiffDrawUtil.drawTrapezium(g, 0, width, startY1, endY1, startY2, endY2, fillColor, borderColor);
            }
        }

        @NotNull
        public DividerPolygon withAlignedHeight() {
            int delta = this.myEnd2 - this.myStart2 - (this.myEnd1 - this.myStart1);
            if (delta == 0) {
                DividerPolygon dividerPolygon = this;
                if (dividerPolygon == null) {
                    DividerPolygon.$$$reportNull$$$0(1);
                }
                return dividerPolygon;
            }
            if (this.myStart2 == this.myEnd1 && this.myEnd1 == this.myEnd2) {
                return new DividerPolygon(this.myStart1, this.myStart2 - (this.myEnd2 - this.myStart1), this.myEnd1, this.myEnd2, this.myFillColor, this.myBorderColor, this.myDottedBorder);
            }
            if (this.myEnd1 == this.myEnd2 && this.myStart1 == this.myEnd1) {
                return new DividerPolygon(this.myStart1 - (this.myEnd2 - this.myStart2), this.myStart2, this.myEnd1, this.myEnd2, this.myFillColor, this.myBorderColor, this.myDottedBorder);
            }
            if (delta < 0) {
                int startDelta = this.myStart2 == this.myEnd2 ? 0 : -delta;
                int endDelta = this.myStart2 == this.myEnd2 ? -delta : 0;
                int firstLineOffset = this.myStart2 == this.myEnd2 && this.myStart1 == 0 ? -1 : 0;
                return new DividerPolygon(this.myStart1, this.myStart2 - startDelta + firstLineOffset, this.myEnd1, this.myEnd2 + endDelta + firstLineOffset, this.myFillColor, this.myBorderColor, this.myDottedBorder);
            }
            int startDelta = this.myStart1 == this.myEnd1 ? 0 : delta;
            int endDelta = this.myStart1 == this.myEnd1 ? delta : 0;
            int firstLineOffset = this.myStart1 == this.myEnd1 && this.myStart2 == 0 ? -1 : 0;
            return new DividerPolygon(this.myStart1 - startDelta + firstLineOffset, this.myStart2, this.myEnd1 + endDelta + firstLineOffset, this.myEnd2, this.myFillColor, this.myBorderColor, this.myDottedBorder);
        }

        public String toString() {
            return "<" + this.myStart1 + ", " + this.myEnd1 + " : " + this.myStart2 + ", " + this.myEnd2 + "> " + String.valueOf(this.myFillColor) + ", " + String.valueOf(this.myBorderColor);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "g";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/diff/util/DiffDividerDrawUtil$DividerPolygon";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/diff/util/DiffDividerDrawUtil$DividerPolygon";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "withAlignedHeight";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "drawTrapezium";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1 -> new IllegalStateException(string);
            };
        }
    }
}

