/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.util;

import com.intellij.diff.util.DiffDrawUtil;
import com.intellij.diff.util.DiffUtil;
import com.intellij.diff.util.TextDiffType;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.ex.EditorGutterComponentEx;
import com.intellij.openapi.editor.markup.LineMarkerRendererEx;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0012\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0017\u0018\u00002\u00020\u0001BW\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0007\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\n\u0012\u0006\u0010\f\u001a\u00020\n\u0012\u0006\u0010\r\u001a\u00020\n\u0012\u0006\u0010\u000e\u001a\u00020\n\u0012\u0006\u0010\u000f\u001a\u00020\n\u00a2\u0006\u0004\b\u0010\u0010\u0011J \u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#H\u0016JT\u0010$\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020%2\u0006\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020'2\u0006\u0010)\u001a\u00020'2\u0006\u0010*\u001a\u00020'2\u0006\u0010\u000e\u001a\u00020\n2\u0006\u0010+\u001a\u00020\u00072\n\b\u0002\u0010,\u001a\u0004\u0018\u00010-H\u0007J\b\u0010.\u001a\u00020/H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0011\u0010\b\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0017R\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u0011\u0010\u000b\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\u001aR\u0011\u0010\f\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u001aR\u0011\u0010\r\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u001aR\u0011\u0010\u000e\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001aR\u000e\u0010\u000f\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00060"}, d2={"Lcom/intellij/diff/util/DiffLineMarkerRenderer;", "Lcom/intellij/openapi/editor/markup/LineMarkerRendererEx;", "highlighter", "Lcom/intellij/openapi/editor/markup/RangeHighlighter;", "diffType", "Lcom/intellij/diff/util/TextDiffType;", "editorMode", "Lcom/intellij/diff/util/DiffDrawUtil$PaintMode;", "gutterMode", "hideWithoutLineNumbers", "", "isEmptyRange", "isFirstLine", "isLastLine", "alignedSides", "clearThinLineBetweenGutterAndEditor", "<init>", "(Lcom/intellij/openapi/editor/markup/RangeHighlighter;Lcom/intellij/diff/util/TextDiffType;Lcom/intellij/diff/util/DiffDrawUtil$PaintMode;Lcom/intellij/diff/util/DiffDrawUtil$PaintMode;ZZZZZZ)V", "getHighlighter", "()Lcom/intellij/openapi/editor/markup/RangeHighlighter;", "getDiffType", "()Lcom/intellij/diff/util/TextDiffType;", "getEditorMode", "()Lcom/intellij/diff/util/DiffDrawUtil$PaintMode;", "getGutterMode", "getHideWithoutLineNumbers", "()Z", "getAlignedSides", "paint", "", "editor", "Lcom/intellij/openapi/editor/Editor;", "g", "Ljava/awt/Graphics;", "range", "Ljava/awt/Rectangle;", "drawMarker", "Ljava/awt/Graphics2D;", "x1", "", "x2", "y1", "y2", "mode", "forcedBackgroundColor", "Ljava/awt/Color;", "getPosition", "Lcom/intellij/openapi/editor/markup/LineMarkerRendererEx$Position;", "intellij.platform.diff.impl"})
@ApiStatus.Internal
public class DiffLineMarkerRenderer
implements LineMarkerRendererEx {
    @NotNull
    private final RangeHighlighter highlighter;
    @NotNull
    private final TextDiffType diffType;
    @NotNull
    private final DiffDrawUtil.PaintMode editorMode;
    @NotNull
    private final DiffDrawUtil.PaintMode gutterMode;
    private final boolean hideWithoutLineNumbers;
    private final boolean isEmptyRange;
    private final boolean isFirstLine;
    private final boolean isLastLine;
    private final boolean alignedSides;
    private final boolean clearThinLineBetweenGutterAndEditor;

    public DiffLineMarkerRenderer(@NotNull RangeHighlighter highlighter, @NotNull TextDiffType diffType, @NotNull DiffDrawUtil.PaintMode editorMode, @NotNull DiffDrawUtil.PaintMode gutterMode, boolean hideWithoutLineNumbers, boolean isEmptyRange, boolean isFirstLine, boolean isLastLine, boolean alignedSides, boolean clearThinLineBetweenGutterAndEditor) {
        Intrinsics.checkNotNullParameter((Object)highlighter, (String)"highlighter");
        Intrinsics.checkNotNullParameter((Object)diffType, (String)"diffType");
        Intrinsics.checkNotNullParameter((Object)editorMode, (String)"editorMode");
        Intrinsics.checkNotNullParameter((Object)gutterMode, (String)"gutterMode");
        this.highlighter = highlighter;
        this.diffType = diffType;
        this.editorMode = editorMode;
        this.gutterMode = gutterMode;
        this.hideWithoutLineNumbers = hideWithoutLineNumbers;
        this.isEmptyRange = isEmptyRange;
        this.isFirstLine = isFirstLine;
        this.isLastLine = isLastLine;
        this.alignedSides = alignedSides;
        this.clearThinLineBetweenGutterAndEditor = clearThinLineBetweenGutterAndEditor;
    }

    @NotNull
    public final RangeHighlighter getHighlighter() {
        return this.highlighter;
    }

    @NotNull
    public final TextDiffType getDiffType() {
        return this.diffType;
    }

    @NotNull
    public final DiffDrawUtil.PaintMode getEditorMode() {
        return this.editorMode;
    }

    @NotNull
    public final DiffDrawUtil.PaintMode getGutterMode() {
        return this.gutterMode;
    }

    public final boolean getHideWithoutLineNumbers() {
        return this.hideWithoutLineNumbers;
    }

    public final boolean isEmptyRange() {
        return this.isEmptyRange;
    }

    public final boolean isFirstLine() {
        return this.isFirstLine;
    }

    public final boolean isLastLine() {
        return this.isLastLine;
    }

    public final boolean getAlignedSides() {
        return this.alignedSides;
    }

    public void paint(@NotNull Editor editor, @NotNull Graphics g, @NotNull Rectangle range) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)g, (String)"g");
        Intrinsics.checkNotNullParameter((Object)range, (String)"range");
        EditorEx cfr_ignored_0 = (EditorEx)editor;
        Graphics2D cfr_ignored_1 = (Graphics2D)g;
        EditorGutterComponentEx editorGutterComponentEx = ((EditorEx)editor).getGutterComponentEx();
        Intrinsics.checkNotNullExpressionValue((Object)editorGutterComponentEx, (String)"getGutterComponentEx(...)");
        EditorGutterComponentEx gutter = editorGutterComponentEx;
        int x1 = 0;
        int x2 = gutter.getWidth();
        int startLine = 0;
        int endLine = 0;
        if (this.isEmptyRange) {
            startLine = this.isLastLine ? DiffUtil.getLineCount((Document)((EditorEx)editor).getDocument()) : ((EditorEx)editor).getDocument().getLineNumber(this.highlighter.getStartOffset());
            endLine = startLine;
        } else {
            startLine = ((EditorEx)editor).getDocument().getLineNumber(this.highlighter.getStartOffset());
            endLine = ((EditorEx)editor).getDocument().getLineNumber(this.highlighter.getEndOffset()) + 1;
        }
        DiffDrawUtil.MarkerRange markerRange = DiffDrawUtil.getGutterMarkerPaintRange(editor, startLine, endLine);
        Intrinsics.checkNotNullExpressionValue((Object)markerRange, (String)"getGutterMarkerPaintRange(...)");
        DiffDrawUtil.MarkerRange markerRange2 = markerRange;
        int y1 = markerRange2.component1();
        int y2 = markerRange2.component2();
        if (this.hideWithoutLineNumbers && !editor.getSettings().isLineNumbersShown()) {
            x1 = gutter.getWhitespaceSeparatorOffset();
        } else {
            int annotationsOffset = gutter.getAnnotationsAreaOffset();
            int annotationsWidth = gutter.getAnnotationsAreaWidth();
            if (annotationsWidth != 0) {
                DiffLineMarkerRenderer.drawMarker$default(this, editor, (Graphics2D)g, x1, annotationsOffset, y1, y2, this.alignedSides, this.gutterMode, null, 256, null);
                x1 = annotationsOffset + annotationsWidth;
            }
        }
        if (Intrinsics.areEqual((Object)this.editorMode, (Object)this.gutterMode)) {
            DiffLineMarkerRenderer.drawMarker$default(this, editor, (Graphics2D)g, x1, x2, y1, y2, this.alignedSides, this.gutterMode, null, 256, null);
        } else {
            int xOutline = gutter.getWhitespaceSeparatorOffset();
            Color thinLineForcedColor = this.clearThinLineBetweenGutterAndEditor ? ((EditorEx)editor).getBackgroundColor() : null;
            this.drawMarker(editor, (Graphics2D)g, xOutline, x2, y1, y2, this.alignedSides, this.editorMode, thinLineForcedColor);
            DiffLineMarkerRenderer.drawMarker$default(this, editor, (Graphics2D)g, x1, xOutline, y1, y2, this.alignedSides, this.gutterMode, null, 256, null);
        }
    }

    @ApiStatus.Internal
    public final void drawMarker(@NotNull Editor editor, @NotNull Graphics2D g, int x1, int x2, int y1, int y2, boolean alignedSides, @NotNull DiffDrawUtil.PaintMode mode, @Nullable Color forcedBackgroundColor) {
        boolean isEmptyRange;
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)g, (String)"g");
        Intrinsics.checkNotNullParameter((Object)mode, (String)"mode");
        if (x1 >= x2) {
            return;
        }
        boolean dottedLine = mode.border == DiffDrawUtil.BorderType.DOTTED;
        Color color = this.diffType.getColor(editor);
        Intrinsics.checkNotNullExpressionValue((Object)color, (String)"getColor(...)");
        Color color2 = color;
        Color color3 = forcedBackgroundColor;
        if (color3 == null) {
            switch (WhenMappings.$EnumSwitchMapping$0[mode.background.ordinal()]) {
                case 1: {
                    color3 = null;
                    break;
                }
                case 2: {
                    color3 = color2;
                    break;
                }
                case 3: {
                    color3 = this.diffType.getIgnoredColor(editor);
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
        }
        Color backgroundColor = color3;
        boolean bl = isEmptyRange = y2 - y1 <= 2;
        if (!isEmptyRange) {
            if (backgroundColor != null) {
                g.setColor(backgroundColor);
                g.fillRect(x1, y1, x2 - x1, y2 - y1);
            }
            if (mode.border != DiffDrawUtil.BorderType.NONE && !alignedSides) {
                DiffDrawUtil.drawChunkBorderLine(g, x1, x2, y1, color2, false, dottedLine);
                DiffDrawUtil.drawChunkBorderLine(g, x1, x2, y2 - 1, color2, false, dottedLine);
            }
        } else if (!alignedSides) {
            DiffDrawUtil.drawChunkBorderLine(g, x1, x2, y1 - 1, color2, true, dottedLine);
        }
    }

    public static /* synthetic */ void drawMarker$default(DiffLineMarkerRenderer diffLineMarkerRenderer, Editor editor, Graphics2D graphics2D, int n, int n2, int n3, int n4, boolean bl, DiffDrawUtil.PaintMode paintMode, Color color, int n5, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: drawMarker");
        }
        if ((n5 & 0x100) != 0) {
            color = null;
        }
        diffLineMarkerRenderer.drawMarker(editor, graphics2D, n, n2, n3, n4, bl, paintMode, color);
    }

    @NotNull
    public LineMarkerRendererEx.Position getPosition() {
        return LineMarkerRendererEx.Position.CUSTOM;
    }

    @Metadata(mv={2, 3, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[DiffDrawUtil.BackgroundType.values().length];
            try {
                nArray[DiffDrawUtil.BackgroundType.NONE.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DiffDrawUtil.BackgroundType.DEFAULT.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DiffDrawUtil.BackgroundType.IGNORED.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

