/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.util;

import com.intellij.diff.util.TextDiffType;
import com.intellij.openapi.diff.DiffBundle;
import com.intellij.openapi.diff.DiffColors;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.ui.ColorUtil;
import com.intellij.ui.JBColor;
import com.intellij.util.ObjectUtils;
import java.awt.Color;
import java.util.Arrays;
import java.util.List;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class TextDiffTypeFactory {
    @NotNull
    public static final TextDiffTypeImpl INSERTED = new TextDiffTypeImpl(DiffColors.DIFF_INSERTED, DiffBundle.message((String)"diff.type.inserted.name", (Object[])new Object[0]));
    @NotNull
    public static final TextDiffTypeImpl DELETED = new TextDiffTypeImpl(DiffColors.DIFF_DELETED, DiffBundle.message((String)"diff.type.deleted.name", (Object[])new Object[0]));
    @NotNull
    public static final TextDiffTypeImpl MODIFIED = new TextDiffTypeImpl(DiffColors.DIFF_MODIFIED, DiffBundle.message((String)"diff.type.changed.name", (Object[])new Object[0]));
    @NotNull
    public static final TextDiffTypeImpl CONFLICT = new TextDiffTypeImpl(DiffColors.DIFF_CONFLICT, DiffBundle.message((String)"diff.type.conflict.name", (Object[])new Object[0]));
    private static final double MIDDLE_COLOR_FACTOR = 0.6;

    @NotNull
    public static List<TextDiffTypeImpl> getAllDiffTypes() {
        List<TextDiffTypeImpl> list = Arrays.asList(INSERTED, DELETED, MODIFIED, CONFLICT);
        if (list == null) {
            TextDiffTypeFactory.$$$reportNull$$$0(0);
        }
        return list;
    }

    @NotNull
    public static Color getMiddleColor(@NotNull Color fg, @NotNull Color bg) {
        if (fg == null) {
            TextDiffTypeFactory.$$$reportNull$$$0(1);
        }
        if (bg == null) {
            TextDiffTypeFactory.$$$reportNull$$$0(2);
        }
        Color color = ColorUtil.mix((Color)fg, (Color)bg, (double)0.6);
        if (color == null) {
            TextDiffTypeFactory.$$$reportNull$$$0(3);
        }
        return color;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/diff/util/TextDiffTypeFactory";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fg";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "bg";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllDiffTypes";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/diff/util/TextDiffTypeFactory";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getMiddleColor";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getMiddleColor";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2 -> new IllegalArgumentException(string);
        };
    }

    public static class TextDiffTypeImpl
    implements TextDiffType {
        @NotNull
        private final TextAttributesKey myKey;
        @NotNull
        @Nls
        private final String myName;

        public TextDiffTypeImpl(@NotNull TextAttributesKey key, @NotNull @Nls String name) {
            if (key == null) {
                TextDiffTypeImpl.$$$reportNull$$$0(0);
            }
            if (name == null) {
                TextDiffTypeImpl.$$$reportNull$$$0(1);
            }
            this.myKey = key;
            this.myName = name;
        }

        @Override
        @Nls
        @NotNull
        public String getName() {
            String string = this.myName;
            if (string == null) {
                TextDiffTypeImpl.$$$reportNull$$$0(2);
            }
            return string;
        }

        @NotNull
        public TextAttributes getAttributes(@Nullable Editor editor) {
            if (editor == null) {
                TextAttributes textAttributes = EditorColorsManager.getInstance().getGlobalScheme().getAttributes(this.myKey);
                if (textAttributes == null) {
                    TextDiffTypeImpl.$$$reportNull$$$0(3);
                }
                return textAttributes;
            }
            TextAttributes textAttributes = editor.getColorsScheme().getAttributes(this.myKey);
            if (textAttributes == null) {
                TextDiffTypeImpl.$$$reportNull$$$0(4);
            }
            return textAttributes;
        }

        @Override
        @NotNull
        public Color getColor(@Nullable Editor editor) {
            Color color = (Color)ObjectUtils.notNull((Object)this.getAttributes(editor).getBackgroundColor(), (Object)JBColor.DARK_GRAY);
            if (color == null) {
                TextDiffTypeImpl.$$$reportNull$$$0(5);
            }
            return color;
        }

        @Override
        @NotNull
        public Color getIgnoredColor(@Nullable Editor editor) {
            Color color = this.getAttributes(editor).getForegroundColor();
            if (color != null) {
                Color color2 = color;
                if (color2 == null) {
                    TextDiffTypeImpl.$$$reportNull$$$0(6);
                }
                return color2;
            }
            Color fg = this.getColor(editor);
            Color bg = editor instanceof EditorEx ? ((EditorEx)editor).getBackgroundColor() : EditorColorsManager.getInstance().getGlobalScheme().getDefaultBackground();
            Color color3 = ColorUtil.mix((Color)fg, (Color)bg, (double)0.6);
            if (color3 == null) {
                TextDiffTypeImpl.$$$reportNull$$$0(7);
            }
            return color3;
        }

        @Override
        @Nullable
        public Color getMarkerColor(@Nullable Editor editor) {
            return this.getAttributes(editor).getErrorStripeColor();
        }

        @NotNull
        public TextAttributesKey getKey() {
            TextAttributesKey textAttributesKey = this.myKey;
            if (textAttributesKey == null) {
                TextDiffTypeImpl.$$$reportNull$$$0(8);
            }
            return textAttributesKey;
        }

        public String toString() {
            return this.myName;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2, 3, 4, 5, 6, 7, 8 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "key";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "name";
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/diff/util/TextDiffTypeFactory$TextDiffTypeImpl";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/diff/util/TextDiffTypeFactory$TextDiffTypeImpl";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getAttributes";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getColor";
                    break;
                }
                case 6: 
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getIgnoredColor";
                    break;
                }
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getKey";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2, 3, 4, 5, 6, 7, 8 -> new IllegalStateException(string);
            };
        }
    }
}

