/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.diff.actions;

import com.intellij.diff.DiffManager;
import com.intellij.diff.DiffRequestFactory;
import com.intellij.diff.InvalidDiffRequestException;
import com.intellij.diff.merge.MergeRequest;
import com.intellij.diff.util.DiffUserDataKeys;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.diff.DiffBundle;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.Arrays;
import java.util.List;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@ApiStatus.Internal
public class MergeFilesAction
extends AnAction
implements DumbAware {
    public void update(@NotNull AnActionEvent e) {
        DataContext context;
        Project project;
        if (e == null) {
            MergeFilesAction.$$$reportNull$$$0(0);
        }
        if ((project = (Project)CommonDataKeys.PROJECT.getData(context = e.getDataContext())) == null) {
            e.getPresentation().setEnabled(false);
            return;
        }
        VirtualFile[] files = (VirtualFile[])CommonDataKeys.VIRTUAL_FILE_ARRAY.getData(context);
        if (files == null || files.length != 3) {
            e.getPresentation().setEnabled(false);
        }
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
        if (actionUpdateThread == null) {
            MergeFilesAction.$$$reportNull$$$0(1);
        }
        return actionUpdateThread;
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        DataContext context;
        VirtualFile[] files;
        if (e == null) {
            MergeFilesAction.$$$reportNull$$$0(2);
        }
        if ((files = (VirtualFile[])CommonDataKeys.VIRTUAL_FILE_ARRAY.getData(context = e.getDataContext())) == null || files.length != 3) {
            return;
        }
        DiffRequestFactory diffRequestFactory = DiffRequestFactory.getInstance();
        try {
            Project project = (Project)CommonDataKeys.PROJECT.getData(context);
            String title = DiffBundle.message((String)"merge.files.dialog.title", (Object[])new Object[0]);
            List<String> titles = Arrays.asList(files[0].getPresentableUrl(), files[1].getPresentableUrl(), files[2].getPresentableUrl());
            VirtualFile outputFile = files[1];
            List<VirtualFile> contents = Arrays.asList(files[0], files[1], files[2]);
            MergeRequest request = diffRequestFactory.createMergeRequestFromFiles(project, outputFile, contents, title, titles, null);
            request.putUserData(DiffUserDataKeys.HELP_ID, (Object)"cvs.merge");
            DiffManager.getInstance().showMerge(project, request);
        }
        catch (InvalidDiffRequestException err) {
            Messages.showErrorDialog((String)err.getMessage(), (String)DiffBundle.message((String)"merge.files.dialog.title", (Object[])new Object[0]));
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/diff/actions/MergeFilesAction";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/diff/actions/MergeFilesAction";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionUpdateThread";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "actionPerformed";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1 -> new IllegalStateException(string);
        };
    }
}

