/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.ex;

import com.intellij.diff.comparison.iterables.FairDiffIterable;
import com.intellij.diff.util.Range;
import com.intellij.diff.util.Side;
import com.intellij.openapi.vcs.ex.DocumentTracker;
import com.intellij.openapi.vcs.ex.DocumentTrackerKt;
import com.intellij.openapi.vcs.ex.RangesBuilder;
import com.intellij.util.containers.PeekableIteratorWrapper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\n\b\u0002\u0018\u00002\u00020\u0001B+\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00060\u0003\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nJ\u0014\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00060\u00032\u0006\u0010\u0018\u001a\u00020\u0019J\u0010\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u0006H\u0002J\u0010\u0010\u001d\u001a\u00020\u001b2\u0006\u0010\u001e\u001a\u00020\u001fH\u0002J\u0018\u0010 \u001a\u00020\u001b2\u0006\u0010!\u001a\u00020\u000e2\u0006\u0010\"\u001a\u00020\u000eH\u0002J\u0010\u0010#\u001a\u00020\u001b2\u0006\u0010$\u001a\u00020\u000eH\u0002J\u001e\u0010%\u001a\u00020\u001b2\f\u0010&\u001a\b\u0012\u0004\u0012\u00020\u00060\u00032\u0006\u0010'\u001a\u00020\u0006H\u0002J\u0018\u0010(\u001a\u00020\u001b2\u0006\u0010&\u001a\u00020\u00062\u0006\u0010'\u001a\u00020\u0006H\u0002R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00060\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00060\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00060\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006)"}, d2={"Lcom/intellij/openapi/vcs/ex/BulkRangeChangeHandler;", "", "handlers", "", "Lcom/intellij/openapi/vcs/ex/DocumentTracker$Handler;", "blocks", "Lcom/intellij/openapi/vcs/ex/DocumentTracker$Block;", "side", "Lcom/intellij/diff/util/Side;", "<init>", "(Ljava/util/List;Ljava/util/List;Lcom/intellij/diff/util/Side;)V", "newBlocks", "", "dirtyStart", "", "dirtyEnd", "dirtyBlocks", "dirtyBlocksModified", "", "blockShift", "changeShift", "dirtyBlockShift", "dirtyChangeShift", "run", "iterable", "Lcom/intellij/diff/comparison/iterables/FairDiffIterable;", "handleBlock", "", "block", "handleChange", "range", "Lcom/intellij/diff/util/Range;", "markDirtyRange", "start", "end", "flush", "nextLine", "onRangesChanged", "before", "after", "onRangeShifted", "intellij.platform.diff.impl"})
@SourceDebugExtension(value={"SMAP\nDocumentTracker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DocumentTracker.kt\ncom/intellij/openapi/vcs/ex/BulkRangeChangeHandler\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,1400:1\n1807#2,3:1401\n1915#2,2:1404\n1915#2,2:1406\n*S KotlinDebug\n*F\n+ 1 DocumentTracker.kt\ncom/intellij/openapi/vcs/ex/BulkRangeChangeHandler\n*L\n988#1:1401,3\n1024#1:1404,2\n1028#1:1406,2\n*E\n"})
final class BulkRangeChangeHandler {
    @NotNull
    private final List<DocumentTracker.Handler> handlers;
    @NotNull
    private final List<DocumentTracker.Block> blocks;
    @NotNull
    private final Side side;
    @NotNull
    private final List<DocumentTracker.Block> newBlocks;
    private int dirtyStart;
    private int dirtyEnd;
    @NotNull
    private final List<DocumentTracker.Block> dirtyBlocks;
    private boolean dirtyBlocksModified;
    private int blockShift;
    private int changeShift;
    private int dirtyBlockShift;
    private int dirtyChangeShift;

    public BulkRangeChangeHandler(@NotNull List<? extends DocumentTracker.Handler> handlers, @NotNull List<DocumentTracker.Block> blocks, @NotNull Side side) {
        Intrinsics.checkNotNullParameter(handlers, (String)"handlers");
        Intrinsics.checkNotNullParameter(blocks, (String)"blocks");
        Intrinsics.checkNotNullParameter((Object)side, (String)"side");
        this.handlers = handlers;
        this.blocks = blocks;
        this.side = side;
        this.newBlocks = new ArrayList();
        this.dirtyStart = -1;
        this.dirtyEnd = -1;
        this.dirtyBlocks = new ArrayList();
    }

    @NotNull
    public final List<DocumentTracker.Block> run(@NotNull FairDiffIterable iterable) {
        Intrinsics.checkNotNullParameter((Object)iterable, (String)"iterable");
        PeekableIteratorWrapper it1 = new PeekableIteratorWrapper(this.blocks.iterator());
        PeekableIteratorWrapper it2 = new PeekableIteratorWrapper(iterable.changes());
        while (it1.hasNext() || it2.hasNext()) {
            if (!it2.hasNext()) {
                this.handleBlock((DocumentTracker.Block)it1.next());
                continue;
            }
            if (!it1.hasNext()) {
                this.handleChange((Range)it2.next());
                continue;
            }
            DocumentTracker.Block block = (DocumentTracker.Block)it1.peek();
            Range range1 = block.getRange();
            Range range2 = (Range)it2.peek();
            if (RangesBuilder.start(range1, this.side) <= range2.start1) {
                this.handleBlock((DocumentTracker.Block)it1.next());
                continue;
            }
            this.handleChange((Range)it2.next());
        }
        this.flush(Integer.MAX_VALUE);
        return this.newBlocks;
    }

    private final void handleBlock(DocumentTracker.Block block) {
        Range range = block.getRange();
        this.flush(RangesBuilder.start(range, this.side));
        this.dirtyBlockShift += DocumentTrackerKt.access$getRangeDelta(range, this.side);
        this.markDirtyRange(RangesBuilder.start(range, this.side), RangesBuilder.end(range, this.side));
        this.dirtyBlocks.add(block);
    }

    private final void handleChange(Range range) {
        this.flush(range.start1);
        this.dirtyChangeShift += DocumentTrackerKt.access$getRangeDelta(range, Side.LEFT);
        this.markDirtyRange(range.start1, range.end1);
        this.dirtyBlocksModified = true;
    }

    private final void markDirtyRange(int start, int end) {
        if (this.dirtyEnd == -1) {
            this.dirtyStart = start;
            this.dirtyEnd = end;
        } else {
            this.dirtyEnd = Math.max(this.dirtyEnd, end);
        }
    }

    private final void flush(int nextLine) {
        if (this.dirtyEnd != -1 && this.dirtyEnd < nextLine) {
            if (this.dirtyBlocksModified) {
                boolean bl;
                block10: {
                    Iterable $this$any$iv = this.dirtyBlocks;
                    boolean $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        bl = false;
                    } else {
                        for (Object element$iv : $this$any$iv) {
                            DocumentTracker.Block it = (DocumentTracker.Block)element$iv;
                            boolean bl2 = false;
                            if (!it.isTooBig$intellij_platform_diff_impl()) continue;
                            bl = true;
                            break block10;
                        }
                        bl = false;
                    }
                }
                boolean isTooBig = bl;
                boolean isDirty = true;
                Range range = DocumentTrackerKt.access$createRange(this.side, this.dirtyStart + this.changeShift, this.dirtyEnd + this.changeShift + this.dirtyChangeShift, this.dirtyStart + this.blockShift, this.dirtyEnd + this.blockShift + this.dirtyBlockShift);
                DocumentTracker.Block newBlock = new DocumentTracker.Block(range, isDirty, isTooBig);
                this.onRangesChanged(this.dirtyBlocks, newBlock);
                this.newBlocks.add(newBlock);
            } else {
                boolean bl;
                boolean bl3 = bl = this.dirtyBlocks.size() == 1;
                if (_Assertions.ENABLED && !bl) {
                    String isDirty = "Assertion failed";
                    throw new AssertionError((Object)isDirty);
                }
                if (this.changeShift != 0) {
                    for (DocumentTracker.Block oldBlock : this.dirtyBlocks) {
                        DocumentTracker.Block newBlock = DocumentTrackerKt.access$shift(oldBlock, this.side, this.changeShift);
                        this.onRangeShifted(oldBlock, newBlock);
                        this.newBlocks.add(newBlock);
                    }
                } else {
                    this.newBlocks.addAll((Collection<DocumentTracker.Block>)this.dirtyBlocks);
                }
            }
            this.dirtyStart = -1;
            this.dirtyEnd = -1;
            this.dirtyBlocks.clear();
            this.dirtyBlocksModified = false;
            this.blockShift += this.dirtyBlockShift;
            this.changeShift += this.dirtyChangeShift;
            this.dirtyBlockShift = 0;
            this.dirtyChangeShift = 0;
        }
    }

    private final void onRangesChanged(List<DocumentTracker.Block> before, DocumentTracker.Block after) {
        Iterable $this$forEach$iv = this.handlers;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            DocumentTracker.Handler it = (DocumentTracker.Handler)element$iv;
            boolean bl = false;
            it.onRangesChanged(before, after);
        }
    }

    private final void onRangeShifted(DocumentTracker.Block before, DocumentTracker.Block after) {
        Iterable $this$forEach$iv = this.handlers;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            DocumentTracker.Handler it = (DocumentTracker.Handler)element$iv;
            boolean bl = false;
            it.onRangeShifted(before, after);
        }
    }
}

