/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.modules.diagram;

import com.intellij.diagram.DiagramNodeBase;
import com.intellij.diagram.DiagramProvider;
import com.intellij.icons.AllIcons;
import com.intellij.lang.ecmascript6.psi.ES6FromClause;
import com.intellij.lang.ecmascript6.psi.ES6ImportDeclaration;
import com.intellij.lang.ecmascript6.psi.ES6ImportSpecifier;
import com.intellij.lang.javascript.modules.diagram.JSModulesDiagramUtils;
import com.intellij.lang.javascript.modules.diagram.JSStructuralDiagramItem;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class JSStructuralUiNode
extends DiagramNodeBase<JSStructuralDiagramItem> {
    @NotNull
    private final JSStructuralDiagramItem myItem;

    public JSStructuralUiNode(@NotNull JSStructuralDiagramItem item, @NotNull DiagramProvider<JSStructuralDiagramItem> provider) {
        if (item == null) {
            JSStructuralUiNode.$$$reportNull$$$0(0);
        }
        if (provider == null) {
            JSStructuralUiNode.$$$reportNull$$$0(1);
        }
        super(provider);
        this.myItem = item;
    }

    @Nullable
    public String getTooltip() {
        return JSModulesDiagramUtils.getJSStructuralItemTooltip(this.myItem);
    }

    @Nullable
    public Icon getIcon() {
        return JSStructuralUiNode.calculateIcon(this.myItem);
    }

    @Nullable
    public static Icon calculateIcon(JSStructuralDiagramItem item) {
        if (item.getElementPointer() == null && JSModulesDiagramUtils.startsWithHttpProtocol(item.getName())) {
            return AllIcons.General.Web;
        }
        if (item.getElementPointer() == null) {
            return null;
        }
        PsiElement element = item.getElementPointer().getElement();
        if (element != null && element.isValid()) {
            ES6ImportDeclaration declaration;
            ES6FromClause fromClause;
            PsiElement resolve;
            if (element instanceof JSReferenceExpression && (resolve = ((JSReferenceExpression)element).resolve()) != null && resolve.isValid()) {
                return resolve.getIcon(2);
            }
            if (element instanceof ES6ImportSpecifier && (resolve = ((ES6ImportSpecifier)element).resolve()) != null && resolve.isValid()) {
                return resolve.getIcon(2);
            }
            if (element instanceof ES6ImportDeclaration && (fromClause = (declaration = (ES6ImportDeclaration)element).getFromClause()) == null) {
                PsiReference[] references;
                for (PsiReference reference : references = declaration.getReferences()) {
                    PsiElement resolve2 = reference.resolve();
                    if (resolve2 == null || !resolve2.isValid() || !(resolve2 instanceof PsiFile)) continue;
                    return resolve2.getIcon(2);
                }
            }
            return element.getIcon(2);
        }
        return null;
    }

    @NotNull
    public JSStructuralDiagramItem getIdentifyingElement() {
        JSStructuralDiagramItem jSStructuralDiagramItem = this.myItem;
        if (jSStructuralDiagramItem == null) {
            JSStructuralUiNode.$$$reportNull$$$0(2);
        }
        return jSStructuralDiagramItem;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        JSStructuralUiNode node = (JSStructuralUiNode)((Object)o);
        return this.myItem.equals(node.myItem);
    }

    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this.myItem.hashCode();
        return result;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "item";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "provider";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/modules/diagram/JSStructuralUiNode";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/modules/diagram/JSStructuralUiNode";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getIdentifyingElement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2 -> new IllegalStateException(string);
        };
    }
}

