/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.wip;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.util.io.OSAgnosticPathUtil;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.intellij.util.io.PathKt;
import io.netty.buffer.ByteBuf;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.util.concurrent.GenericFutureListener;
import java.io.Closeable;
import java.io.OutputStreamWriter;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.wip.LogEntry;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\r\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u0000 \u001e2\u00020\u0001:\u0001\u001eB\u0019\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0018\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\b\b\u0002\u0010\u0012\u001a\u00020\u0003J\u0018\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0013\u001a\u00020\u00142\b\b\u0002\u0010\u0012\u001a\u00020\u0003J$\u0010\u0015\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00032\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u000f0\u0017J\u0010\u0010\u0018\u001a\u00020\u000f2\u0006\u0010\u0019\u001a\u00020\u000bH\u0002J\u0006\u0010\u001a\u001a\u00020\u000fJ\u000e\u0010\u001b\u001a\u00020\u000f2\u0006\u0010\u001c\u001a\u00020\u001dR\u0012\u0010\u0007\u001a\u0006\u0012\u0002\b\u00030\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lorg/jetbrains/wip/MessagingLogger;", "", "debugFileBaseName", "", "suffix", "<init>", "(Ljava/lang/String;Ljava/lang/String;)V", "processFuture", "Ljava/util/concurrent/Future;", "queue", "Ljava/util/concurrent/LinkedBlockingQueue;", "Lorg/jetbrains/wip/LogEntry;", "eventId", "Ljava/util/concurrent/atomic/AtomicInteger;", "add", "", "message", "", "marker", "outMessage", "Lio/netty/buffer/ByteBuf;", "withMeasureTime", "block", "Lkotlin/Function0;", "doAdd", "entry", "close", "closeOnChannelClose", "channel", "Lio/netty/channel/Channel;", "Companion", "intellij.javascript.wip.backend"})
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nlogging.kt\nKotlin\n*S Kotlin\n*F\n+ 1 logging.kt\norg/jetbrains/wip/MessagingLogger\n+ 2 netty.kt\ncom/intellij/util/io/NettyKt\n*L\n1#1,142:1\n66#2,2:143\n*S KotlinDebug\n*F\n+ 1 logging.kt\norg/jetbrains/wip/MessagingLogger\n*L\n117#1:143,2\n*E\n"})
public final class MessagingLogger {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Future<?> processFuture;
    @NotNull
    private final LinkedBlockingQueue<LogEntry> queue;
    @NotNull
    private final AtomicInteger eventId;
    @NotNull
    private static final AtomicInteger sequentialNumber = new AtomicInteger(0);

    public MessagingLogger(@NotNull String debugFileBaseName, @NotNull String suffix) {
        Intrinsics.checkNotNullParameter((Object)debugFileBaseName, (String)"debugFileBaseName");
        Intrinsics.checkNotNullParameter((Object)suffix, (String)"suffix");
        this.queue = new LinkedBlockingQueue();
        this.eventId = new AtomicInteger(0);
        Future future = ApplicationManager.getApplication().executeOnPooledThread(() -> MessagingLogger._init_$lambda$0(suffix, debugFileBaseName, this));
        Intrinsics.checkNotNullExpressionValue((Object)future, (String)"executeOnPooledThread(...)");
        this.processFuture = future;
    }

    public final void add(@NotNull CharSequence message, @NotNull String marker) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        Intrinsics.checkNotNullParameter((Object)marker, (String)"marker");
        this.doAdd(new LogEntry.Message(message, marker, 0L, 4, null));
    }

    public static /* synthetic */ void add$default(MessagingLogger messagingLogger, CharSequence charSequence, String string, int n, Object object) {
        if ((n & 2) != 0) {
            string = "IN";
        }
        messagingLogger.add(charSequence, string);
    }

    public final void add(@NotNull ByteBuf outMessage, @NotNull String marker) {
        Intrinsics.checkNotNullParameter((Object)outMessage, (String)"outMessage");
        Intrinsics.checkNotNullParameter((Object)marker, (String)"marker");
        CharSequence charSequence = outMessage.getCharSequence(outMessage.readerIndex(), outMessage.readableBytes(), Charsets.UTF_8);
        Intrinsics.checkNotNull((Object)charSequence);
        this.add(charSequence, marker);
    }

    public static /* synthetic */ void add$default(MessagingLogger messagingLogger, ByteBuf byteBuf, String string, int n, Object object) {
        if ((n & 2) != 0) {
            string = "OUT";
        }
        messagingLogger.add(byteBuf, string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void withMeasureTime(@NotNull CharSequence message, @NotNull String marker, @NotNull Function0<Unit> block) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        Intrinsics.checkNotNullParameter((Object)marker, (String)"marker");
        Intrinsics.checkNotNullParameter(block, (String)"block");
        long startTime = System.currentTimeMillis();
        int eventId = this.eventId.getAndIncrement();
        this.doAdd(new LogEntry.EventStarted(message, marker, eventId, startTime));
        try {
            block.invoke();
        }
        finally {
            long endTime = System.currentTimeMillis();
            this.doAdd(new LogEntry.EventProcessed(eventId, endTime));
        }
    }

    private final void doAdd(LogEntry entry) {
        if (!(entry instanceof LogEntry.Message) || !StringsKt.startsWith$default((CharSequence)((LogEntry.Message)entry).getMessage(), (CharSequence)"{\"method\":\"Network.", (boolean)false, (int)2, null)) {
            this.queue.add(entry);
        }
    }

    public final void close() {
        AppExecutorUtil.getAppScheduledExecutorService().schedule(() -> MessagingLogger.close$lambda$0(this), 1L, TimeUnit.SECONDS);
    }

    public final void closeOnChannelClose(@NotNull Channel channel) {
        Intrinsics.checkNotNullParameter((Object)channel, (String)"channel");
        ChannelFuture channelFuture = channel.closeFuture();
        Intrinsics.checkNotNullExpressionValue((Object)channelFuture, (String)"closeFuture(...)");
        ChannelFuture $this$addChannelListener$iv = channelFuture;
        boolean $i$f$addChannelListener = false;
        $this$addChannelListener$iv.addListener(new GenericFutureListener(this){
            final /* synthetic */ MessagingLogger this$0;
            {
                this.this$0 = messagingLogger;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public final void operationComplete(ChannelFuture it) {
                Intrinsics.checkNotNull((Object)it);
                ChannelFuture it2 = it;
                boolean bl = false;
                try {
                    this.this$0.add("\"Closed\"", "Channel");
                }
                finally {
                    this.this$0.close();
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void _init_$lambda$0(String $suffix, String $debugFileBaseName, MessagingLogger this$0) {
        int sessionNumber = sequentialNumber.getAndIncrement();
        String nameSuffix = sessionNumber == 0 ? $suffix + ".jsonl" : $suffix + "-" + sessionNumber + ".jsonl";
        String string = OSAgnosticPathUtil.expandUserHome((String)($debugFileBaseName + nameSuffix));
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"expandUserHome(...)");
        Path path = Paths.get(string, new String[0]);
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"get(...)");
        Path logPath = path;
        PathKt.createParentDirectories((Path)logPath);
        Object object = logPath;
        Unit unit = new Unit[]{};
        Object object2 = Charsets.UTF_8;
        object = new OutputStreamWriter(Files.newOutputStream((Path)object, Arrays.copyOf(unit, ((OpenOption[])unit).length)), (Charset)object2);
        object2 = null;
        try {
            OutputStreamWriter writer = (OutputStreamWriter)object;
            boolean bl = false;
            try {
                try {
                    while (true) {
                        LogEntry entry = this$0.queue.take();
                        entry.writeJson(writer);
                        writer.flush();
                    }
                }
                catch (InterruptedException interruptedException) {
                    writer.flush();
                    sequentialNumber.decrementAndGet();
                }
            }
            catch (Throwable throwable) {
                writer.flush();
                sequentialNumber.decrementAndGet();
                throw throwable;
            }
            unit = Unit.INSTANCE;
        }
        catch (Throwable throwable) {
            object2 = throwable;
            throw throwable;
        }
        finally {
            CloseableKt.closeFinally((Closeable)object, (Throwable)object2);
        }
    }

    private static final void close$lambda$0(MessagingLogger this$0) {
        this$0.processFuture.cancel(true);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lorg/jetbrains/wip/MessagingLogger$Companion;", "", "<init>", "()V", "sequentialNumber", "Ljava/util/concurrent/atomic/AtomicInteger;", "intellij.javascript.wip.backend"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

