/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.wip;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Pair;
import com.intellij.util.SmartList;
import com.intellij.util.Url;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.concurrency.Promises;
import org.jetbrains.debugger.Breakpoint;
import org.jetbrains.debugger.BreakpointListener;
import org.jetbrains.debugger.BreakpointTarget;
import org.jetbrains.debugger.SuspendContext;
import org.jetbrains.jsonProtocol.Request;
import org.jetbrains.wip.BreakpointBase;
import org.jetbrains.wip.BreakpointManagerBase;
import org.jetbrains.wip.WipBreakpoint;
import org.jetbrains.wip.WipBreakpointManagerKt;
import org.jetbrains.wip.WipSuspendContext;
import org.jetbrains.wip.WipVm;
import org.jetbrains.wip.protocol.debugger.BreakpointResolvedEventData;
import org.jetbrains.wip.protocol.debugger.DebuggerKt;
import org.jetbrains.wip.protocol.debugger.Instrumentation;
import org.jetbrains.wip.protocol.debugger.LocationValue;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\b\u0016\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J:\u0010\u000e\u001a\u00020\u00022\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00122\b\u0010\u0014\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u0016\u001a\u00020\u00122\u0006\u0010\u0017\u001a\u00020\nH\u0014J(\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u001a0\u00192\u0006\u0010\u000f\u001a\u00020\u00102\b\u0010\u001b\u001a\u0004\u0018\u00010\u001c2\u0006\u0010\u001d\u001a\u00020\u0002H\u0014J\u0014\u0010\u001e\u001a\u0006\u0012\u0002\b\u00030\u00192\u0006\u0010\u001d\u001a\u00020\u0002H\u0014J\u0006\u0010\u001f\u001a\u00020 J\u000e\u0010!\u001a\u00020 2\u0006\u0010\"\u001a\u00020#J\u0014\u0010$\u001a\u0006\u0012\u0002\b\u00030\u00192\u0006\u0010\u0017\u001a\u00020\nH\u0016J\b\u0010%\u001a\u00020 H\u0016J\u0014\u0010&\u001a\u00020\n2\n\u0010'\u001a\u0006\u0012\u0002\b\u00030(H\u0016J.\u0010)\u001a \u0012\u0016\u0012\u0014\u0012\u0004\u0012\u00020\u0015\u0012\n\u0012\b\u0012\u0004\u0012\u00020-0,0+\u0012\u0004\u0012\u00020\u00020*2\u0006\u0010\u001d\u001a\u00020\u0002H\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\u00020\nX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006."}, d2={"Lorg/jetbrains/wip/WipBreakpointManager;", "Lorg/jetbrains/wip/BreakpointManagerBase;", "Lorg/jetbrains/wip/WipBreakpoint;", "vm", "Lorg/jetbrains/wip/WipVm;", "<init>", "(Lorg/jetbrains/wip/WipVm;)V", "getVm", "()Lorg/jetbrains/wip/WipVm;", "breakpointsActive", "", "regExpBreakpointSupported", "getRegExpBreakpointSupported", "()Z", "createBreakpoint", "target", "Lorg/jetbrains/debugger/BreakpointTarget;", "line", "", "column", "condition", "", "ignoreCount", "enabled", "doSetBreakpoint", "Lorg/jetbrains/concurrency/Promise;", "Lorg/jetbrains/debugger/Breakpoint;", "url", "Lcom/intellij/util/Url;", "breakpoint", "doClearBreakpoint", "clearNonProvisionalBreakpoints", "", "breakpointReportedResolved", "eventData", "Lorg/jetbrains/wip/protocol/debugger/BreakpointResolvedEventData;", "enableBreakpoints", "setBreakOnFirstStatement", "isBreakOnFirstStatement", "context", "Lorg/jetbrains/debugger/SuspendContext;", "breakpointResolvedHandler", "Lkotlin/Function1;", "Lcom/intellij/openapi/util/Pair;", "", "Lorg/jetbrains/wip/protocol/debugger/LocationValue;", "intellij.javascript.wip.backend"})
@SourceDebugExtension(value={"SMAP\nWipBreakpointManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WipBreakpointManager.kt\norg/jetbrains/wip/WipBreakpointManager\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,144:1\n1#2:145\n23#3:146\n*S KotlinDebug\n*F\n+ 1 WipBreakpointManager.kt\norg/jetbrains/wip/WipBreakpointManager\n*L\n88#1:146\n*E\n"})
public class WipBreakpointManager
extends BreakpointManagerBase<WipBreakpoint> {
    @NotNull
    private final WipVm vm;
    private boolean breakpointsActive;
    private final boolean regExpBreakpointSupported;

    public WipBreakpointManager(@NotNull WipVm vm) {
        Intrinsics.checkNotNullParameter((Object)((Object)vm), (String)"vm");
        this.vm = vm;
        this.breakpointsActive = true;
        this.regExpBreakpointSupported = true;
    }

    @NotNull
    public final WipVm getVm() {
        return this.vm;
    }

    public boolean getRegExpBreakpointSupported() {
        return this.regExpBreakpointSupported;
    }

    @Override
    @NotNull
    protected WipBreakpoint createBreakpoint(@NotNull BreakpointTarget target, int line, int column, @Nullable String condition, int ignoreCount, boolean enabled) {
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        return new WipBreakpoint(target, line, column, condition, enabled);
    }

    @Override
    @NotNull
    protected Promise<Breakpoint> doSetBreakpoint(@NotNull BreakpointTarget target, @Nullable Url url, @NotNull WipBreakpoint breakpoint) {
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        Intrinsics.checkNotNullParameter((Object)breakpoint, (String)"breakpoint");
        Function1<Pair<String, List<? extends LocationValue>>, WipBreakpoint> breakpointResolvedHandler = this.breakpointResolvedHandler(breakpoint);
        Promise promise = WipBreakpointManagerKt.sendSetBreakpointRequest(target, breakpoint.getLine(), breakpoint.getColumn(), breakpoint.getCondition(), this.vm.getCommandProcessor()).then(arg_0 -> WipBreakpointManager.doSetBreakpoint$lambda$0(breakpointResolvedHandler, arg_0)).then(arg_0 -> WipBreakpointManager.doSetBreakpoint$lambda$2(arg_0 -> WipBreakpointManager.doSetBreakpoint$lambda$1(breakpoint, arg_0), arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)promise, (String)"then(...)");
        return promise;
    }

    @Override
    @NotNull
    protected Promise<?> doClearBreakpoint(@NotNull WipBreakpoint breakpoint) {
        String string;
        block3: {
            block2: {
                Intrinsics.checkNotNullParameter((Object)breakpoint, (String)"breakpoint");
                string = breakpoint.getVmIdImmediately();
                if (string == null) break block2;
                String it = string;
                boolean bl = false;
                Promise promise = this.vm.getCommandProcessor().send((Request)DebuggerKt.RemoveBreakpoint((CharSequence)it));
                string = promise;
                if (promise != null) break block3;
            }
            string = Promises.resolvedPromise((Object)Unit.INSTANCE);
        }
        return string;
    }

    public final void clearNonProvisionalBreakpoints() {
        SmartList deleteList = new SmartList();
        for (WipBreakpoint breakpoint : this.getBreakpoints()) {
            if (breakpoint.getTarget() instanceof BreakpointTarget.ScriptId) {
                deleteList.add((Object)breakpoint);
                continue;
            }
            breakpoint.clearActualLocations();
        }
        Iterator iterator = deleteList.iterator();
        Intrinsics.checkNotNullExpressionValue((Object)iterator, (String)"iterator(...)");
        Iterator iterator2 = iterator;
        while (iterator2.hasNext()) {
            WipBreakpoint breakpoint;
            Object e = iterator2.next();
            Intrinsics.checkNotNullExpressionValue(e, (String)"next(...)");
            breakpoint = (WipBreakpoint)e;
            try {
                this.getBreakpoints().remove(breakpoint);
                this.getBreakpointDuplicationByTarget().remove(breakpoint);
                ((BreakpointListener)this.getDispatcher().getMulticaster()).nonProvisionalBreakpointRemoved((Breakpoint)breakpoint);
            }
            catch (Throwable e2) {
                WipBreakpointManager $this$thisLogger$iv = this;
                boolean $i$f$thisLogger = false;
                Logger logger = Logger.getInstance(WipBreakpointManager.class);
                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
                logger.error(e2);
            }
        }
    }

    public final void breakpointReportedResolved(@NotNull BreakpointResolvedEventData eventData) {
        Object v0;
        block2: {
            Intrinsics.checkNotNullParameter((Object)eventData, (String)"eventData");
            String vmId = eventData.breakpointId();
            Iterable iterable = this.getBreakpoints();
            for (Object t : iterable) {
                WipBreakpoint it = (WipBreakpoint)t;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)vmId, (Object)it.getVmIdImmediately())) continue;
                v0 = t;
                break block2;
            }
            v0 = null;
        }
        WipBreakpoint wipBreakpoint = v0;
        if (wipBreakpoint == null) {
            return;
        }
        WipBreakpoint breakpoint = wipBreakpoint;
        breakpoint.addResolvedLocation(eventData.location());
        this.notifyBreakpointResolvedListener((BreakpointBase)breakpoint);
    }

    @Override
    @NotNull
    public Promise<?> enableBreakpoints(boolean enabled) {
        this.breakpointsActive = enabled;
        return this.vm.getCommandProcessor().send((Request)DebuggerKt.SetBreakpointsActive((boolean)enabled));
    }

    @Override
    public void setBreakOnFirstStatement() {
        this.vm.getCommandProcessor().send((Request)DebuggerKt.SetInstrumentationBreakpoint((Instrumentation)Instrumentation.BEFORE_SCRIPT_WITH_SOURCE_MAP_EXECUTION));
    }

    @Override
    public boolean isBreakOnFirstStatement(@NotNull SuspendContext<?> context) {
        Intrinsics.checkNotNullParameter(context, (String)"context");
        return context instanceof WipSuspendContext && ((WipSuspendContext)context).isBreakOnFirstStatement();
    }

    private final Function1<Pair<String, List<? extends LocationValue>>, WipBreakpoint> breakpointResolvedHandler(WipBreakpoint breakpoint) {
        return arg_0 -> WipBreakpointManager.breakpointResolvedHandler$lambda$0(breakpoint, this, arg_0);
    }

    private static final WipBreakpoint doSetBreakpoint$lambda$0(Function1 $tmp0, Object p0) {
        return (WipBreakpoint)$tmp0.invoke(p0);
    }

    private static final Breakpoint doSetBreakpoint$lambda$1(WipBreakpoint $breakpoint, WipBreakpoint it) {
        return $breakpoint;
    }

    private static final Breakpoint doSetBreakpoint$lambda$2(Function1 $tmp0, Object p0) {
        return (Breakpoint)$tmp0.invoke(p0);
    }

    private static final WipBreakpoint breakpointResolvedHandler$lambda$0(WipBreakpoint $breakpoint, WipBreakpointManager this$0, Pair it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        Object object = it.first;
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"first");
        $breakpoint.updateVmRegistered$intellij_javascript_wip_backend((String)object);
        $breakpoint.addResolvedLocations((List)it.second);
        this$0.notifyBreakpointResolvedListener((BreakpointBase)$breakpoint);
        return $breakpoint;
    }
}

