/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.remoteServer.impl.module;

import com.intellij.DynamicBundle;
import com.intellij.ide.util.projectWizard.ModuleWizardStep;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.project.Project;
import com.intellij.remoteServer.ServerType;
import com.intellij.remoteServer.configuration.RemoteServer;
import com.intellij.remoteServer.impl.module.CloudApplicationConfigurable;
import com.intellij.remoteServer.impl.module.CloudModuleBuilder;
import com.intellij.remoteServer.impl.module.CloudModuleBuilderContributionFactory;
import com.intellij.remoteServer.util.CloudAccountSelectionEditor;
import com.intellij.ui.TitledSeparator;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.JPanel;

public class CloudModuleWizardStep
extends ModuleWizardStep {
    private JPanel myMainPanel;
    private JPanel myAccountPanelPlaceHolder;
    private JPanel myApplicationPanelPlaceHolder;
    private final CloudModuleBuilder myModuleBuilder;
    private final Project myProject;
    private final Disposable myParentDisposable;
    private final CloudAccountSelectionEditor myAccountSelectionPanel;
    private final Set<ServerType<?>> myApplicationConfigurableTypes;

    public CloudModuleWizardStep(CloudModuleBuilder moduleBuilder, Project project, Disposable parentDisposable) {
        this.myModuleBuilder = moduleBuilder;
        this.myProject = project;
        this.myParentDisposable = parentDisposable;
        this.$$$setupUI$$$();
        this.myApplicationConfigurableTypes = new HashSet();
        ArrayList cloudTypes = new ArrayList();
        for (CloudModuleBuilderContributionFactory contribution : (CloudModuleBuilderContributionFactory[])CloudModuleBuilderContributionFactory.EP_NAME.getExtensions()) {
            cloudTypes.add(contribution.getCloudType());
        }
        this.myAccountSelectionPanel = new CloudAccountSelectionEditor(cloudTypes);
        this.myAccountPanelPlaceHolder.add(this.myAccountSelectionPanel.getMainPanel());
        this.myAccountSelectionPanel.setAccountSelectionListener(() -> this.onAccountSelectionChanged());
        this.onAccountSelectionChanged();
    }

    private RemoteServer<?> getSelectedAccount() {
        return this.myAccountSelectionPanel.getSelectedAccount();
    }

    private void onAccountSelectionChanged() {
        CardLayout applicationPlaceHolderLayout = (CardLayout)this.myApplicationPanelPlaceHolder.getLayout();
        RemoteServer<?> account = this.getSelectedAccount();
        boolean haveAccount = account != null;
        this.myApplicationPanelPlaceHolder.setVisible(haveAccount);
        if (!haveAccount) {
            return;
        }
        ServerType cloudType = account.getType();
        String cardName = cloudType.getId();
        CloudApplicationConfigurable applicationConfigurable = this.getApplicationConfigurable();
        if (this.myApplicationConfigurableTypes.add(cloudType)) {
            this.myApplicationPanelPlaceHolder.add(applicationConfigurable.getComponent(), cardName);
        }
        applicationPlaceHolderLayout.show(this.myApplicationPanelPlaceHolder, cardName);
        applicationConfigurable.setAccount(account);
    }

    public JComponent getComponent() {
        return this.myMainPanel;
    }

    private CloudApplicationConfigurable getApplicationConfigurable() {
        RemoteServer<?> account = this.getSelectedAccount();
        if (account == null) {
            return null;
        }
        return this.myModuleBuilder.getContribution(account.getType()).getApplicationConfigurable(this.myProject, this.myParentDisposable);
    }

    public void updateDataModel() {
        this.myModuleBuilder.setAccount(this.myAccountSelectionPanel.getSelectedAccount());
        CloudApplicationConfigurable configurable = this.getApplicationConfigurable();
        this.myModuleBuilder.setApplicationConfiguration(configurable == null ? null : configurable.createConfiguration());
    }

    public boolean validate() throws ConfigurationException {
        this.myAccountSelectionPanel.validate();
        CloudApplicationConfigurable configurable = this.getApplicationConfigurable();
        if (configurable != null) {
            configurable.validate();
        }
        return super.validate();
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JPanel jPanel;
        JPanel jPanel2;
        JPanel jPanel3;
        this.myMainPanel = jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(5, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        this.myAccountPanelPlaceHolder = jPanel2 = new JPanel();
        jPanel2.setLayout(new BorderLayout(0, 0));
        jPanel3.add((Component)jPanel2, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        Spacer spacer = new Spacer();
        jPanel3.add((Component)spacer, new GridConstraints(4, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        TitledSeparator titledSeparator = new TitledSeparator();
        titledSeparator.setText(DynamicBundle.getBundle((String)"messages/CloudBundle", CloudModuleWizardStep.class).getString("CloudModuleWizardStep.title.account"));
        jPanel3.add((Component)titledSeparator, new GridConstraints(0, 0, 1, 1, 0, 1, 3, 0, null, null, null));
        TitledSeparator titledSeparator2 = new TitledSeparator();
        titledSeparator2.setText(DynamicBundle.getBundle((String)"messages/CloudBundle", CloudModuleWizardStep.class).getString("CloudModuleWizardStep.title.application"));
        jPanel3.add((Component)titledSeparator2, new GridConstraints(2, 0, 1, 1, 0, 1, 3, 0, null, null, null));
        this.myApplicationPanelPlaceHolder = jPanel = new JPanel();
        jPanel.setLayout(new CardLayout(0, 0));
        jPanel3.add((Component)jPanel, new GridConstraints(3, 0, 1, 1, 0, 3, 3, 3, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myMainPanel;
    }
}

