import type {
  AreTypesMutuallyAssignableResponse,
  GetCompletionSymbolsResponse,
  GetElementTypeResponse,
  GetResolvedSignatureResponse,
  GetSymbolTypeResponse,
  GetTypeTextResponse,
  SymbolResponse,
  TypeRequestKind
} from "../protocol"
import type {ReverseMapper} from "../ide-get-element-type"
import type {IdeProjectService} from "../ide-project-service"

declare global {
  type RegularMap<K, V> = Map<K, V>

  type ErrorKind = OperationCancelledException | FileOutsideOfImportGraphException | OutdatedTypeCheckerIdException

  type OperationCancelledException = "OperationCancelledException"
  type FileOutsideOfImportGraphException = "FileOutsideOfImportGraphException"
  type OutdatedTypeCheckerIdException = "OutdatedTypeCheckerIdException"

  interface Error {
    ideKind?: ErrorKind
  }
}

declare module "typescript/lib/tsserverlibrary" {

  interface TypeChecker {
    webStormCacheInfo?: {
      ideTypeCheckerId: number,
      ideProjectId: number,
      requestedTypeIds: Set<number>,
      seenTypeIds: RegularMap<number, Type>,
      seenSymbolIds: RegularMap<number, Symbol>,
    }
  }

  interface Type {
    id: number | undefined // internal
  }

  type WebStormGetOptions = {
    ts: typeof import("typescript/lib/tsserverlibrary"),
    cancellationToken: HostCancellationToken,
    reverseMapper?: ReverseMapper,
  }

  interface LanguageService {

    ideProjectId: number

    webStormGetCompletionSymbols(
      options: WebStormGetOptions & {
        fileName: string,
        position: number,
        ls: LanguageService,
      }
    ): GetCompletionSymbolsResponse

    webStormGetElementType(
      options: WebStormGetOptions & {
        fileName: string,
        startOffset: number,
        endOffset: number,
        typeRequestKind: TypeRequestKind,
        forceReturnType: boolean,
      },
    ): GetElementTypeResponse

    webStormGetSymbolType(
      options: WebStormGetOptions & {
        symbolId: number,
      },
    ): GetSymbolTypeResponse

    webStormGetTypeText(
      options: Omit<WebStormGetOptions, "reverseMapper"> & {
        typeId?: number,
        symbolId?: number,
        flags?: number,
      },
    ): GetTypeTextResponse

    webStormGetTypeProperties(
      options: WebStormGetOptions & {
        typeId: number,
      },
    ): GetElementTypeResponse

    webStormGetTypeProperty(
      options: WebStormGetOptions & {
        typeId: number,
        propertyName: string,
      },
    ): SymbolResponse

    webStormAreTypesMutuallyAssignable(
      options: Omit<WebStormGetOptions, "reverseMapper"> & {
        type1Id: number,
        type2Id: number,
      },
    ): AreTypesMutuallyAssignableResponse

    webStormGetResolvedSignature(
      options: WebStormGetOptions & {
        fileName: string,
        startOffset: number,
        endOffset: number,
      },
    ): GetResolvedSignatureResponse
  }

  namespace server {
    interface ExternalProject {
      // TS 4 (hidden in TS 5)
      readonly projectName: string
    }

    interface ProjectService {
      ideProjectService: IdeProjectService
    }

    interface Project {
      // TS 4 (hidden in TS 5)
      readonly projectName: string

      ideProjectId: number
    }
  }

  function getTokenAtPosition(sourceFile: SourceFile, startOffset: number): Node

  function isEqualityOperatorKind(kind: SyntaxKind): kind is EqualityOperator
}
