def initKernel():
    import importlib.util

    def _has(name):
        return importlib.util.find_spec(name) is not None

    __dark = {{THEME_IS_DARK}}
    try:
        if _has("seaborn"):
            import seaborn as sns
            sns.set_style('darkgrid' if __dark else 'whitegrid')
    except:
        pass

    try:
        if _has("bokeh"):
            from bokeh.io import curdoc
            curdoc().theme = 'dark_minimal' if __dark else 'light_minimal'
    except:
        pass

    try:
        if _has("matplotlib"):
            from matplotlib import pyplot as plt
            plt.style.use('dark_background' if __dark else 'default')
    except:
        pass

    try:
        if _has("plotly"):
            import plotly.io as pio
            pio.templates.default = "plotly_dark" if __dark else "plotly"
    except:
        pass
try:
    initKernel()
except:
    pass

del initKernel
#sometimes it does not return reply and we want to force it with return smth
12