/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.java.decompiler.main.rels;

import java.io.IOException;
import java.util.BitSet;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.jetbrains.java.decompiler.code.Instruction;
import org.jetbrains.java.decompiler.code.InstructionSequence;
import org.jetbrains.java.decompiler.main.ClassesProcessor;
import org.jetbrains.java.decompiler.main.DecompilerContext;
import org.jetbrains.java.decompiler.struct.StructClass;
import org.jetbrains.java.decompiler.struct.StructMethod;
import org.jetbrains.java.decompiler.struct.attr.StructBootstrapMethodsAttribute;
import org.jetbrains.java.decompiler.struct.attr.StructGeneralAttribute;
import org.jetbrains.java.decompiler.struct.consts.LinkConstant;
import org.jetbrains.java.decompiler.struct.consts.PooledConstant;
import org.jetbrains.java.decompiler.struct.consts.PrimitiveConstant;
import org.jetbrains.java.decompiler.struct.gen.MethodDescriptor;
import org.jetbrains.java.decompiler.util.InterpreterUtil;

public class LambdaProcessor {
    private static final String JAVAC_LAMBDA_CLASS = "java/lang/invoke/LambdaMetafactory";
    private static final String JAVAC_LAMBDA_METHOD = "metafactory";
    private static final String JAVAC_LAMBDA_ALT_METHOD = "altMetafactory";

    public void processClass(ClassesProcessor.ClassNode node) throws IOException {
        for (ClassesProcessor.ClassNode child : node.nested) {
            this.processClass(child);
        }
        ClassesProcessor clProcessor = DecompilerContext.getClassProcessor();
        StructClass cl = node.classStruct;
        if (!cl.isVersion8()) {
            return;
        }
        StructBootstrapMethodsAttribute bootstrap = cl.getAttribute(StructGeneralAttribute.ATTRIBUTE_BOOTSTRAP_METHODS);
        if (bootstrap == null || bootstrap.getMethodsNumber() == 0) {
            return;
        }
        BitSet lambdaMethods = new BitSet();
        for (int i = 0; i < bootstrap.getMethodsNumber(); ++i) {
            LinkConstant method_ref = bootstrap.getMethodReference(i);
            if (!JAVAC_LAMBDA_CLASS.equals(method_ref.className) || !JAVAC_LAMBDA_METHOD.equals(method_ref.elementName) && !JAVAC_LAMBDA_ALT_METHOD.equals(method_ref.elementName)) continue;
            lambdaMethods.set(i);
        }
        if (lambdaMethods.isEmpty()) {
            return;
        }
        HashMap<String, String> mapMethodsLambda = new HashMap<String, String>();
        for (StructMethod mt : cl.getMethods()) {
            mt.expandData(cl);
            InstructionSequence seq = mt.getInstructionSequence();
            if (seq != null && seq.length() > 0) {
                int len = seq.length();
                for (int i = 0; i < len; ++i) {
                    Instruction instr = seq.getInstr(i);
                    if (instr.opcode != 186) continue;
                    LinkConstant invoke_dynamic = cl.getPool().getLinkConstant(instr.operand(0));
                    if (!lambdaMethods.get(invoke_dynamic.index1)) continue;
                    List<PooledConstant> bootstrap_arguments = bootstrap.getMethodArguments(invoke_dynamic.index1);
                    MethodDescriptor md = MethodDescriptor.parseDescriptor(invoke_dynamic.descriptor);
                    String lambda_class_name = md.ret.getValue();
                    String lambda_method_name = invoke_dynamic.elementName;
                    String lambda_method_descriptor = ((PrimitiveConstant)bootstrap_arguments.get(2)).getString();
                    LinkConstant content_method_handle = (LinkConstant)bootstrap_arguments.get(1);
                    ClassesProcessor.ClassNode node_lambda = new ClassesProcessor.ClassNode(content_method_handle.className, content_method_handle.elementName, content_method_handle.descriptor, content_method_handle.index1, lambda_class_name, lambda_method_name, lambda_method_descriptor, cl);
                    node_lambda.simpleName = cl.qualifiedName + "##Lambda_" + invoke_dynamic.index1 + "_" + invoke_dynamic.index2;
                    node_lambda.enclosingMethod = InterpreterUtil.makeUniqueKey(mt.getName(), mt.getDescriptor());
                    node.nested.add(node_lambda);
                    node_lambda.parent = node;
                    clProcessor.getMapRootClasses().put(node_lambda.simpleName, node_lambda);
                    if (node_lambda.lambdaInformation.is_method_reference) continue;
                    mapMethodsLambda.put(node_lambda.lambdaInformation.content_method_key, node_lambda.simpleName);
                }
            }
            mt.releaseResources();
        }
        Collections.sort(node.nested);
        for (ClassesProcessor.ClassNode nd : node.nested) {
            String parent_class_name;
            if (nd.type != 8 || (parent_class_name = (String)mapMethodsLambda.get(nd.enclosingMethod)) == null) continue;
            ClassesProcessor.ClassNode parent_class = clProcessor.getMapRootClasses().get(parent_class_name);
            parent_class.nested.add(nd);
            nd.parent = parent_class;
            Collections.sort(parent_class.nested);
        }
    }
}

