/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.javaFX.jpackage;

import com.intellij.execution.CommandLineUtil;
import com.intellij.execution.process.BaseOSProcessHandler;
import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.process.ProcessOutputTypes;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.text.StringUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.builders.artifacts.ArtifactBuildTaskProvider;
import org.jetbrains.jps.incremental.BuildTask;
import org.jetbrains.jps.incremental.CompileContext;
import org.jetbrains.jps.incremental.ProjectBuildException;
import org.jetbrains.jps.incremental.messages.BuildMessage;
import org.jetbrains.jps.incremental.messages.CompilerMessage;
import org.jetbrains.jps.model.JpsElement;
import org.jetbrains.jps.model.artifact.JpsArtifact;
import org.jetbrains.jps.model.artifact.elements.JpsArchivePackagingElement;
import org.jetbrains.jps.model.artifact.elements.JpsPackagingElement;
import org.jetbrains.jps.model.java.JpsJavaSdkType;
import org.jetbrains.jps.model.library.sdk.JpsSdk;
import org.jetbrains.jps.model.library.sdk.JpsSdkType;
import org.jetbrains.plugins.javaFX.JavaFXJpsBundle;
import org.jetbrains.plugins.javaFX.jpackage.JPackageArtifactProperties;
import org.jetbrains.plugins.javaFX.jpackage.JPackageJpsArtifactType;

public class JPackageArtifactBuildTaskProvider
extends ArtifactBuildTaskProvider {
    @NotNull
    public List<JPackageBuildTask> createArtifactBuildTasks(@NotNull JpsArtifact artifact, @NotNull ArtifactBuildTaskProvider.ArtifactBuildPhase buildPhase) {
        if (artifact == null) {
            JPackageArtifactBuildTaskProvider.$$$reportNull$$$0(0);
        }
        if (buildPhase == null) {
            JPackageArtifactBuildTaskProvider.$$$reportNull$$$0(1);
        }
        if (buildPhase != ArtifactBuildTaskProvider.ArtifactBuildPhase.POST_PROCESSING || !(artifact.getArtifactType() instanceof JPackageJpsArtifactType)) {
            List<JPackageBuildTask> list = Collections.emptyList();
            if (list == null) {
                JPackageArtifactBuildTaskProvider.$$$reportNull$$$0(2);
            }
            return list;
        }
        JpsElement properties = artifact.getProperties();
        if (!(properties instanceof JPackageArtifactProperties)) {
            List<JPackageBuildTask> list = Collections.emptyList();
            if (list == null) {
                JPackageArtifactBuildTaskProvider.$$$reportNull$$$0(3);
            }
            return list;
        }
        List<JPackageBuildTask> list = Collections.singletonList(new JPackageBuildTask(artifact));
        if (list == null) {
            JPackageArtifactBuildTaskProvider.$$$reportNull$$$0(4);
        }
        return list;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "artifact";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "buildPhase";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/javaFX/jpackage/JPackageArtifactBuildTaskProvider";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/javaFX/jpackage/JPackageArtifactBuildTaskProvider";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "createArtifactBuildTasks";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createArtifactBuildTasks";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class JPackageBuildTask
    extends BuildTask {
        private final JpsArtifact myArtifact;

        JPackageBuildTask(JpsArtifact artifact) {
            this.myArtifact = artifact;
        }

        public void build(CompileContext context) throws ProjectBuildException {
            Set sdks = context.getProjectDescriptor().getProjectJavaSdks();
            JpsSdk javaSdk = null;
            for (JpsSdk sdk : sdks) {
                JpsSdkType sdkType = sdk.getSdkType();
                if (!(sdkType instanceof JpsJavaSdkType)) continue;
                javaSdk = sdk;
                break;
            }
            if (javaSdk == null) {
                context.processMessage((BuildMessage)new CompilerMessage(JavaFXJpsBundle.message("java.fx.packager", new Object[0]), BuildMessage.Kind.ERROR, JavaFXJpsBundle.message("java.version.7.or.higher.is.required.to.build.javafx.package", new Object[0])));
                return;
            }
            new JPackageTool(this.myArtifact, context).start();
        }
    }

    private static class JPackageTool {
        private static final Logger LOG = Logger.getInstance(JPackageTool.class);
        private final JpsArtifact myArtifact;
        private final JPackageArtifactProperties myProperties;
        private final CompileContext myCompileContext;

        JPackageTool(JpsArtifact artifact, CompileContext context) {
            this.myArtifact = artifact;
            this.myProperties = (JPackageArtifactProperties)artifact.getProperties();
            this.myCompileContext = context;
        }

        public void start() {
            Set sdks = this.myCompileContext.getProjectDescriptor().getProjectJavaSdks();
            JpsSdk javaSdk = null;
            for (JpsSdk sdk : sdks) {
                JpsSdkType sdkType = sdk.getSdkType();
                if (!(sdkType instanceof JpsJavaSdkType) || JpsJavaSdkType.getJavaVersion((JpsSdk)sdk) < 14) continue;
                javaSdk = sdk;
                break;
            }
            if (javaSdk == null) {
                this.error(JavaFXJpsBundle.message("java.version.14.or.higher.is.required.to.build.platform.specific.package.using.jpackage", new Object[0]));
                return;
            }
            String homePath = javaSdk.getHomePath();
            String jpackagePath = homePath + File.separatorChar + "bin" + File.separatorChar + "jpackage";
            String archiveName = this.getArchiveName();
            if (archiveName == null) {
                this.error(JavaFXJpsBundle.message("no.archive.found", new Object[0]));
                return;
            }
            ArrayList<String> commands = new ArrayList<String>();
            commands.add(jpackagePath);
            String outputPath = this.myArtifact.getOutputFilePath();
            if (this.myProperties.verbose) {
                commands.add("--verbose");
            }
            JPackageTool.addOption(commands, "--input", outputPath);
            JPackageTool.addOption(commands, "--main-jar", archiveName);
            JPackageTool.addOption(commands, "--name", this.myArtifact.getName());
            JPackageTool.addOption(commands, "--dest", outputPath);
            JPackageTool.addOption(commands, "--app-version", this.myProperties.version);
            JPackageTool.addOption(commands, "--copyright", this.myProperties.copyright);
            JPackageTool.addOption(commands, "--description", this.myProperties.description);
            JPackageTool.addOption(commands, "--vendor", this.myProperties.vendor);
            JPackageTool.addOption(commands, "--main-class", this.myProperties.mainClass);
            int errorCode = this.startProcess(commands);
            if (errorCode != 0) {
                this.error(JavaFXJpsBundle.message("jpackage.task.has.failed", new Object[0]));
            }
        }

        private static void addOption(List<String> commands, @NotNull String key, @Nullable String value) {
            if (key == null) {
                JPackageTool.$$$reportNull$$$0(0);
            }
            if (!StringUtil.isEmpty((String)value)) {
                commands.add(key);
                commands.add(value);
            }
        }

        private String getArchiveName() {
            for (JpsPackagingElement element : this.myArtifact.getRootElement().getChildren()) {
                if (!(element instanceof JpsArchivePackagingElement)) continue;
                return ((JpsArchivePackagingElement)element).getArchiveName();
            }
            return null;
        }

        private void error(@Nls String message) {
            this.myCompileContext.processMessage((BuildMessage)new CompilerMessage("jpackage", BuildMessage.Kind.ERROR, message));
        }

        private void info(@Nls String message) {
            this.myCompileContext.processMessage((BuildMessage)new CompilerMessage("jpackage", BuildMessage.Kind.INFO, message));
        }

        private int startProcess(final List<String> commands) {
            try {
                final AtomicInteger exitCode = new AtomicInteger();
                final @NlsSafe StringBuilder errorOutput = new StringBuilder();
                final ArrayList<@NlsSafe E> delayedInfoOutput = new ArrayList();
                Process process = new ProcessBuilder(CommandLineUtil.toCommandLine(commands)).start();
                BaseOSProcessHandler handler = new BaseOSProcessHandler(process, commands.toString(), null);
                handler.addProcessListener((ProcessListener)new ProcessAdapter(){

                    public void startNotified(@NotNull ProcessEvent event) {
                        if (event == null) {
                            1.$$$reportNull$$$0(0);
                        }
                        if (myProperties.verbose) {
                            LOG.info("Started " + commands);
                        }
                    }

                    public void processTerminated(@NotNull ProcessEvent event) {
                        if (event == null) {
                            1.$$$reportNull$$$0(1);
                        }
                        if (myProperties.verbose) {
                            LOG.info("Terminated " + commands + ", exit code: " + event.getExitCode());
                        }
                        exitCode.set(event.getExitCode());
                    }

                    public void onTextAvailable(@NotNull ProcessEvent event, @NotNull Key outputType) {
                        if (event == null) {
                            1.$$$reportNull$$$0(2);
                        }
                        if (outputType == null) {
                            1.$$$reportNull$$$0(3);
                        }
                        String message = StringUtil.trimTrailing((String)event.getText());
                        if (outputType == ProcessOutputTypes.STDERR) {
                            LOG.error(message, (Throwable)null);
                            errorOutput.append(event.getText());
                        } else {
                            LOG.info(message);
                            if (myProperties.verbose) {
                                this.info(message);
                            } else {
                                delayedInfoOutput.add(message);
                            }
                        }
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        Object[] objectArray;
                        Object[] objectArray2;
                        Object[] objectArray3 = new Object[3];
                        switch (n) {
                            default: {
                                objectArray2 = objectArray3;
                                objectArray3[0] = "event";
                                break;
                            }
                            case 3: {
                                objectArray2 = objectArray3;
                                objectArray3[0] = "outputType";
                                break;
                            }
                        }
                        objectArray2[1] = "org/jetbrains/plugins/javaFX/jpackage/JPackageArtifactBuildTaskProvider$JPackageTool$1";
                        switch (n) {
                            default: {
                                objectArray = objectArray2;
                                objectArray2[2] = "startNotified";
                                break;
                            }
                            case 1: {
                                objectArray = objectArray2;
                                objectArray2[2] = "processTerminated";
                                break;
                            }
                            case 2: 
                            case 3: {
                                objectArray = objectArray2;
                                objectArray2[2] = "onTextAvailable";
                                break;
                            }
                        }
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                    }
                });
                handler.startNotify();
                handler.waitFor();
                int result = exitCode.get();
                if (result != 0) {
                    String message = errorOutput.toString();
                    if (!StringUtil.isEmptyOrSpaces((String)message)) {
                        this.error(message);
                    }
                    for (String info : delayedInfoOutput) {
                        this.error(info);
                    }
                }
                return result;
            }
            catch (Exception e) {
                this.error(e.getMessage());
                LOG.warn((Throwable)e);
                return -1;
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "org/jetbrains/plugins/javaFX/jpackage/JPackageArtifactBuildTaskProvider$JPackageTool", "addOption"));
        }
    }
}

