/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.coverage;

import com.intellij.coverage.AbstractCoverageProjectViewNodeDecorator;
import com.intellij.coverage.CoverageAnnotator;
import com.intellij.coverage.CoverageDataManager;
import com.intellij.coverage.CoverageSuitesBundle;
import com.intellij.coverage.JavaCoverageEngineExtension;
import com.intellij.coverage.analysis.JavaCoverageAnnotator;
import com.intellij.coverage.analysis.PackageAnnotator;
import com.intellij.ide.projectView.PresentationData;
import com.intellij.ide.projectView.ProjectViewNode;
import com.intellij.ide.projectView.impl.nodes.PackageElement;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PsiUtilCore;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class CoverageProjectViewClassNodeDecorator
extends AbstractCoverageProjectViewNodeDecorator {
    CoverageProjectViewClassNodeDecorator() {
    }

    public void decorate(ProjectViewNode node, PresentationData data) {
        block11: {
            PsiElement element;
            JavaCoverageAnnotator javaCovAnnotator;
            CoverageDataManager coverageDataManager;
            block10: {
                String qName;
                Project project = node.getProject();
                if (project == null) {
                    return;
                }
                coverageDataManager = CoverageDataManager.getInstance((Project)project);
                CoverageSuitesBundle javaSuite = CoverageProjectViewClassNodeDecorator.getJavaSuite(coverageDataManager, project);
                if (javaSuite == null) {
                    return;
                }
                javaCovAnnotator = (JavaCoverageAnnotator)javaSuite.getAnnotator(project);
                Object value = node.getValue();
                element = null;
                if (value instanceof PsiElement) {
                    PsiElement psiElement;
                    element = psiElement = (PsiElement)value;
                } else if (value instanceof SmartPsiElementPointer) {
                    SmartPsiElementPointer smartPointer = (SmartPsiElementPointer)value;
                    element = smartPointer.getElement();
                } else if (value instanceof PackageElement) {
                    PackageElement packageElement = (PackageElement)value;
                    String coverageString = javaCovAnnotator.getPackageCoverageInformationString(packageElement.getPackage(), packageElement.getModule(), coverageDataManager);
                    data.setLocationString(coverageString);
                }
                if (!(element instanceof PsiClass)) break block10;
                GlobalSearchScope searchScope = javaSuite.getSearchScope(project);
                VirtualFile vFile = PsiUtilCore.getVirtualFile((PsiElement)element);
                if (vFile == null || !searchScope.contains(vFile) || (qName = ((PsiClass)element).getQualifiedName()) == null) break block11;
                data.setLocationString(javaCovAnnotator.getClassCoverageInformationString(qName, coverageDataManager));
                break block11;
            }
            if (element instanceof PsiNamedElement) {
                PsiNamedElement namedElement = (PsiNamedElement)element;
                if (!(element instanceof PsiFile) && !(element instanceof PsiDirectory)) {
                    for (JavaCoverageEngineExtension extension : (JavaCoverageEngineExtension[])JavaCoverageEngineExtension.EP_NAME.getExtensions()) {
                        PackageAnnotator.ClassCoverageInfo info = extension.getSummaryCoverageInfo(javaCovAnnotator, namedElement);
                        if (info == null) continue;
                        data.setLocationString(JavaCoverageAnnotator.getClassCoverageInformationString(info, coverageDataManager));
                        break;
                    }
                }
            }
        }
    }

    private static CoverageSuitesBundle getJavaSuite(@Nullable CoverageDataManager dataManager, @NotNull Project project) {
        if (project == null) {
            CoverageProjectViewClassNodeDecorator.$$$reportNull$$$0(0);
        }
        if (dataManager == null) {
            return null;
        }
        for (CoverageSuitesBundle bundle : dataManager.activeSuites()) {
            CoverageAnnotator coverageAnnotator = bundle.getAnnotator(project);
            if (!(coverageAnnotator instanceof JavaCoverageAnnotator)) continue;
            return bundle;
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/coverage/CoverageProjectViewClassNodeDecorator", "getJavaSuite"));
    }
}

