/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.eval4j.jdi;

import com.sun.jdi.InvocationException;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.TypeComponent;
import java.util.Set;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.eval4j.Eval4JIllegalArgumentException;
import org.jetbrains.eval4j.Eval4JIllegalStateException;
import org.jetbrains.eval4j.ThrownFromEvaluatedCodeException;
import org.jetbrains.eval4j.ValuesKt;
import org.jetbrains.eval4j.jdi.JdiOperationResult;
import org.jetbrains.eval4j.jdi.JdiValuesKt;
import org.jetbrains.org.objectweb.asm.Type;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u00004\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\u001a\"\u0010\r\u001a\b\u0012\u0004\u0012\u0002H\u000f0\u000e\"\u0004\b\u0000\u0010\u000f2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u0002H\u000f0\u0011H\u0002\u001a\u001a\u0010\u0012\u001a\u00020\b2\u0006\u0010\u0013\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u0016H\u0002\u001a1\u0010\u0017\u001a\u0002H\u000f\"\u0004\b\u0000\u0010\u000f*\b\u0012\u0004\u0012\u0002H\u000f0\u000e2\u0006\u0010\u0013\u001a\u00020\u00142\n\b\u0002\u0010\u0015\u001a\u0004\u0018\u00010\u0016H\u0002\u00a2\u0006\u0002\u0010\u0018\u001a+\u0010\u0017\u001a\u0002H\u000f\"\u0004\b\u0000\u0010\u000f*\b\u0012\u0004\u0012\u0002H\u000f0\u000e2\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\b0\u0011H\u0002\u00a2\u0006\u0002\u0010\u001a\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0014\u0010\u0003\u001a\u00020\u0001X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0004\u0010\u0005\"\u001c\u0010\u0006\u001a\u0010\u0012\f\u0012\n \t*\u0004\u0018\u00010\b0\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0018\u0010\n\u001a\u00020\b*\u00020\u00018@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u001b"}, d2={"CLASS_TYPE", "Lorg/jetbrains/org/objectweb/asm/Type;", "OBJECT_TYPE", "STRING_TYPE", "getSTRING_TYPE", "()Lorg/jetbrains/org/objectweb/asm/Type;", "BOOTSTRAP_CLASS_DESCRIPTORS", "", "", "kotlin.jvm.PlatformType", "jdiName", "getJdiName", "(Lorg/jetbrains/org/objectweb/asm/Type;)Ljava/lang/String;", "mayThrow", "Lorg/jetbrains/eval4j/jdi/JdiOperationResult;", "T", "f", "Lkotlin/Function0;", "memberInfo", "member", "Lcom/sun/jdi/TypeComponent;", "thisObj", "Lcom/sun/jdi/ObjectReference;", "ifFail", "(Lorg/jetbrains/eval4j/jdi/JdiOperationResult;Lcom/sun/jdi/TypeComponent;Lcom/sun/jdi/ObjectReference;)Ljava/lang/Object;", "lazyMessage", "(Lorg/jetbrains/eval4j/jdi/JdiOperationResult;Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "kotlin.jvm-debugger.eval4j"})
public final class JdiEvalKt {
    @NotNull
    private static final Type CLASS_TYPE;
    @NotNull
    private static final Type OBJECT_TYPE;
    @NotNull
    private static final Type STRING_TYPE;
    @NotNull
    private static final Set<String> BOOTSTRAP_CLASS_DESCRIPTORS;

    @NotNull
    public static final Type getSTRING_TYPE() {
        return STRING_TYPE;
    }

    @NotNull
    public static final String getJdiName(@NotNull Type $this$jdiName) {
        Intrinsics.checkNotNullParameter((Object)$this$jdiName, (String)"<this>");
        String string = $this$jdiName.getInternalName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getInternalName(...)");
        return StringsKt.replace$default((String)string, (char)'/', (char)'.', (boolean)false, (int)4, null);
    }

    private static final <T> JdiOperationResult<T> mayThrow(Function0<? extends T> f) {
        JdiOperationResult jdiOperationResult;
        try {
            jdiOperationResult = new JdiOperationResult.OK<Object>(f.invoke());
        }
        catch (IllegalArgumentException e) {
            jdiOperationResult = new JdiOperationResult.Fail(e);
        }
        catch (InvocationException e) {
            throw new ThrownFromEvaluatedCodeException(JdiValuesKt.asValue(e.exception()));
        }
        return jdiOperationResult;
    }

    private static final String memberInfo(TypeComponent member, ObjectReference thisObj) {
        return "\nmember = " + member + "\nobjectRef = " + thisObj;
    }

    private static final <T> T ifFail(JdiOperationResult<T> $this$ifFail, TypeComponent member, ObjectReference thisObj) {
        return JdiEvalKt.ifFail($this$ifFail, (Function0<String>)((Function0)() -> JdiEvalKt.ifFail$lambda$0(member, thisObj)));
    }

    static /* synthetic */ Object ifFail$default(JdiOperationResult jdiOperationResult, TypeComponent typeComponent, ObjectReference objectReference, int n, Object object) {
        if ((n & 2) != 0) {
            objectReference = null;
        }
        return JdiEvalKt.ifFail(jdiOperationResult, typeComponent, objectReference);
    }

    private static final <T> T ifFail(JdiOperationResult<T> $this$ifFail, Function0<String> lazyMessage) {
        JdiOperationResult<T> jdiOperationResult = $this$ifFail;
        if (!(jdiOperationResult instanceof JdiOperationResult.OK)) {
            if (jdiOperationResult instanceof JdiOperationResult.Fail) {
                if (((JdiOperationResult.Fail)$this$ifFail).getCause() instanceof IllegalArgumentException) {
                    ValuesKt.throwBrokenCodeException(new Eval4JIllegalArgumentException((String)lazyMessage.invoke(), ((JdiOperationResult.Fail)$this$ifFail).getCause()));
                    throw new KotlinNothingValueException();
                }
                ValuesKt.throwBrokenCodeException(new Eval4JIllegalStateException((String)lazyMessage.invoke(), ((JdiOperationResult.Fail)$this$ifFail).getCause()));
                throw new KotlinNothingValueException();
            }
            throw new NoWhenBranchMatchedException();
        }
        return ((JdiOperationResult.OK)$this$ifFail).getValue();
    }

    private static final String ifFail$lambda$0(TypeComponent $member, ObjectReference $thisObj) {
        return JdiEvalKt.memberInfo($member, $thisObj);
    }

    public static final /* synthetic */ Set access$getBOOTSTRAP_CLASS_DESCRIPTORS$p() {
        return BOOTSTRAP_CLASS_DESCRIPTORS;
    }

    public static final /* synthetic */ Type access$getCLASS_TYPE$p() {
        return CLASS_TYPE;
    }

    public static final /* synthetic */ JdiOperationResult access$mayThrow(Function0 f) {
        return JdiEvalKt.mayThrow(f);
    }

    public static final /* synthetic */ Object access$ifFail(JdiOperationResult $receiver, TypeComponent member, ObjectReference thisObj) {
        return JdiEvalKt.ifFail($receiver, member, thisObj);
    }

    public static final /* synthetic */ Type access$getOBJECT_TYPE$p() {
        return OBJECT_TYPE;
    }

    static {
        Type type2 = Type.getType(Class.class);
        Intrinsics.checkNotNullExpressionValue((Object)type2, (String)"getType(...)");
        CLASS_TYPE = type2;
        Type type3 = Type.getType(Object.class);
        Intrinsics.checkNotNullExpressionValue((Object)type3, (String)"getType(...)");
        OBJECT_TYPE = type3;
        Type type4 = Type.getType(String.class);
        Intrinsics.checkNotNullExpressionValue((Object)type4, (String)"getType(...)");
        STRING_TYPE = type4;
        Object[] objectArray = new String[]{STRING_TYPE.getDescriptor(), Type.getDescriptor(ClassLoader.class), CLASS_TYPE.getDescriptor()};
        BOOTSTRAP_CLASS_DESCRIPTORS = SetsKt.setOf((Object[])objectArray);
    }
}

