/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.base.platforms;

import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeRegistry;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.impl.libraries.LibraryEx;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.libraries.PersistentLibraryKind;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.RemoveUserDataKt;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileVisitor;
import com.intellij.util.indexing.roots.IndexableFileScanner;
import com.intellij.util.indexing.roots.kind.IndexableSetOrigin;
import com.intellij.util.indexing.roots.kind.LibraryOrigin;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.analysis.decompiler.konan.KlibMetaFileType;
import org.jetbrains.kotlin.analysis.decompiler.psi.KotlinBuiltInFileType;
import org.jetbrains.kotlin.idea.base.platforms.KotlinCommonLibraryKind;
import org.jetbrains.kotlin.idea.base.platforms.KotlinJavaScriptLibraryKind;
import org.jetbrains.kotlin.idea.base.platforms.KotlinJvmEffectiveLibraryKind;
import org.jetbrains.kotlin.idea.base.platforms.KotlinLibraryKind;
import org.jetbrains.kotlin.idea.base.platforms.KotlinLibraryKindGistProvider;
import org.jetbrains.kotlin.idea.base.platforms.LibraryEffectiveKindProviderKt;

@Service(value={Service.Level.PROJECT})
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0007\u0018\u00002\u00020\u0001:\u0002\u0010\u0011B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J!\u0010\u0006\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u00072\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tH\u0002\u00a2\u0006\u0002\u0010\u000bJ\u0014\u0010\f\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u00072\u0006\u0010\r\u001a\u00020\u000eJ\u0016\u0010\u000f\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u0007*\u0006\u0012\u0002\b\u00030\u0007H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/kotlin/idea/base/platforms/LibraryEffectiveKindProvider;", "", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "findKind", "Lcom/intellij/openapi/roots/libraries/PersistentLibraryKind;", "classRoots", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "([Lcom/intellij/openapi/vfs/VirtualFile;)Lcom/intellij/openapi/roots/libraries/PersistentLibraryKind;", "getEffectiveKind", "library", "Lcom/intellij/openapi/roots/libraries/Library;", "nonJvmOrNull", "KnownLibraryKindForIndex", "LibraryKindScanner", "kotlin.base.platforms"})
@SourceDebugExtension(value={"SMAP\nLibraryEffectiveKindProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LibraryEffectiveKindProvider.kt\norg/jetbrains/kotlin/idea/base/platforms/LibraryEffectiveKindProvider\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,233:1\n1#2:234\n*E\n"})
public final class LibraryEffectiveKindProvider {
    @NotNull
    private final Project project;

    public LibraryEffectiveKindProvider(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final PersistentLibraryKind<?> findKind(VirtualFile[] classRoots) {
        VirtualFile virtualFile = (VirtualFile)ArraysKt.firstOrNull((Object[])classRoots);
        if (virtualFile == null) {
            return null;
        }
        VirtualFile virtualFile2 = virtualFile;
        virtualFile2.putUserData(LibraryEffectiveKindProviderKt.access$getCLASS_ROOTS_KEY$p(), (Object)classRoots);
        try {
            PersistentLibraryKind persistentLibraryKind = (PersistentLibraryKind)ActionsKt.runReadAction(() -> LibraryEffectiveKindProvider.findKind$lambda$0(this, virtualFile2));
            return persistentLibraryKind;
        }
        finally {
            RemoveUserDataKt.removeUserData((UserDataHolder)((UserDataHolder)virtualFile2), (Key)LibraryEffectiveKindProviderKt.access$getCLASS_ROOTS_KEY$p());
        }
    }

    @Nullable
    public final PersistentLibraryKind<?> getEffectiveKind(@NotNull Library library) {
        PersistentLibraryKind<?> persistentLibraryKind;
        block9: {
            PersistentLibraryKind<?> nonJvmOrNull;
            PersistentLibraryKind<?> platformKind;
            Object object;
            block11: {
                VirtualFile classRoot;
                Object[] classRoots;
                block10: {
                    PersistentLibraryKind<?> persistentLibraryKind2;
                    block8: {
                        Intrinsics.checkNotNullParameter((Object)library, (String)"library");
                        if (!(library instanceof LibraryEx)) {
                            String string = "Failed requirement.";
                            throw new IllegalArgumentException(string.toString());
                        }
                        if (((LibraryEx)library).isDisposed()) {
                            return null;
                        }
                        PersistentLibraryKind<?> kind2 = ((LibraryEx)library).getKind();
                        if (!(kind2 instanceof KotlinLibraryKind)) break block8;
                        persistentLibraryKind = kind2;
                        break block9;
                    }
                    Object[] objectArray = library.getFiles(OrderRootType.CLASSES);
                    Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"getFiles(...)");
                    classRoots = objectArray;
                    VirtualFile virtualFile = (VirtualFile)ArraysKt.firstOrNull((Object[])classRoots);
                    if (virtualFile == null) {
                        return null;
                    }
                    classRoot = virtualFile;
                    object = (PersistentLibraryKind<?>)classRoot.getUserData(LibraryEffectiveKindProviderKt.access$getLIBRARY_KIND_KEY$p());
                    if (object == null) break block10;
                    PersistentLibraryKind<?> it = persistentLibraryKind2 = object;
                    boolean bl = false;
                    object = !Intrinsics.areEqual((Object)it, (Object)LibraryEffectiveKindProviderKt.access$getNEEDS_TO_BE_CLARIFIED_KIND()) ? persistentLibraryKind2 : null;
                    if (object != null) break block11;
                }
                PersistentLibraryKind<?> persistentLibraryKind3 = this.findKind((VirtualFile[])classRoots);
                if (persistentLibraryKind3 != null) {
                    PersistentLibraryKind<?> it = persistentLibraryKind3;
                    boolean bl = false;
                    classRoot.putUserData(LibraryEffectiveKindProviderKt.access$getLIBRARY_KIND_KEY$p(), it);
                    object = it;
                } else {
                    object = null;
                }
            }
            PersistentLibraryKind<?> persistentLibraryKind4 = platformKind = object;
            persistentLibraryKind = nonJvmOrNull = persistentLibraryKind4 != null ? this.nonJvmOrNull(persistentLibraryKind4) : null;
        }
        return persistentLibraryKind;
    }

    private final PersistentLibraryKind<?> nonJvmOrNull(PersistentLibraryKind<?> $this$nonJvmOrNull) {
        PersistentLibraryKind<?> persistentLibraryKind;
        PersistentLibraryKind<?> it = persistentLibraryKind = $this$nonJvmOrNull;
        boolean bl = false;
        return !Intrinsics.areEqual(it, (Object)KotlinJvmEffectiveLibraryKind.INSTANCE) ? persistentLibraryKind : null;
    }

    private static final PersistentLibraryKind findKind$lambda$0(LibraryEffectiveKindProvider this$0, VirtualFile $virtualFile) {
        return (PersistentLibraryKind)KotlinLibraryKindGistProvider.Companion.getInstance().getKotlinLibraryKindGist().getFileData(this$0.project, $virtualFile);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0006\b\u0082\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/kotlin/idea/base/platforms/LibraryEffectiveKindProvider$KnownLibraryKindForIndex;", "", "<init>", "(Ljava/lang/String;I)V", "COMMON", "JS", "UNKNOWN", "kotlin.base.platforms"})
    private static final class KnownLibraryKindForIndex
    extends Enum<KnownLibraryKindForIndex> {
        public static final /* enum */ KnownLibraryKindForIndex COMMON = new KnownLibraryKindForIndex();
        public static final /* enum */ KnownLibraryKindForIndex JS = new KnownLibraryKindForIndex();
        public static final /* enum */ KnownLibraryKindForIndex UNKNOWN = new KnownLibraryKindForIndex();
        private static final /* synthetic */ KnownLibraryKindForIndex[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static KnownLibraryKindForIndex[] values() {
            return (KnownLibraryKindForIndex[])$VALUES.clone();
        }

        public static KnownLibraryKindForIndex valueOf(String value) {
            return Enum.valueOf(KnownLibraryKindForIndex.class, value);
        }

        @NotNull
        public static EnumEntries<KnownLibraryKindForIndex> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = knownLibraryKindForIndexArray = new KnownLibraryKindForIndex[]{KnownLibraryKindForIndex.COMMON, KnownLibraryKindForIndex.JS, KnownLibraryKindForIndex.UNKNOWN};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \b2\u00020\u0001:\u0002\b\tB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\n"}, d2={"Lorg/jetbrains/kotlin/idea/base/platforms/LibraryEffectiveKindProvider$LibraryKindScanner;", "Lcom/intellij/util/indexing/roots/IndexableFileScanner;", "<init>", "()V", "startSession", "Lcom/intellij/util/indexing/roots/IndexableFileScanner$ScanSession;", "project", "Lcom/intellij/openapi/project/Project;", "Companion", "ScannerVisitor", "kotlin.base.platforms"})
    public static final class LibraryKindScanner
    implements IndexableFileScanner {
        @NotNull
        public static final Companion Companion = new Companion(null);

        @NotNull
        public IndexableFileScanner.ScanSession startSession(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            ScannerVisitor scannerVisitor = new ScannerVisitor();
            return new IndexableFileScanner.ScanSession(scannerVisitor){
                final /* synthetic */ ScannerVisitor $scannerVisitor;
                {
                    this.$scannerVisitor = $scannerVisitor;
                }

                public IndexableFileScanner.IndexableFileVisitor createVisitor(IndexableSetOrigin indexableSetOrigin) {
                    Intrinsics.checkNotNullParameter((Object)indexableSetOrigin, (String)"indexableSetOrigin");
                    if (indexableSetOrigin instanceof LibraryOrigin) {
                        return new IndexableFileScanner.IndexableFileVisitor(this.$scannerVisitor, indexableSetOrigin){
                            final /* synthetic */ ScannerVisitor $scannerVisitor;
                            final /* synthetic */ IndexableSetOrigin $indexableSetOrigin;
                            {
                                this.$scannerVisitor = $scannerVisitor;
                                this.$indexableSetOrigin = $indexableSetOrigin;
                            }

                            public void visitFile(VirtualFile fileOrDir) {
                                Intrinsics.checkNotNullParameter((Object)fileOrDir, (String)"fileOrDir");
                                this.$scannerVisitor.visitFile(fileOrDir);
                            }

                            public void visitingFinished() {
                                List roots = ((LibraryOrigin)this.$indexableSetOrigin).getClassRoots();
                                this.$scannerVisitor.visitingFinished(roots);
                            }
                        };
                    }
                    return null;
                }
            };
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0080\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0019\u0010\u0004\u001a\u00020\u00052\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\u0002\u0010\t\u00a8\u0006\n"}, d2={"Lorg/jetbrains/kotlin/idea/base/platforms/LibraryEffectiveKindProvider$LibraryKindScanner$Companion;", "", "<init>", "()V", "runScannerOutsideScanningSession", "", "classRoots", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "([Lcom/intellij/openapi/vfs/VirtualFile;)V", "kotlin.base.platforms"})
        public static final class Companion {
            private Companion() {
            }

            public final void runScannerOutsideScanningSession(@NotNull VirtualFile[] classRoots) {
                Intrinsics.checkNotNullParameter((Object)classRoots, (String)"classRoots");
                ScannerVisitor scannerVisitor = new ScannerVisitor();
                KnownLibraryKindForIndex lastResult = null;
                int n = classRoots.length;
                for (int j = 0; j < n; ++j) {
                    VirtualFile classRoot = classRoots[j];
                    scannerVisitor.setResult(null);
                    VirtualFileVisitor.Option[] optionArray = new VirtualFileVisitor.Option[]{};
                    VfsUtil.visitChildrenRecursively((VirtualFile)classRoot, (VirtualFileVisitor)((VirtualFileVisitor)new VirtualFileVisitor<Object>(classRoot, scannerVisitor, optionArray){
                        final /* synthetic */ VirtualFile $classRoot;
                        final /* synthetic */ ScannerVisitor $scannerVisitor;
                        {
                            this.$classRoot = $classRoot;
                            this.$scannerVisitor = $scannerVisitor;
                            super($super_call_param$1);
                        }

                        public VirtualFileVisitor.Result visitFileEx(VirtualFile file) {
                            VirtualFileVisitor.Result result2;
                            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
                            if (this.visitFile(file)) {
                                VirtualFileVisitor.Result result3 = VirtualFileVisitor.CONTINUE;
                                result2 = result3;
                                Intrinsics.checkNotNullExpressionValue((Object)result3, (String)"CONTINUE");
                            } else {
                                VirtualFileVisitor.Result result4 = VirtualFileVisitor.skipTo((VirtualFile)this.$classRoot);
                                result2 = result4;
                                Intrinsics.checkNotNullExpressionValue((Object)result4, (String)"skipTo(...)");
                            }
                            return result2;
                        }

                        public boolean visitFile(VirtualFile file) {
                            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
                            ProgressManager.checkCanceled();
                            this.$scannerVisitor.visitFile(file);
                            return this.$scannerVisitor.getResult() == null || this.$scannerVisitor.getResult() == KnownLibraryKindForIndex.COMMON;
                        }
                    }));
                    KnownLibraryKindForIndex result2 = scannerVisitor.getResult();
                    if (result2 == null || lastResult != null && result2 == KnownLibraryKindForIndex.COMMON) continue;
                    lastResult = result2;
                }
                scannerVisitor.setResult(lastResult);
                scannerVisitor.visitingFinished(ArraysKt.toList((Object[])classRoots));
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014J\u0014\u0010\u0015\u001a\u00020\u00122\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00140\u0017R\u0016\u0010\u0004\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0016\u0010\t\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\bR\u001c\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010\u00a8\u0006\u0018"}, d2={"Lorg/jetbrains/kotlin/idea/base/platforms/LibraryEffectiveKindProvider$LibraryKindScanner$ScannerVisitor;", "", "<init>", "()V", "classFileType", "Lcom/intellij/openapi/fileTypes/FileType;", "Lorg/jetbrains/annotations/NotNull;", "getClassFileType", "()Lcom/intellij/openapi/fileTypes/FileType;", "kotlinJavaScriptMetaFileType", "getKotlinJavaScriptMetaFileType", "result", "Lorg/jetbrains/kotlin/idea/base/platforms/LibraryEffectiveKindProvider$KnownLibraryKindForIndex;", "getResult", "()Lorg/jetbrains/kotlin/idea/base/platforms/LibraryEffectiveKindProvider$KnownLibraryKindForIndex;", "setResult", "(Lorg/jetbrains/kotlin/idea/base/platforms/LibraryEffectiveKindProvider$KnownLibraryKindForIndex;)V", "visitFile", "", "fileOrDir", "Lcom/intellij/openapi/vfs/VirtualFile;", "visitingFinished", "roots", "", "kotlin.base.platforms"})
        private static final class ScannerVisitor {
            @NotNull
            private final FileType classFileType;
            @NotNull
            private final FileType kotlinJavaScriptMetaFileType;
            @Nullable
            private KnownLibraryKindForIndex result;

            public ScannerVisitor() {
                FileType fileType = FileTypeRegistry.getInstance().getFileTypeByExtension("class");
                Intrinsics.checkNotNullExpressionValue((Object)fileType, (String)"getFileTypeByExtension(...)");
                this.classFileType = fileType;
                FileType fileType2 = FileTypeRegistry.getInstance().getFileTypeByExtension("kjsm");
                Intrinsics.checkNotNullExpressionValue((Object)fileType2, (String)"getFileTypeByExtension(...)");
                this.kotlinJavaScriptMetaFileType = fileType2;
            }

            @NotNull
            public final FileType getClassFileType() {
                return this.classFileType;
            }

            @NotNull
            public final FileType getKotlinJavaScriptMetaFileType() {
                return this.kotlinJavaScriptMetaFileType;
            }

            @Nullable
            public final KnownLibraryKindForIndex getResult() {
                return this.result;
            }

            public final void setResult(@Nullable KnownLibraryKindForIndex knownLibraryKindForIndex) {
                this.result = knownLibraryKindForIndex;
            }

            public final void visitFile(@NotNull VirtualFile fileOrDir) {
                block4: {
                    FileType fileType;
                    CharSequence nameSequence;
                    block6: {
                        block5: {
                            FileType fileType2;
                            Intrinsics.checkNotNullParameter((Object)fileOrDir, (String)"fileOrDir");
                            if (fileOrDir.isDirectory()) {
                                return;
                            }
                            if (this.result == KnownLibraryKindForIndex.UNKNOWN) break block4;
                            CharSequence charSequence = fileOrDir.getNameSequence();
                            Intrinsics.checkNotNullExpressionValue((Object)charSequence, (String)"getNameSequence(...)");
                            nameSequence = charSequence;
                            if (StringsKt.endsWith$default((CharSequence)nameSequence, (CharSequence)".java", (boolean)false, (int)2, null) || StringsKt.endsWith$default((CharSequence)nameSequence, (CharSequence)".kt", (boolean)false, (int)2, null)) {
                                return;
                            }
                            if (StringsKt.endsWith$default((CharSequence)nameSequence, (CharSequence)".class", (boolean)false, (int)2, null)) {
                                fileType2 = this.classFileType;
                            } else {
                                FileType fileType3 = fileOrDir.getFileType();
                                fileType2 = fileType3;
                                Intrinsics.checkNotNullExpressionValue((Object)fileType3, (String)"getFileType(...)");
                            }
                            fileType = fileType2;
                            if (!Intrinsics.areEqual((Object)fileType, (Object)this.classFileType)) break block5;
                            this.result = KnownLibraryKindForIndex.UNKNOWN;
                            break block4;
                        }
                        if (!Intrinsics.areEqual((Object)fileType, (Object)this.kotlinJavaScriptMetaFileType)) break block6;
                        this.result = KnownLibraryKindForIndex.JS;
                        break block4;
                    }
                    if (this.result != null || !Intrinsics.areEqual((Object)fileType, (Object)KlibMetaFileType.INSTANCE) && (!StringsKt.endsWith$default((CharSequence)nameSequence, (CharSequence)".kotlin_metadata", (boolean)false, (int)2, null) || !Intrinsics.areEqual((Object)fileType, (Object)KotlinBuiltInFileType.INSTANCE))) break block4;
                    this.result = KnownLibraryKindForIndex.COMMON;
                }
            }

            public final void visitingFinished(@NotNull Collection<? extends VirtualFile> roots) {
                Intrinsics.checkNotNullParameter(roots, (String)"roots");
                KnownLibraryKindForIndex knownLibraryKindForIndex = this.result;
                PersistentLibraryKind platformKind = switch (knownLibraryKindForIndex == null ? -1 : WhenMappings.$EnumSwitchMapping$0[knownLibraryKindForIndex.ordinal()]) {
                    case 1 -> KotlinCommonLibraryKind.INSTANCE;
                    case 2 -> KotlinJavaScriptLibraryKind.INSTANCE;
                    default -> (PersistentLibraryKind)LibraryEffectiveKindProviderKt.access$getNEEDS_TO_BE_CLARIFIED_KIND();
                };
                for (VirtualFile virtualFile : roots) {
                    virtualFile.putUserData(LibraryEffectiveKindProviderKt.access$getLIBRARY_KIND_KEY$p(), (Object)platformKind);
                }
            }

            @Metadata(mv={2, 0, 0}, k=3, xi=48)
            public final class WhenMappings {
                public static final /* synthetic */ int[] $EnumSwitchMapping$0;

                static {
                    int[] nArray = new int[KnownLibraryKindForIndex.values().length];
                    try {
                        nArray[KnownLibraryKindForIndex.COMMON.ordinal()] = 1;
                    }
                    catch (NoSuchFieldError noSuchFieldError) {
                        // empty catch block
                    }
                    try {
                        nArray[KnownLibraryKindForIndex.JS.ordinal()] = 2;
                    }
                    catch (NoSuchFieldError noSuchFieldError) {
                        // empty catch block
                    }
                    $EnumSwitchMapping$0 = nArray;
                }
            }
        }
    }
}

