/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.base.projectStructure.forwardDeclarations;

import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.File;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.base.projectStructure.forwardDeclarations.KotlinForwardDeclarationsFileGeneratorKt;
import org.jetbrains.kotlin.idea.base.projectStructure.forwardDeclarations.KotlinForwardDeclarationsFileSystem;
import org.jetbrains.kotlin.idea.base.projectStructure.forwardDeclarations.KotlinForwardDeclarationsFqNameExtractor;
import org.jetbrains.kotlin.idea.base.projectStructure.moduleInfo.NativeKlibLibraryInfo;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.name.NativeForwardDeclarationKind;
import org.jetbrains.kotlin.name.NativeStandardInteropNames;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u00c0\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u0007J*\u0010\b\u001a\u00020\u00052\u0018\u0010\t\u001a\u0014\u0012\u0004\u0012\u00020\u000b\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000b0\f0\n2\u0006\u0010\r\u001a\u00020\u000eH\u0002J.\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00052\u0006\u0010\u0012\u001a\u00020\u000b2\u0006\u0010\u0013\u001a\u00020\u00142\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u000b0\fH\u0002J&\u0010\u0016\u001a\u00020\u000e2\u0006\u0010\u0012\u001a\u00020\u000b2\u0006\u0010\u0013\u001a\u00020\u00142\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u000b0\fH\u0002J\u0014\u0010\u0017\u001a\u00020\u00182\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00100\f\u00a8\u0006\u001a"}, d2={"Lorg/jetbrains/kotlin/idea/base/projectStructure/forwardDeclarations/KotlinForwardDeclarationsFileGenerator;", "", "<init>", "()V", "generateForwardDeclarationFiles", "Ljava/nio/file/Path;", "libraryInfo", "Lorg/jetbrains/kotlin/idea/base/projectStructure/moduleInfo/NativeKlibLibraryInfo;", "generateForwardDeclarationsForFqNames", "groupedFqNames", "", "Lorg/jetbrains/kotlin/name/FqName;", "", "libraryPath", "", "generateFile", "Ljava/io/File;", "parentDir", "pkg", "kind", "Lorg/jetbrains/kotlin/name/NativeForwardDeclarationKind;", "classes", "createText", "cleanUp", "", "roots", "kotlin.base.project-structure"})
@SourceDebugExtension(value={"SMAP\nKotlinForwardDeclarationsFileGenerator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KotlinForwardDeclarationsFileGenerator.kt\norg/jetbrains/kotlin/idea/base/projectStructure/forwardDeclarations/KotlinForwardDeclarationsFileGenerator\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,115:1\n1#2:116\n1#2:127\n136#3,9:117\n216#3:126\n217#3:128\n145#3:129\n1557#4:130\n1628#4,3:131\n*S KotlinDebug\n*F\n+ 1 KotlinForwardDeclarationsFileGenerator.kt\norg/jetbrains/kotlin/idea/base/projectStructure/forwardDeclarations/KotlinForwardDeclarationsFileGenerator\n*L\n44#1:127\n44#1:117,9\n44#1:126\n44#1:128\n44#1:129\n91#1:130\n91#1:131,3\n*E\n"})
public final class KotlinForwardDeclarationsFileGenerator {
    @NotNull
    public static final KotlinForwardDeclarationsFileGenerator INSTANCE = new KotlinForwardDeclarationsFileGenerator();

    private KotlinForwardDeclarationsFileGenerator() {
    }

    @Nullable
    public final Path generateForwardDeclarationFiles(@NotNull NativeKlibLibraryInfo libraryInfo) {
        Intrinsics.checkNotNullParameter((Object)libraryInfo, (String)"libraryInfo");
        Map<FqName, List<FqName>> map = KotlinForwardDeclarationsFqNameExtractor.INSTANCE.getGroupedForwardDeclarations(libraryInfo);
        if (map.isEmpty()) {
            boolean bl = false;
            return null;
        }
        Map<FqName, List<FqName>> groupedClasses = map;
        return this.generateForwardDeclarationsForFqNames(groupedClasses, libraryInfo.getLibraryRoot());
    }

    /*
     * WARNING - void declaration
     */
    private final Path generateForwardDeclarationsForFqNames(Map<FqName, ? extends List<FqName>> groupedFqNames, String libraryPath) {
        void $this$mapNotNullTo$iv$iv;
        Path root = KotlinForwardDeclarationsFileSystem.Companion.getStorageRootPath();
        Path libraryLocation = root.resolve(StringsKt.removePrefix((String)libraryPath, (CharSequence)"/"));
        Map<FqName, ? extends List<FqName>> $this$mapNotNull$iv = groupedFqNames;
        boolean $i$f$mapNotNull = false;
        Map<FqName, ? extends List<FqName>> map = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv.entrySet().iterator();
        while (iterator2.hasNext()) {
            File file;
            Map.Entry element$iv$iv$iv;
            Map.Entry element$iv$iv = element$iv$iv$iv = iterator2.next();
            boolean bl = false;
            Map.Entry entry = element$iv$iv;
            boolean bl2 = false;
            FqName pkg = (FqName)entry.getKey();
            List classes = (List)entry.getValue();
            if ((NativeForwardDeclarationKind)NativeForwardDeclarationKind.Companion.getPackageFqNameToKind().get(pkg) == null) {
                KotlinForwardDeclarationsFileGenerator $this$generateForwardDeclarationsForFqNames_u24lambda_u242_u24lambda_u241 = INSTANCE;
                boolean bl3 = false;
                KotlinForwardDeclarationsFileGeneratorKt.access$getLOG$p().warn("Skipping request to generate K/N forward declarations with an unsupported package " + pkg);
                file = null;
            } else {
                NativeForwardDeclarationKind kind2;
                Intrinsics.checkNotNull((Object)libraryLocation);
                file = INSTANCE.generateFile(libraryLocation, pkg, kind2, classes);
            }
            if (file == null) continue;
            File it$iv$iv = file;
            boolean bl4 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        List cfr_ignored_0 = (List)destination$iv$iv;
        VirtualFile virtualFile = VfsUtil.findFile((Path)root, (boolean)true);
        if (virtualFile != null) {
            VirtualFile it = virtualFile;
            boolean bl = false;
            VirtualFile[] virtualFileArray = new VirtualFile[]{it};
            VfsUtil.markDirtyAndRefresh((boolean)true, (boolean)true, (boolean)true, (VirtualFile[])virtualFileArray);
        }
        Intrinsics.checkNotNull((Object)libraryLocation);
        return libraryLocation;
    }

    private final File generateFile(Path parentDir, FqName pkg, NativeForwardDeclarationKind kind2, List<FqName> classes) {
        String text = this.createText(pkg, kind2, classes);
        File $this$generateFile_u24lambda_u244 = parentDir.resolve(pkg.asString() + ".kt").toFile();
        boolean bl = false;
        $this$generateFile_u24lambda_u244.getParentFile().mkdirs();
        if ($this$generateFile_u24lambda_u244.exists()) {
            $this$generateFile_u24lambda_u244.delete();
        }
        $this$generateFile_u24lambda_u244.createNewFile();
        Intrinsics.checkNotNull((Object)$this$generateFile_u24lambda_u244);
        FilesKt.writeText$default((File)$this$generateFile_u24lambda_u244, (String)text, null, (int)2, null);
        return $this$generateFile_u24lambda_u244;
    }

    /*
     * WARNING - void declaration
     */
    private final String createText(FqName pkg, NativeForwardDeclarationKind kind2, List<FqName> classes) {
        void $this$mapTo$iv$iv;
        String string = kind2.getClassKind().getCodeRepresentation();
        if (string == null) {
            String string2;
            String it = string2 = "";
            boolean bl = false;
            KotlinForwardDeclarationsFileGeneratorKt.access$getLOG$p().error("Error generating forward declarations with kind " + kind2 + " for package " + pkg);
            string = string2;
        }
        String classKindCodeRepresentation = string;
        String constructor = switch (WhenMappings.$EnumSwitchMapping$0[kind2.ordinal()]) {
            case 1 -> "private constructor(rawPtr: " + NativeStandardInteropNames.INSTANCE.getCInteropPackage() + ".NativePtr) ";
            case 2, 3 -> "";
            default -> "";
        };
        Object supertype = switch (WhenMappings.$EnumSwitchMapping$0[kind2.ordinal()]) {
            case 1 -> kind2.getSuperClassFqName().asString() + "(rawPtr)";
            case 2, 3 -> kind2.getSuperClassFqName().asString();
            default -> throw new NoWhenBranchMatchedException();
        };
        String annotation = "@" + NativeStandardInteropNames.INSTANCE.getCInteropPackage() + "." + NativeStandardInteropNames.INSTANCE.getExperimentalForeignApi();
        Iterable $this$map$iv = classes;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            FqName fqName2 = (FqName)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(((Name)CollectionsKt.last((List)it.pathSegments())).asString());
        }
        List classNames = (List)destination$iv$iv;
        String packageWithImports = StringsKt.trimIndent((String)("\n            package " + pkg.asString() + System.lineSeparator() + "\n            \n        "));
        Iterable iterable2 = classNames;
        String string3 = System.lineSeparator();
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"lineSeparator(...)");
        String generatedDeclarations = CollectionsKt.joinToString$default((Iterable)iterable2, (CharSequence)string3, null, null, (int)0, null, arg_0 -> KotlinForwardDeclarationsFileGenerator.createText$lambda$7(annotation, classKindCodeRepresentation, constructor, (String)supertype, arg_0), (int)30, null);
        return packageWithImports + generatedDeclarations;
    }

    public final void cleanUp(@NotNull List<? extends File> roots) {
        Intrinsics.checkNotNullParameter(roots, (String)"roots");
        Path storageRoot = KotlinForwardDeclarationsFileSystem.Companion.getStorageRootPath();
        for (File file : roots) {
            String string = file.getAbsolutePath();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getAbsolutePath(...)");
            if (!StringsKt.startsWith$default((String)string, (String)((Object)storageRoot.toAbsolutePath()).toString(), (boolean)false, (int)2, null)) {
                KotlinForwardDeclarationsFileGeneratorKt.access$getLOG$p().error("Attempt to delete " + file.getAbsolutePath() + " which is not under " + ((Object)storageRoot.toAbsolutePath()).toString());
                continue;
            }
            FilesKt.deleteRecursively((File)file);
        }
    }

    private static final CharSequence createText$lambda$7(String $annotation, String $classKindCodeRepresentation, String $constructor, String $supertype, String className) {
        Intrinsics.checkNotNullParameter((Object)className, (String)"className");
        return $annotation + " " + $classKindCodeRepresentation + " " + className + " " + $constructor + ": " + $supertype;
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[NativeForwardDeclarationKind.values().length];
            try {
                nArray[NativeForwardDeclarationKind.Struct.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[NativeForwardDeclarationKind.ObjCClass.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[NativeForwardDeclarationKind.ObjCProtocol.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

