/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.caches.resolve;

import com.intellij.openapi.util.Key;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.inject.Inject;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptorWithResolutionScopes;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.ModuleDescriptor;
import org.jetbrains.kotlin.descriptors.SimpleFunctionDescriptor;
import org.jetbrains.kotlin.idea.caches.resolve.ExtendedResolutionApiKt;
import org.jetbrains.kotlin.idea.caches.resolve.util.ControlFlowUtilsKt;
import org.jetbrains.kotlin.idea.core.util.CodeFragmentUtilsKt;
import org.jetbrains.kotlin.idea.project.ResolveElementCache;
import org.jetbrains.kotlin.idea.util.ScopeUtils;
import org.jetbrains.kotlin.incremental.components.LookupLocation;
import org.jetbrains.kotlin.incremental.components.NoLookupLocation;
import org.jetbrains.kotlin.psi.KtBlockExpression;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtCodeFragment;
import org.jetbrains.kotlin.psi.KtConstructor;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtDeclarationWithBody;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtFunction;
import org.jetbrains.kotlin.psi.KtFunctionLiteral;
import org.jetbrains.kotlin.psi.KtImportDirective;
import org.jetbrains.kotlin.psi.KtImportInfo;
import org.jetbrains.kotlin.psi.KtImportList;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtPrimaryConstructor;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtPsiUtil;
import org.jetbrains.kotlin.psi.KtSecondaryConstructor;
import org.jetbrains.kotlin.psi.KtTypeReference;
import org.jetbrains.kotlin.psi.codeFragmentUtil.CodeFragmentUtilKt;
import org.jetbrains.kotlin.psi.psiUtil.KtPsiUtilKt;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.DelegatingBindingTrace;
import org.jetbrains.kotlin.resolve.FunctionDescriptorUtil;
import org.jetbrains.kotlin.resolve.QualifiedExpressionResolver;
import org.jetbrains.kotlin.resolve.TypeResolutionContext;
import org.jetbrains.kotlin.resolve.TypeResolver;
import org.jetbrains.kotlin.resolve.bindingContextUtil.BindingContextUtilsKt;
import org.jetbrains.kotlin.resolve.calls.smartcasts.DataFlowInfo;
import org.jetbrains.kotlin.resolve.lazy.BodyResolveMode;
import org.jetbrains.kotlin.resolve.lazy.ResolveSession;
import org.jetbrains.kotlin.resolve.scopes.ExplicitImportsScope;
import org.jetbrains.kotlin.resolve.scopes.HierarchicalScope;
import org.jetbrains.kotlin.resolve.scopes.ImportingScope;
import org.jetbrains.kotlin.resolve.scopes.LexicalScope;
import org.jetbrains.kotlin.resolve.scopes.LocalRedeclarationChecker;
import org.jetbrains.kotlin.resolve.scopes.utils.ScopeUtilsKt;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.SimpleType;
import org.jetbrains.kotlin.types.TypeUtils;
import org.jetbrains.kotlin.types.expressions.ExpressionTypingServices;
import org.jetbrains.kotlin.util.slicedMap.ReadOnlySlice;
import org.jetbrains.kotlin.util.slicedMap.WritableSlice;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u008c\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 62\u00020\u0001:\u0003456B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0016\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018J\u0018\u0010\u0019\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J\u0018\u0010\u001c\u001a\u00020\u001b2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J'\u0010\u001d\u001a\u00020\u001b2\b\u0010\u001e\u001a\u0004\u0018\u00010\u001f2\u0012\u0010 \u001a\u000e\u0012\u0004\u0012\u00020\"\u0012\u0004\u0012\u00020#0!H\u0082\u0010J&\u0010$\u001a\u0004\u0018\u00010%2\u0006\u0010&\u001a\u00020'2\u0012\u0010 \u001a\u000e\u0012\u0004\u0012\u00020\"\u0012\u0004\u0012\u00020#0!H\u0002J\u0014\u0010(\u001a\u0004\u0018\u00010\"2\b\u0010\u001e\u001a\u0004\u0018\u00010\u001fH\u0002J\u0018\u0010)\u001a\u00020*2\u0006\u0010+\u001a\u00020*2\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u0016\u0010,\u001a\b\u0012\u0004\u0012\u00020.0-2\u0006\u0010/\u001a\u000200H\u0002J\u0010\u00101\u001a\u00020*2\u0006\u00102\u001a\u000203H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R$\u0010\u000e\u001a\u00020\r2\u0006\u0010\f\u001a\u00020\r@GX\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012\u00a8\u00067"}, d2={"Lorg/jetbrains/kotlin/idea/caches/resolve/CodeFragmentAnalyzer;", "", "resolveSession", "Lorg/jetbrains/kotlin/resolve/lazy/ResolveSession;", "qualifierResolver", "Lorg/jetbrains/kotlin/resolve/QualifiedExpressionResolver;", "typeResolver", "Lorg/jetbrains/kotlin/resolve/TypeResolver;", "expressionTypingServices", "Lorg/jetbrains/kotlin/types/expressions/ExpressionTypingServices;", "<init>", "(Lorg/jetbrains/kotlin/resolve/lazy/ResolveSession;Lorg/jetbrains/kotlin/resolve/QualifiedExpressionResolver;Lorg/jetbrains/kotlin/resolve/TypeResolver;Lorg/jetbrains/kotlin/types/expressions/ExpressionTypingServices;)V", "value", "Lorg/jetbrains/kotlin/idea/project/ResolveElementCache;", "resolveElementCache", "getResolveElementCache", "()Lorg/jetbrains/kotlin/idea/project/ResolveElementCache;", "setResolveElementCache", "(Lorg/jetbrains/kotlin/idea/project/ResolveElementCache;)V", "analyzeCodeFragment", "Lorg/jetbrains/kotlin/resolve/BindingTrace;", "codeFragment", "Lorg/jetbrains/kotlin/psi/KtCodeFragment;", "bodyResolveMode", "Lorg/jetbrains/kotlin/resolve/lazy/BodyResolveMode;", "doAnalyzeCodeFragment", "contextInfo", "Lorg/jetbrains/kotlin/idea/caches/resolve/CodeFragmentAnalyzer$ContextInfo;", "analyzeCodeFragmentContext", "getContextInfo", "context", "Lcom/intellij/psi/PsiElement;", "resolutionFactory", "Lkotlin/Function1;", "Lorg/jetbrains/kotlin/psi/KtElement;", "Lorg/jetbrains/kotlin/resolve/BindingContext;", "getClassDescriptor", "Lorg/jetbrains/kotlin/idea/caches/resolve/CodeFragmentAnalyzer$ClassResolutionResult;", "classOrObject", "Lorg/jetbrains/kotlin/psi/KtClassOrObject;", "refineContextElement", "enrichScopeWithImports", "Lorg/jetbrains/kotlin/resolve/scopes/LexicalScope;", "scope", "createImportScopes", "", "Lorg/jetbrains/kotlin/resolve/scopes/ImportingScope;", "importList", "Lorg/jetbrains/kotlin/psi/KtImportList;", "createEmptyScope", "moduleDescriptor", "Lorg/jetbrains/kotlin/descriptors/ModuleDescriptor;", "ContextInfo", "ClassResolutionResult", "Companion", "kotlin.base.fe10.analysis"})
@SourceDebugExtension(value={"SMAP\nCodeFragmentAnalyzer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CodeFragmentAnalyzer.kt\norg/jetbrains/kotlin/idea/caches/resolve/CodeFragmentAnalyzer\n+ 2 psiUtils.kt\norg/jetbrains/kotlin/psi/psiUtil/PsiUtilsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,223:1\n133#2:224\n141#2:225\n133#2:227\n1#3:226\n1#3:238\n1611#4,9:228\n1863#4:237\n1864#4:239\n1620#4:240\n*S KotlinDebug\n*F\n+ 1 CodeFragmentAnalyzer.kt\norg/jetbrains/kotlin/idea/caches/resolve/CodeFragmentAnalyzer\n*L\n127#1:224\n145#1:225\n176#1:227\n207#1:238\n207#1:228,9\n207#1:237\n207#1:239\n207#1:240\n*E\n"})
public final class CodeFragmentAnalyzer {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ResolveSession resolveSession;
    @NotNull
    private final QualifiedExpressionResolver qualifierResolver;
    @NotNull
    private final TypeResolver typeResolver;
    @NotNull
    private final ExpressionTypingServices expressionTypingServices;
    public ResolveElementCache resolveElementCache;
    @NotNull
    private static final Key<KotlinType> EXPECTED_TYPE_KEY = new Key("EXPECTED_TYPE");

    public CodeFragmentAnalyzer(@NotNull ResolveSession resolveSession, @NotNull QualifiedExpressionResolver qualifierResolver, @NotNull TypeResolver typeResolver, @NotNull ExpressionTypingServices expressionTypingServices) {
        Intrinsics.checkNotNullParameter((Object)resolveSession, (String)"resolveSession");
        Intrinsics.checkNotNullParameter((Object)qualifierResolver, (String)"qualifierResolver");
        Intrinsics.checkNotNullParameter((Object)typeResolver, (String)"typeResolver");
        Intrinsics.checkNotNullParameter((Object)expressionTypingServices, (String)"expressionTypingServices");
        this.resolveSession = resolveSession;
        this.qualifierResolver = qualifierResolver;
        this.typeResolver = typeResolver;
        this.expressionTypingServices = expressionTypingServices;
    }

    @NotNull
    public final ResolveElementCache getResolveElementCache() {
        ResolveElementCache resolveElementCache = this.resolveElementCache;
        if (resolveElementCache != null) {
            return resolveElementCache;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"resolveElementCache");
        return null;
    }

    @Inject
    public final void setResolveElementCache(@NotNull ResolveElementCache resolveElementCache) {
        Intrinsics.checkNotNullParameter((Object)resolveElementCache, (String)"<set-?>");
        this.resolveElementCache = resolveElementCache;
    }

    @NotNull
    public final BindingTrace analyzeCodeFragment(@NotNull KtCodeFragment codeFragment, @NotNull BodyResolveMode bodyResolveMode) {
        Intrinsics.checkNotNullParameter((Object)codeFragment, (String)"codeFragment");
        Intrinsics.checkNotNullParameter((Object)((Object)bodyResolveMode), (String)"bodyResolveMode");
        ContextInfo contextAnalysisResult = this.analyzeCodeFragmentContext(codeFragment, bodyResolveMode);
        return this.doAnalyzeCodeFragment(codeFragment, contextAnalysisResult);
    }

    private final BindingTrace doAnalyzeCodeFragment(KtCodeFragment codeFragment, ContextInfo contextInfo) {
        BindingContext bindingContext = contextInfo.component1();
        LexicalScope scope = contextInfo.component2();
        DataFlowInfo dataFlowInfo = contextInfo.component3();
        DelegatingBindingTrace bindingTrace = new DelegatingBindingTrace(bindingContext, "For code fragment analysis", false, null, false, null, 60, null);
        KtElement contentElement = codeFragment.getContentElement();
        if (contentElement instanceof KtExpression) {
            KotlinType kotlinType = (KotlinType)codeFragment.getUserData(EXPECTED_TYPE_KEY);
            if (kotlinType == null) {
                SimpleType simpleType = TypeUtils.NO_EXPECTED_TYPE;
                Intrinsics.checkNotNullExpressionValue((Object)simpleType, (String)"NO_EXPECTED_TYPE");
                kotlinType = (KotlinType)simpleType;
            }
            KotlinType expectedType = kotlinType;
            ExtendedResolutionApiKt.analyzeInContext$default((KtExpression)contentElement, scope, null, (BindingTrace)bindingTrace, dataFlowInfo, expectedType, false, null, this.expressionTypingServices, 98, null);
            WritableSlice writableSlice = BindingContext.USED_AS_EXPRESSION;
            Intrinsics.checkNotNullExpressionValue((Object)writableSlice, (String)"USED_AS_EXPRESSION");
            bindingTrace.record(writableSlice, (Object)KtPsiUtilKt.lastBlockStatementOrThis((KtExpression)((KtExpression)contentElement)));
            ControlFlowUtilsKt.analyzeControlFlow(this.resolveSession, contentElement, (BindingTrace)bindingTrace);
        } else if (contentElement instanceof KtTypeReference) {
            TypeResolutionContext typeResolutionContext = new TypeResolutionContext(scope, (BindingTrace)bindingTrace, true, true, CodeFragmentUtilKt.suppressDiagnosticsInDebugMode((KtElement)((KtElement)codeFragment))).noBareTypes();
            Intrinsics.checkNotNullExpressionValue((Object)typeResolutionContext, (String)"noBareTypes(...)");
            TypeResolutionContext context2 = typeResolutionContext;
            this.typeResolver.resolvePossiblyBareType(context2, (KtTypeReference)contentElement);
        }
        return (BindingTrace)bindingTrace;
    }

    private final ContextInfo analyzeCodeFragmentContext(KtCodeFragment codeFragment, BodyResolveMode bodyResolveMode) {
        KtElement context2 = this.refineContextElement(codeFragment.getContext());
        ContextInfo info2 = this.getContextInfo((PsiElement)context2, (Function1<? super KtElement, ? extends BindingContext>)((Function1)new Function1<KtElement, BindingContext>(this, bodyResolveMode){
            final /* synthetic */ CodeFragmentAnalyzer this$0;
            final /* synthetic */ BodyResolveMode $bodyResolveMode;
            {
                this.this$0 = $receiver;
                this.$bodyResolveMode = $bodyResolveMode;
                super(1, Intrinsics.Kotlin.class, "resolutionFactory", "analyzeCodeFragmentContext$resolutionFactory(Lorg/jetbrains/kotlin/idea/caches/resolve/CodeFragmentAnalyzer;Lorg/jetbrains/kotlin/resolve/lazy/BodyResolveMode;Lorg/jetbrains/kotlin/psi/KtElement;)Lorg/jetbrains/kotlin/resolve/BindingContext;", 0);
            }

            public final BindingContext invoke(KtElement p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                return CodeFragmentAnalyzer.access$analyzeCodeFragmentContext$resolutionFactory(this.this$0, this.$bodyResolveMode, p0);
            }
        }));
        return ContextInfo.copy$default(info2, null, this.enrichScopeWithImports(info2.getScope(), codeFragment), null, 5, null);
    }

    /*
     * WARNING - void declaration
     */
    private final ContextInfo getContextInfo(PsiElement context2, Function1<? super KtElement, ? extends BindingContext> resolutionFactory) {
        LexicalScope lexicalScope;
        BindingContext bindingContext;
        LexicalScope scope;
        DataFlowInfo dataFlowInfo;
        CodeFragmentAnalyzer codeFragmentAnalyzer = this;
        while (true) {
            PsiElement parentDeclaration;
            PsiElement psiElement;
            Intrinsics.checkNotNullExpressionValue((Object)BindingContext.EMPTY, (String)"EMPTY");
            dataFlowInfo = DataFlowInfo.Companion.getEMPTY();
            scope = null;
            PsiElement psiElement2 = context2;
            if (psiElement2 instanceof KtPrimaryConstructor) {
                KtClassOrObject containingClass = ((KtPrimaryConstructor)context2).getContainingClassOrObject();
                ClassResolutionResult resolutionResult = codeFragmentAnalyzer.getClassDescriptor(containingClass, resolutionFactory);
                if (resolutionResult != null) {
                    bindingContext = resolutionResult.getBindingContext();
                    scope = resolutionResult.getDescriptor().getScopeForInitializerResolution();
                }
            } else if (psiElement2 instanceof KtSecondaryConstructor) {
                KtBlockExpression expression;
                KtBlockExpression ktBlockExpression = ((KtSecondaryConstructor)context2).getBodyExpression();
                if (ktBlockExpression == null) {
                    ktBlockExpression = ((KtSecondaryConstructor)context2).getDelegationCallOrNull();
                }
                if ((expression = ktBlockExpression) != null) {
                    bindingContext = (BindingContext)resolutionFactory.invoke((Object)expression);
                    scope = (LexicalScope)bindingContext.get((ReadOnlySlice)BindingContext.LEXICAL_SCOPE, (Object)expression);
                }
            } else if (psiElement2 instanceof KtClassOrObject) {
                ClassResolutionResult resolutionResult = codeFragmentAnalyzer.getClassDescriptor((KtClassOrObject)context2, resolutionFactory);
                if (resolutionResult != null) {
                    bindingContext = resolutionResult.getBindingContext();
                    scope = resolutionResult.getDescriptor().getScopeForMemberDeclarationResolution();
                }
            } else if (psiElement2 instanceof KtFunction) {
                BindingContext bindingContextForFunction = (BindingContext)resolutionFactory.invoke((Object)context2);
                SimpleFunctionDescriptor functionDescriptor = (SimpleFunctionDescriptor)bindingContextForFunction.get((ReadOnlySlice)BindingContext.FUNCTION, (Object)context2);
                if (functionDescriptor != null) {
                    void $this$getParentOfType$iv;
                    bindingContext = bindingContextForFunction;
                    psiElement = context2;
                    boolean strict$iv = true;
                    boolean $i$f$getParentOfType = false;
                    LexicalScope outerScope = codeFragmentAnalyzer.getContextInfo(PsiTreeUtil.getParentOfType((PsiElement)$this$getParentOfType$iv, KtDeclaration.class, (boolean)strict$iv), resolutionFactory).getScope();
                    LocalRedeclarationChecker.DO_NOTHING localRedeclarationChecker = LocalRedeclarationChecker.DO_NOTHING.INSTANCE;
                    scope = FunctionDescriptorUtil.getFunctionInnerScope((LexicalScope)outerScope, (FunctionDescriptor)((FunctionDescriptor)functionDescriptor), (LocalRedeclarationChecker)((LocalRedeclarationChecker)localRedeclarationChecker));
                }
            } else if (psiElement2 instanceof KtFile) {
                bindingContext = codeFragmentAnalyzer.resolveSession.getBindingContext();
                scope = codeFragmentAnalyzer.resolveSession.getFileScopeProvider().getFileResolutionScope((KtFile)context2);
            } else if (psiElement2 instanceof KtElement) {
                bindingContext = (BindingContext)resolutionFactory.invoke((Object)context2);
                scope = ScopeUtils.getResolutionScope(context2, bindingContext);
                dataFlowInfo = BindingContextUtilsKt.getDataFlowInfoAfter((BindingContext)bindingContext, (PsiElement)context2);
            }
            if (scope != null) break;
            if (context2 != null) {
                PsiElement $this$getParentOfTypes3$iv;
                boolean $i$f$getParentOfTypes3 = false;
                psiElement = new PsiElement[]{KtDeclaration.class, KtFile.class, KtExpression.class};
                v1 = PsiTreeUtil.getParentOfType((PsiElement)$this$getParentOfTypes3$iv, (Class[])psiElement);
            } else {
                v1 = parentDeclaration = null;
            }
            if (parentDeclaration == null) break;
            CodeFragmentAnalyzer codeFragmentAnalyzer2 = codeFragmentAnalyzer;
            Function1<? super KtElement, ? extends BindingContext> function1 = resolutionFactory;
            codeFragmentAnalyzer = codeFragmentAnalyzer2;
            context2 = parentDeclaration;
            resolutionFactory = function1;
        }
        if ((lexicalScope = scope) == null) {
            ModuleDescriptor moduleDescriptor = codeFragmentAnalyzer.resolveSession.getModuleDescriptor();
            Intrinsics.checkNotNullExpressionValue((Object)moduleDescriptor, (String)"<get-moduleDescriptor>(...)");
            lexicalScope = codeFragmentAnalyzer.createEmptyScope(moduleDescriptor);
        }
        return new ContextInfo(bindingContext, lexicalScope, dataFlowInfo);
    }

    private final ClassResolutionResult getClassDescriptor(KtClassOrObject classOrObject, Function1<? super KtElement, ? extends BindingContext> resolutionFactory) {
        ClassResolutionResult classResolutionResult;
        BindingContext bindingContext = null;
        ClassDescriptor classDescriptor = null;
        if (!KtPsiUtil.isLocal((KtDeclaration)((KtDeclaration)classOrObject))) {
            bindingContext = this.resolveSession.getBindingContext();
            classDescriptor = this.resolveSession.getClassDescriptor(classOrObject, (LookupLocation)NoLookupLocation.FROM_IDE);
        } else {
            bindingContext = (BindingContext)resolutionFactory.invoke((Object)classOrObject);
            classDescriptor = (ClassDescriptor)bindingContext.get(BindingContext.DECLARATION_TO_DESCRIPTOR, (Object)classOrObject);
        }
        ClassDescriptorWithResolutionScopes classDescriptorWithResolutionScopes = classDescriptor instanceof ClassDescriptorWithResolutionScopes ? (ClassDescriptorWithResolutionScopes)classDescriptor : null;
        if (classDescriptorWithResolutionScopes != null) {
            ClassDescriptorWithResolutionScopes it = classDescriptorWithResolutionScopes;
            boolean bl = false;
            classResolutionResult = new ClassResolutionResult(bindingContext, it);
        } else {
            classResolutionResult = null;
        }
        return classResolutionResult;
    }

    /*
     * WARNING - void declaration
     */
    private final KtElement refineContextElement(PsiElement context2) {
        Object object;
        KtElement ktElement;
        PsiElement psiElement = context2;
        if (psiElement instanceof KtParameter) {
            void $this$getParentOfType$iv;
            PsiElement psiElement2 = context2;
            boolean strict$iv = true;
            boolean $i$f$getParentOfType = false;
            ktElement = (KtElement)PsiTreeUtil.getParentOfType((PsiElement)$this$getParentOfType$iv, KtFunction.class, (boolean)strict$iv);
        } else if (psiElement instanceof KtProperty) {
            ktElement = (KtElement)((KtProperty)context2).getDelegateExpressionOrInitializer();
        } else if (psiElement instanceof KtConstructor) {
            ktElement = (KtElement)context2;
        } else if (psiElement instanceof KtFunctionLiteral) {
            Object object2 = ((KtFunctionLiteral)context2).getBodyExpression();
            ktElement = (KtElement)(object2 != null && (object2 = object2.getStatements()) != null ? (KtExpression)CollectionsKt.lastOrNull((List)object2) : null);
        } else if (psiElement instanceof KtDeclarationWithBody) {
            ktElement = (KtElement)((KtDeclarationWithBody)context2).getBodyExpression();
        } else if (psiElement instanceof KtBlockExpression) {
            List list2 = ((KtBlockExpression)context2).getStatements();
            Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"getStatements(...)");
            ktElement = (KtElement)CollectionsKt.lastOrNull((List)list2);
        } else {
            ktElement = object = null;
        }
        if (ktElement == null) {
            object = context2 instanceof KtElement ? (KtElement)context2 : null;
        }
        return object;
    }

    private final LexicalScope enrichScopeWithImports(LexicalScope scope, KtCodeFragment codeFragment) {
        KtImportList importList;
        List externalDescriptors;
        List additionalImportingScopes = new ArrayList();
        List list2 = CodeFragmentUtilsKt.getExternalDescriptors(codeFragment);
        if (list2 == null) {
            list2 = CollectionsKt.emptyList();
        }
        if (!((Collection)(externalDescriptors = list2)).isEmpty()) {
            ((Collection)additionalImportingScopes).add(new ExplicitImportsScope(externalDescriptors));
        }
        if ((importList = codeFragment.importsAsImportList()) != null) {
            List list3 = importList.getImports();
            Intrinsics.checkNotNullExpressionValue((Object)list3, (String)"getImports(...)");
            if (!((Collection)list3).isEmpty()) {
                CollectionsKt.addAll((Collection)additionalImportingScopes, (Iterable)this.createImportScopes(importList));
            }
        }
        if (!((Collection)additionalImportingScopes).isEmpty()) {
            return ScopeUtilsKt.addImportingScopes((LexicalScope)scope, (List)additionalImportingScopes);
        }
        return scope;
    }

    /*
     * WARNING - void declaration
     */
    private final List<ImportingScope> createImportScopes(KtImportList importList) {
        void $this$mapNotNullTo$iv$iv;
        List list2 = importList.getImports();
        Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"getImports(...)");
        Iterable $this$mapNotNull$iv = list2;
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
        while (iterator2.hasNext()) {
            ImportingScope it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator2.next();
            boolean bl = false;
            KtImportDirective it = (KtImportDirective)element$iv$iv;
            boolean bl2 = false;
            Intrinsics.checkNotNull((Object)it);
            KtImportInfo ktImportInfo = (KtImportInfo)it;
            ModuleDescriptor moduleDescriptor = this.resolveSession.getModuleDescriptor();
            Intrinsics.checkNotNullExpressionValue((Object)moduleDescriptor, (String)"<get-moduleDescriptor>(...)");
            BindingTrace bindingTrace = this.resolveSession.getTrace();
            Intrinsics.checkNotNullExpressionValue((Object)bindingTrace, (String)"<get-trace>(...)");
            if (this.qualifierResolver.processImportReference(ktImportInfo, moduleDescriptor, bindingTrace, (Collection)CollectionsKt.emptyList(), null) == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    private final LexicalScope createEmptyScope(ModuleDescriptor moduleDescriptor) {
        return (LexicalScope)new LexicalScope.Base((HierarchicalScope)ImportingScope.Empty.INSTANCE, (DeclarationDescriptor)moduleDescriptor);
    }

    private static final BindingContext analyzeCodeFragmentContext$resolutionFactory(CodeFragmentAnalyzer this$0, BodyResolveMode $bodyResolveMode, KtElement element) {
        return this$0.getResolveElementCache().resolveToElement(element, $bodyResolveMode);
    }

    public static final /* synthetic */ BindingContext access$analyzeCodeFragmentContext$resolutionFactory(CodeFragmentAnalyzer this$0, BodyResolveMode $bodyResolveMode, KtElement element) {
        return CodeFragmentAnalyzer.analyzeCodeFragmentContext$resolutionFactory(this$0, $bodyResolveMode, element);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\t\u0010\f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\r\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\u000e\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0012\u001a\u00020\u0013H\u00d6\u0001J\t\u0010\u0014\u001a\u00020\u0015H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/kotlin/idea/caches/resolve/CodeFragmentAnalyzer$ClassResolutionResult;", "", "bindingContext", "Lorg/jetbrains/kotlin/resolve/BindingContext;", "descriptor", "Lorg/jetbrains/kotlin/descriptors/ClassDescriptorWithResolutionScopes;", "<init>", "(Lorg/jetbrains/kotlin/resolve/BindingContext;Lorg/jetbrains/kotlin/descriptors/ClassDescriptorWithResolutionScopes;)V", "getBindingContext", "()Lorg/jetbrains/kotlin/resolve/BindingContext;", "getDescriptor", "()Lorg/jetbrains/kotlin/descriptors/ClassDescriptorWithResolutionScopes;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "", "kotlin.base.fe10.analysis"})
    private static final class ClassResolutionResult {
        @NotNull
        private final BindingContext bindingContext;
        @NotNull
        private final ClassDescriptorWithResolutionScopes descriptor;

        public ClassResolutionResult(@NotNull BindingContext bindingContext, @NotNull ClassDescriptorWithResolutionScopes descriptor2) {
            Intrinsics.checkNotNullParameter((Object)bindingContext, (String)"bindingContext");
            Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor");
            this.bindingContext = bindingContext;
            this.descriptor = descriptor2;
        }

        @NotNull
        public final BindingContext getBindingContext() {
            return this.bindingContext;
        }

        @NotNull
        public final ClassDescriptorWithResolutionScopes getDescriptor() {
            return this.descriptor;
        }

        @NotNull
        public final BindingContext component1() {
            return this.bindingContext;
        }

        @NotNull
        public final ClassDescriptorWithResolutionScopes component2() {
            return this.descriptor;
        }

        @NotNull
        public final ClassResolutionResult copy(@NotNull BindingContext bindingContext, @NotNull ClassDescriptorWithResolutionScopes descriptor2) {
            Intrinsics.checkNotNullParameter((Object)bindingContext, (String)"bindingContext");
            Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor");
            return new ClassResolutionResult(bindingContext, descriptor2);
        }

        public static /* synthetic */ ClassResolutionResult copy$default(ClassResolutionResult classResolutionResult, BindingContext bindingContext, ClassDescriptorWithResolutionScopes classDescriptorWithResolutionScopes, int n, Object object) {
            if ((n & 1) != 0) {
                bindingContext = classResolutionResult.bindingContext;
            }
            if ((n & 2) != 0) {
                classDescriptorWithResolutionScopes = classResolutionResult.descriptor;
            }
            return classResolutionResult.copy(bindingContext, classDescriptorWithResolutionScopes);
        }

        @NotNull
        public String toString() {
            return "ClassResolutionResult(bindingContext=" + this.bindingContext + ", descriptor=" + this.descriptor + ")";
        }

        public int hashCode() {
            int result2 = this.bindingContext.hashCode();
            result2 = result2 * 31 + this.descriptor.hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof ClassResolutionResult)) {
                return false;
            }
            ClassResolutionResult classResolutionResult = (ClassResolutionResult)other;
            if (!Intrinsics.areEqual((Object)this.bindingContext, (Object)classResolutionResult.bindingContext)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.descriptor, (Object)classResolutionResult.descriptor);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\t"}, d2={"Lorg/jetbrains/kotlin/idea/caches/resolve/CodeFragmentAnalyzer$Companion;", "", "<init>", "()V", "EXPECTED_TYPE_KEY", "Lcom/intellij/openapi/util/Key;", "Lorg/jetbrains/kotlin/types/KotlinType;", "getEXPECTED_TYPE_KEY", "()Lcom/intellij/openapi/util/Key;", "kotlin.base.fe10.analysis"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Key<KotlinType> getEXPECTED_TYPE_KEY() {
            return EXPECTED_TYPE_KEY;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\t\u0010\u0010\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0011\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0012\u001a\u00020\u0007H\u00c6\u0003J'\u0010\u0013\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u0007H\u00c6\u0001J\u0013\u0010\u0014\u001a\u00020\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0017\u001a\u00020\u0018H\u00d6\u0001J\t\u0010\u0019\u001a\u00020\u001aH\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u001b"}, d2={"Lorg/jetbrains/kotlin/idea/caches/resolve/CodeFragmentAnalyzer$ContextInfo;", "", "bindingContext", "Lorg/jetbrains/kotlin/resolve/BindingContext;", "scope", "Lorg/jetbrains/kotlin/resolve/scopes/LexicalScope;", "dataFlowInfo", "Lorg/jetbrains/kotlin/resolve/calls/smartcasts/DataFlowInfo;", "<init>", "(Lorg/jetbrains/kotlin/resolve/BindingContext;Lorg/jetbrains/kotlin/resolve/scopes/LexicalScope;Lorg/jetbrains/kotlin/resolve/calls/smartcasts/DataFlowInfo;)V", "getBindingContext", "()Lorg/jetbrains/kotlin/resolve/BindingContext;", "getScope", "()Lorg/jetbrains/kotlin/resolve/scopes/LexicalScope;", "getDataFlowInfo", "()Lorg/jetbrains/kotlin/resolve/calls/smartcasts/DataFlowInfo;", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "", "toString", "", "kotlin.base.fe10.analysis"})
    private static final class ContextInfo {
        @NotNull
        private final BindingContext bindingContext;
        @NotNull
        private final LexicalScope scope;
        @NotNull
        private final DataFlowInfo dataFlowInfo;

        public ContextInfo(@NotNull BindingContext bindingContext, @NotNull LexicalScope scope, @NotNull DataFlowInfo dataFlowInfo) {
            Intrinsics.checkNotNullParameter((Object)bindingContext, (String)"bindingContext");
            Intrinsics.checkNotNullParameter((Object)scope, (String)"scope");
            Intrinsics.checkNotNullParameter((Object)dataFlowInfo, (String)"dataFlowInfo");
            this.bindingContext = bindingContext;
            this.scope = scope;
            this.dataFlowInfo = dataFlowInfo;
        }

        @NotNull
        public final BindingContext getBindingContext() {
            return this.bindingContext;
        }

        @NotNull
        public final LexicalScope getScope() {
            return this.scope;
        }

        @NotNull
        public final DataFlowInfo getDataFlowInfo() {
            return this.dataFlowInfo;
        }

        @NotNull
        public final BindingContext component1() {
            return this.bindingContext;
        }

        @NotNull
        public final LexicalScope component2() {
            return this.scope;
        }

        @NotNull
        public final DataFlowInfo component3() {
            return this.dataFlowInfo;
        }

        @NotNull
        public final ContextInfo copy(@NotNull BindingContext bindingContext, @NotNull LexicalScope scope, @NotNull DataFlowInfo dataFlowInfo) {
            Intrinsics.checkNotNullParameter((Object)bindingContext, (String)"bindingContext");
            Intrinsics.checkNotNullParameter((Object)scope, (String)"scope");
            Intrinsics.checkNotNullParameter((Object)dataFlowInfo, (String)"dataFlowInfo");
            return new ContextInfo(bindingContext, scope, dataFlowInfo);
        }

        public static /* synthetic */ ContextInfo copy$default(ContextInfo contextInfo, BindingContext bindingContext, LexicalScope lexicalScope, DataFlowInfo dataFlowInfo, int n, Object object) {
            if ((n & 1) != 0) {
                bindingContext = contextInfo.bindingContext;
            }
            if ((n & 2) != 0) {
                lexicalScope = contextInfo.scope;
            }
            if ((n & 4) != 0) {
                dataFlowInfo = contextInfo.dataFlowInfo;
            }
            return contextInfo.copy(bindingContext, lexicalScope, dataFlowInfo);
        }

        @NotNull
        public String toString() {
            return "ContextInfo(bindingContext=" + this.bindingContext + ", scope=" + this.scope + ", dataFlowInfo=" + this.dataFlowInfo + ")";
        }

        public int hashCode() {
            int result2 = this.bindingContext.hashCode();
            result2 = result2 * 31 + this.scope.hashCode();
            result2 = result2 * 31 + this.dataFlowInfo.hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof ContextInfo)) {
                return false;
            }
            ContextInfo contextInfo = (ContextInfo)other;
            if (!Intrinsics.areEqual((Object)this.bindingContext, (Object)contextInfo.bindingContext)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.scope, (Object)contextInfo.scope)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.dataFlowInfo, (Object)contextInfo.dataFlowInfo);
        }
    }
}

