/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.codeInsight.codevision;

import com.intellij.codeInsight.hints.ChangeListener;
import com.intellij.codeInsight.hints.ImmediateConfigurable;
import com.intellij.codeInsight.hints.InlayGroup;
import com.intellij.codeInsight.hints.InlayHintsCollector;
import com.intellij.codeInsight.hints.InlayHintsProvider;
import com.intellij.codeInsight.hints.InlayHintsSink;
import com.intellij.codeInsight.hints.NoSettings;
import com.intellij.codeInsight.hints.SettingsKey;
import com.intellij.lang.Language;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.psi.PsiFile;
import com.intellij.ui.dsl.builder.BuilderKt;
import com.intellij.ui.dsl.builder.Panel;
import java.util.List;
import javax.swing.JPanel;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.KotlinLanguage;
import org.jetbrains.kotlin.idea.base.resources.KotlinBundle;
import org.jetbrains.kotlin.idea.codeInsight.codevision.KotlinCodeVisionHintsCollector;
import org.jetbrains.kotlin.idea.codeInsight.codevision.KotlinCodeVisionProvider;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\b\n\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0010\u0010&\u001a\u00020\u001d2\u0006\u0010'\u001a\u00020(H\u0016J\u0010\u0010)\u001a\u00020*2\u0006\u0010+\u001a\u00020\u0002H\u0016J\b\u0010,\u001a\u00020\u0002H\u0016J*\u0010-\u001a\u0004\u0018\u00010.2\u0006\u0010/\u001a\u0002002\u0006\u00101\u001a\u0002022\u0006\u0010+\u001a\u00020\u00022\u0006\u00103\u001a\u000204H\u0016R\u001a\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\t\u001a\u00020\nX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\r\u001a\u00020\u000e8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R\u0016\u0010\u0011\u001a\u0004\u0018\u00010\nX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\fR\u001a\u0010\u0013\u001a\u00020\u0014X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\u0016\"\u0004\b\u0017\u0010\u0018R\u001a\u0010\u0019\u001a\u00020\u0014X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001a\u0010\u0016\"\u0004\b\u001b\u0010\u0018R\u001a\u0010\u001c\u001a\u00020\u001dX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001e\u0010\u001f\"\u0004\b \u0010!R\u001a\u0010\"\u001a\u00020\u001dX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b#\u0010\u001f\"\u0004\b$\u0010!R\u0014\u0010%\u001a\u00020\u001dX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b%\u0010\u001f\u00a8\u00065"}, d2={"Lorg/jetbrains/kotlin/idea/codeInsight/codevision/KotlinCodeVisionProvider;", "Lcom/intellij/codeInsight/hints/InlayHintsProvider;", "Lcom/intellij/codeInsight/hints/NoSettings;", "<init>", "()V", "key", "Lcom/intellij/codeInsight/hints/SettingsKey;", "getKey", "()Lcom/intellij/codeInsight/hints/SettingsKey;", "name", "", "getName", "()Ljava/lang/String;", "group", "Lcom/intellij/codeInsight/hints/InlayGroup;", "getGroup", "()Lcom/intellij/codeInsight/hints/InlayGroup;", "previewText", "getPreviewText", "usagesLimit", "", "getUsagesLimit", "()I", "setUsagesLimit", "(I)V", "inheritorsLimit", "getInheritorsLimit", "setInheritorsLimit", "showUsages", "", "getShowUsages", "()Z", "setShowUsages", "(Z)V", "showInheritors", "getShowInheritors", "setShowInheritors", "isVisibleInSettings", "isLanguageSupported", "language", "Lcom/intellij/lang/Language;", "createConfigurable", "Lcom/intellij/codeInsight/hints/ImmediateConfigurable;", "settings", "createSettings", "getCollectorFor", "Lcom/intellij/codeInsight/hints/InlayHintsCollector;", "file", "Lcom/intellij/psi/PsiFile;", "editor", "Lcom/intellij/openapi/editor/Editor;", "sink", "Lcom/intellij/codeInsight/hints/InlayHintsSink;", "kotlin.idea"})
public final class KotlinCodeVisionProvider
implements InlayHintsProvider<NoSettings> {
    @NotNull
    private final SettingsKey<NoSettings> key = new SettingsKey("CodeVision");
    @NotNull
    private final String name = KotlinBundle.message((String)"hints.title.codevision", (Object[])new Object[0]);
    @Nullable
    private final String previewText;
    private int usagesLimit = 100;
    private int inheritorsLimit = 100;
    private boolean showUsages;
    private boolean showInheritors;
    private final boolean isVisibleInSettings;

    @NotNull
    public SettingsKey<NoSettings> getKey() {
        return this.key;
    }

    @NotNull
    public String getName() {
        return this.name;
    }

    @NotNull
    public InlayGroup getGroup() {
        return InlayGroup.CODE_VISION_GROUP;
    }

    @Nullable
    public String getPreviewText() {
        return this.previewText;
    }

    public final int getUsagesLimit() {
        return this.usagesLimit;
    }

    public final void setUsagesLimit(int n) {
        this.usagesLimit = n;
    }

    public final int getInheritorsLimit() {
        return this.inheritorsLimit;
    }

    public final void setInheritorsLimit(int n) {
        this.inheritorsLimit = n;
    }

    public final boolean getShowUsages() {
        return this.showUsages;
    }

    public final void setShowUsages(boolean bl) {
        this.showUsages = bl;
    }

    public final boolean getShowInheritors() {
        return this.showInheritors;
    }

    public final void setShowInheritors(boolean bl) {
        this.showInheritors = bl;
    }

    public boolean isVisibleInSettings() {
        return this.isVisibleInSettings;
    }

    public boolean isLanguageSupported(@NotNull Language language) {
        Intrinsics.checkNotNullParameter((Object)language, (String)"language");
        return language instanceof KotlinLanguage;
    }

    @NotNull
    public ImmediateConfigurable createConfigurable(@NotNull NoSettings settings2) {
        Intrinsics.checkNotNullParameter((Object)settings2, (String)"settings");
        return new ImmediateConfigurable(){
            private final List<ImmediateConfigurable.Case> cases;
            private final String mainCheckboxText;
            {
                this.cases = CollectionsKt.emptyList();
                this.mainCheckboxText = "";
            }

            public JPanel createComponent(ChangeListener listener2) {
                Intrinsics.checkNotNullParameter((Object)listener2, (String)"listener");
                return (JPanel)BuilderKt.panel(createConfigurable.1::createComponent$lambda$0);
            }

            public List<ImmediateConfigurable.Case> getCases() {
                return this.cases;
            }

            public String getMainCheckboxText() {
                return this.mainCheckboxText;
            }

            private static final Unit createComponent$lambda$0(Panel $this$panel) {
                Intrinsics.checkNotNullParameter((Object)$this$panel, (String)"$this$panel");
                return Unit.INSTANCE;
            }
        };
    }

    @NotNull
    public NoSettings createSettings() {
        return new NoSettings();
    }

    @Nullable
    public InlayHintsCollector getCollectorFor(@NotNull PsiFile file, @NotNull Editor editor, @NotNull NoSettings settings2, @NotNull InlayHintsSink sink) {
        boolean showInheritorsResolved;
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)settings2, (String)"settings");
        Intrinsics.checkNotNullParameter((Object)sink, (String)"sink");
        boolean showUsagesResolved = Registry.Companion.is("kotlin.code-vision.usages", false) || this.showUsages;
        boolean bl = showInheritorsResolved = Registry.Companion.is("kotlin.code-vision.inheritors", false) || this.showInheritors;
        if (!showUsagesResolved && !showInheritorsResolved) {
            return null;
        }
        return (InlayHintsCollector)new KotlinCodeVisionHintsCollector(editor, showUsagesResolved, showInheritorsResolved, this.usagesLimit, this.inheritorsLimit);
    }
}

