/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.codeInsight.inspections.shared;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.base.resources.KotlinBundle;
import org.jetbrains.kotlin.idea.codeinsight.utils.KotlinPsiUtilsKt;
import org.jetbrains.kotlin.psi.KtPropertyAccessor;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0006\u001a\u00020\u0007H\u0016J\b\u0010\b\u001a\u00020\u0007H\u0016J\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/kotlin/idea/codeInsight/inspections/shared/RemoveRedundantSetterFix;", "Lcom/intellij/codeInspection/LocalQuickFix;", "canBeCompletelyDeleted", "", "<init>", "(Z)V", "getName", "", "getFamilyName", "applyFix", "", "project", "Lcom/intellij/openapi/project/Project;", "descriptor", "Lcom/intellij/codeInspection/ProblemDescriptor;", "kotlin.code-insight.inspections.shared"})
final class RemoveRedundantSetterFix
implements LocalQuickFix {
    private final boolean canBeCompletelyDeleted;

    public RemoveRedundantSetterFix(boolean canBeCompletelyDeleted) {
        this.canBeCompletelyDeleted = canBeCompletelyDeleted;
    }

    @NotNull
    public String getName() {
        String key = this.canBeCompletelyDeleted ? "remove.redundant.setter.fix.text" : "remove.redundant.setter.body.fix.text";
        return KotlinBundle.message((String)key, (Object[])new Object[0]);
    }

    @NotNull
    public String getFamilyName() {
        return this.getName();
    }

    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor2) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor");
        PsiElement psiElement = descriptor2.getPsiElement();
        KtPropertyAccessor ktPropertyAccessor = psiElement instanceof KtPropertyAccessor ? (KtPropertyAccessor)psiElement : null;
        if (ktPropertyAccessor == null) {
            return;
        }
        KtPropertyAccessor accessor = ktPropertyAccessor;
        KotlinPsiUtilsKt.removeRedundantSetter(accessor);
    }
}

