/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.completion;

import com.intellij.codeInsight.completion.CompletionInitializationContext;
import com.intellij.codeInsight.completion.InsertHandler;
import com.intellij.codeInsight.completion.InsertionContext;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementDecorator;
import com.intellij.codeInsight.lookup.LookupElementPresentation;
import com.intellij.openapi.editor.Editor;
import com.intellij.psi.PsiFile;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.completion.CompletionUtilsNoResolveKt;
import org.jetbrains.kotlin.idea.completion.handlers.HandlerUtilsKt;
import org.jetbrains.kotlin.idea.core.GenerateUtilsKt;
import org.jetbrains.kotlin.idea.core.formatter.KotlinCodeStyleSettings;
import org.jetbrains.kotlin.idea.formatter.CodeStyleUtilsKt;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\"\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B'\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0006\u0010\u0006\u001a\u00020\u0002\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nJ\b\u0010\f\u001a\u00020\u0004H\u0016J\u000e\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00040\u000eH\u0016J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u000e\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00020\u0014H\u0016J\u0013\u0010\u0015\u001a\u00020\b2\b\u0010\u0016\u001a\u0004\u0018\u00010\u0017H\u0096\u0002J\b\u0010\u0018\u001a\u00020\u0019H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lorg/jetbrains/kotlin/idea/completion/NameWithTypeLookupElementDecorator;", "Lcom/intellij/codeInsight/lookup/LookupElementDecorator;", "Lcom/intellij/codeInsight/lookup/LookupElement;", "parameterName", "", "typeIdString", "typeLookupElement", "shouldInsertType", "", "<init>", "(Ljava/lang/String;Ljava/lang/String;Lcom/intellij/codeInsight/lookup/LookupElement;Z)V", "lookupString", "getLookupString", "getAllLookupStrings", "", "renderElement", "", "presentation", "Lcom/intellij/codeInsight/lookup/LookupElementPresentation;", "getDelegateInsertHandler", "Lcom/intellij/codeInsight/completion/InsertHandler;", "equals", "other", "", "hashCode", "", "kotlin.completion.impl.shared"})
public final class NameWithTypeLookupElementDecorator
extends LookupElementDecorator<LookupElement> {
    @NotNull
    private final String parameterName;
    @NotNull
    private final String typeIdString;
    private final boolean shouldInsertType;
    @NotNull
    private final String lookupString;

    public NameWithTypeLookupElementDecorator(@NotNull String parameterName2, @NotNull String typeIdString, @NotNull LookupElement typeLookupElement, boolean shouldInsertType) {
        Intrinsics.checkNotNullParameter((Object)parameterName2, (String)"parameterName");
        Intrinsics.checkNotNullParameter((Object)typeIdString, (String)"typeIdString");
        Intrinsics.checkNotNullParameter((Object)typeLookupElement, (String)"typeLookupElement");
        super(typeLookupElement);
        this.parameterName = parameterName2;
        this.typeIdString = typeIdString;
        this.shouldInsertType = shouldInsertType;
        this.lookupString = this.parameterName + (String)(this.shouldInsertType ? ": " + this.getDelegate().getLookupString() : "");
    }

    @NotNull
    public String getLookupString() {
        return this.lookupString;
    }

    @NotNull
    public Set<String> getAllLookupStrings() {
        return SetsKt.setOf((Object)this.lookupString);
    }

    public void renderElement(@NotNull LookupElementPresentation presentation) {
        Intrinsics.checkNotNullParameter((Object)presentation, (String)"presentation");
        super.renderElement(presentation);
        if (this.shouldInsertType) {
            presentation.setItemText(this.parameterName + ": " + presentation.getItemText());
        } else {
            CompletionUtilsNoResolveKt.prependTailText(presentation, ": " + presentation.getItemText(), true);
            presentation.setItemText(this.parameterName);
        }
    }

    @NotNull
    public InsertHandler<LookupElement> getDelegateInsertHandler() {
        return (arg_0, arg_1) -> NameWithTypeLookupElementDecorator.getDelegateInsertHandler$lambda$0(this, arg_0, arg_1);
    }

    public boolean equals(@Nullable Object other) {
        return other instanceof NameWithTypeLookupElementDecorator && Intrinsics.areEqual((Object)this.parameterName, (Object)((NameWithTypeLookupElementDecorator)((Object)other)).parameterName) && Intrinsics.areEqual((Object)this.typeIdString, (Object)((NameWithTypeLookupElementDecorator)((Object)other)).typeIdString) && this.shouldInsertType == ((NameWithTypeLookupElementDecorator)((Object)other)).shouldInsertType;
    }

    public int hashCode() {
        return this.parameterName.hashCode();
    }

    private static final void getDelegateInsertHandler$lambda$0(NameWithTypeLookupElementDecorator this$0, InsertionContext context2, LookupElement element) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        if (context2.getCompletionChar() == '\t') {
            int tailOffset = context2.getTailOffset();
            CharSequence charSequence = context2.getDocument().getCharsSequence();
            Intrinsics.checkNotNullExpressionValue((Object)charSequence, (String)"getCharsSequence(...)");
            CharSequence chars = charSequence;
            int offset = HandlerUtilsKt.skipSpaces(chars, tailOffset);
            if (HandlerUtilsKt.isCharAt(chars, offset, ',')) {
                ++offset;
                offset = HandlerUtilsKt.skipSpaces(chars, offset);
                Editor editor = context2.getEditor();
                Intrinsics.checkNotNullExpressionValue((Object)editor, (String)"getEditor(...)");
                GenerateUtilsKt.moveCaret$default(editor, offset, null, 2, null);
            }
        }
        PsiFile psiFile = context2.getFile();
        Intrinsics.checkNotNullExpressionValue((Object)psiFile, (String)"getFile(...)");
        KotlinCodeStyleSettings settings2 = CodeStyleUtilsKt.getKotlinCustomSettings((PsiFile)psiFile);
        String spaceBefore = settings2.SPACE_BEFORE_TYPE_COLON ? " " : "";
        String spaceAfter = settings2.SPACE_AFTER_TYPE_COLON ? " " : "";
        int startOffset = context2.getStartOffset();
        if (this$0.shouldInsertType) {
            String text = this$0.parameterName + spaceBefore + ":" + spaceAfter;
            context2.getDocument().insertString(startOffset, (CharSequence)text);
            context2.commitDocument();
            context2.getOffsetMap().addOffset(CompletionInitializationContext.START_OFFSET, startOffset + text.length());
            element.handleInsert(context2);
        } else {
            context2.getDocument().replaceString(startOffset, context2.getTailOffset(), (CharSequence)this$0.parameterName);
            context2.commitDocument();
        }
    }
}

