/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.core.script;

import com.intellij.diagnostic.PluginException;
import com.intellij.execution.wsl.WslPath;
import com.intellij.ide.plugins.PluginManager;
import com.intellij.openapi.diagnostic.ControlFlowException;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.NioPathUtil;
import com.intellij.util.ExceptionUtil;
import com.intellij.util.PathUtil;
import com.intellij.util.lang.UrlClassLoader;
import java.io.File;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmClassMappingKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KClass;
import kotlin.script.experimental.annotations.KotlinScript;
import kotlin.script.experimental.host.HostConfigurationKt;
import kotlin.script.experimental.host.ScriptingHostConfiguration;
import kotlin.script.experimental.jvm.JvmDependency;
import kotlin.script.templates.ScriptTemplateDefinition;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.core.script.ScriptUtilsKt;
import org.jetbrains.kotlin.scripting.definitions.ScriptCompilationConfigurationFromDefinitionKt;
import org.jetbrains.kotlin.scripting.definitions.ScriptDefinition;
import org.jetbrains.kotlin.scripting.definitions.ScriptDefinitionsSource;
import org.jetbrains.kotlin.scripting.resolve.KotlinScriptDefinitionFromAnnotatedTemplate;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000:\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001c\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\u001aP\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00040\u00012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00060\u00012\u0006\u0010\u0007\u001a\u00020\b2\u000e\b\u0002\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00060\u00012\u000e\b\u0002\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00040\u000b\u001aP\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00040\u00012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\r0\u00012\u0006\u0010\u0007\u001a\u00020\b2\u000e\b\u0002\u0010\t\u001a\b\u0012\u0004\u0012\u00020\r0\u00012\u000e\b\u0002\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00040\u000b\u001a\u001c\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\r0\u00012\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\r0\u0001H\u0002\u001a \u0010\u0010\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\r2\u000e\u0010\u0011\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\r0\u0012H\u0002\u001a\f\u0010\u0013\u001a\u00020\u0014*\u00020\rH\u0002\u00a8\u0006\u0015"}, d2={"loadDefinitionsFromTemplates", "", "Lorg/jetbrains/kotlin/scripting/definitions/ScriptDefinition;", "templateClassNames", "", "templateClasspath", "Ljava/io/File;", "baseHostConfiguration", "Lkotlin/script/experimental/host/ScriptingHostConfiguration;", "additionalResolverClasspath", "defaultCompilerOptions", "", "loadDefinitionsFromTemplatesByPaths", "Ljava/nio/file/Path;", "adjustClasspath", "source", "moveJarFromWslToHost", "targetFolderPathResolver", "Lkotlin/Lazy;", "shouldBeMovedToHost", "", "kotlin.base.scripting"})
@SourceDebugExtension(value={"SMAP\nscriptDefinitionLoading.kt\nKotlin\n*S Kotlin\n*F\n+ 1 scriptDefinitionLoading.kt\norg/jetbrains/kotlin/idea/core/script/ScriptDefinitionLoadingKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 addToStdlib.kt\norg/jetbrains/kotlin/utils/addToStdlib/AddToStdlibKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,163:1\n1557#2:164\n1628#2,3:165\n1557#2:168\n1628#2,3:169\n1611#2,9:172\n1863#2:181\n1557#2:182\n1628#2,3:183\n1864#2:191\n1620#2:192\n1557#2:193\n1628#2,3:194\n1557#2:197\n1628#2,3:198\n21#3,2:186\n21#3,2:188\n1#4:190\n*S KotlinDebug\n*F\n+ 1 scriptDefinitionLoading.kt\norg/jetbrains/kotlin/idea/core/script/ScriptDefinitionLoadingKt\n*L\n46#1:164\n46#1:165,3\n48#1:168\n48#1:169,3\n75#1:172,9\n75#1:181\n81#1:182\n81#1:183,3\n75#1:191\n75#1:192\n126#1:193\n126#1:194,3\n137#1:197\n137#1:198,3\n87#1:186,2\n91#1:188,2\n75#1:190\n*E\n"})
public final class ScriptDefinitionLoadingKt {
    @NotNull
    public static final List<ScriptDefinition> loadDefinitionsFromTemplates(@NotNull List<String> templateClassNames, @NotNull List<? extends File> templateClasspath, @NotNull ScriptingHostConfiguration baseHostConfiguration, @NotNull List<? extends File> additionalResolverClasspath, @NotNull Iterable<String> defaultCompilerOptions) {
        Collection<Path> collection;
        File p0;
        Collection collection2;
        Iterable $this$mapTo$iv$iv;
        Iterable $this$map$iv;
        Intrinsics.checkNotNullParameter(templateClassNames, (String)"templateClassNames");
        Intrinsics.checkNotNullParameter(templateClasspath, (String)"templateClasspath");
        Intrinsics.checkNotNullParameter((Object)baseHostConfiguration, (String)"baseHostConfiguration");
        Intrinsics.checkNotNullParameter(additionalResolverClasspath, (String)"additionalResolverClasspath");
        Intrinsics.checkNotNullParameter(defaultCompilerOptions, (String)"defaultCompilerOptions");
        Iterable iterable = templateClasspath;
        List<String> list2 = templateClassNames;
        boolean $i$f$map = false;
        void var7_8 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            File file = (File)item$iv$iv;
            collection2 = destination$iv$iv;
            boolean $i$f$loadDefinitionsFromTemplates$stub_for_inlining = false;
            boolean bl = false;
            collection2.add(p0.toPath());
        }
        $this$map$iv = additionalResolverClasspath;
        ScriptingHostConfiguration scriptingHostConfiguration = baseHostConfiguration;
        collection2 = (List)destination$iv$iv;
        $i$f$map = false;
        $this$mapTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            p0 = (File)item$iv$iv;
            collection = destination$iv$iv;
            boolean $i$f$loadDefinitionsFromTemplates$stub_for_inlining$0 = false;
            boolean bl = false;
            collection.add(p0.toPath());
        }
        collection = (List)destination$iv$iv;
        return ScriptDefinitionLoadingKt.loadDefinitionsFromTemplatesByPaths(list2, (List<? extends Path>)collection2, scriptingHostConfiguration, (List<? extends Path>)collection, defaultCompilerOptions);
    }

    public static /* synthetic */ List loadDefinitionsFromTemplates$default(List list2, List list3, ScriptingHostConfiguration scriptingHostConfiguration, List list4, Iterable iterable, int n, Object object) {
        if ((n & 8) != 0) {
            list4 = CollectionsKt.emptyList();
        }
        if ((n & 0x10) != 0) {
            iterable = CollectionsKt.emptyList();
        }
        return ScriptDefinitionLoadingKt.loadDefinitionsFromTemplates(list2, list3, scriptingHostConfiguration, list4, iterable);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<ScriptDefinition> loadDefinitionsFromTemplatesByPaths(@NotNull List<String> templateClassNames, @NotNull List<? extends Path> templateClasspath, @NotNull ScriptingHostConfiguration baseHostConfiguration, @NotNull List<? extends Path> additionalResolverClasspath, @NotNull Iterable<String> defaultCompilerOptions) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        void $this$mapNotNullTo$iv$iv;
        Intrinsics.checkNotNullParameter(templateClassNames, (String)"templateClassNames");
        Intrinsics.checkNotNullParameter(templateClasspath, (String)"templateClasspath");
        Intrinsics.checkNotNullParameter((Object)baseHostConfiguration, (String)"baseHostConfiguration");
        Intrinsics.checkNotNullParameter(additionalResolverClasspath, (String)"additionalResolverClasspath");
        Intrinsics.checkNotNullParameter(defaultCompilerOptions, (String)"defaultCompilerOptions");
        List<Path> classpath = ScriptDefinitionLoadingKt.adjustClasspath(CollectionsKt.plus((Collection)templateClasspath, (Iterable)additionalResolverClasspath));
        ScriptUtilsKt.scriptingInfoLog("Loading script definitions: classes = " + templateClassNames + ", classpath = " + classpath);
        ClassLoader baseLoader = ScriptDefinitionsSource.class.getClassLoader();
        ClassLoader loader = classpath.isEmpty() ? baseLoader : (ClassLoader)UrlClassLoader.build().files(classpath).parent(baseLoader).get();
        Iterable $this$mapNotNull$iv = templateClassNames;
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Object object = $this$forEach$iv$iv$iv.iterator();
        while (object.hasNext()) {
            ScriptDefinition it$iv$iv;
            ScriptDefinition scriptDefinition;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = object.next();
            boolean bl = false;
            String templateClassName = (String)element$iv$iv;
            boolean bl2 = false;
            try {
                ScriptDefinition scriptDefinition2;
                Object v1;
                boolean $i$f$firstIsInstanceOrNull;
                Iterable $this$firstIsInstanceOrNull$iv;
                ScriptingHostConfiguration hostConfiguration;
                List templateClasspathAsFiles;
                KClass template2;
                block15: {
                    void $this$mapTo$iv$iv2;
                    Class<?> clazz = loader.loadClass(templateClassName);
                    Intrinsics.checkNotNullExpressionValue(clazz, (String)"loadClass(...)");
                    template2 = JvmClassMappingKt.getKotlinClass(clazz);
                    Iterable $this$map$iv2 = templateClasspath;
                    boolean $i$f$map22 = false;
                    Iterable iterable2 = $this$map$iv2;
                    Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
                    boolean $i$f$mapTo = false;
                    for (Object item$iv$iv : $this$mapTo$iv$iv2) {
                        void it;
                        Path path2 = (Path)item$iv$iv;
                        Collection collection = destination$iv$iv2;
                        boolean bl3 = false;
                        collection.add(new File(it.toString()));
                    }
                    templateClasspathAsFiles = (List)destination$iv$iv2;
                    ScriptingHostConfiguration[] $i$f$map22 = new ScriptingHostConfiguration[]{baseHostConfiguration};
                    hostConfiguration = new ScriptingHostConfiguration($i$f$map22, (Function1<? super ScriptingHostConfiguration.Builder, Unit>)((Function1)arg_0 -> ScriptDefinitionLoadingKt.loadDefinitionsFromTemplatesByPaths$lambda$4$lambda$2(templateClasspathAsFiles, arg_0)));
                    $this$firstIsInstanceOrNull$iv = template2.getAnnotations();
                    $i$f$firstIsInstanceOrNull = false;
                    for (Object element$iv : $this$firstIsInstanceOrNull$iv) {
                        if (!(element$iv instanceof KotlinScript)) continue;
                        v1 = element$iv;
                        break block15;
                    }
                    v1 = null;
                }
                if (v1 != null) {
                    scriptDefinition2 = new ScriptDefinition.FromTemplate(hostConfiguration, template2, Reflection.getOrCreateKotlinClass(ScriptDefinition.class), defaultCompilerOptions);
                } else {
                    Object v3;
                    block16: {
                        $this$firstIsInstanceOrNull$iv = template2.getAnnotations();
                        $i$f$firstIsInstanceOrNull = false;
                        for (Object element$iv : $this$firstIsInstanceOrNull$iv) {
                            if (!(element$iv instanceof ScriptTemplateDefinition)) continue;
                            v3 = element$iv;
                            break block16;
                        }
                        v3 = null;
                    }
                    if (v3 != null) {
                        Function0<Map<String, Object>> function0 = hostConfiguration.get(ScriptCompilationConfigurationFromDefinitionKt.getGetEnvironment(ScriptingHostConfiguration.Companion));
                        scriptDefinition2 = new ScriptDefinition.FromLegacy(hostConfiguration, new KotlinScriptDefinitionFromAnnotatedTemplate((KClass<? extends Object>)template2, function0 != null ? (Map)function0.invoke() : null, templateClasspathAsFiles), defaultCompilerOptions);
                    } else {
                        ScriptUtilsKt.scriptingWarnLog("Cannot find a valid script definition annotation on the class " + template2);
                        scriptDefinition2 = null;
                    }
                }
                scriptDefinition = scriptDefinition2;
            }
            catch (ClassNotFoundException e) {
                ScriptUtilsKt.scriptingWarnLog("Cannot load script definition class " + templateClassName, e);
                scriptDefinition = null;
            }
            catch (Throwable e) {
                if (e instanceof ControlFlowException) {
                    throw e;
                }
                String message2 = "Cannot load script definition class " + templateClassName;
                if (PluginManager.getPluginByClassNameAsNoAccessToClass((String)templateClassName) != null) {
                    PluginId it;
                    boolean bl4 = false;
                    ScriptUtilsKt.scriptingErrorLog(message2, (Throwable)new PluginException(message2, e, it));
                } else {
                    ScriptUtilsKt.scriptingErrorLog(message2, e);
                }
                scriptDefinition = null;
            }
            if (scriptDefinition == null) continue;
            boolean bl5 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        List definitions2 = (List)destination$iv$iv;
        $this$mapNotNull$iv = definitions2;
        List<String> list2 = templateClassNames;
        boolean $i$f$map = false;
        $this$mapNotNullTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            object = (ScriptDefinition)((Object)item$iv$iv);
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getName());
        }
        ScriptUtilsKt.scriptingInfoLog("Loaded definitions: classes = " + list2 + ", definitions = " + (List)destination$iv$iv);
        return definitions2;
    }

    public static /* synthetic */ List loadDefinitionsFromTemplatesByPaths$default(List list2, List list3, ScriptingHostConfiguration scriptingHostConfiguration, List list4, Iterable iterable, int n, Object object) {
        if ((n & 8) != 0) {
            list4 = CollectionsKt.emptyList();
        }
        if ((n & 0x10) != 0) {
            iterable = CollectionsKt.emptyList();
        }
        return ScriptDefinitionLoadingKt.loadDefinitionsFromTemplatesByPaths(list2, list3, scriptingHostConfiguration, list4, iterable);
    }

    /*
     * WARNING - void declaration
     */
    private static final List<Path> adjustClasspath(List<? extends Path> source) {
        void $this$mapTo$iv$iv;
        Lazy cacheFolder = LazyKt.lazy(ScriptDefinitionLoadingKt::adjustClasspath$lambda$6);
        Iterable $this$map$iv = source;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Path path2 = (Path)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(ScriptDefinitionLoadingKt.shouldBeMovedToHost((Path)it) ? ScriptDefinitionLoadingKt.moveJarFromWslToHost((Path)it, (Lazy<? extends Path>)cacheFolder) : it);
        }
        return (List)destination$iv$iv;
    }

    private static final Path moveJarFromWslToHost(Path source, Lazy<? extends Path> targetFolderPathResolver) {
        Path path2 = (Path)targetFolderPathResolver.getValue();
        if (path2 == null) {
            return source;
        }
        Path targetFolderPath = path2;
        String string = PathUtil.getFileName((String)NioPathUtil.toCanonicalPath((Path)source));
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getFileName(...)");
        String fileNameWithExtension = string;
        Path relocatedJar = targetFolderPath.resolve(fileNameWithExtension);
        Intrinsics.checkNotNull((Object)relocatedJar);
        LinkOption[] linkOptionArray = new LinkOption[]{};
        if (Files.exists(relocatedJar, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
            return relocatedJar;
        }
        try {
            CopyOption[] copyOptionArray = new CopyOption[]{StandardCopyOption.REPLACE_EXISTING};
            Files.copy(source, relocatedJar, copyOptionArray);
        }
        catch (Throwable t) {
            ScriptUtilsKt.getLogger().warn("Unable to copy a DSL-related jar from " + source + " to " + relocatedJar + ": " + ExceptionUtil.getMessage((Throwable)t));
            return source;
        }
        return relocatedJar;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean shouldBeMovedToHost(Path $this$shouldBeMovedToHost) {
        if (!WslPath.Companion.isWslUncPath(((Object)$this$shouldBeMovedToHost).toString())) return false;
        String string = PathUtil.getFileName((String)NioPathUtil.toCanonicalPath((Path)$this$shouldBeMovedToHost));
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getFileName(...)");
        if (!StringsKt.endsWith$default((String)string, (String)".jar", (boolean)false, (int)2, null)) return false;
        return true;
    }

    private static final Unit loadDefinitionsFromTemplatesByPaths$lambda$4$lambda$2(List $templateClasspathAsFiles, ScriptingHostConfiguration.Builder $this$ScriptingHostConfiguration) {
        Intrinsics.checkNotNullParameter((Object)$this$ScriptingHostConfiguration, (String)"$this$ScriptingHostConfiguration");
        JvmDependency[] jvmDependencyArray = new JvmDependency[]{new JvmDependency($templateClasspathAsFiles)};
        $this$ScriptingHostConfiguration.invoke(HostConfigurationKt.getConfigurationDependencies($this$ScriptingHostConfiguration), (T[])jvmDependencyArray);
        return Unit.INSTANCE;
    }

    private static final Path adjustClasspath$lambda$6() {
        Path path2;
        String string = FileUtil.getTempDirectory();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getTempDirectory(...)");
        String tempDirectory = string;
        Path path3 = NioPathUtil.toNioPathOrNull((String)tempDirectory);
        return path3 != null && (path2 = path3.resolve("kotlin-script-dependencies")) != null ? NioPathUtil.findOrCreateDirectory((Path)path2) : null;
    }
}

