/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.debugger.core.filter;

import com.intellij.debugger.settings.DebuggerSettings;
import com.intellij.ui.classFilter.ClassFilter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.ArrayIteratorKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000\u001e\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\u001a\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0001H\u0002\u001a \u0010\t\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00012\u0006\u0010\n\u001a\u00020\u000bH\u0002\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0003\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"KOTLIN_STDLIB_FILTER", "", "KOTLINX_FILTER", "COMPOSE_RUNTIME_FILTER", "addSteppingFilterIfNeeded", "", "debuggerSettings", "Lcom/intellij/debugger/settings/DebuggerSettings;", "pattern", "leaveOnlyFirstOccurenceOfSteppingFilter", "occurrencesNum", "", "kotlin.jvm-debugger.core"})
@SourceDebugExtension(value={"SMAP\nJvmDebuggerAddFilterStartupActivity.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JvmDebuggerAddFilterStartupActivity.kt\norg/jetbrains/kotlin/idea/debugger/core/filter/JvmDebuggerAddFilterStartupActivityKt\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,51:1\n12734#2,3:52\n37#3,2:55\n*S KotlinDebug\n*F\n+ 1 JvmDebuggerAddFilterStartupActivity.kt\norg/jetbrains/kotlin/idea/debugger/core/filter/JvmDebuggerAddFilterStartupActivityKt\n*L\n26#1:52,3\n49#1:55,2\n*E\n"})
public final class JvmDebuggerAddFilterStartupActivityKt {
    @NotNull
    private static final String KOTLIN_STDLIB_FILTER = "kotlin.*";
    @NotNull
    private static final String KOTLINX_FILTER = "kotlinx.*";
    @NotNull
    private static final String COMPOSE_RUNTIME_FILTER = "androidx.compose.runtime.*";

    private static final void addSteppingFilterIfNeeded(DebuggerSettings debuggerSettings, String pattern2) {
        Object[] steppingFilters = debuggerSettings.getSteppingFilters();
        Intrinsics.checkNotNull((Object)steppingFilters);
        Object[] $this$count$iv = steppingFilters;
        boolean $i$f$count = false;
        int count$iv = 0;
        int n = $this$count$iv.length;
        for (int j = 0; j < n; ++j) {
            ClassFilter element$iv;
            ClassFilter it = element$iv = $this$count$iv[j];
            boolean bl = false;
            if (!Intrinsics.areEqual((Object)it.getPattern(), (Object)pattern2)) continue;
            ++count$iv;
        }
        int occurrencesNum = count$iv;
        switch (occurrencesNum) {
            case 0: {
                debuggerSettings.setSteppingFilters((ClassFilter[])ArraysKt.plus((Object[])steppingFilters, (Object)new ClassFilter(pattern2)));
                break;
            }
            case 1: {
                return;
            }
            default: {
                JvmDebuggerAddFilterStartupActivityKt.leaveOnlyFirstOccurenceOfSteppingFilter(debuggerSettings, pattern2, occurrencesNum);
            }
        }
    }

    private static final void leaveOnlyFirstOccurenceOfSteppingFilter(DebuggerSettings debuggerSettings, String pattern2, int occurrencesNum) {
        Object[] steppingFilters = debuggerSettings.getSteppingFilters();
        ArrayList<ClassFilter> newFilters = new ArrayList<ClassFilter>(steppingFilters.length - occurrencesNum + 1);
        boolean firstOccurrenceFound = false;
        Iterator iterator2 = ArrayIteratorKt.iterator((Object[])steppingFilters);
        while (iterator2.hasNext()) {
            ClassFilter filter2 = (ClassFilter)iterator2.next();
            if (Intrinsics.areEqual((Object)filter2.getPattern(), (Object)pattern2)) {
                if (firstOccurrenceFound) continue;
                newFilters.add(filter2);
                firstOccurrenceFound = true;
                continue;
            }
            newFilters.add(filter2);
        }
        Collection $this$toTypedArray$iv = newFilters;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        debuggerSettings.setSteppingFilters(thisCollection$iv.toArray(new ClassFilter[0]));
    }

    public static final /* synthetic */ void access$addSteppingFilterIfNeeded(DebuggerSettings debuggerSettings, String pattern2) {
        JvmDebuggerAddFilterStartupActivityKt.addSteppingFilterIfNeeded(debuggerSettings, pattern2);
    }
}

