/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.debugger.core.stepping;

import com.intellij.debugger.engine.LightOrRealThreadInfo;
import com.intellij.debugger.engine.MethodFilter;
import com.intellij.debugger.engine.RequestHint;
import com.intellij.debugger.engine.SuspendContextImpl;
import com.intellij.debugger.jdi.ThreadReferenceProxyImpl;
import com.intellij.openapi.diagnostic.Logger;
import com.sun.jdi.Location;
import com.sun.jdi.Method;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.debugger.base.util.SafeUtilKt;
import org.jetbrains.kotlin.idea.debugger.core.DebuggerUtil;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u0001BE\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\t\u0012\b\u0010\u000b\u001a\u0004\u0018\u00010\f\u0012\b\u0010\r\u001a\u0004\u0018\u00010\u0001\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u0010\u0010\u0010\u001a\u00020\t2\u0006\u0010\u0011\u001a\u00020\u0007H\u0016R\u0010\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/core/stepping/KotlinStepOutRequestHint;", "Lcom/intellij/debugger/engine/RequestHint;", "returnAfterSuspendLocation", "Lcom/sun/jdi/Location;", "stepThread", "Lcom/intellij/debugger/jdi/ThreadReferenceProxyImpl;", "suspendContext", "Lcom/intellij/debugger/engine/SuspendContextImpl;", "stepSize", "", "depth", "filter", "Lcom/intellij/debugger/engine/MethodFilter;", "parentHint", "<init>", "(Lcom/sun/jdi/Location;Lcom/intellij/debugger/jdi/ThreadReferenceProxyImpl;Lcom/intellij/debugger/engine/SuspendContextImpl;IILcom/intellij/debugger/engine/MethodFilter;Lcom/intellij/debugger/engine/RequestHint;)V", "getNextStepDepth", "context", "kotlin.jvm-debugger.core"})
@SourceDebugExtension(value={"SMAP\nKotlinRequestHint.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KotlinRequestHint.kt\norg/jetbrains/kotlin/idea/debugger/core/stepping/KotlinStepOutRequestHint\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,285:1\n24#2:286\n24#2:287\n*S KotlinDebug\n*F\n+ 1 KotlinRequestHint.kt\norg/jetbrains/kotlin/idea/debugger/core/stepping/KotlinStepOutRequestHint\n*L\n91#1:286\n94#1:287\n*E\n"})
public final class KotlinStepOutRequestHint
extends RequestHint {
    @Nullable
    private final Location returnAfterSuspendLocation;

    public KotlinStepOutRequestHint(@Nullable Location returnAfterSuspendLocation, @NotNull ThreadReferenceProxyImpl stepThread, @NotNull SuspendContextImpl suspendContext, int stepSize, int depth, @Nullable MethodFilter filter2, @Nullable RequestHint parentHint) {
        Intrinsics.checkNotNullParameter((Object)stepThread, (String)"stepThread");
        Intrinsics.checkNotNullParameter((Object)suspendContext, (String)"suspendContext");
        super(stepThread, suspendContext, stepSize, depth, filter2, parentHint);
        this.returnAfterSuspendLocation = returnAfterSuspendLocation;
    }

    public int getNextStepDepth(@NotNull SuspendContextImpl context2) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Location currentLocation = context2.getLocation();
        if (currentLocation != null && this.returnAfterSuspendLocation != null) {
            Method currentMethod = SafeUtilKt.safeMethod(currentLocation);
            if (currentMethod != null && !Intrinsics.areEqual((Object)currentMethod, (Object)SafeUtilKt.safeMethod(this.returnAfterSuspendLocation))) {
                if (DebuggerUtil.isInSuspendMethod(currentLocation) && SafeUtilKt.safeLineNumber(currentLocation) < 0) {
                    return 2;
                }
                return super.getNextStepDepth(context2);
            }
            LightOrRealThreadInfo filterThread = context2.getDebugProcess().getRequestsManager().getFilterThread();
            KotlinStepOutRequestHint $this$thisLogger$iv = this;
            boolean $i$f$thisLogger = false;
            Logger logger = Logger.getInstance(KotlinStepOutRequestHint.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            Method method = currentLocation.method();
            logger.debug("KotlinStepOutRequestHint: stepping to the suspend RETURN in method " + (method != null ? method.name() : null) + ", filterThread = " + filterThread + ", resumeLocationIndex = " + this.returnAfterSuspendLocation + ", currentIndex = " + currentLocation.codeIndex());
            if (currentLocation.codeIndex() < this.returnAfterSuspendLocation.codeIndex()) {
                return 2;
            }
            if (currentLocation.codeIndex() == this.returnAfterSuspendLocation.codeIndex()) {
                $this$thisLogger$iv = this;
                $i$f$thisLogger = false;
                Logger logger2 = Logger.getInstance(KotlinStepOutRequestHint.class);
                Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"getInstance(...)");
                logger2.debug("KotlinStepOutRequestHint: reached suspend RETURN, currentIndex = " + currentLocation.codeIndex() + " -> RESUME");
                return -100;
            }
        }
        return super.getNextStepDepth(context2);
    }
}

