/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.debugger.coroutine.command;

import com.intellij.debugger.DebuggerManagerEx;
import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.SuspendContextImpl;
import com.intellij.debugger.engine.events.DebuggerCommandImpl;
import com.intellij.debugger.engine.events.SuspendContextCommandImpl;
import com.intellij.debugger.impl.DebuggerContextImpl;
import com.intellij.debugger.impl.DebuggerSession;
import com.intellij.execution.filters.ExceptionFilters;
import com.intellij.execution.filters.TextConsoleBuilder;
import com.intellij.execution.filters.TextConsoleBuilderFactory;
import com.intellij.execution.ui.ConsoleView;
import com.intellij.execution.ui.RunnerLayoutUi;
import com.intellij.execution.ui.layout.impl.RunnerContentUi;
import com.intellij.notification.NotificationGroup;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.util.Disposer;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.ui.content.Content;
import com.intellij.util.text.DateFormatUtil;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.impl.XDebuggerManagerImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.debugger.coroutine.KotlinDebuggerCoroutinesBundle;
import org.jetbrains.kotlin.idea.debugger.coroutine.command.CoroutineDumpAction;
import org.jetbrains.kotlin.idea.debugger.coroutine.data.CompleteCoroutineInfoData;
import org.jetbrains.kotlin.idea.debugger.coroutine.data.CoroutineInfoCache;
import org.jetbrains.kotlin.idea.debugger.coroutine.data.CoroutineInfoData;
import org.jetbrains.kotlin.idea.debugger.coroutine.data.CoroutineInfoDatasKt;
import org.jetbrains.kotlin.idea.debugger.coroutine.proxy.CoroutineDebugProbesProxy;
import org.jetbrains.kotlin.idea.debugger.coroutine.view.CoroutineDumpPanel;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J,\u0010\b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\n2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011J\b\u0010\u0012\u001a\u00020\u0013H\u0016J\u0010\u0010\u0014\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/coroutine/command/CoroutineDumpAction;", "Lcom/intellij/openapi/actionSystem/AnAction;", "<init>", "()V", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "addCoroutineDump", "project", "Lcom/intellij/openapi/project/Project;", "coroutines", "", "Lorg/jetbrains/kotlin/idea/debugger/coroutine/data/CompleteCoroutineInfoData;", "ui", "Lcom/intellij/execution/ui/RunnerLayoutUi;", "searchScope", "Lcom/intellij/psi/search/GlobalSearchScope;", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "update", "kotlin.jvm-debugger.coroutines"})
public final class CoroutineDumpAction
extends AnAction {
    public void actionPerformed(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Project project = e.getProject();
        if (project == null) {
            return;
        }
        Project project2 = project;
        DebuggerContextImpl debuggerContextImpl = DebuggerManagerEx.getInstanceEx((Project)project2).getContext();
        Intrinsics.checkNotNullExpressionValue((Object)debuggerContextImpl, (String)"getContext(...)");
        DebuggerContextImpl context2 = debuggerContextImpl;
        DebuggerSession session = context2.getDebuggerSession();
        if (session != null && session.isAttached()) {
            DebugProcessImpl debugProcessImpl = context2.getDebugProcess();
            if (debugProcessImpl == null) {
                return;
            }
            DebugProcessImpl process2 = debugProcessImpl;
            SuspendContextImpl suspendContextImpl = context2.getSuspendContext();
            process2.getManagerThread().schedule((DebuggerCommandImpl)new SuspendContextCommandImpl(project2, session, this, suspendContextImpl){
                final /* synthetic */ Project $project;
                final /* synthetic */ DebuggerSession $session;
                final /* synthetic */ CoroutineDumpAction this$0;
                {
                    this.$project = $project;
                    this.$session = $session;
                    this.this$0 = $receiver;
                    super($super_call_param$1);
                }

                /*
                 * WARNING - void declaration
                 */
                public void contextAction(SuspendContextImpl suspendContext) {
                    Intrinsics.checkNotNullParameter((Object)suspendContext, (String)"suspendContext");
                    CoroutineInfoCache states = new CoroutineDebugProbesProxy(suspendContext).dumpCoroutines();
                    if (states.isOk()) {
                        void $this$mapTo$iv$iv;
                        Iterable $this$map$iv = states.getCache();
                        boolean $i$f$map = false;
                        Iterable iterable = $this$map$iv;
                        Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                        boolean $i$f$mapTo = false;
                        for (T item$iv$iv : $this$mapTo$iv$iv) {
                            void it;
                            CoroutineInfoData coroutineInfoData = (CoroutineInfoData)item$iv$iv;
                            Collection collection = destination$iv$iv;
                            boolean bl = false;
                            collection.add(CoroutineInfoDatasKt.toCompleteCoroutineInfoData((CoroutineInfoData)it));
                        }
                        List coroutines = (List)destination$iv$iv;
                        Function0 f = () -> actionPerformed.1.contextAction$lambda$1(this.$session, this.this$0, this.$project, coroutines);
                        ApplicationManager.getApplication().invokeLater(() -> actionPerformed.1.contextAction$lambda$2(f), ModalityState.nonModal());
                    } else {
                        String message2 = KotlinDebuggerCoroutinesBundle.message("coroutine.dump.failed", new Object[0]);
                        NotificationGroup notificationGroup = XDebuggerManagerImpl.getNotificationGroup();
                        MessageType messageType = MessageType.ERROR;
                        Intrinsics.checkNotNullExpressionValue((Object)messageType, (String)"ERROR");
                        notificationGroup.createNotification(message2, messageType).notify(this.$project);
                    }
                }

                private static final Unit contextAction$lambda$1(DebuggerSession session, CoroutineDumpAction this$0, Project project, List<CompleteCoroutineInfoData> coroutines) {
                    XDebugSession xDebugSession = session.getXDebugSession();
                    if (xDebugSession == null || (xDebugSession = xDebugSession.getUI()) == null) {
                        return Unit.INSTANCE;
                    }
                    XDebugSession ui = xDebugSession;
                    GlobalSearchScope globalSearchScope = session.getSearchScope();
                    Intrinsics.checkNotNullExpressionValue((Object)globalSearchScope, (String)"getSearchScope(...)");
                    this$0.addCoroutineDump(project, coroutines, (RunnerLayoutUi)ui, globalSearchScope);
                    return Unit.INSTANCE;
                }

                private static final void contextAction$lambda$2(Function0 $tmp0) {
                    $tmp0.invoke();
                }
            });
        }
    }

    public final void addCoroutineDump(@NotNull Project project, @NotNull List<CompleteCoroutineInfoData> coroutines, @NotNull RunnerLayoutUi ui, @NotNull GlobalSearchScope searchScope) {
        Content content;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter(coroutines, (String)"coroutines");
        Intrinsics.checkNotNullParameter((Object)ui, (String)"ui");
        Intrinsics.checkNotNullParameter((Object)searchScope, (String)"searchScope");
        TextConsoleBuilder textConsoleBuilder = TextConsoleBuilderFactory.getInstance().createBuilder(project);
        Intrinsics.checkNotNullExpressionValue((Object)textConsoleBuilder, (String)"createBuilder(...)");
        TextConsoleBuilder consoleBuilder = textConsoleBuilder;
        consoleBuilder.filters(ExceptionFilters.getFilters((GlobalSearchScope)searchScope));
        ConsoleView consoleView = consoleBuilder.getConsole();
        Intrinsics.checkNotNullExpressionValue((Object)consoleView, (String)"getConsole(...)");
        ConsoleView consoleView2 = consoleView;
        DefaultActionGroup toolbarActions = new DefaultActionGroup();
        consoleView2.allowHeavyFilters();
        CoroutineDumpPanel panel = new CoroutineDumpPanel(project, consoleView2, toolbarActions, coroutines);
        String id = "DumpKt " + DateFormatUtil.formatTimeWithSeconds((long)System.currentTimeMillis());
        Content $this$addCoroutineDump_u24lambda_u240 = content = ui.createContent(id, (JComponent)panel, id, null, null);
        boolean bl = false;
        $this$addCoroutineDump_u24lambda_u240.putUserData(RunnerContentUi.LIGHTWEIGHT_CONTENT_MARKER, (Object)true);
        $this$addCoroutineDump_u24lambda_u240.setCloseable(true);
        $this$addCoroutineDump_u24lambda_u240.setDescription(KotlinDebuggerCoroutinesBundle.message("coroutine.dump.panel.title", new Object[0]));
        Content content2 = content;
        Intrinsics.checkNotNullExpressionValue((Object)content2, (String)"apply(...)");
        Content content3 = content2;
        ui.addContent(content3);
        ui.selectAndFocus(content3, true, true);
        Disposer.register((Disposable)((Disposable)content3), (Disposable)((Disposable)consoleView2));
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        return ActionUpdateThread.EDT;
    }

    public void update(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Presentation presentation = e.getPresentation();
        Intrinsics.checkNotNullExpressionValue((Object)presentation, (String)"getPresentation(...)");
        Presentation presentation2 = presentation;
        Project project = e.getProject();
        if (project == null) {
            CoroutineDumpAction $this$update_u24lambda_u241 = this;
            boolean bl = false;
            presentation2.setEnabledAndVisible(false);
            return;
        }
        Project project2 = project;
        if (DebuggerManagerEx.getInstanceEx((Project)project2).getContext().getSuspendContext() == null) {
            presentation2.setEnabled(false);
            return;
        }
        DebuggerSession debuggerSession = DebuggerManagerEx.getInstanceEx((Project)project2).getContext().getDebuggerSession();
        presentation2.setEnabled(debuggerSession != null && debuggerSession.isAttached());
        presentation2.setVisible(presentation2.isEnabled());
    }
}

