/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.debugger.coroutine.data;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.debugger.base.util.evaluate.DefaultExecutionContext;
import org.jetbrains.kotlin.idea.debugger.coroutine.data.CoroutineStackFrameItem;
import org.jetbrains.kotlin.idea.debugger.coroutine.data.CreationCoroutineStackFrameItem;
import org.jetbrains.kotlin.idea.debugger.coroutine.proxy.LocationCache;
import org.jetbrains.kotlin.idea.debugger.coroutine.proxy.mirror.DebugMetadata;
import org.jetbrains.kotlin.idea.debugger.coroutine.proxy.mirror.MirrorOfCoroutineInfo;
import org.jetbrains.kotlin.idea.debugger.coroutine.proxy.mirror.MirrorOfStackFrame;
import org.jetbrains.kotlin.idea.debugger.coroutine.proxy.mirror.MirrorOfStackTraceElement;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\r\u001a\u00020\u000eJ\u0014\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00100\u000b2\u0006\u0010\r\u001a\u00020\u000eR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/coroutine/data/CoroutineStackFramesProvider;", "", "executionContext", "Lorg/jetbrains/kotlin/idea/debugger/base/util/evaluate/DefaultExecutionContext;", "<init>", "(Lorg/jetbrains/kotlin/idea/debugger/base/util/evaluate/DefaultExecutionContext;)V", "locationCache", "Lorg/jetbrains/kotlin/idea/debugger/coroutine/proxy/LocationCache;", "debugMetadata", "Lorg/jetbrains/kotlin/idea/debugger/coroutine/proxy/mirror/DebugMetadata;", "getContinuationStack", "", "Lorg/jetbrains/kotlin/idea/debugger/coroutine/data/CoroutineStackFrameItem;", "mirror", "Lorg/jetbrains/kotlin/idea/debugger/coroutine/proxy/mirror/MirrorOfCoroutineInfo;", "getCreationStackTrace", "Lorg/jetbrains/kotlin/idea/debugger/coroutine/data/CreationCoroutineStackFrameItem;", "kotlin.jvm-debugger.coroutines"})
@SourceDebugExtension(value={"SMAP\nCoroutineStackFramesProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CoroutineStackFramesProvider.kt\norg/jetbrains/kotlin/idea/debugger/coroutine/data/CoroutineStackFramesProvider\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,25:1\n1611#2,9:26\n1863#2:35\n1864#2:37\n1620#2:38\n1567#2:39\n1598#2,4:40\n1#3:36\n*S KotlinDebug\n*F\n+ 1 CoroutineStackFramesProvider.kt\norg/jetbrains/kotlin/idea/debugger/coroutine/data/CoroutineStackFramesProvider\n*L\n15#1:26,9\n15#1:35\n15#1:37\n15#1:38\n21#1:39\n21#1:40,4\n15#1:36\n*E\n"})
public final class CoroutineStackFramesProvider {
    @NotNull
    private final DefaultExecutionContext executionContext;
    @NotNull
    private final LocationCache locationCache;
    @Nullable
    private final DebugMetadata debugMetadata;

    public CoroutineStackFramesProvider(@NotNull DefaultExecutionContext executionContext) {
        Intrinsics.checkNotNullParameter((Object)executionContext, (String)"executionContext");
        this.executionContext = executionContext;
        this.locationCache = new LocationCache(this.executionContext);
        this.debugMetadata = DebugMetadata.Companion.instance(this.executionContext);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<CoroutineStackFrameItem> getContinuationStack(@NotNull MirrorOfCoroutineInfo mirror) {
        void $this$mapNotNullTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)mirror, (String)"mirror");
        if (this.debugMetadata == null || mirror.getLastObservedFrame() == null) {
            return CollectionsKt.emptyList();
        }
        Iterable $this$mapNotNull$iv = this.debugMetadata.fetchContinuationStack(mirror.getLastObservedFrame(), this.executionContext);
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
        while (iterator2.hasNext()) {
            CoroutineStackFrameItem it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator2.next();
            boolean bl = false;
            MirrorOfStackFrame it = (MirrorOfStackFrame)element$iv$iv;
            boolean bl2 = false;
            if (it.toCoroutineStackFrameItem(this.executionContext, this.locationCache) == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<CreationCoroutineStackFrameItem> getCreationStackTrace(@NotNull MirrorOfCoroutineInfo mirror) {
        void $this$mapIndexedTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)mirror, (String)"mirror");
        Iterable $this$mapIndexed$iv = mirror.getCreationStackTraceProvider().getStackTrace();
        boolean $i$f$mapIndexed = false;
        Iterable iterable = $this$mapIndexed$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$mapIndexed$iv, (int)10));
        boolean $i$f$mapIndexedTo = false;
        int index$iv$iv = 0;
        for (Object item$iv$iv : $this$mapIndexedTo$iv$iv) {
            void index2;
            void frame;
            int n;
            if ((n = index$iv$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            MirrorOfStackTraceElement mirrorOfStackTraceElement = (MirrorOfStackTraceElement)item$iv$iv;
            int n2 = n;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(new CreationCoroutineStackFrameItem(this.locationCache.createLocation(frame.stackTraceElement()), index2 == false));
        }
        return (List)destination$iv$iv;
    }
}

