/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.debugger.evaluate;

import com.intellij.debugger.jdi.LocalVariableProxyImpl;
import com.intellij.debugger.jdi.StackFrameProxyImpl;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiNameHelper;
import com.intellij.psi.PsiType;
import com.intellij.psi.search.GlobalSearchScope;
import com.sun.jdi.AbsentInformationException;
import com.sun.jdi.ArrayReference;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.PrimitiveValue;
import com.sun.jdi.Value;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.debugger.base.util.SafeUtilKt;
import org.jetbrains.kotlin.idea.j2k.OldJ2KUtilsKt;
import org.jetbrains.kotlin.psi.KtNamedDeclaration;
import org.jetbrains.kotlin.psi.KtProperty;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0005\u0018\u0000 \u00132\u00020\u0001:\u0002\u0013\u0014B/\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\u0012\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u00050\u0007\u00a2\u0006\u0004\b\t\u0010\nR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0017\u0010\u0004\u001a\b\u0018\u00010\rR\u00020\u0000\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u001b\u0010\u0006\u001a\f\u0012\b\u0012\u00060\rR\u00020\u00000\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/evaluate/FrameInfo;", "", "project", "Lcom/intellij/openapi/project/Project;", "thisObject", "Lcom/sun/jdi/Value;", "variables", "", "Lcom/intellij/debugger/jdi/LocalVariableProxyImpl;", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/sun/jdi/Value;Ljava/util/Map;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "Lorg/jetbrains/kotlin/idea/debugger/evaluate/FrameInfo$Variable;", "getThisObject", "()Lorg/jetbrains/kotlin/idea/debugger/evaluate/FrameInfo$Variable;", "", "getVariables", "()Ljava/util/List;", "Companion", "Variable", "kotlin.jvm-debugger.evaluation.k1"})
@SourceDebugExtension(value={"SMAP\nFrameInfo.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FrameInfo.kt\norg/jetbrains/kotlin/idea/debugger/evaluate/FrameInfo\n+ 2 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,81:1\n126#2:82\n153#2,3:83\n*S KotlinDebug\n*F\n+ 1 FrameInfo.kt\norg/jetbrains/kotlin/idea/debugger/evaluate/FrameInfo\n*L\n28#1:82\n28#1:83,3\n*E\n"})
public final class FrameInfo {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @Nullable
    private final Variable thisObject;
    @NotNull
    private final List<Variable> variables;
    @NotNull
    private static final String FAKE_JAVA_THIS_NAME = "$this$_java_locals_debug_fun_";

    /*
     * WARNING - void declaration
     */
    private FrameInfo(Project project, Value thisObject, Map<LocalVariableProxyImpl, ? extends Value> variables) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Variable variable;
        this.project = project;
        FrameInfo frameInfo = this;
        FrameInfo frameInfo2 = this;
        boolean $i$a$-run-FrameInfo$thisObject$22 = false;
        if (thisObject == null) {
            variable = null;
        } else {
            void $this$thisObject_u24lambda_u240;
            String string = thisObject.type().name();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"name(...)");
            variable = (FrameInfo)$this$thisObject_u24lambda_u240.new Variable(FAKE_JAVA_THIS_NAME, string, thisObject);
        }
        frameInfo2.thisObject = variable;
        Map<LocalVariableProxyImpl, ? extends Value> map = variables;
        frameInfo2 = this;
        boolean $i$f$map = false;
        void $i$a$-run-FrameInfo$thisObject$22 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.size());
        boolean $i$f$mapTo = false;
        Iterator iterator2 = $this$mapTo$iv$iv.entrySet().iterator();
        while (iterator2.hasNext()) {
            Map.Entry item$iv$iv;
            Map.Entry entry = item$iv$iv = iterator2.next();
            Collection collection = destination$iv$iv;
            boolean bl = false;
            LocalVariableProxyImpl v = (LocalVariableProxyImpl)entry.getKey();
            Value value = (Value)entry.getValue();
            String string = v.name();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"name(...)");
            String string2 = v.typeName();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"typeName(...)");
            collection.add(new Variable(string, string2, value));
        }
        frameInfo2.variables = (List)destination$iv$iv;
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    @Nullable
    public final Variable getThisObject() {
        return this.thisObject;
    }

    @NotNull
    public final List<Variable> getVariables() {
        return this.variables;
    }

    public /* synthetic */ FrameInfo(Project project, Value thisObject, Map variables, DefaultConstructorMarker $constructor_marker) {
        this(project, thisObject, variables);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\b\u0010\n\u001a\u0004\u0018\u00010\u000bJ\u001c\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000f0\r2\u0006\u0010\n\u001a\u00020\u000bH\u0002J,\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0012\u001a\u00020\u00052\u0006\u0010\u0013\u001a\u00020\u00052\b\u0010\u0014\u001a\u0004\u0018\u00010\u000fH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/evaluate/FrameInfo$Companion;", "", "<init>", "()V", "FAKE_JAVA_THIS_NAME", "", "from", "Lorg/jetbrains/kotlin/idea/debugger/evaluate/FrameInfo;", "project", "Lcom/intellij/openapi/project/Project;", "frameProxy", "Lcom/intellij/debugger/jdi/StackFrameProxyImpl;", "collectVariableValues", "", "Lcom/intellij/debugger/jdi/LocalVariableProxyImpl;", "Lcom/sun/jdi/Value;", "createKotlinProperty", "Lorg/jetbrains/kotlin/psi/KtProperty;", "name", "typeName", "value", "kotlin.jvm-debugger.evaluation.k1"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final FrameInfo from(@NotNull Project project, @Nullable StackFrameProxyImpl frameProxy) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            if (frameProxy == null) {
                return new FrameInfo(project, null, MapsKt.emptyMap(), null);
            }
            Map<LocalVariableProxyImpl, Value> variableValues = this.collectVariableValues(frameProxy);
            ObjectReference objectReference = SafeUtilKt.safeThisObject(frameProxy);
            if (objectReference == null) {
                throw new AbsentInformationException();
            }
            ObjectReference thisObject = objectReference;
            return new FrameInfo(project, thisObject, variableValues, null);
        }

        private final Map<LocalVariableProxyImpl, Value> collectVariableValues(StackFrameProxyImpl frameProxy) {
            List<LocalVariableProxyImpl> variables = SafeUtilKt.safeVisibleVariables(frameProxy);
            HashMap values2 = new HashMap(variables.size());
            for (LocalVariableProxyImpl variable : variables) {
                Value value;
                if (frameProxy.getValue(variable) == null) continue;
                ((Map)values2).put(variable, value);
            }
            return values2;
        }

        private final KtProperty createKotlinProperty(Project project, String name2, String typeName, Value value) {
            KtProperty ktProperty;
            block0: {
                String className = StringsKt.substringBefore$default((String)StringsKt.replace$default((String)typeName, (String)"$", (String)".", (boolean)false, (int)4, null), (String)"[]", null, (int)2, null);
                PsiClassType psiClassType = PsiType.getTypeByName((String)className, (Project)project, (GlobalSearchScope)GlobalSearchScope.allScope((Project)project));
                Intrinsics.checkNotNullExpressionValue((Object)psiClassType, (String)"getTypeByName(...)");
                PsiClassType classType = psiClassType;
                String elementType = !(value instanceof PrimitiveValue) && classType.resolve() == null ? "java.lang.Object" : className;
                Object propertyType = value instanceof ArrayReference ? elementType + "[]" : elementType;
                PsiClassType psiClassType2 = PsiType.getTypeByName((String)propertyType, (Project)project, (GlobalSearchScope)GlobalSearchScope.allScope((Project)project));
                Intrinsics.checkNotNullExpressionValue((Object)psiClassType2, (String)"getTypeByName(...)");
                PsiClassType psiType = psiClassType2;
                PsiField psiField2 = PsiElementFactory.getInstance((Project)project).createField(name2, (PsiType)psiType);
                Intrinsics.checkNotNullExpressionValue((Object)psiField2, (String)"createField(...)");
                PsiField field2 = psiField2;
                KtNamedDeclaration ktNamedDeclaration = OldJ2KUtilsKt.j2k$default((PsiMember)field2, null, 1, null);
                ktProperty = ktNamedDeclaration instanceof KtProperty ? (KtProperty)ktNamedDeclaration : null;
                KtProperty ktProperty2 = ktProperty;
                if (ktProperty2 == null || (ktProperty2 = ktProperty2.getModifierList()) == null) break block0;
                ktProperty2.delete();
            }
            return ktProperty;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\b\u0086\u0004\u0018\u00002\u00020\u0001B!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\nR\u0013\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/evaluate/FrameInfo$Variable;", "", "name", "", "typeName", "value", "Lcom/sun/jdi/Value;", "<init>", "(Lorg/jetbrains/kotlin/idea/debugger/evaluate/FrameInfo;Ljava/lang/String;Ljava/lang/String;Lcom/sun/jdi/Value;)V", "getName", "()Ljava/lang/String;", "getTypeName", "getValue", "()Lcom/sun/jdi/Value;", "asProperty", "Lorg/jetbrains/kotlin/psi/KtProperty;", "kotlin.jvm-debugger.evaluation.k1"})
    public final class Variable {
        @NotNull
        private final String name;
        @NotNull
        private final String typeName;
        @Nullable
        private final Value value;

        public Variable(@NotNull String name2, @Nullable String typeName, Value value) {
            Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
            Intrinsics.checkNotNullParameter((Object)typeName, (String)"typeName");
            this.name = name2;
            this.typeName = typeName;
            this.value = value;
        }

        @NotNull
        public final String getName() {
            return this.name;
        }

        @NotNull
        public final String getTypeName() {
            return this.typeName;
        }

        @Nullable
        public final Value getValue() {
            return this.value;
        }

        @Nullable
        public final KtProperty asProperty() {
            if (!PsiNameHelper.getInstance((Project)FrameInfo.this.getProject()).isIdentifier(this.name)) {
                return null;
            }
            return Companion.createKotlinProperty(FrameInfo.this.getProject(), this.name, this.typeName, this.value);
        }
    }
}

