/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.gradle.statistics;

import com.intellij.internal.statistic.beans.MetricEvent;
import com.intellij.internal.statistic.eventLog.EventLogGroup;
import com.intellij.internal.statistic.eventLog.events.EventField;
import com.intellij.internal.statistic.eventLog.events.EventFields;
import com.intellij.internal.statistic.eventLog.events.EventId2;
import com.intellij.internal.statistic.service.fus.collectors.ProjectUsagesCollector;
import com.intellij.openapi.externalSystem.model.DataNode;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.openapi.roots.LibraryOrderEntry;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.OrderEntry;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.gradle.configuration.KotlinGradleProjectData;
import org.jetbrains.plugins.gradle.util.GradleUtil;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u0002\u001b\u001cB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0006\u001a\u00020\u0007H\u0014J\b\u0010\b\u001a\u00020\u0005H\u0016J\u0012\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0012\u001a\u00020\u000bH\u0007J\u0012\u0010\u0013\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u0016\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00180\n2\u0006\u0010\u0019\u001a\u00020\u001aH\u0014R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\f\u001a\u0012\u0012\u0006\u0012\u0004\u0018\u00010\u000b\u0012\u0006\u0012\u0004\u0018\u00010\u000b0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lorg/jetbrains/kotlin/idea/gradle/statistics/ComposeLibraryUsagesCollector;", "Lcom/intellij/internal/statistic/service/fus/collectors/ProjectUsagesCollector;", "<init>", "()V", "GROUP", "Lcom/intellij/internal/statistic/eventLog/EventLogGroup;", "requiresReadAccess", "", "getGroup", "librariesToScanFor", "", "", "USED_COMPOSE", "Lcom/intellij/internal/statistic/eventLog/events/EventId2;", "libraryRegex", "Lkotlin/text/Regex;", "extractLibraryDefinition", "Lorg/jetbrains/kotlin/idea/gradle/statistics/ComposeLibraryUsagesCollector$LibraryDefinition;", "name", "parseLibrary", "Lorg/jetbrains/kotlin/idea/gradle/statistics/ComposeLibraryUsagesCollector$ComposeLibrary;", "orderEntry", "Lcom/intellij/openapi/roots/LibraryOrderEntry;", "getMetrics", "Lcom/intellij/internal/statistic/beans/MetricEvent;", "project", "Lcom/intellij/openapi/project/Project;", "LibraryDefinition", "ComposeLibrary", "kotlin.gradle.gradle"})
@SourceDebugExtension(value={"SMAP\nComposeLibraryUsagesCollector.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ComposeLibraryUsagesCollector.kt\norg/jetbrains/kotlin/idea/gradle/statistics/ComposeLibraryUsagesCollector\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,101:1\n4135#2,11:102\n1619#3:113\n1863#3:114\n1864#3:116\n1620#3:117\n1628#3,3:118\n1#4:115\n*S KotlinDebug\n*F\n+ 1 ComposeLibraryUsagesCollector.kt\norg/jetbrains/kotlin/idea/gradle/statistics/ComposeLibraryUsagesCollector\n*L\n96#1:102,11\n97#1:113\n97#1:114\n97#1:116\n97#1:117\n99#1:118,3\n97#1:115\n*E\n"})
public final class ComposeLibraryUsagesCollector
extends ProjectUsagesCollector {
    @NotNull
    private final EventLogGroup GROUP = new EventLogGroup("kotlin.compose.libraries", 1, null, 4, null);
    @NotNull
    private final Set<String> librariesToScanFor;
    @NotNull
    private final EventId2<String, String> USED_COMPOSE;
    @NotNull
    private final Regex libraryRegex;

    public ComposeLibraryUsagesCollector() {
        Object[] objectArray = new String[]{"androidx.compose.ui:ui-android", "org.jetbrains.compose.ui:ui-desktop", "org.jetbrains.compose.ui:ui-android", "org.jetbrains.compose.ui:ui-wasm-js", "org.jetbrains.compose.ui:ui-uikitx64", "org.jetbrains.compose.ui:ui-uikitarm64", "org.jetbrains.compose.ui:ui-uikitsimarm64", "org.jetbrains.compose.ui:ui-js", "org.jetbrains.compose.ui:ui-macosx64", "org.jetbrains.compose.ui:ui-macosarm64", "org.jetbrains.compose.runtime:runtime-js"};
        this.librariesToScanFor = SetsKt.setOf((Object[])objectArray);
        this.USED_COMPOSE = EventLogGroup.registerEvent$default((EventLogGroup)this.GROUP, (String)"used.compose", (EventField)((EventField)EventFields.String((String)"library", (List)CollectionsKt.toList((Iterable)this.librariesToScanFor))), (EventField)((EventField)EventFields.Version), null, (int)8, null);
        this.libraryRegex = new Regex("(?:Gradle: )?([\\w-_.+]+):([\\w-_.+]+):([\\w-_.+]+)(?:@.*)?");
    }

    protected boolean requiresReadAccess() {
        return true;
    }

    @NotNull
    public EventLogGroup getGroup() {
        return this.GROUP;
    }

    @ApiStatus.Internal
    @Nullable
    public final LibraryDefinition extractLibraryDefinition(@NotNull String name2) {
        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
        MatchResult matchResult = this.libraryRegex.matchEntire((CharSequence)name2);
        if (matchResult == null) {
            return null;
        }
        MatchResult matchedLibrary = matchResult;
        String groupId = (String)matchedLibrary.getGroupValues().get(1);
        String artifactId = (String)matchedLibrary.getGroupValues().get(2);
        String version = (String)matchedLibrary.getGroupValues().get(3);
        return new LibraryDefinition(groupId, artifactId, version);
    }

    private final ComposeLibrary parseLibrary(LibraryOrderEntry orderEntry) {
        Object object = orderEntry.getLibrary();
        if (object == null || (object = object.getName()) == null) {
            return null;
        }
        Object name2 = object;
        LibraryDefinition libraryDefinition = this.extractLibraryDefinition((String)name2);
        if (libraryDefinition == null) {
            return null;
        }
        LibraryDefinition libraryDefinition2 = libraryDefinition;
        String artifactCoordinates = libraryDefinition2.getGroupId() + ":" + libraryDefinition2.getArtifactId();
        if (!this.librariesToScanFor.contains(artifactCoordinates)) {
            return null;
        }
        return new ComposeLibrary(artifactCoordinates, libraryDefinition2.getVersion());
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    protected Set<MetricEvent> getMetrics(@NotNull Project project) {
        void destination$iv;
        Object gradleProjectData;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Set allLibraries = new LinkedHashSet();
        for (Module module : ProjectUtil.getModules((Project)project)) {
            void $this$mapNotNullTo$iv;
            void $this$filterIsInstanceTo$iv$iv;
            DataNode gradleModuleData;
            ProgressManager.checkCanceled();
            if (GradleUtil.findGradleModuleData((Module)module) == null) continue;
            DataNode dataNode = ExternalSystemApiUtil.find((DataNode)gradleModuleData, KotlinGradleProjectData.Companion.getKEY());
            Object object = gradleProjectData = dataNode != null ? (KotlinGradleProjectData)dataNode.getData() : null;
            if (gradleProjectData == null || !((KotlinGradleProjectData)gradleProjectData).isHmpp() && !((KotlinGradleProjectData)gradleProjectData).getHasKotlinPlugin()) continue;
            ModuleRootManager moduleRoots = ModuleRootManager.getInstance((Module)module);
            OrderEntry[] orderEntryArray = moduleRoots.getOrderEntries();
            Intrinsics.checkNotNullExpressionValue((Object)orderEntryArray, (String)"getOrderEntries(...)");
            Object $this$filterIsInstance$iv = orderEntryArray;
            boolean $i$f$filterIsInstance = false;
            Object[] objectArray = $this$filterIsInstance$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterIsInstanceTo = false;
            for (void element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                if (!(element$iv$iv instanceof LibraryOrderEntry)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $this$filterIsInstance$iv = (List)destination$iv$iv;
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv = $this$mapNotNullTo$iv;
            boolean $i$f$forEach = false;
            Iterator iterator2 = $this$forEach$iv$iv.iterator();
            while (iterator2.hasNext()) {
                ComposeLibrary it$iv;
                Object element$iv$iv;
                Object element$iv = element$iv$iv = iterator2.next();
                boolean bl = false;
                LibraryOrderEntry p0 = (LibraryOrderEntry)element$iv;
                boolean $i$f$getMetrics$stub_for_inlining = false;
                boolean bl2 = false;
                if (this.parseLibrary(p0) == null) continue;
                boolean bl3 = false;
                ((Collection)allLibraries).add(it$iv);
            }
        }
        Iterable iterable = allLibraries;
        Collection collection = new LinkedHashSet();
        boolean $i$f$mapTo = false;
        for (Object item$iv : iterable) {
            void it;
            gradleProjectData = (ComposeLibrary)item$iv;
            void var23_31 = destination$iv;
            boolean bl = false;
            var23_31.add(this.USED_COMPOSE.metric((Object)it.getLibrary(), (Object)it.getVersion()));
        }
        return (Set)destination$iv;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0082\b\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\t\u0010\n\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\u001d\u0010\f\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0010\u001a\u00020\u0011H\u00d6\u0001J\t\u0010\u0012\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\b\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/kotlin/idea/gradle/statistics/ComposeLibraryUsagesCollector$ComposeLibrary;", "", "library", "", "version", "<init>", "(Ljava/lang/String;Ljava/lang/String;)V", "getLibrary", "()Ljava/lang/String;", "getVersion", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "kotlin.gradle.gradle"})
    private static final class ComposeLibrary {
        @NotNull
        private final String library;
        @NotNull
        private final String version;

        public ComposeLibrary(@NotNull String library, @NotNull String version) {
            Intrinsics.checkNotNullParameter((Object)library, (String)"library");
            Intrinsics.checkNotNullParameter((Object)version, (String)"version");
            this.library = library;
            this.version = version;
        }

        @NotNull
        public final String getLibrary() {
            return this.library;
        }

        @NotNull
        public final String getVersion() {
            return this.version;
        }

        @NotNull
        public final String component1() {
            return this.library;
        }

        @NotNull
        public final String component2() {
            return this.version;
        }

        @NotNull
        public final ComposeLibrary copy(@NotNull String library, @NotNull String version) {
            Intrinsics.checkNotNullParameter((Object)library, (String)"library");
            Intrinsics.checkNotNullParameter((Object)version, (String)"version");
            return new ComposeLibrary(library, version);
        }

        public static /* synthetic */ ComposeLibrary copy$default(ComposeLibrary composeLibrary, String string, String string2, int n, Object object) {
            if ((n & 1) != 0) {
                string = composeLibrary.library;
            }
            if ((n & 2) != 0) {
                string2 = composeLibrary.version;
            }
            return composeLibrary.copy(string, string2);
        }

        @NotNull
        public String toString() {
            return "ComposeLibrary(library=" + this.library + ", version=" + this.version + ")";
        }

        public int hashCode() {
            int result2 = this.library.hashCode();
            result2 = result2 * 31 + this.version.hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof ComposeLibrary)) {
                return false;
            }
            ComposeLibrary composeLibrary = (ComposeLibrary)other;
            if (!Intrinsics.areEqual((Object)this.library, (Object)composeLibrary.library)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.version, (Object)composeLibrary.version);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u000e\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0087\b\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0006\u0010\f\u001a\u00020\u0003J\t\u0010\r\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000e\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000f\u001a\u00020\u0003H\u00c6\u0003J'\u0010\u0010\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0014\u001a\u00020\u0015H\u00d6\u0001J\t\u0010\u0016\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\tR\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\t\u00a8\u0006\u0017"}, d2={"Lorg/jetbrains/kotlin/idea/gradle/statistics/ComposeLibraryUsagesCollector$LibraryDefinition;", "", "groupId", "", "artifactId", "version", "<init>", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", "getGroupId", "()Ljava/lang/String;", "getArtifactId", "getVersion", "toLibraryCoordinates", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "", "toString", "kotlin.gradle.gradle"})
    @ApiStatus.Internal
    public static final class LibraryDefinition {
        @NotNull
        private final String groupId;
        @NotNull
        private final String artifactId;
        @NotNull
        private final String version;

        public LibraryDefinition(@NotNull String groupId, @NotNull String artifactId, @NotNull String version) {
            Intrinsics.checkNotNullParameter((Object)groupId, (String)"groupId");
            Intrinsics.checkNotNullParameter((Object)artifactId, (String)"artifactId");
            Intrinsics.checkNotNullParameter((Object)version, (String)"version");
            this.groupId = groupId;
            this.artifactId = artifactId;
            this.version = version;
        }

        @NotNull
        public final String getGroupId() {
            return this.groupId;
        }

        @NotNull
        public final String getArtifactId() {
            return this.artifactId;
        }

        @NotNull
        public final String getVersion() {
            return this.version;
        }

        @NotNull
        public final String toLibraryCoordinates() {
            return this.groupId + ":" + this.artifactId;
        }

        @NotNull
        public final String component1() {
            return this.groupId;
        }

        @NotNull
        public final String component2() {
            return this.artifactId;
        }

        @NotNull
        public final String component3() {
            return this.version;
        }

        @NotNull
        public final LibraryDefinition copy(@NotNull String groupId, @NotNull String artifactId, @NotNull String version) {
            Intrinsics.checkNotNullParameter((Object)groupId, (String)"groupId");
            Intrinsics.checkNotNullParameter((Object)artifactId, (String)"artifactId");
            Intrinsics.checkNotNullParameter((Object)version, (String)"version");
            return new LibraryDefinition(groupId, artifactId, version);
        }

        public static /* synthetic */ LibraryDefinition copy$default(LibraryDefinition libraryDefinition, String string, String string2, String string3, int n, Object object) {
            if ((n & 1) != 0) {
                string = libraryDefinition.groupId;
            }
            if ((n & 2) != 0) {
                string2 = libraryDefinition.artifactId;
            }
            if ((n & 4) != 0) {
                string3 = libraryDefinition.version;
            }
            return libraryDefinition.copy(string, string2, string3);
        }

        @NotNull
        public String toString() {
            return "LibraryDefinition(groupId=" + this.groupId + ", artifactId=" + this.artifactId + ", version=" + this.version + ")";
        }

        public int hashCode() {
            int result2 = this.groupId.hashCode();
            result2 = result2 * 31 + this.artifactId.hashCode();
            result2 = result2 * 31 + this.version.hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof LibraryDefinition)) {
                return false;
            }
            LibraryDefinition libraryDefinition = (LibraryDefinition)other;
            if (!Intrinsics.areEqual((Object)this.groupId, (Object)libraryDefinition.groupId)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.artifactId, (Object)libraryDefinition.artifactId)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.version, (Object)libraryDefinition.version);
        }
    }
}

