/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.gradleJava.scripting.roots;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.gradle.scripting.settings.StandaloneScriptsStorage;
import org.jetbrains.kotlin.idea.gradleJava.scripting.roots.GradleBuildRoot;
import org.jetbrains.kotlin.idea.gradleJava.scripting.roots.StandaloneScriptsUpdater;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u000b\u0018\u00002\u00020\u0001:\u0001,B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0006\u0010\u0019\u001a\u00020\u001aJ\u0010\u0010\u001b\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u001c\u001a\u00020\u0010J\u0010\u0010\u001d\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u001e\u001a\u00020\u0010J\u0010\u0010\u001f\u001a\u0004\u0018\u00010\u00112\u0006\u0010 \u001a\u00020\u0010J\u000e\u0010!\u001a\u00020\"2\u0006\u0010\u001e\u001a\u00020\u0010J\u0010\u0010#\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u001e\u001a\u00020\u0010J\u0010\u0010$\u001a\u0004\u0018\u00010\u00112\u0006\u0010%\u001a\u00020\u0011J\u0010\u0010&\u001a\u0004\u0018\u00010\u00112\u0006\u0010'\u001a\u00020\u0010J\u0010\u0010(\u001a\u00020\u001a2\u0006\u0010\u001e\u001a\u00020\u0010H\u0016J\u0012\u0010)\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u001e\u001a\u00020\u0010H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001f\u0010\b\u001a\u00060\tR\u00020\u00008BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\f\u0010\r\u001a\u0004\b\n\u0010\u000bR\u001a\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u00110\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R*\u0010\u0012\u001a\u001e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u00110\u0013j\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u0011`\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00110\u00168F\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0018R\u001a\u0010*\u001a\b\u0012\u0004\u0012\u00020\u00100\u00168VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b+\u0010\u0018\u00a8\u0006-"}, d2={"Lorg/jetbrains/kotlin/idea/gradleJava/scripting/roots/GradleBuildRootIndex;", "Lorg/jetbrains/kotlin/idea/gradleJava/scripting/roots/StandaloneScriptsUpdater;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "log", "Lcom/intellij/openapi/diagnostic/Logger;", "standaloneScriptRoots", "Lorg/jetbrains/kotlin/idea/gradleJava/scripting/roots/GradleBuildRootIndex$StandaloneScriptRootsCache;", "getStandaloneScriptRoots", "()Lorg/jetbrains/kotlin/idea/gradleJava/scripting/roots/GradleBuildRootIndex$StandaloneScriptRootsCache;", "standaloneScriptRoots$delegate", "Lkotlin/Lazy;", "byWorkingDir", "Ljava/util/concurrent/ConcurrentHashMap;", "", "Lorg/jetbrains/kotlin/idea/gradleJava/scripting/roots/GradleBuildRoot;", "byProjectDir", "Ljava/util/HashMap;", "Lkotlin/collections/HashMap;", "list", "", "getList", "()Ljava/util/Collection;", "rebuildProjectRoots", "", "getBuildByRootDir", "dir", "findNearestRoot", "path", "getBuildByProjectDir", "projectDir", "isStandaloneScript", "", "getStandaloneScriptRoot", "add", "value", "remove", "prefix", "addStandaloneScript", "removeStandaloneScript", "standaloneScripts", "getStandaloneScripts", "StandaloneScriptRootsCache", "kotlin.gradle.gradle-java"})
@SourceDebugExtension(value={"SMAP\nGradleBuildRootIndex.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GradleBuildRootIndex.kt\norg/jetbrains/kotlin/idea/gradleJava/scripting/roots/GradleBuildRootIndex\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,111:1\n14#2:112\n1863#3:113\n1863#3,2:114\n1864#3:116\n1863#3,2:117\n1863#3,2:119\n*S KotlinDebug\n*F\n+ 1 GradleBuildRootIndex.kt\norg/jetbrains/kotlin/idea/gradleJava/scripting/roots/GradleBuildRootIndex\n*L\n11#1:112\n52#1:113\n53#1:114,2\n52#1:116\n58#1:117,2\n67#1:119,2\n*E\n"})
public final class GradleBuildRootIndex
implements StandaloneScriptsUpdater {
    @NotNull
    private final Project project;
    @NotNull
    private final Logger log;
    @NotNull
    private final Lazy standaloneScriptRoots$delegate;
    @NotNull
    private final ConcurrentHashMap<String, GradleBuildRoot> byWorkingDir;
    @NotNull
    private final HashMap<String, GradleBuildRoot> byProjectDir;

    public GradleBuildRootIndex(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(GradleBuildRootIndex.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        this.log = logger;
        this.standaloneScriptRoots$delegate = LazyKt.lazy(() -> GradleBuildRootIndex.standaloneScriptRoots_delegate$lambda$0(this));
        this.byWorkingDir = new ConcurrentHashMap();
        this.byProjectDir = new HashMap();
    }

    private final StandaloneScriptRootsCache getStandaloneScriptRoots() {
        Lazy lazy = this.standaloneScriptRoots$delegate;
        return (StandaloneScriptRootsCache)lazy.getValue();
    }

    @NotNull
    public final Collection<GradleBuildRoot> getList() {
        Collection<GradleBuildRoot> collection = this.byWorkingDir.values();
        Intrinsics.checkNotNullExpressionValue(collection, (String)"<get-values>(...)");
        return collection;
    }

    public final synchronized void rebuildProjectRoots() {
        this.byProjectDir.clear();
        Collection<GradleBuildRoot> collection = this.byWorkingDir.values();
        Intrinsics.checkNotNullExpressionValue(collection, (String)"<get-values>(...)");
        Iterable $this$forEach$iv = collection;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            GradleBuildRoot buildRoot = (GradleBuildRoot)element$iv;
            boolean bl = false;
            Iterable $this$forEach$iv2 = buildRoot.getProjectRoots();
            boolean $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                String it = (String)element$iv2;
                boolean bl2 = false;
                ((Map)this.byProjectDir).put(it, buildRoot);
            }
        }
        $this$forEach$iv = this.getStandaloneScriptRoots().all();
        StandaloneScriptRootsCache standaloneScriptRootsCache = this.getStandaloneScriptRoots();
        boolean $i$f$forEach3 = false;
        for (Object element$iv : $this$forEach$iv) {
            String p0 = (String)element$iv;
            boolean $i$f$rebuildProjectRoots$stub_for_inlining = false;
            boolean bl = false;
            standaloneScriptRootsCache.updateRootsCache(p0);
        }
    }

    @Nullable
    public final synchronized GradleBuildRoot getBuildByRootDir(@NotNull String dir) {
        Intrinsics.checkNotNullParameter((Object)dir, (String)"dir");
        return this.byWorkingDir.get(dir);
    }

    @Nullable
    public final synchronized GradleBuildRoot findNearestRoot(@NotNull String path2) {
        Intrinsics.checkNotNullParameter((Object)path2, (String)"path");
        Pair max = null;
        Set<Map.Entry<String, GradleBuildRoot>> set = this.byWorkingDir.entrySet();
        Intrinsics.checkNotNullExpressionValue(set, (String)"<get-entries>(...)");
        Iterable $this$forEach$iv = set;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Map.Entry it = (Map.Entry)element$iv;
            boolean bl = false;
            Object k = it.getKey();
            Intrinsics.checkNotNullExpressionValue(k, (String)"<get-key>(...)");
            if (!StringsKt.startsWith$default((String)path2, (String)((String)k), (boolean)false, (int)2, null) || max != null && ((String)it.getKey()).length() <= ((String)max.getFirst()).length()) continue;
            Object k2 = it.getKey();
            Intrinsics.checkNotNullExpressionValue(k2, (String)"<get-key>(...)");
            max = TuplesKt.to(k2, it.getValue());
        }
        Pair pair = max;
        return pair != null ? (GradleBuildRoot)pair.getSecond() : null;
    }

    @Nullable
    public final synchronized GradleBuildRoot getBuildByProjectDir(@NotNull String projectDir) {
        Intrinsics.checkNotNullParameter((Object)projectDir, (String)"projectDir");
        return this.byProjectDir.get(projectDir);
    }

    public final synchronized boolean isStandaloneScript(@NotNull String path2) {
        Intrinsics.checkNotNullParameter((Object)path2, (String)"path");
        return this.getStandaloneScriptRoots().all().contains(path2);
    }

    @Nullable
    public final synchronized GradleBuildRoot getStandaloneScriptRoot(@NotNull String path2) {
        Intrinsics.checkNotNullParameter((Object)path2, (String)"path");
        return this.getStandaloneScriptRoots().get(path2);
    }

    @Nullable
    public final synchronized GradleBuildRoot add(@NotNull GradleBuildRoot value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        String prefix2 = value.getPathPrefix();
        GradleBuildRoot old = this.byWorkingDir.put(prefix2, value);
        this.rebuildProjectRoots();
        this.log.info(prefix2 + ": " + old + " -> " + value);
        return old;
    }

    @Nullable
    public final synchronized GradleBuildRoot remove(@NotNull String prefix2) {
        GradleBuildRoot gradleBuildRoot;
        Intrinsics.checkNotNullParameter((Object)prefix2, (String)"prefix");
        GradleBuildRoot gradleBuildRoot2 = this.byWorkingDir.remove(prefix2);
        if (gradleBuildRoot2 != null) {
            GradleBuildRoot gradleBuildRoot3;
            GradleBuildRoot it = gradleBuildRoot3 = gradleBuildRoot2;
            boolean bl = false;
            this.rebuildProjectRoots();
            this.log.info(prefix2 + ": removed");
            gradleBuildRoot = gradleBuildRoot3;
        } else {
            gradleBuildRoot = null;
        }
        return gradleBuildRoot;
    }

    @Override
    public synchronized void addStandaloneScript(@NotNull String path2) {
        Intrinsics.checkNotNullParameter((Object)path2, (String)"path");
        this.getStandaloneScriptRoots().add(path2);
    }

    @Override
    @Nullable
    public synchronized GradleBuildRoot removeStandaloneScript(@NotNull String path2) {
        Intrinsics.checkNotNullParameter((Object)path2, (String)"path");
        return this.getStandaloneScriptRoots().remove(path2);
    }

    @Override
    @NotNull
    public synchronized Collection<String> getStandaloneScripts() {
        return this.getStandaloneScriptRoots().all();
    }

    private static final StandaloneScriptRootsCache standaloneScriptRoots_delegate$lambda$0(GradleBuildRootIndex this$0) {
        return this$0.new StandaloneScriptRootsCache();
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010#\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00060\rJ\u0010\u0010\u000e\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u000f\u001a\u00020\u0006J\u000e\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u000f\u001a\u00020\u0006J\u0010\u0010\u0012\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u000f\u001a\u00020\u0006J\u000e\u0010\u0013\u001a\u00020\u00112\u0006\u0010\u000f\u001a\u00020\u0006R\u001a\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00058BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u001c\u0010\t\u001a\u0010\u0012\u0004\u0012\u00020\u0006\u0012\u0006\u0012\u0004\u0018\u00010\u000b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/kotlin/idea/gradleJava/scripting/roots/GradleBuildRootIndex$StandaloneScriptRootsCache;", "", "<init>", "(Lorg/jetbrains/kotlin/idea/gradleJava/scripting/roots/GradleBuildRootIndex;)V", "standaloneScripts", "", "", "getStandaloneScripts", "()Ljava/util/Set;", "standaloneScriptRoots", "", "Lorg/jetbrains/kotlin/idea/gradleJava/scripting/roots/GradleBuildRoot;", "all", "", "get", "path", "add", "", "remove", "updateRootsCache", "kotlin.gradle.gradle-java"})
    @SourceDebugExtension(value={"SMAP\nGradleBuildRootIndex.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GradleBuildRootIndex.kt\norg/jetbrains/kotlin/idea/gradleJava/scripting/roots/GradleBuildRootIndex$StandaloneScriptRootsCache\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,111:1\n1863#2,2:112\n*S KotlinDebug\n*F\n+ 1 GradleBuildRootIndex.kt\norg/jetbrains/kotlin/idea/gradleJava/scripting/roots/GradleBuildRootIndex$StandaloneScriptRootsCache\n*L\n20#1:112,2\n*E\n"})
    private final class StandaloneScriptRootsCache {
        @NotNull
        private final Map<String, GradleBuildRoot> standaloneScriptRoots = new LinkedHashMap();

        public StandaloneScriptRootsCache() {
            Iterable $this$forEach$iv = this.getStandaloneScripts();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                String p0 = (String)element$iv;
                boolean $i$f$_init_$stub_for_inlining = false;
                boolean bl = false;
                this.updateRootsCache(p0);
            }
        }

        private final Set<String> getStandaloneScripts() {
            Object object = StandaloneScriptsStorage.Companion.getInstance(GradleBuildRootIndex.this.project);
            if (object == null || (object = ((StandaloneScriptsStorage)object).getFiles()) == null) {
                object = new HashSet();
            }
            return object;
        }

        @NotNull
        public final List<String> all() {
            return CollectionsKt.toList((Iterable)this.getStandaloneScripts());
        }

        @Nullable
        public final GradleBuildRoot get(@NotNull String path2) {
            Intrinsics.checkNotNullParameter((Object)path2, (String)"path");
            return this.standaloneScriptRoots.get(path2);
        }

        public final void add(@NotNull String path2) {
            Intrinsics.checkNotNullParameter((Object)path2, (String)"path");
            this.getStandaloneScripts().add(path2);
            this.updateRootsCache(path2);
        }

        @Nullable
        public final GradleBuildRoot remove(@NotNull String path2) {
            Intrinsics.checkNotNullParameter((Object)path2, (String)"path");
            this.getStandaloneScripts().remove(path2);
            return this.standaloneScriptRoots.remove(path2);
        }

        public final void updateRootsCache(@NotNull String path2) {
            Intrinsics.checkNotNullParameter((Object)path2, (String)"path");
            this.standaloneScriptRoots.put(path2, GradleBuildRootIndex.this.findNearestRoot(path2));
        }
    }
}

