/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.highlighter;

import com.intellij.codeInsight.daemon.impl.HighlightInfoType;
import com.intellij.codeInsight.daemon.impl.analysis.HighlightInfoHolder;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.NavigatablePsiElement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiTreeUtilKt;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.ConstructorDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.descriptors.TypeAliasDescriptor;
import org.jetbrains.kotlin.descriptors.TypeParameterDescriptor;
import org.jetbrains.kotlin.idea.highlighter.AfterAnalysisHighlightingVisitor;
import org.jetbrains.kotlin.idea.highlighter.KotlinHighlightInfoTypeSemanticNames;
import org.jetbrains.kotlin.idea.highlighter.visitor.AbstractHighlightingVisitor;
import org.jetbrains.kotlin.psi.KtAnnotationEntry;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtClass;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtDynamicType;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtElementImplStub;
import org.jetbrains.kotlin.psi.KtImportDirective;
import org.jetbrains.kotlin.psi.KtIntersectionType;
import org.jetbrains.kotlin.psi.KtObjectDeclaration;
import org.jetbrains.kotlin.psi.KtPackageDirective;
import org.jetbrains.kotlin.psi.KtSimpleNameExpression;
import org.jetbrains.kotlin.psi.KtSuperExpression;
import org.jetbrains.kotlin.psi.KtSuperTypeCallEntry;
import org.jetbrains.kotlin.psi.KtThisExpression;
import org.jetbrains.kotlin.psi.KtTypeAlias;
import org.jetbrains.kotlin.psi.KtTypeReference;
import org.jetbrains.kotlin.psi.KtValueArgumentList;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.calls.util.CallUtilKt;
import org.jetbrains.kotlin.resolve.calls.util.FakeCallableDescriptorForObject;
import org.jetbrains.kotlin.util.DescriptorUtilsKt;
import org.jetbrains.kotlin.util.slicedMap.ReadOnlySlice;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0012\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u0012\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u0018\u0010\u0010\u001a\u00020\u00112\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0012\u001a\u00020\u000fH\u0002J\u0010\u0010\u0013\u001a\u00020\t2\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u0010\u0010\u0016\u001a\u00020\t2\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J\u0010\u0010\u0019\u001a\u00020\t2\u0006\u0010\u0017\u001a\u00020\u001aH\u0016J\u0010\u0010\u001b\u001a\u00020\r2\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J\u0010\u0010\u001e\u001a\u00020\r2\u0006\u0010\u001c\u001a\u00020\u001fH\u0002J\u0012\u0010 \u001a\u0004\u0018\u00010\r2\u0006\u0010\u001c\u001a\u00020\u000fH\u0002\u00a8\u0006!"}, d2={"Lorg/jetbrains/kotlin/idea/highlighter/TypeKindHighlightingVisitor;", "Lorg/jetbrains/kotlin/idea/highlighter/AfterAnalysisHighlightingVisitor;", "holder", "Lcom/intellij/codeInsight/daemon/impl/analysis/HighlightInfoHolder;", "bindingContext", "Lorg/jetbrains/kotlin/resolve/BindingContext;", "<init>", "(Lcom/intellij/codeInsight/daemon/impl/analysis/HighlightInfoHolder;Lorg/jetbrains/kotlin/resolve/BindingContext;)V", "visitSimpleNameExpression", "", "expression", "Lorg/jetbrains/kotlin/psi/KtSimpleNameExpression;", "attributeKeyForObjectAccess", "Lcom/intellij/codeInsight/daemon/impl/HighlightInfoType;", "computeReferencedDescriptor", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "computeHighlightingRangeForUsage", "Lcom/intellij/openapi/util/TextRange;", "referenceTarget", "visitClassOrObject", "classOrObject", "Lorg/jetbrains/kotlin/psi/KtClassOrObject;", "visitDynamicType", "type", "Lorg/jetbrains/kotlin/psi/KtDynamicType;", "visitIntersectionType", "Lorg/jetbrains/kotlin/psi/KtIntersectionType;", "calculateClassReferenceAttributes", "target", "Lorg/jetbrains/kotlin/descriptors/ClassDescriptor;", "calculateTypeAliasReferenceAttributes", "Lorg/jetbrains/kotlin/descriptors/TypeAliasDescriptor;", "calculateDeclarationReferenceAttributes", "kotlin.highlighting.k1"})
@SourceDebugExtension(value={"SMAP\nTypeKindHighlightingVisitor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TypeKindHighlightingVisitor.kt\norg/jetbrains/kotlin/idea/highlighter/TypeKindHighlightingVisitor\n+ 2 addToStdlib.kt\norg/jetbrains/kotlin/utils/addToStdlib/AddToStdlibKt\n+ 3 psiUtils.kt\norg/jetbrains/kotlin/psi/psiUtil/PsiUtilsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,130:1\n119#2:131\n119#2:136\n202#3:132\n133#3:133\n202#3:134\n133#3:135\n1#4:137\n*S KotlinDebug\n*F\n+ 1 TypeKindHighlightingVisitor.kt\norg/jetbrains/kotlin/idea/highlighter/TypeKindHighlightingVisitor\n*L\n32#1:131\n101#1:136\n55#1:132\n55#1:133\n56#1:134\n56#1:135\n*E\n"})
public final class TypeKindHighlightingVisitor
extends AfterAnalysisHighlightingVisitor {
    public TypeKindHighlightingVisitor(@NotNull HighlightInfoHolder holder, @NotNull BindingContext bindingContext) {
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        Intrinsics.checkNotNullParameter((Object)bindingContext, (String)"bindingContext");
        super(holder, bindingContext);
    }

    public void visitSimpleNameExpression(@NotNull KtSimpleNameExpression expression) {
        block13: {
            HighlightInfoType key;
            TextRange textRange;
            block12: {
                KtElementImplStub ktElementImplStub;
                KtIntersectionType ktIntersectionType;
                Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
                PsiElement parent = expression.getParent();
                if (parent instanceof KtSuperExpression || parent instanceof KtThisExpression) {
                    return;
                }
                PsiElement psiElement = parent;
                if (psiElement != null && (psiElement = psiElement.getParent()) != null && (psiElement = psiElement.getParent()) != null) {
                    PsiElement $this$safeAs$iv = psiElement;
                    boolean $i$f$safeAs = false;
                    PsiElement psiElement2 = $this$safeAs$iv;
                    if (!(psiElement2 instanceof KtIntersectionType)) {
                        psiElement2 = null;
                    }
                    ktIntersectionType = (KtIntersectionType)psiElement2;
                } else {
                    ktIntersectionType = null;
                }
                if (ktIntersectionType != null) {
                    return;
                }
                DeclarationDescriptor declarationDescriptor = this.computeReferencedDescriptor(expression);
                if (declarationDescriptor == null) {
                    return;
                }
                DeclarationDescriptor referenceTarget = declarationDescriptor;
                textRange = this.computeHighlightingRangeForUsage(expression, referenceTarget);
                HighlightInfoType highlightInfoType = this.attributeKeyForObjectAccess(expression);
                if (highlightInfoType == null && (highlightInfoType = this.calculateDeclarationReferenceAttributes(referenceTarget)) == null) {
                    return;
                }
                key = highlightInfoType;
                if (!Intrinsics.areEqual((Object)key, (Object)KotlinHighlightInfoTypeSemanticNames.INSTANCE.getANNOTATION())) break block12;
                PsiElement psiElement3 = parent;
                if (psiElement3 != null) {
                    KClass[] kClassArray = new KClass[]{Reflection.getOrCreateKotlinClass(KtImportDirective.class), Reflection.getOrCreateKotlinClass(KtPackageDirective.class), Reflection.getOrCreateKotlinClass(KtTypeAlias.class)};
                    ktElementImplStub = (KtElementImplStub)PsiTreeUtilKt.parentOfTypes$default((PsiElement)psiElement3, (KClass[])kClassArray, (boolean)false, (int)2, null);
                } else {
                    ktElementImplStub = null;
                }
                if (ktElementImplStub == null) break block13;
            }
            AbstractHighlightingVisitor abstractHighlightingVisitor = this;
            Project project = expression.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
            AbstractHighlightingVisitor.highlightName$default((AbstractHighlightingVisitor)abstractHighlightingVisitor, (Project)project, (TextRange)textRange, (HighlightInfoType)key, null, (int)8, null);
        }
    }

    private final HighlightInfoType attributeKeyForObjectAccess(KtSimpleNameExpression expression) {
        ResolvedCall resolvedCall;
        ResolvedCall resolvedCall2 = resolvedCall = CallUtilKt.getResolvedCall((KtElement)((KtElement)expression), (BindingContext)this.getBindingContext());
        return (resolvedCall2 != null ? resolvedCall2.getResultingDescriptor() : null) instanceof FakeCallableDescriptorForObject ? this.attributeKeyForCallFromExtensions(expression, (ResolvedCall<? extends CallableDescriptor>)resolvedCall) : null;
    }

    private final DeclarationDescriptor computeReferencedDescriptor(KtSimpleNameExpression expression) {
        NavigatablePsiElement callElement;
        boolean strict$iv;
        PsiElement $this$getParentOfTypeAndBranch$iv;
        DeclarationDescriptor referenceTarget = (DeclarationDescriptor)this.getBindingContext().get((ReadOnlySlice)BindingContext.REFERENCE_TARGET, (Object)expression);
        if (!(referenceTarget instanceof ConstructorDescriptor)) {
            return referenceTarget;
        }
        PsiElement psiElement = (PsiElement)expression;
        boolean bl = true;
        Function1 branch$iv = TypeKindHighlightingVisitor::computeReferencedDescriptor$lambda$0;
        boolean $i$f$getParentOfTypeAndBranch = false;
        PsiElement $this$getParentOfType$iv$iv = $this$getParentOfTypeAndBranch$iv;
        boolean $i$f$getParentOfType = false;
        PsiElement psiElement2 = PsiTreeUtil.getParentOfType((PsiElement)$this$getParentOfType$iv$iv, KtCallExpression.class, (boolean)strict$iv);
        KtCallExpression ktCallExpression = (KtCallExpression)(psiElement2 != null ? PsiUtilsKt.getIfChildIsInBranch((PsiElement)psiElement2, (PsiElement)$this$getParentOfTypeAndBranch$iv, (Function1)branch$iv) : null);
        if (ktCallExpression != null) {
            v2 = (NavigatablePsiElement)ktCallExpression;
        } else {
            $this$getParentOfTypeAndBranch$iv = (PsiElement)expression;
            strict$iv = true;
            branch$iv = TypeKindHighlightingVisitor::computeReferencedDescriptor$lambda$1;
            $i$f$getParentOfTypeAndBranch = false;
            $this$getParentOfType$iv$iv = $this$getParentOfTypeAndBranch$iv;
            $i$f$getParentOfType = false;
            PsiElement psiElement3 = PsiTreeUtil.getParentOfType((PsiElement)$this$getParentOfType$iv$iv, KtSuperTypeCallEntry.class, (boolean)strict$iv);
            v2 = callElement = (NavigatablePsiElement)(psiElement3 != null ? PsiUtilsKt.getIfChildIsInBranch((PsiElement)psiElement3, (PsiElement)$this$getParentOfTypeAndBranch$iv, (Function1)branch$iv) : null);
        }
        if (callElement != null) {
            return referenceTarget;
        }
        return (DeclarationDescriptor)((ConstructorDescriptor)referenceTarget).getContainingDeclaration();
    }

    private final TextRange computeHighlightingRangeForUsage(KtSimpleNameExpression expression, DeclarationDescriptor referenceTarget) {
        ClassDescriptor target;
        DeclarationDescriptor declarationDescriptor = DescriptorUtilsKt.unwrapIfTypeAlias(referenceTarget);
        ClassDescriptor classDescriptor = target = declarationDescriptor instanceof ClassDescriptor ? (ClassDescriptor)declarationDescriptor : null;
        if ((classDescriptor != null ? classDescriptor.getKind() : null) != ClassKind.ANNOTATION_CLASS) {
            TextRange textRange = expression.getTextRange();
            Intrinsics.checkNotNullExpressionValue((Object)textRange, (String)"getTextRange(...)");
            return textRange;
        }
        Class[] classArray = new Class[]{KtValueArgumentList.class};
        KtAnnotationEntry annotationEntry2 = (KtAnnotationEntry)PsiTreeUtil.getParentOfType((PsiElement)((PsiElement)expression), KtAnnotationEntry.class, (boolean)false, (Class[])classArray);
        KtAnnotationEntry ktAnnotationEntry = annotationEntry2;
        if (ktAnnotationEntry == null || (ktAnnotationEntry = ktAnnotationEntry.getAtSymbol()) == null) {
            TextRange textRange = expression.getTextRange();
            Intrinsics.checkNotNullExpressionValue((Object)textRange, (String)"getTextRange(...)");
            return textRange;
        }
        KtAnnotationEntry atSymbol = ktAnnotationEntry;
        return new TextRange(atSymbol.getTextRange().getStartOffset(), expression.getTextRange().getEndOffset());
    }

    public void visitClassOrObject(@NotNull KtClassOrObject classOrObject) {
        Intrinsics.checkNotNullParameter((Object)classOrObject, (String)"classOrObject");
        PsiElement identifier = classOrObject.getNameIdentifier();
        ClassDescriptor classDescriptor = (ClassDescriptor)this.getBindingContext().get((ReadOnlySlice)BindingContext.CLASS, (Object)classOrObject);
        if (identifier != null && classDescriptor != null && !(identifier.getParent() instanceof KtClass) && !(classOrObject instanceof KtObjectDeclaration)) {
            AbstractHighlightingVisitor abstractHighlightingVisitor = this;
            HighlightInfoType highlightInfoType = this.attributeKeyForDeclarationFromExtensions((PsiElement)classOrObject, (DeclarationDescriptor)classDescriptor);
            if (highlightInfoType == null) {
                highlightInfoType = this.calculateClassReferenceAttributes(classDescriptor);
            }
            AbstractHighlightingVisitor.highlightName$default((AbstractHighlightingVisitor)abstractHighlightingVisitor, (PsiElement)identifier, (HighlightInfoType)highlightInfoType, null, (int)4, null);
        }
        super.visitClassOrObject(classOrObject);
    }

    public void visitDynamicType(@NotNull KtDynamicType type2) {
        Intrinsics.checkNotNullParameter((Object)type2, (String)"type");
    }

    public void visitIntersectionType(@NotNull KtIntersectionType type2) {
        Intrinsics.checkNotNullParameter((Object)type2, (String)"type");
        PsiElement psiElement = type2.getParent();
        if (psiElement != null) {
            PsiElement $this$safeAs$iv = psiElement;
            boolean $i$f$safeAs = false;
            PsiElement psiElement2 = $this$safeAs$iv;
            if (!(psiElement2 instanceof KtTypeReference)) {
                psiElement2 = null;
            }
            if ((psiElement = (KtTypeReference)psiElement2) != null) {
                PsiElement $this$visitIntersectionType_u24lambda_u242 = psiElement;
                boolean bl = false;
                AbstractHighlightingVisitor.highlightName$default((AbstractHighlightingVisitor)this, (PsiElement)$this$visitIntersectionType_u24lambda_u242, (HighlightInfoType)KotlinHighlightInfoTypeSemanticNames.INSTANCE.getTYPE_PARAMETER(), null, (int)4, null);
            }
        }
        super.visitIntersectionType(type2);
    }

    private final HighlightInfoType calculateClassReferenceAttributes(ClassDescriptor target) {
        return switch (WhenMappings.$EnumSwitchMapping$0[target.getKind().ordinal()]) {
            case 1 -> KotlinHighlightInfoTypeSemanticNames.INSTANCE.getANNOTATION();
            case 2 -> KotlinHighlightInfoTypeSemanticNames.INSTANCE.getTRAIT();
            case 3 -> KotlinHighlightInfoTypeSemanticNames.INSTANCE.getOBJECT();
            case 4 -> KotlinHighlightInfoTypeSemanticNames.INSTANCE.getENUM();
            case 5 -> KotlinHighlightInfoTypeSemanticNames.INSTANCE.getENUM_ENTRY();
            default -> target.getModality() == Modality.ABSTRACT ? KotlinHighlightInfoTypeSemanticNames.INSTANCE.getABSTRACT_CLASS() : KotlinHighlightInfoTypeSemanticNames.INSTANCE.getCLASS();
        };
    }

    private final HighlightInfoType calculateTypeAliasReferenceAttributes(TypeAliasDescriptor target) {
        ClassifierDescriptor aliasedTarget = target.getExpandedType().getConstructor().getDeclarationDescriptor();
        return aliasedTarget instanceof ClassDescriptor && ((ClassDescriptor)aliasedTarget).getKind() == ClassKind.ANNOTATION_CLASS ? KotlinHighlightInfoTypeSemanticNames.INSTANCE.getANNOTATION() : KotlinHighlightInfoTypeSemanticNames.INSTANCE.getTYPE_ALIAS();
    }

    private final HighlightInfoType calculateDeclarationReferenceAttributes(DeclarationDescriptor target) {
        DeclarationDescriptor declarationDescriptor = target;
        return declarationDescriptor instanceof TypeParameterDescriptor ? KotlinHighlightInfoTypeSemanticNames.INSTANCE.getTYPE_PARAMETER() : (declarationDescriptor instanceof TypeAliasDescriptor ? this.calculateTypeAliasReferenceAttributes((TypeAliasDescriptor)target) : (declarationDescriptor instanceof ClassDescriptor ? this.calculateClassReferenceAttributes((ClassDescriptor)target) : null));
    }

    private static final PsiElement computeReferencedDescriptor$lambda$0(KtCallExpression $this$getParentOfTypeAndBranch) {
        Intrinsics.checkNotNullParameter((Object)$this$getParentOfTypeAndBranch, (String)"$this$getParentOfTypeAndBranch");
        return (PsiElement)$this$getParentOfTypeAndBranch.getCalleeExpression();
    }

    private static final PsiElement computeReferencedDescriptor$lambda$1(KtSuperTypeCallEntry $this$getParentOfTypeAndBranch) {
        Intrinsics.checkNotNullParameter((Object)$this$getParentOfTypeAndBranch, (String)"$this$getParentOfTypeAndBranch");
        return (PsiElement)$this$getParentOfTypeAndBranch.getCalleeExpression();
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[ClassKind.values().length];
            try {
                nArray[ClassKind.ANNOTATION_CLASS.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ClassKind.INTERFACE.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ClassKind.OBJECT.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ClassKind.ENUM_CLASS.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ClassKind.ENUM_ENTRY.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

