/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.inspections;

import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.idea.actions.generate.KotlinGenerateEqualsAndHashcodeAction;
import org.jetbrains.kotlin.idea.base.resources.KotlinBundle;
import org.jetbrains.kotlin.idea.caches.resolve.ExtendedResolutionApiKt;
import org.jetbrains.kotlin.idea.caches.resolve.ResolutionUtils;
import org.jetbrains.kotlin.idea.codeinsight.api.classic.inspections.AbstractKotlinInspection;
import org.jetbrains.kotlin.idea.codeinsight.utils.EditorUtilsKt;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtClass;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtFunction;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtPrimaryConstructor;
import org.jetbrains.kotlin.psi.VisitorWrappersKt;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.lazy.BodyResolveMode;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.util.OperatorNameConventions;
import org.jetbrains.kotlin.util.slicedMap.ReadOnlySlice;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\u000fB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J \u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0010\u0010\f\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\u000eH\u0002\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/kotlin/idea/inspections/ArrayInDataClassInspection;", "Lorg/jetbrains/kotlin/idea/codeinsight/api/classic/inspections/AbstractKotlinInspection;", "<init>", "()V", "buildVisitor", "Lcom/intellij/psi/PsiElementVisitor;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "isOnTheFly", "", "session", "Lcom/intellij/codeInspection/LocalInspectionToolSession;", "hasOverriddenEqualsAndHashCode", "klass", "Lorg/jetbrains/kotlin/psi/KtClass;", "GenerateEqualsAndHashcodeFix", "kotlin.idea"})
public final class ArrayInDataClassInspection
extends AbstractKotlinInspection {
    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly, @NotNull LocalInspectionToolSession session) {
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        return (PsiElementVisitor)VisitorWrappersKt.classVisitor(arg_0 -> ArrayInDataClassInspection.buildVisitor$lambda$0(this, holder, arg_0));
    }

    private final boolean hasOverriddenEqualsAndHashCode(KtClass klass) {
        boolean overriddenEquals = false;
        boolean overriddenHashCode = false;
        for (KtDeclaration declaration : klass.getDeclarations()) {
            if (!(declaration instanceof KtFunction) || !declaration.hasModifier(KtTokens.OVERRIDE_KEYWORD)) continue;
            if (Intrinsics.areEqual((Object)((KtFunction)declaration).getNameAsName(), (Object)OperatorNameConventions.EQUALS) && ((KtFunction)declaration).getValueParameters().size() == 1) {
                KotlinType type2;
                DeclarationDescriptor declarationDescriptor = ResolutionUtils.resolveToDescriptorIfAny$default(declaration, null, 1, null);
                Object object = declarationDescriptor instanceof FunctionDescriptor ? (FunctionDescriptor)declarationDescriptor : null;
                KotlinType kotlinType = object != null && (object = object.getValueParameters()) != null && (object = (ValueParameterDescriptor)CollectionsKt.singleOrNull((List)object)) != null ? object.getType() : (type2 = null);
                if (type2 != null && KotlinBuiltIns.isNullableAny(type2)) {
                    overriddenEquals = true;
                }
            }
            if (!Intrinsics.areEqual((Object)((KtFunction)declaration).getName(), (Object)"hashCode") || ((KtFunction)declaration).getValueParameters().size() != 0) continue;
            overriddenHashCode = true;
        }
        return overriddenEquals && overriddenHashCode;
    }

    private static final Unit buildVisitor$lambda$0(ArrayInDataClassInspection this$0, ProblemsHolder $holder, KtClass klass) {
        Intrinsics.checkNotNullParameter((Object)klass, (String)"klass");
        if (!klass.isData()) {
            return Unit.INSTANCE;
        }
        KtPrimaryConstructor ktPrimaryConstructor = klass.getPrimaryConstructor();
        if (ktPrimaryConstructor == null) {
            return Unit.INSTANCE;
        }
        KtPrimaryConstructor constructor = ktPrimaryConstructor;
        if (this$0.hasOverriddenEqualsAndHashCode(klass)) {
            return Unit.INSTANCE;
        }
        BindingContext context2 = ExtendedResolutionApiKt.safeAnalyzeNonSourceRootCode((KtElement)constructor, BodyResolveMode.PARTIAL);
        for (KtParameter parameter : constructor.getValueParameters()) {
            KotlinType type2;
            if (!parameter.hasValOrVar() || (KotlinType)context2.get((ReadOnlySlice)BindingContext.TYPE, (Object)parameter.getTypeReference()) == null || !KotlinBuiltIns.isArray((KotlinType)type2) && !KotlinBuiltIns.isPrimitiveArray((KotlinType)type2)) continue;
            LocalQuickFix[] localQuickFixArray = new LocalQuickFix[]{new GenerateEqualsAndHashcodeFix()};
            $holder.registerProblem((PsiElement)parameter, KotlinBundle.message((String)"array.property.in.data.class.it.s.recommended.to.override.equals.hashcode", (Object[])new Object[0]), ProblemHighlightType.GENERIC_ERROR_OR_WARNING, localQuickFixArray);
        }
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0016J\b\u0010\u0006\u001a\u00020\u0005H\u0016J\b\u0010\u0007\u001a\u00020\bH\u0016J\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/kotlin/idea/inspections/ArrayInDataClassInspection$GenerateEqualsAndHashcodeFix;", "Lcom/intellij/codeInspection/LocalQuickFix;", "<init>", "()V", "getName", "", "getFamilyName", "startInWriteAction", "", "applyFix", "", "project", "Lcom/intellij/openapi/project/Project;", "descriptor", "Lcom/intellij/codeInspection/ProblemDescriptor;", "kotlin.idea"})
    @SourceDebugExtension(value={"SMAP\nArrayInDataClassInspection.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ArrayInDataClassInspection.kt\norg/jetbrains/kotlin/idea/inspections/ArrayInDataClassInspection$GenerateEqualsAndHashcodeFix\n+ 2 psiUtils.kt\norg/jetbrains/kotlin/psi/psiUtil/PsiUtilsKt\n*L\n1#1,83:1\n154#2:84\n*S KotlinDebug\n*F\n+ 1 ArrayInDataClassInspection.kt\norg/jetbrains/kotlin/idea/inspections/ArrayInDataClassInspection$GenerateEqualsAndHashcodeFix\n*L\n77#1:84\n*E\n"})
    public static final class GenerateEqualsAndHashcodeFix
    implements LocalQuickFix {
        @NotNull
        public String getName() {
            return KotlinBundle.message((String)"generate.equals.and.hashcode.fix.text", (Object[])new Object[0]);
        }

        @NotNull
        public String getFamilyName() {
            return this.getName();
        }

        public boolean startInWriteAction() {
            return false;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor2) {
            block1: {
                Intrinsics.checkNotNullParameter((Object)project, (String)"project");
                Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor");
                if (!FileModificationService.getInstance().preparePsiElementForWrite(descriptor2.getPsiElement())) {
                    return;
                }
                PsiElement psiElement = descriptor2.getPsiElement();
                Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"getPsiElement(...)");
                PsiElement $this$getNonStrictParentOfType$iv = psiElement;
                boolean $i$f$getNonStrictParentOfType = false;
                KtClass ktClass = (KtClass)PsiTreeUtil.getParentOfType((PsiElement)$this$getNonStrictParentOfType$iv, KtClass.class, (boolean)false);
                if (ktClass == null) break block1;
                KtClass $this$applyFix_u24lambda_u240 = ktClass;
                boolean bl = false;
                KotlinGenerateEqualsAndHashcodeAction kotlinGenerateEqualsAndHashcodeAction = new KotlinGenerateEqualsAndHashcodeAction();
                PsiElement psiElement2 = descriptor2.getPsiElement();
                Intrinsics.checkNotNullExpressionValue((Object)psiElement2, (String)"getPsiElement(...)");
                kotlinGenerateEqualsAndHashcodeAction.doInvoke(project, EditorUtilsKt.findExistingEditor(psiElement2), (KtClassOrObject)$this$applyFix_u24lambda_u240);
            }
        }
    }
}

