/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.maven.inspections;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomFileElement;
import com.intellij.util.xml.highlighting.DomElementAnnotationHolder;
import com.intellij.util.xml.highlighting.DomElementsInspection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.maven.dom.model.MavenDomDependency;
import org.jetbrains.idea.maven.dom.model.MavenDomProjectModel;
import org.jetbrains.idea.maven.model.MavenArtifact;
import org.jetbrains.idea.maven.project.MavenProject;
import org.jetbrains.idea.maven.project.MavenProjectsManager;
import org.jetbrains.kotlin.idea.maven.KotlinMavenBundle;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0002\u000b\fB\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u001e\u0010\u0005\u001a\u00020\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016\u00a8\u0006\r"}, d2={"Lorg/jetbrains/kotlin/idea/maven/inspections/KotlinTestJUnitInspection;", "Lcom/intellij/util/xml/highlighting/DomElementsInspection;", "Lorg/jetbrains/idea/maven/dom/model/MavenDomProjectModel;", "<init>", "()V", "checkFileElement", "", "domFileElement", "Lcom/intellij/util/xml/DomFileElement;", "holder", "Lcom/intellij/util/xml/highlighting/DomElementAnnotationHolder;", "ReplaceToKotlinTest", "RemoveKotlinTest", "kotlin.maven"})
@SourceDebugExtension(value={"SMAP\nKotlinTestJUnitInspection.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KotlinTestJUnitInspection.kt\norg/jetbrains/kotlin/idea/maven/inspections/KotlinTestJUnitInspection\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,81:1\n1755#2,3:82\n774#2:85\n865#2,2:86\n774#2:88\n865#2,2:89\n1863#2,2:91\n1863#2,2:93\n*S KotlinDebug\n*F\n+ 1 KotlinTestJUnitInspection.kt\norg/jetbrains/kotlin/idea/maven/inspections/KotlinTestJUnitInspection\n*L\n25#1:82,3\n31#1:85\n31#1:86,2\n35#1:88\n35#1:89,2\n40#1:91,2\n49#1:93,2\n*E\n"})
public final class KotlinTestJUnitInspection
extends DomElementsInspection<MavenDomProjectModel> {
    public KotlinTestJUnitInspection() {
        super(MavenDomProjectModel.class, new Class[0]);
    }

    /*
     * WARNING - void declaration
     */
    public void checkFileElement(@NotNull DomFileElement<MavenDomProjectModel> domFileElement, @NotNull DomElementAnnotationHolder holder) {
        void $this$filterTo$iv$iv;
        void $this$filterTo$iv$iv2;
        boolean hasJunit;
        Object element$iv2;
        block13: {
            Intrinsics.checkNotNullParameter(domFileElement, (String)"domFileElement");
            Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
            Module module = domFileElement.getModule();
            if (module == null) {
                return;
            }
            Module module2 = module;
            MavenProjectsManager mavenProjectsManager = MavenProjectsManager.getInstance((Project)module2.getProject());
            if (mavenProjectsManager == null) {
                return;
            }
            MavenProjectsManager manager = mavenProjectsManager;
            MavenProject mavenProject = manager.findProject(module2);
            if (mavenProject == null) {
                return;
            }
            MavenProject mavenProject2 = mavenProject;
            Iterable $this$any$iv = mavenProject2.getDependencies();
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                v3 = false;
            } else {
                for (Object element$iv2 : $this$any$iv) {
                    MavenArtifact it = (MavenArtifact)element$iv2;
                    boolean bl = false;
                    if (!(Intrinsics.areEqual((Object)it.getGroupId(), (Object)"junit") && Intrinsics.areEqual((Object)it.getArtifactId(), (Object)"junit"))) continue;
                    v3 = true;
                    break block13;
                }
                v3 = hasJunit = false;
            }
        }
        if (!hasJunit) {
            return;
        }
        List list2 = ((MavenDomProjectModel)domFileElement.getRootElement()).getDependencies().getDependencies();
        Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"getDependencies(...)");
        Iterable $this$filter$iv = list2;
        boolean $i$f$filter = false;
        element$iv2 = $this$filter$iv;
        Iterable destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv2) {
            MavenDomDependency it = (MavenDomDependency)element$iv$iv;
            boolean bl = false;
            if (!(Intrinsics.areEqual((Object)it.getGroupId().getRawText(), (Object)"org.jetbrains.kotlin") && Intrinsics.areEqual((Object)it.getArtifactId().getRawText(), (Object)"kotlin-test-junit"))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List kotlinTestJunitDependency = (List)destination$iv$iv;
        List list3 = ((MavenDomProjectModel)domFileElement.getRootElement()).getDependencies().getDependencies();
        Intrinsics.checkNotNullExpressionValue((Object)list3, (String)"getDependencies(...)");
        Iterable $this$filter$iv2 = list3;
        boolean $i$f$filter2 = false;
        destination$iv$iv = $this$filter$iv2;
        Collection destination$iv$iv2 = new ArrayList();
        boolean $i$f$filterTo2 = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            MavenDomDependency it = (MavenDomDependency)element$iv$iv;
            boolean bl = false;
            if (!(Intrinsics.areEqual((Object)it.getGroupId().getRawText(), (Object)"org.jetbrains.kotlin") && Intrinsics.areEqual((Object)it.getArtifactId().getRawText(), (Object)"kotlin-test"))) continue;
            destination$iv$iv2.add(element$iv$iv);
        }
        List kotlinTestDependencies = (List)destination$iv$iv2;
        if (!((Collection)kotlinTestJunitDependency).isEmpty()) {
            $this$forEach$iv = kotlinTestDependencies;
            $i$f$forEach = false;
            for (Object element$iv3 : $this$forEach$iv) {
                MavenDomDependency it = (MavenDomDependency)element$iv3;
                boolean bl = false;
                DomElement domElement = (DomElement)it.getArtifactId();
                String string = KotlinMavenBundle.message("inspection.message.kotlin.test.junit.already.presented", new Object[0]);
                var15_25 = new LocalQuickFix[1];
                Intrinsics.checkNotNull((Object)it);
                var15_25[0] = new RemoveKotlinTest(it);
                holder.createProblem(domElement, HighlightSeverity.WEAK_WARNING, string, var15_25);
            }
        } else {
            $this$forEach$iv = kotlinTestDependencies;
            $i$f$forEach = false;
            for (Object element$iv3 : $this$forEach$iv) {
                MavenDomDependency it = (MavenDomDependency)element$iv3;
                boolean bl = false;
                DomElement domElement = (DomElement)it.getArtifactId();
                String string = KotlinMavenBundle.message("fix.kotlin.test.junit.is.recommended", new Object[0]);
                var15_25 = new LocalQuickFix[1];
                Intrinsics.checkNotNull((Object)it);
                var15_25[0] = new ReplaceToKotlinTest(it);
                holder.createProblem(domElement, HighlightSeverity.WEAK_WARNING, string, var15_25);
            }
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\b\u001a\u00020\tH\u0016J\b\u0010\n\u001a\u00020\tH\u0016J\u0018\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/kotlin/idea/maven/inspections/KotlinTestJUnitInspection$RemoveKotlinTest;", "Lcom/intellij/codeInspection/LocalQuickFix;", "dependency", "Lorg/jetbrains/idea/maven/dom/model/MavenDomDependency;", "<init>", "(Lorg/jetbrains/idea/maven/dom/model/MavenDomDependency;)V", "getDependency", "()Lorg/jetbrains/idea/maven/dom/model/MavenDomDependency;", "getName", "", "getFamilyName", "applyFix", "", "project", "Lcom/intellij/openapi/project/Project;", "descriptor", "Lcom/intellij/codeInspection/ProblemDescriptor;", "kotlin.maven"})
    private static final class RemoveKotlinTest
    implements LocalQuickFix {
        @NotNull
        private final MavenDomDependency dependency;

        public RemoveKotlinTest(@NotNull MavenDomDependency dependency) {
            Intrinsics.checkNotNullParameter((Object)dependency, (String)"dependency");
            this.dependency = dependency;
        }

        @NotNull
        public final MavenDomDependency getDependency() {
            return this.dependency;
        }

        @NotNull
        public String getName() {
            return KotlinMavenBundle.message("fix.remove.kotlin.test", new Object[0]);
        }

        @NotNull
        public String getFamilyName() {
            return this.getName();
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor2) {
            block0: {
                Intrinsics.checkNotNullParameter((Object)project, (String)"project");
                Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor");
                XmlTag xmlTag = this.dependency.getXmlTag();
                if (xmlTag == null) break block0;
                xmlTag.delete();
            }
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\b\u001a\u00020\tH\u0016J\b\u0010\n\u001a\u00020\tH\u0016J\u0018\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/kotlin/idea/maven/inspections/KotlinTestJUnitInspection$ReplaceToKotlinTest;", "Lcom/intellij/codeInspection/LocalQuickFix;", "dependency", "Lorg/jetbrains/idea/maven/dom/model/MavenDomDependency;", "<init>", "(Lorg/jetbrains/idea/maven/dom/model/MavenDomDependency;)V", "getDependency", "()Lorg/jetbrains/idea/maven/dom/model/MavenDomDependency;", "getName", "", "getFamilyName", "applyFix", "", "project", "Lcom/intellij/openapi/project/Project;", "descriptor", "Lcom/intellij/codeInspection/ProblemDescriptor;", "kotlin.maven"})
    private static final class ReplaceToKotlinTest
    implements LocalQuickFix {
        @NotNull
        private final MavenDomDependency dependency;

        public ReplaceToKotlinTest(@NotNull MavenDomDependency dependency) {
            Intrinsics.checkNotNullParameter((Object)dependency, (String)"dependency");
            this.dependency = dependency;
        }

        @NotNull
        public final MavenDomDependency getDependency() {
            return this.dependency;
        }

        @NotNull
        public String getName() {
            return KotlinMavenBundle.message("fix.replace.to.kotlin.test.name", new Object[0]);
        }

        @NotNull
        public String getFamilyName() {
            return this.getName();
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor2) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor");
            if (this.dependency.isValid()) {
                this.dependency.getArtifactId().setStringValue("kotlin-test-junit");
            }
        }
    }
}

