/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.quickfix;

import com.intellij.modcommand.ActionContext;
import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.modcommand.PsiUpdateModCommandAction;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.base.resources.KotlinBundle;
import org.jetbrains.kotlin.idea.quickfix.StarProjectionUtils;
import org.jetbrains.kotlin.psi.KtPsiFactory;
import org.jetbrains.kotlin.psi.KtTypeElement;
import org.jetbrains.kotlin.psi.KtUserType;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J!\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0003\u001a\u00020\u00022\u0006\u0010\f\u001a\u00020\rH\u0094\u0002J\b\u0010\u000e\u001a\u00020\u000fH\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/kotlin/idea/quickfix/AddStarProjectionsFix;", "Lcom/intellij/modcommand/PsiUpdateModCommandAction;", "Lorg/jetbrains/kotlin/psi/KtUserType;", "element", "argumentCount", "", "<init>", "(Lorg/jetbrains/kotlin/psi/KtUserType;I)V", "invoke", "", "actionContext", "Lcom/intellij/modcommand/ActionContext;", "updater", "Lcom/intellij/modcommand/ModPsiUpdater;", "getFamilyName", "", "kotlin.fir.frontend-independent"})
@SourceDebugExtension(value={"SMAP\nAddStarProjectionsFix.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AddStarProjectionsFix.kt\norg/jetbrains/kotlin/idea/quickfix/AddStarProjectionsFix\n+ 2 coreLib.kt\norg/jetbrains/kotlin/utils/CoreLibKt\n*L\n1#1,35:1\n19#2:36\n*S KotlinDebug\n*F\n+ 1 AddStarProjectionsFix.kt\norg/jetbrains/kotlin/idea/quickfix/AddStarProjectionsFix\n*L\n25#1:36\n*E\n"})
public final class AddStarProjectionsFix
extends PsiUpdateModCommandAction<KtUserType> {
    private final int argumentCount;

    public AddStarProjectionsFix(@NotNull KtUserType element, int argumentCount) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        super((PsiElement)element);
        this.argumentCount = argumentCount;
    }

    protected void invoke(@NotNull ActionContext actionContext, @NotNull KtUserType element, @NotNull ModPsiUpdater updater2) {
        Intrinsics.checkNotNullParameter((Object)actionContext, (String)"actionContext");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)updater2, (String)"updater");
        boolean bl = element.getTypeArguments().isEmpty();
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw new AssertionError((Object)string);
        }
        String string = element.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        String typeString = StarProjectionUtils.INSTANCE.getTypeNameAndStarProjectionsString(string, this.argumentCount);
        Project project = actionContext.project();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"project(...)");
        KtPsiFactory psiFactory = new KtPsiFactory(project, false, 2, null);
        KtTypeElement $this$sure$iv = psiFactory.createType(typeString).getTypeElement();
        boolean $i$f$sure = false;
        KtTypeElement ktTypeElement = $this$sure$iv;
        if (ktTypeElement == null) {
            boolean bl2 = false;
            String string2 = "No type element after parsing " + typeString;
            throw new AssertionError((Object)string2);
        }
        KtTypeElement replacement = ktTypeElement;
        element.replace((PsiElement)replacement);
    }

    @NotNull
    public String getFamilyName() {
        Object[] objectArray = new Object[]{StarProjectionUtils.INSTANCE.getTypeNameAndStarProjectionsString("", this.argumentCount)};
        return KotlinBundle.message((String)"fix.add.star.projection.text", (Object[])objectArray);
    }
}

