/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.quickfix;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.codeStyle.CodeStyleManager;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.base.resources.KotlinBundle;
import org.jetbrains.kotlin.idea.codeinsight.api.classic.quickfixes.KotlinQuickFixAction;
import org.jetbrains.kotlin.idea.intentions.AddJvmStaticIntention;
import org.jetbrains.kotlin.idea.intentions.MoveMemberToCompanionObjectIntention;
import org.jetbrains.kotlin.idea.util.ModifierListModifactorKt;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.psi.KtClass;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtModifierListOwner;
import org.jetbrains.kotlin.psi.KtNamedDeclaration;
import org.jetbrains.kotlin.psi.psiUtil.KtPsiUtilKt;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\u0018\u0000 \u00112\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u0011B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J#\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\b\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\f\u001a\u00020\rH\u0094\u0002J\b\u0010\u000e\u001a\u00020\u000fH\u0016J\b\u0010\u0010\u001a\u00020\u000fH\u0016\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/kotlin/idea/quickfix/MakeMemberStaticFix;", "Lorg/jetbrains/kotlin/idea/codeinsight/api/classic/quickfixes/KotlinQuickFixAction;", "Lorg/jetbrains/kotlin/psi/KtNamedDeclaration;", "declaration", "<init>", "(Lorg/jetbrains/kotlin/psi/KtNamedDeclaration;)V", "invoke", "", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "file", "Lorg/jetbrains/kotlin/psi/KtFile;", "getText", "", "getFamilyName", "Companion", "kotlin.idea"})
public final class MakeMemberStaticFix
extends KotlinQuickFixAction<KtNamedDeclaration> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final FqName JVM_STATIC_FQ_NAME = new FqName("kotlin.jvm.JvmStatic");

    public MakeMemberStaticFix(@NotNull KtNamedDeclaration declaration) {
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        super((PsiElement)declaration);
    }

    @Override
    protected void invoke(@NotNull Project project, @Nullable Editor editor, @NotNull KtFile file) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        KtNamedDeclaration ktNamedDeclaration = (KtNamedDeclaration)this.getElement();
        if (ktNamedDeclaration == null) {
            return;
        }
        KtNamedDeclaration declaration = ktNamedDeclaration;
        if (declaration instanceof KtClass) {
            if (((KtClass)declaration).hasModifier(KtTokens.INNER_KEYWORD)) {
                ((KtClass)declaration).removeModifier(KtTokens.INNER_KEYWORD);
            }
        } else {
            KtClassOrObject ktClassOrObject = KtPsiUtilKt.getContainingClassOrObject((KtDeclaration)((KtDeclaration)declaration));
            if (ktClassOrObject == null) {
                return;
            }
            KtClassOrObject containingClass = ktClassOrObject;
            if (containingClass instanceof KtClass) {
                MoveMemberToCompanionObjectIntention moveMemberToCompanionObjectIntention = new MoveMemberToCompanionObjectIntention();
                declaration = moveMemberToCompanionObjectIntention.doMove((ProgressIndicator)new EmptyProgressIndicator(), declaration, CollectionsKt.emptyList(), CollectionsKt.emptyList(), editor);
            }
        }
        if (new AddJvmStaticIntention().applicabilityRange(declaration) != null) {
            ModifierListModifactorKt.addAnnotation$default((KtModifierListOwner)declaration, JVM_STATIC_FQ_NAME, null, null, null, 14, null);
            CodeStyleManager.getInstance((Project)project).reformat((PsiElement)declaration, true);
        }
    }

    @NotNull
    public String getText() {
        Object[] objectArray = new Object[1];
        Object object = (KtNamedDeclaration)this.getElement();
        if (object == null || (object = object.getName()) == null) {
            object = "";
        }
        objectArray[0] = object;
        return KotlinBundle.message((String)"make.member.static.quickfix", (Object[])objectArray);
    }

    @NotNull
    public String getFamilyName() {
        return this.getText();
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lorg/jetbrains/kotlin/idea/quickfix/MakeMemberStaticFix$Companion;", "", "<init>", "()V", "JVM_STATIC_FQ_NAME", "Lorg/jetbrains/kotlin/name/FqName;", "kotlin.idea"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

