/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.quickfix;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.base.resources.KotlinBundle;
import org.jetbrains.kotlin.idea.codeinsight.api.classic.quickfixes.KotlinPsiOnlyQuickFixAction;
import org.jetbrains.kotlin.idea.quickfix.ReplaceCallFixKt;
import org.jetbrains.kotlin.psi.CreateByPatternKt;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtPsiFactory;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\b\u001a\u00020\tH\u0016J\b\u0010\n\u001a\u00020\tH\u0016J#\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0094\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/kotlin/idea/quickfix/ReplaceImplicitReceiverCallFix;", "Lorg/jetbrains/kotlin/idea/codeinsight/api/classic/quickfixes/KotlinPsiOnlyQuickFixAction;", "Lorg/jetbrains/kotlin/psi/KtExpression;", "expression", "notNullNeeded", "", "<init>", "(Lorg/jetbrains/kotlin/psi/KtExpression;Z)V", "getFamilyName", "", "getText", "invoke", "", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "file", "Lorg/jetbrains/kotlin/psi/KtFile;", "kotlin.fir.frontend-independent"})
public final class ReplaceImplicitReceiverCallFix
extends KotlinPsiOnlyQuickFixAction<KtExpression> {
    private final boolean notNullNeeded;

    public ReplaceImplicitReceiverCallFix(@NotNull KtExpression expression, boolean notNullNeeded) {
        Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
        super((PsiElement)expression);
        this.notNullNeeded = notNullNeeded;
    }

    @NotNull
    public String getFamilyName() {
        return this.getText();
    }

    @NotNull
    public String getText() {
        return KotlinBundle.message((String)"replace.with.safe.this.call", (Object[])new Object[0]);
    }

    @Override
    protected void invoke(@NotNull Project project, @Nullable Editor editor, @NotNull KtFile file) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        KtExpression ktExpression = (KtExpression)this.getElement();
        if (ktExpression == null) {
            return;
        }
        KtExpression element = ktExpression;
        String elvis = ReplaceCallFixKt.elvisOrEmpty(element, this.notNullNeeded);
        Object[] objectArray = new Object[]{element};
        KtExpression newExpression = CreateByPatternKt.createExpressionByPattern$default((KtPsiFactory)new KtPsiFactory(project, false, 2, null), (String)("this?.$0" + elvis), (Object[])objectArray, (boolean)false, (int)4, null);
        PsiElement replacement = element.replace((PsiElement)newExpression);
        if (((CharSequence)elvis).length() > 0) {
            Intrinsics.checkNotNull((Object)replacement);
            ReplaceCallFixKt.moveCaretToEnd(replacement, editor, project);
        }
    }
}

