/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.quickfix;

import com.google.common.collect.ImmutableSet;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.psi.PsiElement;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.Named;
import org.jetbrains.kotlin.diagnostics.Diagnostic;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.idea.caches.resolve.ResolutionUtils;
import org.jetbrains.kotlin.idea.inspections.collections.FunctionUtilsKt;
import org.jetbrains.kotlin.idea.intentions.UtilsKt;
import org.jetbrains.kotlin.idea.quickfix.KotlinSingleIntentionActionFactory;
import org.jetbrains.kotlin.idea.quickfix.ReplaceCallFixUtilsKt;
import org.jetbrains.kotlin.idea.quickfix.ReplaceInfixOrOperatorCallFix;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtArrayAccessExpression;
import org.jetbrains.kotlin.psi.KtBinaryExpression;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.calls.util.CallUtilKt;
import org.jetbrains.kotlin.resolve.calls.util.ResolvedCallUtilKt;
import org.jetbrains.kotlin.resolve.lazy.BodyResolveMode;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.KotlinTypeKt;
import org.jetbrains.kotlin.types.TypeProjection;
import org.jetbrains.kotlin.types.expressions.OperatorConventions;
import org.jetbrains.kotlin.types.typeUtil.TypeUtilsKt;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0012\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\u0012\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000bH\u0014\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlin/idea/quickfix/ReplaceInfixOrOperatorCallFixFactory;", "Lorg/jetbrains/kotlin/idea/quickfix/KotlinSingleIntentionActionFactory;", "<init>", "()V", "findArrayAccessExpression", "Lorg/jetbrains/kotlin/psi/KtArrayAccessExpression;", "expression", "Lcom/intellij/psi/PsiElement;", "createAction", "Lcom/intellij/codeInsight/intention/IntentionAction;", "diagnostic", "Lorg/jetbrains/kotlin/diagnostics/Diagnostic;", "kotlin.idea"})
@SourceDebugExtension(value={"SMAP\nReplaceInfixOrOperatorCallFixFactory.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ReplaceInfixOrOperatorCallFixFactory.kt\norg/jetbrains/kotlin/idea/quickfix/ReplaceInfixOrOperatorCallFixFactory\n+ 2 addToStdlib.kt\norg/jetbrains/kotlin/utils/addToStdlib/AddToStdlibKt\n*L\n1#1,72:1\n119#2:73\n*S KotlinDebug\n*F\n+ 1 ReplaceInfixOrOperatorCallFixFactory.kt\norg/jetbrains/kotlin/idea/quickfix/ReplaceInfixOrOperatorCallFixFactory\n*L\n27#1:73\n*E\n"})
public final class ReplaceInfixOrOperatorCallFixFactory
extends KotlinSingleIntentionActionFactory {
    @NotNull
    public static final ReplaceInfixOrOperatorCallFixFactory INSTANCE = new ReplaceInfixOrOperatorCallFixFactory();

    private ReplaceInfixOrOperatorCallFixFactory() {
    }

    private final KtArrayAccessExpression findArrayAccessExpression(PsiElement expression) {
        KtArrayAccessExpression ktArrayAccessExpression;
        PsiElement $this$safeAs$iv = expression;
        boolean $i$f$safeAs = false;
        PsiElement psiElement = $this$safeAs$iv;
        if (!(psiElement instanceof KtArrayAccessExpression)) {
            psiElement = null;
        }
        if ((ktArrayAccessExpression = (KtArrayAccessExpression)psiElement) == null) {
            PsiElement psiElement2 = expression.getParent();
            if (psiElement2 != null) {
                PsiElement $this$safeAs$iv2 = psiElement2;
                boolean $i$f$safeAs2 = false;
                PsiElement psiElement3 = $this$safeAs$iv2;
                if (!(psiElement3 instanceof KtArrayAccessExpression)) {
                    psiElement3 = null;
                }
                ktArrayAccessExpression = (KtArrayAccessExpression)psiElement3;
            } else {
                ktArrayAccessExpression = null;
            }
        }
        return ktArrayAccessExpression;
    }

    @Override
    @Nullable
    protected IntentionAction createAction(@NotNull Diagnostic diagnostic) {
        Intrinsics.checkNotNullParameter((Object)diagnostic, (String)"diagnostic");
        PsiElement expression = diagnostic.getPsiElement();
        KtArrayAccessExpression arrayAccessExpression = this.findArrayAccessExpression(expression);
        if (arrayAccessExpression != null && !Intrinsics.areEqual((Object)diagnostic.getFactory(), (Object)Errors.UNSAFE_IMPLICIT_INVOKE_CALL)) {
            if (arrayAccessExpression.getArrayExpression() == null) {
                return null;
            }
            return new ReplaceInfixOrOperatorCallFix((KtExpression)arrayAccessExpression, ReplaceCallFixUtilsKt.shouldHaveNotNullType((KtExpression)arrayAccessExpression), null, 4, null);
        }
        PsiElement parent = expression.getParent();
        if (parent instanceof KtBinaryExpression) {
            ReplaceInfixOrOperatorCallFix replaceInfixOrOperatorCallFix;
            CallableDescriptor callableDescriptor;
            String binaryOperatorName;
            KtExpression left = ((KtBinaryExpression)parent).getLeft();
            if (left == null || ((KtBinaryExpression)parent).getRight() == null) {
                return null;
            }
            if (Intrinsics.areEqual((Object)((KtBinaryExpression)parent).getOperationToken(), (Object)KtTokens.EQ)) {
                return null;
            }
            ImmutableSet immutableSet = OperatorConventions.COMPARISON_OPERATIONS;
            Intrinsics.checkNotNullExpressionValue((Object)immutableSet, (String)"COMPARISON_OPERATIONS");
            if (CollectionsKt.contains((Iterable)((Iterable)immutableSet), (Object)((KtBinaryExpression)parent).getOperationToken())) {
                return null;
            }
            if (KtTokens.AUGMENTED_ASSIGNMENTS.contains(((KtBinaryExpression)parent).getOperationToken()) && left instanceof KtArrayAccessExpression) {
                KtExpression ktExpression = ((KtArrayAccessExpression)left).getArrayExpression();
                if (ktExpression == null || (ktExpression = CallUtilKt.getType((KtExpression)ktExpression, (BindingContext)ResolutionUtils.analyze$default((KtElement)left, null, 1, null))) == null) {
                    return null;
                }
                KtExpression type2 = ktExpression;
                if (FunctionUtilsKt.isMap((KotlinType)type2, TypeUtilsKt.getBuiltIns((KotlinType)type2))) {
                    TypeProjection typeProjection = (TypeProjection)CollectionsKt.lastOrNull((List)type2.getArguments());
                    if (!(typeProjection != null && (typeProjection = typeProjection.getType()) != null ? KotlinTypeKt.isNullable((KotlinType)typeProjection) : false)) {
                        return null;
                    }
                }
            }
            String string = binaryOperatorName = Intrinsics.areEqual((Object)((KtBinaryExpression)parent).getOperationToken(), (Object)KtTokens.IDENTIFIER) ? ((KtBinaryExpression)parent).getOperationReference().getText() : ((callableDescriptor = ResolutionUtils.resolveToCall((KtElement)parent, BodyResolveMode.FULL)) != null && (callableDescriptor = callableDescriptor.getCandidateDescriptor()) != null && (callableDescriptor = ((Named)callableDescriptor).getName()) != null ? callableDescriptor.asString() : null);
            if (string != null) {
                String it = string;
                boolean bl = false;
                replaceInfixOrOperatorCallFix = new ReplaceInfixOrOperatorCallFix((KtExpression)parent, ReplaceCallFixUtilsKt.shouldHaveNotNullType((KtExpression)parent), binaryOperatorName);
            } else {
                replaceInfixOrOperatorCallFix = null;
            }
            return replaceInfixOrOperatorCallFix;
        }
        if (parent instanceof KtCallExpression) {
            if (((KtCallExpression)parent).getCalleeExpression() == null || ((KtCallExpression)parent).getValueArgumentList() == null) {
                return null;
            }
            ResolvedCall<? extends CallableDescriptor> resolvedCall = ResolutionUtils.resolveToCall((KtElement)parent, BodyResolveMode.FULL);
            if (resolvedCall == null) {
                return null;
            }
            ResolvedCall<? extends CallableDescriptor> resolvedCall2 = resolvedCall;
            if (!UtilsKt.canBeReplacedWithInvokeCall(resolvedCall2) || ResolvedCallUtilKt.getImplicitReceiverValue(resolvedCall2) != null) {
                return null;
            }
            return new ReplaceInfixOrOperatorCallFix((KtExpression)parent, ReplaceCallFixUtilsKt.shouldHaveNotNullType((KtExpression)parent), null, 4, null);
        }
        return null;
    }
}

