/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.nj2k.conversions;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.ProjectScope;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.analysis.api.KaSession;
import org.jetbrains.kotlin.config.ApiVersion;
import org.jetbrains.kotlin.idea.stubindex.KotlinTopLevelTypeAliasFqNameIndex;
import org.jetbrains.kotlin.load.java.JvmAnnotationNames;
import org.jetbrains.kotlin.nj2k.ConversionsKt;
import org.jetbrains.kotlin.nj2k.NewJ2kConverterContext;
import org.jetbrains.kotlin.nj2k.RecursiveConversion;
import org.jetbrains.kotlin.nj2k.symbols.JKFieldSymbol;
import org.jetbrains.kotlin.nj2k.tree.FormattingKt;
import org.jetbrains.kotlin.nj2k.tree.JKAnnotation;
import org.jetbrains.kotlin.nj2k.tree.JKAnnotationList;
import org.jetbrains.kotlin.nj2k.tree.JKAnnotationMemberValue;
import org.jetbrains.kotlin.nj2k.tree.JKAnnotationParameter;
import org.jetbrains.kotlin.nj2k.tree.JKAnnotationParameterImpl;
import org.jetbrains.kotlin.nj2k.tree.JKElement;
import org.jetbrains.kotlin.nj2k.tree.JKExpression;
import org.jetbrains.kotlin.nj2k.tree.JKFieldAccessExpression;
import org.jetbrains.kotlin.nj2k.tree.JKFormattingOwner;
import org.jetbrains.kotlin.nj2k.tree.JKKtAnnotationArrayInitializerExpression;
import org.jetbrains.kotlin.nj2k.tree.JKLiteralExpression;
import org.jetbrains.kotlin.nj2k.tree.JKQualifiedExpression;
import org.jetbrains.kotlin.nj2k.tree.JKTreeElement;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u0000 \u001a2\u00020\u0001:\u0001\u001aB\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0019\u0010\u0006\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\u0007H\u0016R\u00020\b\u00a2\u0006\u0002\u0010\nJ\f\u0010\u000b\u001a\u00020\f*\u00020\rH\u0002J\f\u0010\u000e\u001a\u00020\f*\u00020\rH\u0002J\f\u0010\u000f\u001a\u00020\f*\u00020\rH\u0002J\f\u0010\u0010\u001a\u00020\f*\u00020\rH\u0002J\f\u0010\u0011\u001a\u00020\f*\u00020\rH\u0002J\f\u0010\u0012\u001a\u00020\u0013*\u00020\rH\u0002J\u0012\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u0015*\u00020\u0017H\u0002J\u000e\u0010\u0018\u001a\u0004\u0018\u00010\u0019*\u00020\u0016H\u0002\u00a8\u0006\u001b"}, d2={"Lorg/jetbrains/kotlin/nj2k/conversions/JavaAnnotationsConversion;", "Lorg/jetbrains/kotlin/nj2k/RecursiveConversion;", "context", "Lorg/jetbrains/kotlin/nj2k/NewJ2kConverterContext;", "<init>", "(Lorg/jetbrains/kotlin/nj2k/NewJ2kConverterContext;)V", "applyToElement", "Lorg/jetbrains/kotlin/nj2k/tree/JKTreeElement;", "Lorg/jetbrains/kotlin/analysis/api/KaSession;", "element", "(Lorg/jetbrains/kotlin/analysis/api/KaSession;Lorg/jetbrains/kotlin/nj2k/tree/JKTreeElement;)Lorg/jetbrains/kotlin/nj2k/tree/JKTreeElement;", "convertDeprecatedAnnotation", "", "Lorg/jetbrains/kotlin/nj2k/tree/JKAnnotation;", "convertDocumentedAnnotation", "convertTargetAnnotation", "convertRetentionAnnotation", "convertRepeatableAnnotation", "convertSuppressAnnotation", "", "values", "", "Lorg/jetbrains/kotlin/nj2k/tree/JKAnnotationMemberValue;", "Lorg/jetbrains/kotlin/nj2k/tree/JKAnnotationParameter;", "fieldAccessFqName", "", "Companion", "kotlin.j2k.shared"})
@SourceDebugExtension(value={"SMAP\nJavaAnnotationsConversion.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JavaAnnotationsConversion.kt\norg/jetbrains/kotlin/nj2k/conversions/JavaAnnotationsConversion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 collections.kt\norg/jetbrains/kotlin/utils/CollectionsKt\n+ 5 addToStdlib.kt\norg/jetbrains/kotlin/utils/addToStdlib/AddToStdlibKt\n+ 6 treeUtils.kt\norg/jetbrains/kotlin/nj2k/tree/TreeUtilsKt\n*L\n1#1,135:1\n1863#2,2:136\n1368#2:138\n1454#2,2:139\n1557#2:141\n1628#2,3:142\n1456#2,3:145\n1663#2,8:148\n1557#2:156\n1628#2,3:157\n774#2:162\n865#2:163\n866#2:165\n1557#2:166\n1628#2,2:167\n1630#2:176\n1187#2,2:179\n1261#2,2:181\n1557#2:183\n1628#2,3:184\n1264#2:187\n1187#2,2:188\n1261#2,4:190\n1#3:160\n58#4:161\n119#5:164\n119#5:177\n119#5:178\n76#6:169\n73#6,6:170\n*S KotlinDebug\n*F\n+ 1 JavaAnnotationsConversion.kt\norg/jetbrains/kotlin/nj2k/conversions/JavaAnnotationsConversion\n*L\n22#1:136,2\n51#1:138\n51#1:139,2\n54#1:141\n54#1:142,3\n51#1:145,3\n56#1:148,8\n56#1:156\n56#1:157,3\n79#1:162\n79#1:163\n79#1:165\n84#1:166\n84#1:167,2\n84#1:176\n121#1:179,2\n121#1:181,2\n122#1:183\n122#1:184,3\n121#1:187\n130#1:188,2\n130#1:190,4\n73#1:161\n80#1:164\n95#1:177\n96#1:178\n84#1:169\n84#1:170,6\n*E\n"})
public final class JavaAnnotationsConversion
extends RecursiveConversion {
    @NotNull
    public static final Companion Companion;
    @NotNull
    private static final Set<String> commonDiagnosticNames;
    @NotNull
    private static final Map<String, List<String>> targetMappings;
    @NotNull
    private static final Map<String, String> retentionMappings;

    public JavaAnnotationsConversion(@NotNull NewJ2kConverterContext context2) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        super(context2);
    }

    @Override
    @NotNull
    public JKTreeElement applyToElement(@NotNull KaSession $context_receiver_0, @NotNull JKTreeElement element) {
        Intrinsics.checkNotNullParameter((Object)$context_receiver_0, (String)"$context_receiver_0");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        if (!(element instanceof JKAnnotationList)) {
            return this.recurse($context_receiver_0, element);
        }
        Iterable $this$forEach$iv = ((JKAnnotationList)element).getAnnotations();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            JKAnnotation it = (JKAnnotation)element$iv;
            boolean bl = false;
            String string = it.getClassSymbol().getFqName();
            if (Intrinsics.areEqual((Object)string, (Object)JvmAnnotationNames.DEPRECATED_ANNOTATION.asString())) {
                this.convertDeprecatedAnnotation(it);
                continue;
            }
            if (Intrinsics.areEqual((Object)string, (Object)JvmAnnotationNames.TARGET_ANNOTATION.asString())) {
                this.convertTargetAnnotation(it);
                continue;
            }
            if (Intrinsics.areEqual((Object)string, (Object)JvmAnnotationNames.RETENTION_ANNOTATION.asString())) {
                this.convertRetentionAnnotation(it);
                continue;
            }
            if (Intrinsics.areEqual((Object)string, (Object)JvmAnnotationNames.REPEATABLE_ANNOTATION.asString())) {
                this.convertRepeatableAnnotation(it);
                continue;
            }
            if (Intrinsics.areEqual((Object)string, (Object)JvmAnnotationNames.DOCUMENTED_ANNOTATION.asString())) {
                this.convertDocumentedAnnotation(it);
                continue;
            }
            if (!Intrinsics.areEqual((Object)string, (Object)"java.lang.SuppressWarnings") || this.convertSuppressAnnotation(it)) continue;
            JKAnnotationList jKAnnotationList = (JKAnnotationList)element;
            jKAnnotationList.setAnnotations(CollectionsKt.minus((Iterable)jKAnnotationList.getAnnotations(), (Object)it));
        }
        return this.recurse($context_receiver_0, element);
    }

    private final void convertDeprecatedAnnotation(JKAnnotation $this$convertDeprecatedAnnotation) {
        $this$convertDeprecatedAnnotation.setClassSymbol(this.getSymbolProvider().provideClassSymbol("kotlin.Deprecated"));
        $this$convertDeprecatedAnnotation.setArguments(CollectionsKt.listOf((Object)new JKAnnotationParameterImpl(new JKLiteralExpression("\"\"", JKLiteralExpression.LiteralType.STRING, null, 4, null))));
    }

    private final void convertDocumentedAnnotation(JKAnnotation $this$convertDocumentedAnnotation) {
        $this$convertDocumentedAnnotation.setClassSymbol(this.getSymbolProvider().provideClassSymbol("kotlin.annotation.MustBeDocumented"));
    }

    /*
     * WARNING - void declaration
     */
    private final void convertTargetAnnotation(JKAnnotation $this$convertTargetAnnotation) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Iterable $this$distinctBy$iv;
        void $this$flatMapTo$iv$iv;
        $this$convertTargetAnnotation.setClassSymbol(this.getSymbolProvider().provideClassSymbol("kotlin.annotation.Target"));
        Object object = (JKAnnotationParameter)CollectionsKt.singleOrNull($this$convertTargetAnnotation.getArguments());
        if (object == null || (object = this.values((JKAnnotationParameter)object)) == null) {
            return;
        }
        Object javaTargets = object;
        Iterable $this$flatMap$iv = (Iterable)javaTargets;
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            void $this$mapTo$iv$iv2;
            List<String> kotlinFqNames;
            String javaFqName;
            JKAnnotationMemberValue target = (JKAnnotationMemberValue)element$iv$iv;
            boolean bl = false;
            if (this.fieldAccessFqName(target) == null) {
                return;
            }
            if (targetMappings.get(javaFqName) == null) {
                return;
            }
            Iterable $this$map$iv2 = kotlinFqNames;
            boolean $i$f$map = false;
            Iterable iterable2 = $this$map$iv2;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv2) {
                void it;
                String string = (String)item$iv$iv;
                Collection collection = destination$iv$iv2;
                boolean bl2 = false;
                collection.add(new JKFieldAccessExpression(this.getSymbolProvider().provideFieldSymbol((String)it), null, 2, null));
            }
            Iterable list$iv$iv = (List)destination$iv$iv2;
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        List kotlinTargets = (List)destination$iv$iv;
        $this$flatMap$iv = kotlinTargets;
        JKAnnotation jKAnnotation = $this$convertTargetAnnotation;
        boolean $i$f$distinctBy = false;
        HashSet<String> set$iv = new HashSet<String>();
        ArrayList list$iv = new ArrayList();
        for (Object e$iv : $this$distinctBy$iv) {
            JKFieldAccessExpression it = (JKFieldAccessExpression)e$iv;
            boolean bl = false;
            String key$iv = it.getIdentifier().getFqName();
            if (!set$iv.add(key$iv)) continue;
            list$iv.add(e$iv);
        }
        $this$distinctBy$iv = list$iv;
        boolean $i$f$map = false;
        set$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            JKFieldAccessExpression bl = (JKFieldAccessExpression)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl3 = false;
            collection.add(new JKAnnotationParameterImpl((JKAnnotationMemberValue)it));
        }
        jKAnnotation.setArguments((List)destination$iv$iv);
    }

    private final void convertRetentionAnnotation(JKAnnotation $this$convertRetentionAnnotation) {
        $this$convertRetentionAnnotation.setClassSymbol(this.getSymbolProvider().provideClassSymbol("kotlin.annotation.Retention"));
        JKTreeElement jKTreeElement = (JKAnnotationParameter)CollectionsKt.singleOrNull($this$convertRetentionAnnotation.getArguments());
        if (jKTreeElement == null || (jKTreeElement = jKTreeElement.getValue()) == null) {
            return;
        }
        JKTreeElement javaRetention = jKTreeElement;
        String string = this.fieldAccessFqName((JKAnnotationMemberValue)javaRetention);
        if (string == null) {
            return;
        }
        String javaFqName = string;
        String string2 = retentionMappings.get(javaFqName);
        if (string2 == null) {
            return;
        }
        String kotlinFqName = string2;
        JKAnnotationParameterImpl kotlinRetention = new JKAnnotationParameterImpl(new JKFieldAccessExpression(this.getSymbolProvider().provideFieldSymbol(kotlinFqName), null, 2, null));
        $this$convertRetentionAnnotation.setArguments(CollectionsKt.listOf((Object)kotlinRetention));
    }

    private final void convertRepeatableAnnotation(JKAnnotation $this$convertRepeatableAnnotation) {
        Module module;
        String jvmRepeatable;
        block6: {
            block5: {
                if (ConversionsKt.getModuleApiVersion(this).compareTo(ApiVersion.KOTLIN_1_6) < 0) {
                    return;
                }
                jvmRepeatable = "kotlin.jvm.JvmRepeatable";
                module = this.getContext().getConverter().getTargetModule();
                if (module == null) break block5;
                Module it = module;
                boolean bl = false;
                GlobalSearchScope globalSearchScope = GlobalSearchScope.moduleWithLibrariesScope((Module)it);
                module = globalSearchScope;
                if (globalSearchScope != null) break block6;
            }
            GlobalSearchScope globalSearchScope = ProjectScope.getLibrariesScope((Project)this.getContext().getProject());
            module = globalSearchScope;
            Intrinsics.checkNotNullExpressionValue((Object)globalSearchScope, (String)"getLibrariesScope(...)");
        }
        Module scope = module;
        Collection $this$ifEmpty$iv = KotlinTopLevelTypeAliasFqNameIndex.Helper.get(jvmRepeatable, this.getContext().getProject(), (GlobalSearchScope)scope);
        boolean $i$f$ifEmpty = false;
        if ($this$ifEmpty$iv.isEmpty()) {
            boolean bl = false;
            return;
        }
        $this$convertRepeatableAnnotation.setClassSymbol(this.getSymbolProvider().provideClassSymbol(jvmRepeatable));
    }

    /*
     * WARNING - void declaration
     */
    private final boolean convertSuppressAnnotation(JKAnnotation $this$convertSuppressAnnotation) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        JKAnnotationMemberValue it;
        void $this$filterTo$iv$iv;
        Object object = (JKAnnotationParameter)CollectionsKt.singleOrNull($this$convertSuppressAnnotation.getArguments());
        if (object == null || (object = this.values((JKAnnotationParameter)object)) == null) {
            return false;
        }
        Object javaDiagnosticNames = object;
        Iterable $this$filter$iv = (Iterable)javaDiagnosticNames;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            String string;
            Object object2;
            it = (JKAnnotationMemberValue)element$iv$iv;
            boolean bl = false;
            Iterable iterable2 = commonDiagnosticNames;
            JKAnnotationMemberValue $this$safeAs$iv = it;
            boolean $i$f$safeAs2 = false;
            JKAnnotationMemberValue jKAnnotationMemberValue = $this$safeAs$iv;
            if (!(jKAnnotationMemberValue instanceof JKLiteralExpression)) {
                jKAnnotationMemberValue = null;
            }
            if ((object2 = (JKLiteralExpression)jKAnnotationMemberValue) != null && (object2 = ((JKLiteralExpression)object2).getLiteral()) != null) {
                char[] $i$f$safeAs2 = new char[]{'\"'};
                string = StringsKt.trim((String)object2, (char[])$i$f$safeAs2);
            } else {
                string = null;
            }
            if (!CollectionsKt.contains((Iterable)iterable2, string)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List commonDiagnosticNames = (List)destination$iv$iv;
        if (commonDiagnosticNames.isEmpty()) {
            return false;
        }
        $this$convertSuppressAnnotation.setClassSymbol(this.getSymbolProvider().provideClassSymbol("kotlin.Suppress"));
        $this$filter$iv = commonDiagnosticNames;
        JKAnnotation jKAnnotation = $this$convertSuppressAnnotation;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            JKTreeElement jKTreeElement;
            it = (JKAnnotationMemberValue)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            JKTreeElement $this$copyTreeAndDetach$iv = it;
            boolean $i$f$copyTreeAndDetach = false;
            JKTreeElement $this$copyTree$iv$iv = $this$copyTreeAndDetach$iv;
            boolean $i$f$copyTree = false;
            JKFormattingOwner jKFormattingOwner = FormattingKt.withFormattingFrom((JKFormattingOwner)$this$copyTree$iv$iv.copy(), (JKFormattingOwner)$this$copyTree$iv$iv);
            if (jKFormattingOwner == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.nj2k.tree.JKAnnotationMemberValue");
            }
            JKTreeElement it$iv = jKTreeElement = (JKTreeElement)((JKAnnotationMemberValue)jKFormattingOwner);
            boolean bl2 = false;
            if (it$iv.getParent() != null) {
                JKElement jKElement = it$iv.getParent();
                Intrinsics.checkNotNull((Object)jKElement);
                it$iv.detach(jKElement);
            }
            collection.add(new JKAnnotationParameterImpl((JKAnnotationMemberValue)jKTreeElement));
        }
        jKAnnotation.setArguments((List)destination$iv$iv);
        return true;
    }

    private final List<JKAnnotationMemberValue> values(JKAnnotationParameter $this$values) {
        JKAnnotationMemberValue value = $this$values.getValue();
        return value instanceof JKKtAnnotationArrayInitializerExpression ? ((JKKtAnnotationArrayInitializerExpression)value).getInitializers() : CollectionsKt.listOf((Object)value);
    }

    private final String fieldAccessFqName(JKAnnotationMemberValue $this$fieldAccessFqName) {
        JKFieldSymbol jKFieldSymbol;
        JKFieldAccessExpression jKFieldAccessExpression;
        JKExpression jKExpression;
        JKAnnotationMemberValue $this$safeAs$iv = $this$fieldAccessFqName;
        boolean $i$f$safeAs = false;
        JKAnnotationMemberValue jKAnnotationMemberValue = $this$safeAs$iv;
        if (!(jKAnnotationMemberValue instanceof JKQualifiedExpression)) {
            jKAnnotationMemberValue = null;
        }
        JKAnnotationMemberValue $this$safeAs$iv2 = (jKExpression = (JKQualifiedExpression)jKAnnotationMemberValue) != null && (jKExpression = jKExpression.getSelector()) != null ? (JKAnnotationMemberValue)jKExpression : $this$fieldAccessFqName;
        boolean $i$f$safeAs2 = false;
        JKAnnotationMemberValue jKAnnotationMemberValue2 = $this$safeAs$iv2;
        if (!(jKAnnotationMemberValue2 instanceof JKFieldAccessExpression)) {
            jKAnnotationMemberValue2 = null;
        }
        return (jKFieldAccessExpression = (JKFieldAccessExpression)jKAnnotationMemberValue2) != null && (jKFieldSymbol = jKFieldAccessExpression.getIdentifier()) != null ? jKFieldSymbol.getFqName() : null;
    }

    /*
     * WARNING - void declaration
     */
    static {
        Object kotlin;
        String java;
        Pair pair;
        Map map;
        Object element$iv$iv;
        Object $this$associateTo$iv$iv;
        Companion = new Companion(null);
        Object[] objectArray = new String[]{"deprecation", "unused", "SpellCheckingInspection", "HardCodedStringLiteral"};
        commonDiagnosticNames = SetsKt.setOf((Object[])objectArray);
        objectArray = new Pair[10];
        objectArray[0] = TuplesKt.to((Object)"ANNOTATION_TYPE", (Object)CollectionsKt.listOf((Object)"ANNOTATION_CLASS"));
        objectArray[1] = TuplesKt.to((Object)"CONSTRUCTOR", (Object)CollectionsKt.listOf((Object)"CONSTRUCTOR"));
        objectArray[2] = TuplesKt.to((Object)"FIELD", (Object)CollectionsKt.listOf((Object)"FIELD"));
        objectArray[3] = TuplesKt.to((Object)"LOCAL_VARIABLE", (Object)CollectionsKt.listOf((Object)"LOCAL_VARIABLE"));
        Object[] objectArray2 = new String[]{"FUNCTION", "PROPERTY_GETTER", "PROPERTY_SETTER"};
        objectArray[4] = TuplesKt.to((Object)"METHOD", (Object)CollectionsKt.listOf((Object[])objectArray2));
        objectArray[5] = TuplesKt.to((Object)"PACKAGE", (Object)CollectionsKt.listOf((Object)"FILE"));
        objectArray[6] = TuplesKt.to((Object)"PARAMETER", (Object)CollectionsKt.listOf((Object)"VALUE_PARAMETER"));
        objectArray[7] = TuplesKt.to((Object)"TYPE_PARAMETER", (Object)CollectionsKt.listOf((Object)"TYPE_PARAMETER"));
        objectArray[8] = TuplesKt.to((Object)"TYPE", (Object)CollectionsKt.listOf((Object)"CLASS"));
        objectArray2 = new String[]{"CLASS", "TYPE", "TYPE_PARAMETER"};
        objectArray[9] = TuplesKt.to((Object)"TYPE_USE", (Object)CollectionsKt.listOf((Object[])objectArray2));
        Object $this$associate$iv = (Object[])CollectionsKt.listOf((Object[])objectArray);
        boolean $i$f$associate = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associate$iv, (int)10)), (int)16);
        Object[] objectArray3 = $this$associate$iv;
        Map destination$iv$iv = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateTo = false;
        Iterator iterator2 = $this$associateTo$iv$iv.iterator();
        while (iterator2.hasNext()) {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            element$iv$iv = iterator2.next();
            map = destination$iv$iv;
            pair = (Pair)element$iv$iv;
            boolean bl = false;
            java = (String)pair.component1();
            kotlin = (List)pair.component2();
            Iterable iterable = (Iterable)kotlin;
            String string = "java.lang.annotation.ElementType." + java;
            boolean $i$f$map = false;
            void var16_17 = $this$map$iv;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                String string2 = (String)item$iv$iv;
                Collection collection = destination$iv$iv2;
                boolean bl2 = false;
                collection.add("kotlin.annotation.AnnotationTarget." + (String)it);
            }
            pair = TuplesKt.to((Object)string, (Object)((List)destination$iv$iv2));
            map.put(pair.getFirst(), pair.getSecond());
        }
        targetMappings = destination$iv$iv;
        $this$associate$iv = new Pair[]{TuplesKt.to((Object)"SOURCE", (Object)"SOURCE"), TuplesKt.to((Object)"CLASS", (Object)"BINARY"), TuplesKt.to((Object)"RUNTIME", (Object)"RUNTIME")};
        $this$associate$iv = CollectionsKt.listOf((Object[])$this$associate$iv);
        $i$f$associate = false;
        capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associate$iv, (int)10)), (int)16);
        $this$associateTo$iv$iv = $this$associate$iv;
        destination$iv$iv = new LinkedHashMap(capacity$iv);
        $i$f$associateTo = false;
        iterator2 = $this$associateTo$iv$iv.iterator();
        while (iterator2.hasNext()) {
            element$iv$iv = iterator2.next();
            map = destination$iv$iv;
            pair = (Pair)element$iv$iv;
            boolean bl = false;
            Object object = pair.component1();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"component1(...)");
            java = (String)object;
            Object object2 = pair.component2();
            Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"component2(...)");
            kotlin = (String)object2;
            pair = TuplesKt.to((Object)("java.lang.annotation.RetentionPolicy." + java), (Object)("kotlin.annotation.AnnotationRetention." + (String)kotlin));
            map.put(pair.getFirst(), pair.getSecond());
        }
        retentionMappings = destination$iv$iv;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010$\n\u0002\u0010 \n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u0007\u001a\u0014\u0012\u0004\u0012\u00020\u0006\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00060\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/kotlin/nj2k/conversions/JavaAnnotationsConversion$Companion;", "", "<init>", "()V", "commonDiagnosticNames", "", "", "targetMappings", "", "", "retentionMappings", "kotlin.j2k.shared"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

