/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs;

import com.intellij.ide.IdeView;
import com.intellij.ide.impl.dataRules.GetDataRule;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.JBIterable;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public final class VcsVirtualFilesRule
implements GetDataRule {
    private static final Logger LOG = Logger.getInstance(VcsVirtualFilesRule.class);

    @Nullable
    public Object getData(@NotNull DataProvider dataProvider) {
        JBIterable directories;
        Object[] files;
        if (dataProvider == null) {
            VcsVirtualFilesRule.$$$reportNull$$$0(0);
        }
        if ((files = (VirtualFile[])CommonDataKeys.VIRTUAL_FILE_ARRAY.getData(dataProvider)) != null) {
            return JBIterable.of((Object[])files);
        }
        VirtualFile file = (VirtualFile)CommonDataKeys.VIRTUAL_FILE.getData(dataProvider);
        if (file != null) {
            return JBIterable.of((Object)file);
        }
        IdeView view = (IdeView)LangDataKeys.IDE_VIEW.getData(dataProvider);
        if (view != null && (directories = JBIterable.of((Object[])view.getDirectories())).isNotEmpty()) {
            if (directories.contains(null)) {
                LOG.error("Array with null provided by " + view.getClass().getName());
            }
            return directories.filterNotNull().filterMap(o -> o.getVirtualFile()).collect();
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataProvider", "com/intellij/openapi/vcs/VcsVirtualFilesRule", "getData"));
    }
}

