/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rd.ui.icons.converters;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.IconLoader;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.ui.icons.CachedImageIcon;
import com.intellij.ui.icons.ImageDataLoader;
import com.intellij.ui.icons.ImageDescriptor;
import com.intellij.ui.icons.ImageDescriptorKt;
import com.intellij.util.io.URLUtil;
import com.jetbrains.rd.ide.model.IconModel;
import com.jetbrains.rd.ide.model.IconSource;
import com.jetbrains.rd.ide.model.ImageIconInternWrapper;
import com.jetbrains.rd.ide.model.ImageIconModel;
import com.jetbrains.rd.ui.icons.ProtocolIconConverter;
import com.jetbrains.rd.ui.icons.ProtocolIconRegistry;
import com.jetbrains.rd.ui.icons.converters.ImageIconConverterKt;
import com.jetbrains.rd.ui.icons.converters.ProtocolImageDataLoader;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\u0007\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0018\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00032\u0006\u0010\t\u001a\u00020\nH\u0016J\u001a\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\nH\u0016\u00a8\u0006\u000e"}, d2={"Lcom/jetbrains/rd/ui/icons/converters/ImageIconConverter;", "Lcom/jetbrains/rd/ui/icons/ProtocolIconConverter;", "Lcom/intellij/ui/icons/CachedImageIcon;", "Lcom/jetbrains/rd/ide/model/ImageIconModel;", "<init>", "()V", "createIcon", "Ljavax/swing/Icon;", "model", "registry", "Lcom/jetbrains/rd/ui/icons/ProtocolIconRegistry;", "createModel", "Lcom/jetbrains/rd/ide/model/IconModel;", "icon", "intellij.rd.ui"})
@SourceDebugExtension(value={"SMAP\nImageIconConverter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ImageIconConverter.kt\ncom/jetbrains/rd/ui/icons/converters/ImageIconConverter\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,92:1\n1#2:93\n1#2:116\n68#3,4:94\n68#3,4:98\n1557#4:102\n1628#4,3:103\n1611#4,9:106\n1863#4:115\n1864#4:117\n1620#4:118\n*S KotlinDebug\n*F\n+ 1 ImageIconConverter.kt\ncom/jetbrains/rd/ui/icons/converters/ImageIconConverter\n*L\n67#1:116\n44#1:94,4\n52#1:98,4\n63#1:102\n63#1:103,3\n67#1:106,9\n67#1:115\n67#1:117\n67#1:118\n*E\n"})
public final class ImageIconConverter
implements ProtocolIconConverter<CachedImageIcon, ImageIconModel> {
    @Override
    @NotNull
    public Icon createIcon(@NotNull ImageIconModel model, @NotNull ProtocolIconRegistry registry) {
        Intrinsics.checkNotNullParameter((Object)model, (String)"model");
        Intrinsics.checkNotNullParameter((Object)registry, (String)"registry");
        String path = model.getWrapper().getPath();
        Icon icon = IconLoader.findIcon((String)path, AllIcons.class, (boolean)false, (boolean)false);
        if (icon != null && !(icon instanceof CachedImageIcon)) {
            return icon;
        }
        Icon unscaledIcon = registry.cacheIcon(model.getWrapper().getIdentity(), (Function1<? super Long, ? extends Icon>)((Function1)arg_0 -> ImageIconConverter.createIcon$lambda$0(model, icon, arg_0)));
        Float scale = model.getInitialScale();
        if (scale == null) {
            return unscaledIcon;
        }
        CachedImageIcon cachedImageIcon = unscaledIcon instanceof CachedImageIcon ? (CachedImageIcon)unscaledIcon : null;
        return cachedImageIcon != null && (cachedImageIcon = cachedImageIcon.scale(scale.floatValue())) != null ? (Icon)cachedImageIcon : unscaledIcon;
    }

    @Override
    @Nullable
    public IconModel createModel(@NotNull CachedImageIcon icon, @NotNull ProtocolIconRegistry registry) {
        Intrinsics.checkNotNullParameter((Object)icon, (String)"icon");
        Intrinsics.checkNotNullParameter((Object)registry, (String)"registry");
        IconModel it = registry.cacheModel((Icon)icon, (Function1<? super Long, ? extends IconModel>)((Function1)arg_0 -> ImageIconConverter.createModel$lambda$9(icon, arg_0)));
        boolean bl = false;
        ImageIconModel imageIconModel = it instanceof ImageIconModel ? (ImageIconModel)it : null;
        if (imageIconModel == null) {
            return it;
        }
        ImageIconModel model = imageIconModel;
        Double scale = icon.getObjScale();
        if (scale == null) {
            return model;
        }
        return new ImageIconModel(model.getWrapper(), Float.valueOf((float)scale.doubleValue()));
    }

    private static final Icon createIcon$lambda$0(ImageIconModel $model, Icon $icon, long it) {
        Icon icon = $icon;
        CachedImageIcon cachedImageIcon = icon instanceof CachedImageIcon ? (CachedImageIcon)icon : null;
        return (Icon)new CachedImageIcon((ImageDataLoader)new ProtocolImageDataLoader($model, (ImageDataLoader)(cachedImageIcon != null ? cachedImageIcon.getOriginalLoader() : null)));
    }

    /*
     * WARNING - void declaration
     */
    private static final IconModel createModel$lambda$9(CachedImageIcon $icon, long identity) {
        Object object;
        List sources;
        String effectiveName;
        String effectivePath;
        Object object2;
        Object name;
        Pair path;
        Object object3;
        URL url;
        String originalPath;
        block30: {
            block29: {
                block28: {
                    Object object4;
                    block27: {
                        Object object5;
                        String string;
                        String string2 = $icon.getExpUIPath();
                        if (string2 == null) {
                            string2 = $icon.getOriginalPath();
                        }
                        originalPath = string2;
                        url = $icon.getUrl();
                        Logger $this$trace$iv = ImageIconConverterKt.access$getLogger$p();
                        boolean $i$f$trace = false;
                        if ($this$trace$iv.isTraceEnabled()) {
                            object3 = $this$trace$iv;
                            boolean bl = false;
                            URL uRL = url;
                            object3.trace("originalPath=" + originalPath + ", icon.url.path=" + (uRL != null ? uRL.getPath() : null));
                        }
                        if ((string = originalPath) == null) {
                            URL uRL = url;
                            string = uRL != null ? uRL.getPath() : null;
                        }
                        if (string != null) {
                            String it = string;
                            boolean bl = false;
                            object5 = URLUtil.splitJarUrl((String)it);
                            if (object5 == null || (object5 = (String)object5.second) == null) {
                                object5 = it;
                            }
                        } else {
                            object5 = null;
                        }
                        if ((object4 = (path = object5)) == null) break block27;
                        Pair it = object4;
                        boolean bl = false;
                        String string3 = FileUtilRt.getNameWithoutExtension((String)it);
                        object4 = string3;
                        if (string3 != null) break block28;
                    }
                    object4 = name = "protocol_icon_no_path";
                }
                if ((object2 = path) == null) break block29;
                Pair it = object2;
                boolean bl = false;
                String string = FileUtilRt.getExtension((String)it);
                object2 = string;
                if (string != null) break block30;
            }
            object2 = "png";
        }
        Object it = object2;
        boolean bl = false;
        String ext = Intrinsics.areEqual((Object)it, (Object)"") ? "svg" : it;
        Logger $this$trace$iv = ImageIconConverterKt.access$getLogger$p();
        boolean $i$f$trace = false;
        if ($this$trace$iv.isTraceEnabled()) {
            object3 = $this$trace$iv;
            boolean bl2 = false;
            object3.trace("path=" + (String)path + ", name=" + (String)name + ", ext=" + ext);
        }
        if (originalPath == null) {
            ImageIconConverterKt.access$getLogger$p().warn("originalPath is null, using " + (String)name + "." + ext + " as a fallback");
        }
        URL uRL = url;
        String string = effectivePath = uRL != null ? uRL.getPath() : null;
        String effectiveExtension = string != null ? StringsKt.substringAfterLast$default((String)string, (String)".", null, (int)2, null) : null;
        String string4 = effectivePath;
        String string5 = effectiveName = string4 != null ? StringsKt.substringBeforeLast$default((String)string4, (String)".", null, (int)2, null) : null;
        if (path != null && effectiveName != null && effectiveExtension != null) {
            void $this$mapNotNullTo$iv$iv;
            Object object6;
            Iterable $this$mapTo$iv$iv;
            Iterable $this$map$iv = ImageDescriptorKt.createImageDescriptorList((String)path, (boolean)true, (boolean)true, (float)1.0f);
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it2;
                object6 = (ImageDescriptor)item$iv$iv;
                object3 = destination$iv$iv;
                boolean bl3 = false;
                String transformedPath = (String)it2.pathTransform.invoke((Object)effectiveName, (Object)effectiveExtension);
                String sourceId = (String)it2.pathTransform.invoke(name, (Object)ext);
                object3.add(TuplesKt.to((Object)transformedPath, (Object)sourceId));
            }
            Iterable $this$mapNotNull$iv = CollectionsKt.distinct((Iterable)((List)destination$iv$iv));
            boolean $i$f$mapNotNull = false;
            $this$mapTo$iv$iv = $this$mapNotNull$iv;
            destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            object6 = $this$forEach$iv$iv$iv.iterator();
            while (object6.hasNext()) {
                IconSource iconSource;
                block26: {
                    byte[] byArray;
                    Object element$iv$iv$iv;
                    Object element$iv$iv = element$iv$iv$iv = object6.next();
                    boolean bl4 = false;
                    kotlin.Pair it3 = (kotlin.Pair)element$iv$iv;
                    boolean bl5 = false;
                    URL newUrl = new URL(url.getProtocol(), url.getHost(), url.getPort(), (String)it3.getFirst());
                    try {
                        byArray = TextStreamsKt.readBytes((URL)newUrl);
                    }
                    catch (IOException ex) {
                        iconSource = null;
                        break block26;
                    }
                    byte[] bytes = byArray;
                    iconSource = new IconSource((String)it3.getSecond(), bytes);
                }
                if (iconSource == null) continue;
                IconSource it$iv$iv = iconSource;
                boolean bl6 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            v14 = (List)destination$iv$iv;
        } else {
            v14 = sources = CollectionsKt.emptyList();
        }
        if (sources.isEmpty()) {
            ImageIconConverterKt.access$getLogger$p().error("Failed to read icon:'" + (String)path + "'");
        }
        if ((object = path) == null) {
            object = (String)name + "." + ext;
        }
        Pair pair = object;
        int n = $icon.getImageFlags();
        return new ImageIconModel(new ImageIconInternWrapper(identity, (String)pair, n, sources), null);
    }
}

