/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.codegen.intrinsics;

import com.google.common.collect.ImmutableList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.PrimitiveType;
import org.jetbrains.kotlin.builtins.StandardNames;
import org.jetbrains.kotlin.codegen.AsmUtil;
import org.jetbrains.kotlin.codegen.intrinsics.ArrayConstructor;
import org.jetbrains.kotlin.codegen.intrinsics.ArrayGet;
import org.jetbrains.kotlin.codegen.intrinsics.ArrayIterator;
import org.jetbrains.kotlin.codegen.intrinsics.ArrayOf;
import org.jetbrains.kotlin.codegen.intrinsics.ArraySet;
import org.jetbrains.kotlin.codegen.intrinsics.ArraySize;
import org.jetbrains.kotlin.codegen.intrinsics.BinaryOp;
import org.jetbrains.kotlin.codegen.intrinsics.Clone;
import org.jetbrains.kotlin.codegen.intrinsics.CompareTo;
import org.jetbrains.kotlin.codegen.intrinsics.Concat;
import org.jetbrains.kotlin.codegen.intrinsics.EqualsThrowingNpeForNullReceiver;
import org.jetbrains.kotlin.codegen.intrinsics.HashCode;
import org.jetbrains.kotlin.codegen.intrinsics.Increment;
import org.jetbrains.kotlin.codegen.intrinsics.IntrinsicMethod;
import org.jetbrains.kotlin.codegen.intrinsics.IntrinsicsMap;
import org.jetbrains.kotlin.codegen.intrinsics.Inv;
import org.jetbrains.kotlin.codegen.intrinsics.IsArrayOf;
import org.jetbrains.kotlin.codegen.intrinsics.IteratorNext;
import org.jetbrains.kotlin.codegen.intrinsics.Java8UIntCompare;
import org.jetbrains.kotlin.codegen.intrinsics.Java8UIntDivide;
import org.jetbrains.kotlin.codegen.intrinsics.Java8UIntRemainder;
import org.jetbrains.kotlin.codegen.intrinsics.Java8UIntToString;
import org.jetbrains.kotlin.codegen.intrinsics.Java8ULongCompare;
import org.jetbrains.kotlin.codegen.intrinsics.Java8ULongDivide;
import org.jetbrains.kotlin.codegen.intrinsics.Java8ULongRemainder;
import org.jetbrains.kotlin.codegen.intrinsics.Java8ULongToString;
import org.jetbrains.kotlin.codegen.intrinsics.JavaClassProperty;
import org.jetbrains.kotlin.codegen.intrinsics.KCallableNameProperty;
import org.jetbrains.kotlin.codegen.intrinsics.KClassJavaObjectTypeProperty;
import org.jetbrains.kotlin.codegen.intrinsics.KClassJavaPrimitiveTypeProperty;
import org.jetbrains.kotlin.codegen.intrinsics.KClassJavaProperty;
import org.jetbrains.kotlin.codegen.intrinsics.LateinitIsInitialized;
import org.jetbrains.kotlin.codegen.intrinsics.MonitorInstruction;
import org.jetbrains.kotlin.codegen.intrinsics.MutableMapSet;
import org.jetbrains.kotlin.codegen.intrinsics.NewArray;
import org.jetbrains.kotlin.codegen.intrinsics.Not;
import org.jetbrains.kotlin.codegen.intrinsics.NumberCast;
import org.jetbrains.kotlin.codegen.intrinsics.RangeTo;
import org.jetbrains.kotlin.codegen.intrinsics.StringGetChar;
import org.jetbrains.kotlin.codegen.intrinsics.StringPlus;
import org.jetbrains.kotlin.codegen.intrinsics.ToString;
import org.jetbrains.kotlin.codegen.intrinsics.TrimIndent;
import org.jetbrains.kotlin.codegen.intrinsics.TrimMargin;
import org.jetbrains.kotlin.codegen.intrinsics.UnaryMinus;
import org.jetbrains.kotlin.codegen.intrinsics.UnaryPlus;
import org.jetbrains.kotlin.config.JvmTarget;
import org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.FqNameUnsafe;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.resolve.jvm.JvmPrimitiveType;
import org.jetbrains.kotlin.types.expressions.OperatorConventions;
import org.jetbrains.kotlin.util.capitalizeDecapitalize.CapitalizeDecapitalizeKt;
import org.jetbrains.org.objectweb.asm.Type;

public class IntrinsicMethods {
    public static final String INTRINSICS_CLASS_NAME = "kotlin/jvm/internal/Intrinsics";
    private static final FqName KOTLIN_JVM = new FqName("kotlin.jvm");
    static final FqNameUnsafe RECEIVER_PARAMETER_FQ_NAME = new FqNameUnsafe("T");
    private static final FqNameUnsafe KOTLIN_UINT = new FqNameUnsafe("kotlin.UInt");
    private static final FqNameUnsafe KOTLIN_ULONG = new FqNameUnsafe("kotlin.ULong");
    private static final IntrinsicMethod UNARY_MINUS = new UnaryMinus();
    private static final IntrinsicMethod UNARY_PLUS = new UnaryPlus();
    private static final IntrinsicMethod NUMBER_CAST = new NumberCast();
    private static final IntrinsicMethod INV = new Inv();
    private static final IntrinsicMethod RANGE_TO = new RangeTo();
    private static final IntrinsicMethod INC = new Increment(1);
    private static final IntrinsicMethod DEC = new Increment(-1);
    private static final IntrinsicMethod ARRAY_SIZE = new ArraySize();
    private static final IteratorNext ITERATOR_NEXT = new IteratorNext();
    private static final ArraySet ARRAY_SET = new ArraySet();
    private static final ArrayGet ARRAY_GET = new ArrayGet();
    private static final StringPlus STRING_PLUS = new StringPlus();
    private static final ToString TO_STRING = new ToString();
    private static final Clone CLONE = new Clone();
    private static final IntrinsicMethod ARRAY_ITERATOR = new ArrayIterator();
    private final IntrinsicsMap intrinsicsMap = new IntrinsicsMap();

    public IntrinsicMethods(JvmTarget jvmTarget) {
        this(false);
    }

    public IntrinsicMethods(boolean canReplaceStdlibRuntimeApiBehavior) {
        this.intrinsicsMap.registerIntrinsic(KOTLIN_JVM, RECEIVER_PARAMETER_FQ_NAME, "javaClass", -1, JavaClassProperty.INSTANCE);
        this.intrinsicsMap.registerIntrinsic(KOTLIN_JVM, StandardNames.FqNames.kClass, "java", -1, new KClassJavaProperty());
        this.intrinsicsMap.registerIntrinsic(KOTLIN_JVM, StandardNames.FqNames.kClass, "javaObjectType", -1, new KClassJavaObjectTypeProperty());
        this.intrinsicsMap.registerIntrinsic(KOTLIN_JVM, StandardNames.FqNames.kClass, "javaPrimitiveType", -1, new KClassJavaPrimitiveTypeProperty());
        this.intrinsicsMap.registerIntrinsic(StandardNames.FqNames.kCallable.toSafe(), null, "name", -1, new KCallableNameProperty());
        this.intrinsicsMap.registerIntrinsic(new FqName("kotlin.jvm.internal.unsafe"), null, "monitorEnter", 1, MonitorInstruction.MONITOR_ENTER);
        this.intrinsicsMap.registerIntrinsic(new FqName("kotlin.jvm.internal.unsafe"), null, "monitorExit", 1, MonitorInstruction.MONITOR_EXIT);
        this.intrinsicsMap.registerIntrinsic(KOTLIN_JVM, StandardNames.FqNames.array, "isArrayOf", 0, new IsArrayOf());
        this.intrinsicsMap.registerIntrinsic(StandardNames.BUILT_INS_PACKAGE_FQ_NAME, StandardNames.FqNames.kProperty0, "isInitialized", -1, LateinitIsInitialized.INSTANCE);
        this.intrinsicsMap.registerIntrinsic(StandardNames.BUILT_INS_PACKAGE_FQ_NAME, null, "arrayOf", 1, new ArrayOf());
        this.intrinsicsMap.registerIntrinsic(new FqName("kotlin.collections"), new FqNameUnsafe("kotlin.collections.MutableMap"), "set", 2, new MutableMapSet());
        ImmutableList primitiveCastMethods = OperatorConventions.NUMBER_CONVERSIONS.asList();
        for (Name method : primitiveCastMethods) {
            String methodName = method.asString();
            this.declareIntrinsicFunction(StandardNames.FqNames.number, methodName, 0, NUMBER_CAST);
            for (PrimitiveType type : PrimitiveType.NUMBER_TYPES) {
                this.declareIntrinsicFunction(type.getTypeFqName(), methodName, 0, NUMBER_CAST);
            }
        }
        for (PrimitiveType[] type : PrimitiveType.NUMBER_TYPES) {
            FqName typeFqName = type.getTypeFqName();
            this.declareIntrinsicFunction(typeFqName, "plus", 0, UNARY_PLUS);
            this.declareIntrinsicFunction(typeFqName, "unaryPlus", 0, UNARY_PLUS);
            this.declareIntrinsicFunction(typeFqName, "minus", 0, UNARY_MINUS);
            this.declareIntrinsicFunction(typeFqName, "unaryMinus", 0, UNARY_MINUS);
            this.declareIntrinsicFunction(typeFqName, "inv", 0, INV);
            this.declareIntrinsicFunction(typeFqName, "rangeTo", 1, RANGE_TO);
            this.declareIntrinsicFunction(typeFqName, "inc", 0, INC);
            this.declareIntrinsicFunction(typeFqName, "dec", 0, DEC);
        }
        HashCode hashCode = new HashCode();
        for (PrimitiveType type : PrimitiveType.values()) {
            FqName typeFqName = type.getTypeFqName();
            Type wrapperType = AsmUtil.asmTypeByFqNameWithoutInnerClasses(JvmPrimitiveType.get((PrimitiveType)type).getWrapperFqName());
            this.declareIntrinsicFunction(typeFqName, "equals", 1, (IntrinsicMethod)new EqualsThrowingNpeForNullReceiver(wrapperType));
            this.declareIntrinsicFunction(typeFqName, "hashCode", 0, (IntrinsicMethod)hashCode);
            this.declareIntrinsicFunction(typeFqName, "toString", 0, (IntrinsicMethod)TO_STRING);
            this.intrinsicsMap.registerIntrinsic(StandardNames.BUILT_INS_PACKAGE_FQ_NAME, null, CapitalizeDecapitalizeKt.decapitalizeAsciiOnly((String)type.getArrayTypeName().asString()) + "Of", 1, new ArrayOf());
        }
        this.declareBinaryOp("plus", 96);
        this.declareBinaryOp("minus", 100);
        this.declareBinaryOp("times", 104);
        this.declareBinaryOp("div", 108);
        this.declareBinaryOp("mod", 112);
        this.declareBinaryOp("rem", 112);
        this.declareBinaryOp("shl", 120);
        this.declareBinaryOp("shr", 122);
        this.declareBinaryOp("ushr", 124);
        this.declareBinaryOp("and", 126);
        this.declareBinaryOp("or", 128);
        this.declareBinaryOp("xor", 130);
        this.declareIntrinsicFunction(StandardNames.FqNames._boolean, "not", 0, (IntrinsicMethod)new Not());
        this.declareIntrinsicFunction(StandardNames.FqNames.string, "plus", 1, (IntrinsicMethod)new Concat());
        this.declareIntrinsicFunction(StandardNames.FqNames.string, "get", 1, (IntrinsicMethod)new StringGetChar());
        if (canReplaceStdlibRuntimeApiBehavior) {
            this.intrinsicsMap.registerIntrinsic(StandardNames.TEXT_PACKAGE_FQ_NAME, StandardNames.FqNames.string, "trimMargin", 1, new TrimMargin());
            this.intrinsicsMap.registerIntrinsic(StandardNames.TEXT_PACKAGE_FQ_NAME, StandardNames.FqNames.string, "trimIndent", 0, new TrimIndent());
        }
        this.declareIntrinsicFunction(StandardNames.FqNames.cloneable, "clone", 0, (IntrinsicMethod)CLONE);
        this.intrinsicsMap.registerIntrinsic(StandardNames.BUILT_INS_PACKAGE_FQ_NAME, StandardNames.FqNames.any, "toString", 0, TO_STRING);
        this.intrinsicsMap.registerIntrinsic(StandardNames.BUILT_INS_PACKAGE_FQ_NAME, StandardNames.FqNames.string, "plus", 1, STRING_PLUS);
        this.intrinsicsMap.registerIntrinsic(StandardNames.BUILT_INS_PACKAGE_FQ_NAME, null, "arrayOfNulls", 1, new NewArray());
        for (PrimitiveType type : PrimitiveType.values()) {
            this.declareIntrinsicFunction(type.getTypeFqName(), "compareTo", 1, (IntrinsicMethod)new CompareTo());
            this.declareIntrinsicFunction(StandardNames.COLLECTIONS_PACKAGE_FQ_NAME.child(Name.identifier((String)(type.getTypeName().asString() + "Iterator"))), "next", 0, (IntrinsicMethod)ITERATOR_NEXT);
        }
        this.declareArrayMethods();
        Java8UIntDivide java8UIntDivide = new Java8UIntDivide();
        this.intrinsicsMap.registerIntrinsic(KOTLIN_UINT.toSafe(), null, "div", 1, java8UIntDivide);
        this.intrinsicsMap.registerIntrinsic(StandardNames.BUILT_INS_PACKAGE_FQ_NAME, null, "uintDivide", 2, java8UIntDivide);
        Java8UIntRemainder java8UIntRemainder = new Java8UIntRemainder();
        this.intrinsicsMap.registerIntrinsic(KOTLIN_UINT.toSafe(), null, "rem", 1, java8UIntRemainder);
        this.intrinsicsMap.registerIntrinsic(StandardNames.BUILT_INS_PACKAGE_FQ_NAME, null, "uintRemainder", 2, java8UIntRemainder);
        Java8UIntCompare java8UIntCompare = new Java8UIntCompare();
        this.intrinsicsMap.registerIntrinsic(KOTLIN_UINT.toSafe(), null, "compareTo", 1, java8UIntCompare);
        this.intrinsicsMap.registerIntrinsic(StandardNames.BUILT_INS_PACKAGE_FQ_NAME, null, "uintCompare", 2, java8UIntCompare);
        this.intrinsicsMap.registerIntrinsic(KOTLIN_UINT.toSafe(), null, "toString", 0, new Java8UIntToString());
        Java8ULongDivide java8ULongDivide = new Java8ULongDivide();
        this.intrinsicsMap.registerIntrinsic(KOTLIN_ULONG.toSafe(), null, "div", 1, java8ULongDivide);
        this.intrinsicsMap.registerIntrinsic(StandardNames.BUILT_INS_PACKAGE_FQ_NAME, null, "ulongDivide", 2, java8ULongDivide);
        Java8ULongRemainder java8ULongRemainder = new Java8ULongRemainder();
        this.intrinsicsMap.registerIntrinsic(KOTLIN_ULONG.toSafe(), null, "rem", 1, java8ULongRemainder);
        this.intrinsicsMap.registerIntrinsic(StandardNames.BUILT_INS_PACKAGE_FQ_NAME, null, "ulongRemainder", 2, java8ULongRemainder);
        Java8ULongCompare java8ULongCompare = new Java8ULongCompare();
        this.intrinsicsMap.registerIntrinsic(KOTLIN_ULONG.toSafe(), null, "compareTo", 1, java8ULongCompare);
        this.intrinsicsMap.registerIntrinsic(StandardNames.BUILT_INS_PACKAGE_FQ_NAME, null, "ulongCompare", 2, java8ULongCompare);
        this.intrinsicsMap.registerIntrinsic(KOTLIN_ULONG.toSafe(), null, "toString", 0, new Java8ULongToString());
    }

    private void declareArrayMethods() {
        for (JvmPrimitiveType jvmPrimitiveType : JvmPrimitiveType.values()) {
            this.declareArrayMethods(jvmPrimitiveType.getPrimitiveType().getArrayTypeFqName());
        }
        this.declareArrayMethods(StandardNames.FqNames.array.toSafe());
    }

    private void declareArrayMethods(@NotNull FqName arrayTypeFqName) {
        if (arrayTypeFqName == null) {
            IntrinsicMethods.$$$reportNull$$$0(0);
        }
        this.declareIntrinsicFunction(arrayTypeFqName, "size", -1, ARRAY_SIZE);
        this.declareIntrinsicFunction(arrayTypeFqName, "set", 2, (IntrinsicMethod)ARRAY_SET);
        this.declareIntrinsicFunction(arrayTypeFqName, "get", 1, (IntrinsicMethod)ARRAY_GET);
        this.declareIntrinsicFunction(arrayTypeFqName, "clone", 0, (IntrinsicMethod)CLONE);
        this.declareIntrinsicFunction(arrayTypeFqName, "iterator", 0, ARRAY_ITERATOR);
        this.declareIntrinsicFunction(arrayTypeFqName, "<init>", 2, (IntrinsicMethod)ArrayConstructor.INSTANCE);
    }

    private void declareBinaryOp(@NotNull String methodName, int opcode) {
        if (methodName == null) {
            IntrinsicMethods.$$$reportNull$$$0(1);
        }
        BinaryOp op = new BinaryOp(opcode);
        for (PrimitiveType type : PrimitiveType.values()) {
            this.declareIntrinsicFunction(type.getTypeFqName(), methodName, 1, (IntrinsicMethod)op);
        }
    }

    private void declareIntrinsicFunction(@NotNull FqName classFqName, @NotNull String methodName, int arity, @NotNull IntrinsicMethod implementation2) {
        if (classFqName == null) {
            IntrinsicMethods.$$$reportNull$$$0(2);
        }
        if (methodName == null) {
            IntrinsicMethods.$$$reportNull$$$0(3);
        }
        if (implementation2 == null) {
            IntrinsicMethods.$$$reportNull$$$0(4);
        }
        this.intrinsicsMap.registerIntrinsic(classFqName, null, methodName, arity, implementation2);
    }

    private void declareIntrinsicFunction(@NotNull FqNameUnsafe classFqName, @NotNull String methodName, int arity, @NotNull IntrinsicMethod implementation2) {
        if (classFqName == null) {
            IntrinsicMethods.$$$reportNull$$$0(5);
        }
        if (methodName == null) {
            IntrinsicMethods.$$$reportNull$$$0(6);
        }
        if (implementation2 == null) {
            IntrinsicMethods.$$$reportNull$$$0(7);
        }
        this.intrinsicsMap.registerIntrinsic(classFqName.toSafe(), null, methodName, arity, implementation2);
    }

    @Nullable
    public IntrinsicMethod getIntrinsic(@NotNull CallableMemberDescriptor descriptor) {
        if (descriptor == null) {
            IntrinsicMethods.$$$reportNull$$$0(8);
        }
        return this.intrinsicsMap.getIntrinsic(descriptor);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "arrayTypeFqName";
                break;
            }
            case 1: 
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "methodName";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classFqName";
                break;
            }
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "implementation";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/kotlin/codegen/intrinsics/IntrinsicMethods";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "declareArrayMethods";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "declareBinaryOp";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "declareIntrinsicFunction";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "getIntrinsic";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

