/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.inline.util.rewriters;

import java.util.ArrayDeque;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.js.backend.ast.JsBreak;
import org.jetbrains.kotlin.js.backend.ast.JsContext;
import org.jetbrains.kotlin.js.backend.ast.JsContinue;
import org.jetbrains.kotlin.js.backend.ast.JsFunction;
import org.jetbrains.kotlin.js.backend.ast.JsFunctionScope;
import org.jetbrains.kotlin.js.backend.ast.JsLabel;
import org.jetbrains.kotlin.js.backend.ast.JsName;
import org.jetbrains.kotlin.js.backend.ast.JsNameRef;
import org.jetbrains.kotlin.js.backend.ast.JsNode;
import org.jetbrains.kotlin.js.backend.ast.JsVisitorWithContextImpl;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u001e\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011H\u0016J\u001e\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u000e\u001a\u00020\u00152\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011H\u0016J\u001e\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u000e\u001a\u00020\u00162\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011H\u0016J\u001e\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u00172\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011H\u0016J\u001e\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u000e\u001a\u00020\u00172\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011H\u0016J\u0010\u0010\u0018\u001a\u00020\n2\u0006\u0010\u0019\u001a\u00020\nH\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R \u0010\b\u001a\u0014\u0012\u0004\u0012\u00020\n\u0012\n\u0012\b\u0012\u0004\u0012\u00020\n0\u000b0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lorg/jetbrains/kotlin/js/inline/util/rewriters/LabelNameRefreshingVisitor;", "Lorg/jetbrains/kotlin/js/backend/ast/JsVisitorWithContextImpl;", "functionScope", "Lorg/jetbrains/kotlin/js/backend/ast/JsFunctionScope;", "<init>", "(Lorg/jetbrains/kotlin/js/backend/ast/JsFunctionScope;)V", "getFunctionScope", "()Lorg/jetbrains/kotlin/js/backend/ast/JsFunctionScope;", "substitutions", "", "Lorg/jetbrains/kotlin/js/backend/ast/JsName;", "Ljava/util/ArrayDeque;", "visit", "", "x", "Lorg/jetbrains/kotlin/js/backend/ast/JsFunction;", "ctx", "Lorg/jetbrains/kotlin/js/backend/ast/JsContext;", "Lorg/jetbrains/kotlin/js/backend/ast/JsNode;", "endVisit", "", "Lorg/jetbrains/kotlin/js/backend/ast/JsBreak;", "Lorg/jetbrains/kotlin/js/backend/ast/JsContinue;", "Lorg/jetbrains/kotlin/js/backend/ast/JsLabel;", "getSubstitution", "name", "js.translator"})
@SourceDebugExtension(value={"SMAP\nLabelNameRefreshingVisitor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LabelNameRefreshingVisitor.kt\norg/jetbrains/kotlin/js/inline/util/rewriters/LabelNameRefreshingVisitor\n+ 2 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,62:1\n381#2,7:63\n1#3:70\n*S KotlinDebug\n*F\n+ 1 LabelNameRefreshingVisitor.kt\norg/jetbrains/kotlin/js/inline/util/rewriters/LabelNameRefreshingVisitor\n*L\n46#1:63,7\n*E\n"})
public final class LabelNameRefreshingVisitor
extends JsVisitorWithContextImpl {
    @NotNull
    private final JsFunctionScope functionScope;
    @NotNull
    private final Map<JsName, ArrayDeque<JsName>> substitutions;

    public LabelNameRefreshingVisitor(@NotNull JsFunctionScope functionScope) {
        Intrinsics.checkNotNullParameter((Object)functionScope, (String)"functionScope");
        this.functionScope = functionScope;
        this.substitutions = new LinkedHashMap();
    }

    @NotNull
    public final JsFunctionScope getFunctionScope() {
        return this.functionScope;
    }

    public boolean visit(@NotNull JsFunction x, @NotNull JsContext<JsNode> ctx) {
        Intrinsics.checkNotNullParameter((Object)x, (String)"x");
        Intrinsics.checkNotNullParameter(ctx, (String)"ctx");
        return false;
    }

    public void endVisit(@NotNull JsBreak x, @NotNull JsContext<JsNode> ctx) {
        JsName label;
        Intrinsics.checkNotNullParameter((Object)x, (String)"x");
        Intrinsics.checkNotNullParameter(ctx, (String)"ctx");
        JsNameRef jsNameRef = x.getLabel();
        JsName jsName = label = jsNameRef != null ? jsNameRef.getName() : null;
        if (label != null) {
            ctx.replaceMe(new JsBreak(this.getSubstitution(label).makeRef()).source(x.getSource()));
        }
        super.endVisit(x, ctx);
    }

    public void endVisit(@NotNull JsContinue x, @NotNull JsContext<JsNode> ctx) {
        JsName label;
        Intrinsics.checkNotNullParameter((Object)x, (String)"x");
        Intrinsics.checkNotNullParameter(ctx, (String)"ctx");
        JsNameRef jsNameRef = x.getLabel();
        JsName jsName = label = jsNameRef != null ? jsNameRef.getName() : null;
        if (label != null) {
            ctx.replaceMe(new JsContinue(this.getSubstitution(label).makeRef()).source(x.getSource()));
        }
        super.endVisit(x, ctx);
    }

    public boolean visit(@NotNull JsLabel x, @NotNull JsContext<JsNode> ctx) {
        ArrayDeque<JsName> arrayDeque;
        Intrinsics.checkNotNullParameter((Object)x, (String)"x");
        Intrinsics.checkNotNullParameter(ctx, (String)"ctx");
        JsName labelName = x.getName();
        String string = labelName.getIdent();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getIdent(...)");
        String string2 = labelName.getIdent();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getIdent(...)");
        JsName freshName = this.functionScope.enterLabel(string, string2);
        Map<JsName, ArrayDeque<JsName>> $this$getOrPut$iv = this.substitutions;
        boolean $i$f$getOrPut = false;
        ArrayDeque<JsName> value$iv = $this$getOrPut$iv.get(labelName);
        if (value$iv == null) {
            boolean bl = false;
            ArrayDeque answer$iv = new ArrayDeque();
            $this$getOrPut$iv.put(labelName, answer$iv);
            arrayDeque = answer$iv;
        } else {
            arrayDeque = value$iv;
        }
        arrayDeque.push(freshName);
        return super.visit(x, ctx);
    }

    public void endVisit(@NotNull JsLabel x, @NotNull JsContext<JsNode> ctx) {
        JsLabel jsLabel;
        Intrinsics.checkNotNullParameter((Object)x, (String)"x");
        Intrinsics.checkNotNullParameter(ctx, (String)"ctx");
        JsName labelName = x.getName();
        ArrayDeque<JsName> arrayDeque = this.substitutions.get(labelName);
        Intrinsics.checkNotNull(arrayDeque);
        ArrayDeque<JsName> stack = arrayDeque;
        JsLabel $this$endVisit_u24lambda_u241 = jsLabel = new JsLabel(stack.pop(), x.getStatement());
        boolean bl = false;
        $this$endVisit_u24lambda_u241.copyMetadataFrom(x);
        JsLabel replacementLabel = jsLabel;
        ctx.replaceMe((JsNode)replacementLabel);
        this.functionScope.exitLabel();
        super.endVisit(x, ctx);
    }

    private final JsName getSubstitution(JsName name) {
        ArrayDeque<JsName> arrayDeque = this.substitutions.get(name);
        if (arrayDeque == null || (arrayDeque = arrayDeque.peek()) == null) {
            arrayDeque = name;
        }
        return arrayDeque;
    }
}

