/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.intentions.style;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnnotationMemberValue;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiTypeParameterList;
import com.intellij.psi.PsiTypes;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.GroovyBundle;
import org.jetbrains.plugins.groovy.codeStyle.GrReferenceAdjuster;
import org.jetbrains.plugins.groovy.intentions.base.Intention;
import org.jetbrains.plugins.groovy.intentions.base.PsiElementPredicate;
import org.jetbrains.plugins.groovy.intentions.style.inference.DefaultInferenceContext;
import org.jetbrains.plugins.groovy.intentions.style.inference.InferenceProcessKt;
import org.jetbrains.plugins.groovy.intentions.style.inference.InferenceProcessUtilKt;
import org.jetbrains.plugins.groovy.intentions.style.inference.SignatureInferenceOptions;
import org.jetbrains.plugins.groovy.intentions.style.inference.driver.InferenceDriverUtilKt;
import org.jetbrains.plugins.groovy.lang.psi.GrQualifiedReference;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElement;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.modifiers.GrModifierList;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.modifiers.annotation.GrAnnotation;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrOpenBlock;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.params.GrParameter;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrMethod;
import org.jetbrains.plugins.groovy.lang.resolve.processors.inference.InferenceKt;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\"\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\b\u0010\n\u001a\u0004\u0018\u00010\u000bH\u0014J\u0018\u0010\f\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000eH\u0002J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u000eH\u0002J\b\u0010\u0013\u001a\u00020\u0014H\u0014J\u0012\u0010\u0015\u001a\u00020\u00162\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007H\u0014J\b\u0010\u0017\u001a\u00020\u0018H\u0016J\b\u0010\u0019\u001a\u00020\u0018H\u0016\u00a8\u0006\u001a"}, d2={"Lorg/jetbrains/plugins/groovy/intentions/style/InferMethodParametersTypesIntention;", "Lorg/jetbrains/plugins/groovy/intentions/base/Intention;", "<init>", "()V", "processIntention", "", "element", "Lcom/intellij/psi/PsiElement;", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "substituteMethodSignature", "sourceMethod", "Lorg/jetbrains/plugins/groovy/lang/psi/api/statements/typedef/members/GrMethod;", "sinkMethod", "collectParameterSubstitutor", "Lcom/intellij/psi/PsiSubstitutor;", "virtualMethod", "getElementPredicate", "Lorg/jetbrains/plugins/groovy/intentions/base/PsiElementPredicate;", "isStopElement", "", "getText", "", "getFamilyName", "intellij.groovy"})
@SourceDebugExtension(value={"SMAP\nInferMethodParametersTypesIntention.kt\nKotlin\n*S Kotlin\n*F\n+ 1 InferMethodParametersTypesIntention.kt\norg/jetbrains/plugins/groovy/intentions/style/InferMethodParametersTypesIntention\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,105:1\n13409#2,2:106\n11165#2:108\n11500#2,3:109\n13409#2,2:112\n13409#2,2:114\n11165#2:117\n11500#2,3:118\n12574#2,2:123\n1#3:116\n37#4,2:121\n*S KotlinDebug\n*F\n+ 1 InferMethodParametersTypesIntention.kt\norg/jetbrains/plugins/groovy/intentions/style/InferMethodParametersTypesIntention\n*L\n51#1:106,2\n62#1:108\n62#1:109,3\n63#1:112,2\n71#1:114,2\n80#1:117\n80#1:118,3\n91#1:123,2\n83#1:121,2\n*E\n"})
public final class InferMethodParametersTypesIntention
extends Intention {
    @Override
    protected void processIntention(@NotNull PsiElement element, @NotNull Project project, @Nullable Editor editor) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        GrMethod method = (GrMethod)element;
        SignatureInferenceOptions options = new SignatureInferenceOptions(false, DefaultInferenceContext.INSTANCE);
        GrMethod virtualMethod = InferenceProcessKt.runInferenceProcess(method, options);
        this.substituteMethodSignature(virtualMethod, method);
    }

    /*
     * WARNING - void declaration
     */
    private final void substituteMethodSignature(GrMethod sourceMethod, GrMethod sinkMethod) {
        block15: {
            Object object;
            block17: {
                block16: {
                    PsiType psiType;
                    if (!sinkMethod.isConstructor() && !sinkMethod.getModifierList().hasModifierProperty("def")) {
                        sinkMethod.getModifierList().setModifierProperty("def", true);
                    }
                    if (sourceMethod.hasTypeParameters()) {
                        if (sinkMethod.hasTypeParameters()) {
                            PsiTypeParameterList psiTypeParameterList = sinkMethod.getTypeParameterList();
                            Intrinsics.checkNotNull((Object)psiTypeParameterList);
                            PsiTypeParameterList psiTypeParameterList2 = sourceMethod.getTypeParameterList();
                            Intrinsics.checkNotNull((Object)psiTypeParameterList2);
                            v2 = psiTypeParameterList.replace((PsiElement)psiTypeParameterList2);
                        } else if (sinkMethod.isConstructor()) {
                            PsiSubstitutor parameterSubstitutor = this.collectParameterSubstitutor(sourceMethod);
                            GrParameter[] grParameterArray = sourceMethod.getParameters();
                            Intrinsics.checkNotNullExpressionValue((Object)grParameterArray, (String)"getParameters(...)");
                            Pair $this$forEach$iv = (Pair)grParameterArray;
                            boolean $i$f$forEach = false;
                            for (Pair element$iv : $this$forEach$iv) {
                                GrParameter it = (GrParameter)element$iv;
                                boolean bl = false;
                                PsiType psiType2 = it.getType();
                                Intrinsics.checkNotNullExpressionValue((Object)psiType2, (String)"getType(...)");
                                it.setType(InferenceProcessUtilKt.recursiveSubstitute$default(parameterSubstitutor, psiType2, 0, 2, null));
                            }
                            v2 = Unit.INSTANCE;
                        } else {
                            PsiTypeParameterList psiTypeParameterList = sourceMethod.getTypeParameterList();
                            Intrinsics.checkNotNull((Object)psiTypeParameterList);
                            v2 = sinkMethod.addAfter((PsiElement)psiTypeParameterList, sinkMethod.getFirstChild());
                        }
                    }
                    GrParameter[] grParameterArray = sinkMethod.getParameters();
                    Intrinsics.checkNotNullExpressionValue((Object)grParameterArray, (String)"getParameters(...)");
                    Object[] objectArray = grParameterArray;
                    GrParameter[] grParameterArray2 = sourceMethod.getParameters();
                    Intrinsics.checkNotNullExpressionValue((Object)grParameterArray2, (String)"getParameters(...)");
                    for (Pair $this$forEach$iv : ArraysKt.zip((Object[])objectArray, (Object[])grParameterArray2)) {
                        void $this$mapTo$iv$iv;
                        GrParameter actual = (GrParameter)$this$forEach$iv.component1();
                        GrParameter inferred = (GrParameter)$this$forEach$iv.component2();
                        actual.setType(inferred.getType());
                        actual.getModifierList().setModifierProperty("def", false);
                        if (actual.isVarArgs()) {
                            PsiElement psiElement = actual.getEllipsisDots();
                            Intrinsics.checkNotNull((Object)psiElement);
                            psiElement.delete();
                        }
                        PsiAnnotation[] psiAnnotationArray = actual.getAnnotations();
                        Intrinsics.checkNotNullExpressionValue((Object)psiAnnotationArray, (String)"getAnnotations(...)");
                        Object[] $this$map$iv = psiAnnotationArray;
                        boolean $i$f$map = false;
                        Object[] bl = $this$map$iv;
                        Collection destination$iv$iv = new ArrayList($this$map$iv.length);
                        boolean $i$f$mapTo = false;
                        for (void item$iv$iv : $this$mapTo$iv$iv) {
                            void it;
                            PsiAnnotation psiAnnotation = (PsiAnnotation)item$iv$iv;
                            Collection collection = destination$iv$iv;
                            boolean bl2 = false;
                            collection.add(it.getText());
                        }
                        List currentAnnotations = (List)destination$iv$iv;
                        PsiAnnotation[] psiAnnotationArray2 = inferred.getAnnotations();
                        Intrinsics.checkNotNullExpressionValue((Object)psiAnnotationArray2, (String)"getAnnotations(...)");
                        Object[] $this$forEach$iv2 = psiAnnotationArray2;
                        boolean $i$f$forEach = false;
                        for (Object element$iv : $this$forEach$iv2) {
                            PsiAnnotation anno;
                            PsiAnnotation it = (PsiAnnotation)element$iv;
                            boolean bl3 = false;
                            if (currentAnnotations.contains(it.getText())) continue;
                            GrModifierList grModifierList = actual.getModifierList();
                            String string = it.getText();
                            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
                            String string2 = string;
                            int n = 1;
                            String string3 = string2.substring(n);
                            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"substring(...)");
                            Intrinsics.checkNotNullExpressionValue((Object)grModifierList.addAnnotation(string3), (String)"addAnnotation(...)");
                            Intrinsics.checkNotNull((Object)anno, (String)"null cannot be cast to non-null type org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.modifiers.annotation.GrAnnotation");
                            PsiElement psiElement = ((GrAnnotation)anno).getOriginalElement();
                            Intrinsics.checkNotNull((Object)psiElement, (String)"null cannot be cast to non-null type org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElement");
                            GrReferenceAdjuster.shortenAllReferencesIn((GroovyPsiElement)psiElement);
                            PsiAnnotationMemberValue psiAnnotationMemberValue = anno.findAttributeValue("value");
                            string2 = psiAnnotationMemberValue != null ? psiAnnotationMemberValue.getReference() : null;
                            GrQualifiedReference grQualifiedReference = string2 instanceof GrQualifiedReference ? (GrQualifiedReference)((Object)string2) : null;
                            if (grQualifiedReference == null) continue;
                            GrReferenceAdjuster.shortenReference(grQualifiedReference);
                        }
                    }
                    PsiTypeParameter[] psiTypeParameterArray = sinkMethod.getTypeParameters();
                    Intrinsics.checkNotNullExpressionValue((Object)psiTypeParameterArray, (String)"getTypeParameters(...)");
                    Object[] $this$forEach$iv = psiTypeParameterArray;
                    boolean $i$f$forEach = false;
                    for (Object element$iv : $this$forEach$iv) {
                        PsiTypeParameter it = (PsiTypeParameter)element$iv;
                        boolean bl = false;
                        GrReferenceAdjuster.shortenAllReferencesIn((GroovyPsiElement)it.getOriginalElement());
                    }
                    if (sinkMethod.isConstructor() || sinkMethod.getReturnTypeElement() != null) break block15;
                    object = sinkMethod.getInferredReturnType();
                    if (object == null) break block16;
                    PsiType it = psiType = object;
                    boolean bl = false;
                    object = !Intrinsics.areEqual((Object)it, (Object)PsiTypes.nullType()) ? psiType : null;
                    if (object != null) break block17;
                }
                object = (PsiType)InferenceDriverUtilKt.getJavaLangObject(sinkMethod);
            }
            PsiType returnType = object;
            GrReferenceAdjuster.shortenAllReferencesIn(sinkMethod.setReturnType(returnType));
        }
        sinkMethod.getModifierList().setModifierProperty("def", false);
    }

    /*
     * WARNING - void declaration
     */
    private final PsiSubstitutor collectParameterSubstitutor(GrMethod virtualMethod) {
        void $this$mapTo$iv$iv;
        PsiTypeParameter[] psiTypeParameterArray = virtualMethod.getTypeParameters();
        Intrinsics.checkNotNullExpressionValue((Object)psiTypeParameterArray, (String)"getTypeParameters(...)");
        Object[] $this$map$iv = psiTypeParameterArray;
        boolean $i$f$map = false;
        Object[] objectArray = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.length);
        boolean $i$f$mapTo = false;
        for (void item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            PsiTypeParameter psiTypeParameter = (PsiTypeParameter)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            PsiClassType[] psiClassTypeArray = it.getExtendsListTypes();
            Intrinsics.checkNotNullExpressionValue((Object)psiClassTypeArray, (String)"getExtendsListTypes(...)");
            PsiClassType psiClassType = (PsiClassType)ArraysKt.firstOrNull((Object[])psiClassTypeArray);
            if (psiClassType == null) {
                psiClassType = InferenceDriverUtilKt.getJavaLangObject(virtualMethod);
            }
            collection.add(psiClassType);
        }
        List parameterTypes = (List)destination$iv$iv;
        PsiSubstitutor psiSubstitutor = PsiSubstitutor.EMPTY;
        Intrinsics.checkNotNullExpressionValue((Object)psiSubstitutor, (String)"EMPTY");
        PsiTypeParameter[] psiTypeParameterArray2 = virtualMethod.getTypeParameters();
        Intrinsics.checkNotNullExpressionValue((Object)psiTypeParameterArray2, (String)"getTypeParameters(...)");
        Collection $this$toTypedArray$iv = parameterTypes;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        return InferenceKt.putAll(psiSubstitutor, psiTypeParameterArray2, (PsiType[])thisCollection$iv.toArray(new PsiClassType[0]));
    }

    @Override
    @NotNull
    protected PsiElementPredicate getElementPredicate() {
        return InferMethodParametersTypesIntention::getElementPredicate$lambda$7;
    }

    @Override
    protected boolean isStopElement(@Nullable PsiElement element) {
        return element instanceof GrOpenBlock || element instanceof GrMethod || super.isStopElement(element);
    }

    @Override
    @NotNull
    public String getText() {
        String string = GroovyBundle.message("infer.method.parameters.types", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        return string;
    }

    @Override
    @NotNull
    public String getFamilyName() {
        String string = GroovyBundle.message("infer.method.parameters.types.for.method.declaration", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        return string;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean getElementPredicate$lambda$7(PsiElement element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        if (!(element instanceof GrMethod)) return false;
        if (element instanceof GrOpenBlock) return false;
        GrParameter[] grParameterArray = ((GrMethod)element).getParameters();
        Intrinsics.checkNotNullExpressionValue((Object)grParameterArray, (String)"getParameters(...)");
        Object[] $this$any$iv = grParameterArray;
        boolean $i$f$any = false;
        int n = 0;
        int n2 = $this$any$iv.length;
        while (n < n2) {
            Object element$iv = $this$any$iv[n];
            GrParameter it = (GrParameter)element$iv;
            boolean bl = false;
            if (it.getTypeElement() == null) {
                return true;
            }
            boolean bl2 = false;
            if (bl2) {
                return true;
            }
            ++n;
        }
        return false;
    }
}

