/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.util;

import com.intellij.lexer.Lexer;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.search.IndexPatternBuilder;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.groovydoc.parser.GroovyDocElementTypes;
import org.jetbrains.plugins.groovy.lang.lexer.GroovyLexer;
import org.jetbrains.plugins.groovy.lang.lexer.GroovyTokenTypes;
import org.jetbrains.plugins.groovy.lang.lexer.TokenSets;
import org.jetbrains.plugins.groovy.lang.psi.GroovyElementTypes;
import org.jetbrains.plugins.groovy.lang.psi.GroovyFile;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0012\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0012\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0010\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\f\u001a\u00020\rH\u0016\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/plugins/groovy/util/GroovyIndexPatternBuilder;", "Lcom/intellij/psi/impl/search/IndexPatternBuilder;", "<init>", "()V", "getIndexingLexer", "Lcom/intellij/lexer/Lexer;", "file", "Lcom/intellij/psi/PsiFile;", "getCommentTokenSet", "Lcom/intellij/psi/tree/TokenSet;", "getCommentStartDelta", "", "tokenType", "Lcom/intellij/psi/tree/IElementType;", "getCommentEndDelta", "getCharsAllowedInContinuationPrefix", "", "intellij.groovy.psi"})
public final class GroovyIndexPatternBuilder
implements IndexPatternBuilder {
    @Nullable
    public Lexer getIndexingLexer(@NotNull PsiFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        return file instanceof GroovyFile ? (Lexer)new GroovyLexer() : null;
    }

    @Nullable
    public TokenSet getCommentTokenSet(@NotNull PsiFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        return TokenSets.ALL_COMMENT_TOKENS;
    }

    public int getCommentStartDelta(@NotNull IElementType tokenType) {
        Intrinsics.checkNotNullParameter((Object)tokenType, (String)"tokenType");
        return Intrinsics.areEqual((Object)tokenType, (Object)GroovyElementTypes.SL_COMMENT) ? 2 : 0;
    }

    public int getCommentEndDelta(@NotNull IElementType tokenType) {
        Intrinsics.checkNotNullParameter((Object)tokenType, (String)"tokenType");
        return tokenType == GroovyTokenTypes.mML_COMMENT ? 2 : 0;
    }

    @NotNull
    public String getCharsAllowedInContinuationPrefix(@NotNull IElementType tokenType) {
        Intrinsics.checkNotNullParameter((Object)tokenType, (String)"tokenType");
        return Intrinsics.areEqual((Object)tokenType, (Object)GroovyElementTypes.ML_COMMENT) || Intrinsics.areEqual((Object)tokenType, (Object)GroovyDocElementTypes.GROOVY_DOC_COMMENT) ? "*" : "";
    }
}

