/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rdclient.editorActions.cwm;

import com.intellij.codeWithMe.ClientId;
import com.intellij.codeWithMe.ClientIdExKt;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.ex.ActionUtil;
import com.intellij.openapi.client.ClientAppSession;
import com.intellij.openapi.command.impl.ResetUndoHistoryToken;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.diagnostic.LoggerKt;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.jetbrains.rd.ide.model.RdCallEditorActionRequest;
import com.jetbrains.rd.ide.model.RdPatch;
import com.jetbrains.rd.ide.model.RdRequest;
import com.jetbrains.rd.ide.model.TextControlId;
import com.jetbrains.rd.ide.requests.ChangeScope;
import com.jetbrains.rd.ide.requests.PatchEngine;
import com.jetbrains.rd.ide.requests.RdPatchEngine;
import com.jetbrains.rd.util.string.IPrintableKt;
import com.jetbrains.rdclient.editors.FrontendTextControlHostKt;
import com.jetbrains.rdclient.patches.FrontendPatchEngineKt;
import com.jetbrains.rdclient.requests.FrontendAsyncRequestWithImmediateResult;
import com.jetbrains.rdclient.requests.FrontendRebaseSession;
import com.jetbrains.rdclient.services.AppLevelIdeBackend;
import java.lang.invoke.MethodHandles;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\b\u0016\u0018\u00002\u00020\u0001B1\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\b\u0010\n\u001a\u0004\u0018\u00010\u000b\u00a2\u0006\u0004\b\f\u0010\rJ\u0016\u0010\u0015\u001a\u00020\u00132\u0006\u0010\u0016\u001a\u00020\u0017H\u0096@\u00a2\u0006\u0002\u0010\u0018J\b\u0010\u0019\u001a\u00020\u001aH\u0016J\b\u0010\u001b\u001a\u00020\u0007H\u0014J\b\u0010\u001c\u001a\u00020\u001dH\u0016R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0014\u0010\u0012\u001a\u00020\u00138VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0014\u00a8\u0006\u001e"}, d2={"Lcom/jetbrains/rdclient/editorActions/cwm/FrontendCallEditorActionRequest;", "Lcom/jetbrains/rdclient/requests/FrontendAsyncRequestWithImmediateResult;", "patch", "Lcom/jetbrains/rd/ide/model/RdPatch;", "editorId", "Lcom/jetbrains/rd/ide/model/TextControlId;", "frontendActionId", "", "session", "Lcom/intellij/openapi/client/ClientAppSession;", "resetUndoHistoryToken", "Lcom/intellij/openapi/command/impl/ResetUndoHistoryToken;", "<init>", "(Lcom/jetbrains/rd/ide/model/RdPatch;Lcom/jetbrains/rd/ide/model/TextControlId;Ljava/lang/String;Lcom/intellij/openapi/client/ClientAppSession;Lcom/intellij/openapi/command/impl/ResetUndoHistoryToken;)V", "getEditorId", "()Lcom/jetbrains/rd/ide/model/TextControlId;", "getFrontendActionId", "()Ljava/lang/String;", "isBatchingAllowed", "", "()Z", "redo", "rebaseSession", "Lcom/jetbrains/rdclient/requests/FrontendRebaseSession;", "(Lcom/jetbrains/rdclient/requests/FrontendRebaseSession;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "createModel", "Lcom/jetbrains/rd/ide/model/RdRequest;", "debugDescription", "assertClientId", "", "intellij.rd.client"})
@SourceDebugExtension(value={"SMAP\nFrontendCallEditorActionRequest.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FrontendCallEditorActionRequest.kt\ncom/jetbrains/rdclient/editorActions/cwm/FrontendCallEditorActionRequest\n+ 2 PatchEngine.kt\ncom/jetbrains/rd/ide/requests/PatchEngineKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,76:1\n45#2,2:77\n48#2,3:80\n51#2,2:88\n53#2,8:91\n24#3:79\n58#3:83\n36#3,2:84\n83#3,2:86\n85#3:90\n*S KotlinDebug\n*F\n+ 1 FrontendCallEditorActionRequest.kt\ncom/jetbrains/rdclient/editorActions/cwm/FrontendCallEditorActionRequest\n*L\n41#1:77,2\n41#1:80,3\n41#1:88,2\n41#1:91,8\n41#1:79\n41#1:83\n41#1:84,2\n41#1:86,2\n41#1:90\n*E\n"})
public class FrontendCallEditorActionRequest
extends FrontendAsyncRequestWithImmediateResult {
    @NotNull
    private final TextControlId editorId;
    @NotNull
    private final String frontendActionId;

    public FrontendCallEditorActionRequest(@NotNull RdPatch patch, @NotNull TextControlId editorId, @NotNull String frontendActionId, @NotNull ClientAppSession session, @Nullable ResetUndoHistoryToken resetUndoHistoryToken) {
        Intrinsics.checkNotNullParameter((Object)patch, (String)"patch");
        Intrinsics.checkNotNullParameter((Object)editorId, (String)"editorId");
        Intrinsics.checkNotNullParameter((Object)frontendActionId, (String)"frontendActionId");
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        super(session, patch, resetUndoHistoryToken);
        this.editorId = editorId;
        this.frontendActionId = frontendActionId;
    }

    @NotNull
    public final TextControlId getEditorId() {
        return this.editorId;
    }

    @NotNull
    public final String getFrontendActionId() {
        return this.frontendActionId;
    }

    @Override
    public boolean isBatchingAllowed() {
        return true;
    }

    @Override
    @Nullable
    public Object redo(@NotNull FrontendRebaseSession rebaseSession, @NotNull Continuation<? super Boolean> $completion) {
        return FrontendCallEditorActionRequest.redo$suspendImpl(this, rebaseSession, $completion);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    static /* synthetic */ Object redo$suspendImpl(FrontendCallEditorActionRequest $this, FrontendRebaseSession rebaseSession, Continuation<? super Boolean> $completion) {
        RdPatch rdPatch;
        void $this$recordChanges$iv;
        Editor editor = FrontendTextControlHostKt.toEditorOrNull($this.editorId);
        EditorImpl editorImpl = editor instanceof EditorImpl ? (EditorImpl)editor : null;
        if (editorImpl == null) {
            return Boxing.boxBoolean((boolean)false);
        }
        EditorImpl editor2 = editorImpl;
        ResetUndoHistoryToken resetUndoHistoryToken = $this.getResetUndoHistoryToken();
        if (resetUndoHistoryToken != null) {
            resetUndoHistoryToken.refresh();
        }
        editor = FrontendPatchEngineKt.getEngine($this.getSession());
        String description$iv = "Redoing call editor action " + $this.frontendActionId;
        boolean $i$f$recordChanges = false;
        if ($this$recordChanges$iv.getHasActivePatch()) {
            void $this$thisLogger$iv$iv = $this$recordChanges$iv;
            boolean $i$f$thisLogger = false;
            Logger logger = Logger.getInstance(PatchEngine.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            logger.error("recordChanges must no be called under another patch, because it leads to recording and  sending the same patch multiple times");
        }
        try {
            RdPatch rdPatch2;
            AutoCloseable autoCloseable = (AutoCloseable)PatchEngine.openAccumulatingSession$default((PatchEngine)$this$recordChanges$iv, (boolean)false, (String)description$iv, null, (int)4, null);
            Throwable throwable = null;
            try {
                Object object;
                void $this$runAndLogException$iv$iv;
                RdPatchEngine.ChangeAccumulatingSessionToken it$iv2 = (RdPatchEngine.ChangeAccumulatingSessionToken)autoCloseable;
                boolean bl = false;
                boolean $i$f$fileLogger22 = false;
                boolean $i$f$currentClassLogger = false;
                Class<?> clazz$iv$iv$iv = MethodHandles.lookup().lookupClass();
                Logger logger = Logger.getInstance(clazz$iv$iv$iv);
                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
                Logger $i$f$fileLogger22 = logger;
                boolean $i$f$runAndLogException = false;
                void var14_20 = $this$runAndLogException$iv$iv;
                try {
                    void $this$runAndLogException_u24lambda_u240$iv$iv = var14_20;
                    boolean bl2 = false;
                    boolean bl3 = false;
                    ChangeScope $this$redo_u24lambda_u240 = it$iv2.getSession().getChangeScope();
                    boolean bl4 = false;
                    ActionManager actionManager = ActionManager.getInstance();
                    AnAction anAction = actionManager.getAction($this.frontendActionId);
                    if (anAction == null) {
                        throw new IllegalStateException(("Not found action id: " + $this.frontendActionId).toString());
                    }
                    AnAction action = anAction;
                    DataContext dataContext = editor2.getDataContext();
                    Intrinsics.checkNotNullExpressionValue((Object)dataContext, (String)"getDataContext(...)");
                    DataContext dataContext2 = dataContext;
                    AnActionEvent anActionEvent = AnActionEvent.createFromAnAction((AnAction)action, null, (String)"keyboard shortcut", (DataContext)dataContext2);
                    Intrinsics.checkNotNullExpressionValue((Object)anActionEvent, (String)"createFromAnAction(...)");
                    AnActionEvent actionEvent = anActionEvent;
                    ActionUtil.performActionDumbAwareWithCallbacks((AnAction)action, (AnActionEvent)actionEvent);
                    object = Result.constructor-impl((Object)Unit.INSTANCE);
                }
                catch (Throwable throwable2) {
                    object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable2));
                }
                LoggerKt.getOrLogException((Object)object, (Logger)$this$runAndLogException$iv$iv);
                rdPatch2 = it$iv2.getSession().getPatch();
            }
            catch (Throwable it$iv2) {
                try {
                    throwable = it$iv2;
                    throw it$iv2;
                }
                catch (Throwable it$iv2) {
                    AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, throwable);
                    throw it$iv2;
                }
            }
            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
            rdPatch = rdPatch2;
        }
        finally {
            if ($this$recordChanges$iv.getHasActivePatch()) {
                void $this$thisLogger$iv$iv = $this$recordChanges$iv;
                boolean $i$f$thisLogger = false;
                Logger logger = Logger.getInstance(PatchEngine.class);
                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
                logger.error("There are unclosed accumulating sessions after recordChanges. Close them forcibly");
                while ($this$recordChanges$iv.getHasActivePatch()) {
                    $this$recordChanges$iv.closeCurrentSession("Wrong dispose ordering: " + description$iv);
                }
            }
        }
        RdPatch patchAfterRedo2 = rdPatch;
        return Boxing.boxBoolean(($this.updatePatchAfterRedo(patchAfterRedo2) != null || $this.getStatus().isExecuting() ? 1 : 0) != 0);
    }

    @Override
    @NotNull
    public RdRequest createModel() {
        String backendActionId = AppLevelIdeBackend.Companion.getInstance().getBackendActionId(this.frontendActionId);
        return (RdRequest)new RdCallEditorActionRequest(backendActionId, this.editorId);
    }

    @Override
    @NotNull
    protected String debugDescription() {
        return "Call editor action=" + this.frontendActionId + " Patch: " + IPrintableKt.printToString((Object)this.getPatch());
    }

    @Override
    public void assertClientId() {
        ClientIdExKt.assertClientIdConsistency((ClientId)new ClientId(this.editorId.getClientId()), (String)(this.debugDescription() + "::" + this.editorId.getDocumentId()));
    }
}

