/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.project;

import com.intellij.execution.filters.Filter;
import com.intellij.execution.filters.HyperlinkInfo;
import com.intellij.execution.filters.OpenFileHyperlinkInfo;
import com.intellij.openapi.editor.colors.CodeInsightColors;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.markup.EffectType;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.JBColor;
import java.awt.Color;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractMavenConsoleFilter
implements Filter {
    private final Pattern myPattern;
    private final Project myProject;

    public AbstractMavenConsoleFilter(Project project, Pattern pattern) {
        this.myProject = project;
        this.myPattern = pattern;
    }

    protected abstract boolean lightCheck(String var1);

    @Nullable
    public Filter.Result applyFilter(@NotNull String line, int entireLength) {
        int lineNumber;
        if (line == null) {
            AbstractMavenConsoleFilter.$$$reportNull$$$0(0);
        }
        if (!this.lightCheck(line)) {
            return null;
        }
        Matcher matcher = this.myPattern.matcher(line);
        if (!matcher.matches()) {
            return null;
        }
        String path = matcher.group(1);
        VirtualFile file = LocalFileSystem.getInstance().findFileByPath(path);
        if (file == null) {
            if (SystemInfo.isWindows && path.matches("/[A-Z]:/.+")) {
                file = LocalFileSystem.getInstance().findFileByPath(path.substring(1));
            }
            if (file == null) {
                return null;
            }
        }
        if ((lineNumber = Integer.parseInt(matcher.group(2)) - 1) < 0) {
            lineNumber = -1;
        }
        TextAttributes attr = AbstractMavenConsoleFilter.createCompilationErrorAttr();
        return new Filter.Result(entireLength - line.length() + matcher.start(1), entireLength - line.length() + matcher.end(1), (HyperlinkInfo)new OpenFileHyperlinkInfo(this.myProject, file, lineNumber), attr);
    }

    private static TextAttributes createCompilationErrorAttr() {
        TextAttributes attr = EditorColorsManager.getInstance().getGlobalScheme().getAttributes(CodeInsightColors.HYPERLINK_ATTRIBUTES).clone();
        attr.setForegroundColor((Color)JBColor.RED);
        attr.setEffectColor((Color)JBColor.RED);
        attr.setEffectType(EffectType.LINE_UNDERSCORE);
        attr.setFontType(0);
        return attr;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "line", "org/jetbrains/idea/maven/project/AbstractMavenConsoleFilter", "applyFilter"));
    }
}

