/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.packageChecker.model.impl;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.packageChecker.inspection.VulnerableLibrariesLocalInspection;
import com.intellij.packageChecker.model.Dependency;
import com.intellij.packageChecker.model.ModuleModel;
import com.intellij.packageChecker.service.IgnorableDependenciesServiceKt;
import com.intellij.packageChecker.toolwindow.DependencyContext;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u001c\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0016\u0018\u00002\u00020\u0001B9\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u0012\u0006\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0004\b\r\u0010\u000eJ\u0014\u0010\u001f\u001a\u00020\u00002\f\u0010 \u001a\b\u0012\u0004\u0012\u00020\n0!J\u0013\u0010&\u001a\u00020'2\b\u0010(\u001a\u0004\u0018\u00010)H\u0096\u0002J\b\u0010*\u001a\u00020+H\u0016J\b\u0010,\u001a\u00020\u0003H\u0016R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0016\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0016\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R \u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\u0016\"\u0004\b\u0017\u0010\u0018R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u0019\u001a\u00020\u001a8VX\u0096\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001d\u0010\u001e\u001a\u0004\b\u001b\u0010\u001cR\u001e\u0010\"\u001a\f0\u0003\u00a2\u0006\u0002\b#\u00a2\u0006\u0002\b$X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b%\u0010\u0010\u00a8\u0006-"}, d2={"Lcom/intellij/packageChecker/model/impl/MutableModuleModel;", "Lcom/intellij/packageChecker/model/ModuleModel;", "id", "", "platformModule", "Lcom/intellij/openapi/module/Module;", "buildFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "dependencies", "", "Lcom/intellij/packageChecker/model/Dependency;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Ljava/lang/String;Lcom/intellij/openapi/module/Module;Lcom/intellij/openapi/vfs/VirtualFile;Ljava/util/Set;Lcom/intellij/openapi/project/Project;)V", "getId", "()Ljava/lang/String;", "getPlatformModule", "()Lcom/intellij/openapi/module/Module;", "getBuildFile", "()Lcom/intellij/openapi/vfs/VirtualFile;", "getDependencies", "()Ljava/util/Set;", "setDependencies", "(Ljava/util/Set;)V", "context", "Lcom/intellij/packageChecker/toolwindow/DependencyContext;", "getContext", "()Lcom/intellij/packageChecker/toolwindow/DependencyContext;", "context$delegate", "Lkotlin/Lazy;", "withDependencies", "dependencyList", "", "parentModuleName", "Lorg/jetbrains/annotations/NotNull;", "Lcom/intellij/openapi/util/NlsSafe;", "getParentModuleName", "equals", "", "other", "", "hashCode", "", "toString", "intellij.packageChecker"})
@SourceDebugExtension(value={"SMAP\nMutableModuleModel.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MutableModuleModel.kt\ncom/intellij/packageChecker/model/impl/MutableModuleModel\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,66:1\n827#2:67\n855#2,2:68\n*S KotlinDebug\n*F\n+ 1 MutableModuleModel.kt\ncom/intellij/packageChecker/model/impl/MutableModuleModel\n*L\n28#1:67\n28#1:68,2\n*E\n"})
public class MutableModuleModel
implements ModuleModel {
    @NotNull
    private final String id;
    @Nullable
    private final Module platformModule;
    @Nullable
    private final VirtualFile buildFile;
    @NotNull
    private Set<Dependency> dependencies;
    @NotNull
    private final Project project;
    @NotNull
    private final Lazy context$delegate;
    @NotNull
    private final String parentModuleName;

    public MutableModuleModel(@NotNull String id, @Nullable Module platformModule, @Nullable VirtualFile buildFile, @NotNull Set<Dependency> dependencies, @NotNull Project project) {
        String string;
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter(dependencies, (String)"dependencies");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.id = id;
        this.platformModule = platformModule;
        this.buildFile = buildFile;
        this.dependencies = dependencies;
        this.project = project;
        this.context$delegate = LazyKt.lazy(() -> MutableModuleModel.context_delegate$lambda$0(this));
        if (this.getBuildFile() != null) {
            VirtualFile virtualFile = this.getBuildFile();
            Intrinsics.checkNotNull((Object)virtualFile);
            string = ModuleUtilCore.findModuleForFile((VirtualFile)virtualFile, (Project)this.project);
            if (string == null || (string = string.getName()) == null) {
                string = this.getId();
            }
        } else {
            string = this.getId();
        }
        this.parentModuleName = string;
    }

    @Override
    @NotNull
    public String getId() {
        return this.id;
    }

    @Override
    @Nullable
    public Module getPlatformModule() {
        return this.platformModule;
    }

    @Override
    @Nullable
    public VirtualFile getBuildFile() {
        return this.buildFile;
    }

    @Override
    @NotNull
    public Set<Dependency> getDependencies() {
        return this.dependencies;
    }

    public void setDependencies(@NotNull Set<Dependency> set) {
        Intrinsics.checkNotNullParameter(set, (String)"<set-?>");
        this.dependencies = set;
    }

    @Override
    @NotNull
    public DependencyContext getContext() {
        Lazy lazy = this.context$delegate;
        return (DependencyContext)lazy.getValue();
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final MutableModuleModel withDependencies(@NotNull Iterable<Dependency> dependencyList) {
        Set set;
        Intrinsics.checkNotNullParameter(dependencyList, (String)"dependencyList");
        VulnerableLibrariesLocalInspection inspectionInstance = IgnorableDependenciesServiceKt.getInspectionInstanceIfIgnoringEnabled(this.project);
        if (inspectionInstance != null) {
            void $this$filterNotTo$iv$iv;
            Iterable<Dependency> $this$filterNot$iv = dependencyList;
            boolean $i$f$filterNot = false;
            Iterable<Dependency> iterable = $this$filterNot$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterNotTo = false;
            for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
                Dependency it = (Dependency)element$iv$iv;
                boolean bl = false;
                if (inspectionInstance.isIgnorable(it.getPkg(), this.getParentModuleName())) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            set = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
        } else {
            set = CollectionsKt.toSet(dependencyList);
        }
        Set dependencySet = set;
        return new MutableModuleModel(this.getId(), this.getPlatformModule(), this.getBuildFile(), dependencySet, this.project);
    }

    @Override
    @NotNull
    public String getParentModuleName() {
        return this.parentModuleName;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        Object object = other;
        if (!Intrinsics.areEqual(this.getClass(), object != null ? object.getClass() : null)) {
            return false;
        }
        Intrinsics.checkNotNull((Object)other, (String)"null cannot be cast to non-null type com.intellij.packageChecker.model.impl.MutableModuleModel");
        MutableModuleModel cfr_ignored_0 = (MutableModuleModel)other;
        return Intrinsics.areEqual((Object)this.getId(), (Object)((MutableModuleModel)other).getId()) && Intrinsics.areEqual((Object)this.getPlatformModule(), (Object)((MutableModuleModel)other).getPlatformModule()) && Intrinsics.areEqual((Object)this.getBuildFile(), (Object)((MutableModuleModel)other).getBuildFile()) && Intrinsics.areEqual(this.getDependencies(), ((MutableModuleModel)other).getDependencies());
    }

    public int hashCode() {
        Object[] objectArray = new Object[]{this.getId(), this.getPlatformModule(), this.getBuildFile()};
        return Objects.hash(objectArray);
    }

    @NotNull
    public String toString() {
        return "MutableModuleModel(id='" + this.getId() + "', platformModule=" + this.getPlatformModule() + ", buildFile=" + this.getBuildFile() + ")";
    }

    private static final DependencyContext context_delegate$lambda$0(MutableModuleModel this$0) {
        return new DependencyContext(this$0.project, this$0.getPlatformModule(), this$0.getBuildFile(), null, null);
    }
}

