/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.sa.jdi;

import com.jetbrains.sa.jdi.BooleanValueImpl;
import com.jetbrains.sa.jdi.ByteValueImpl;
import com.jetbrains.sa.jdi.CharValueImpl;
import com.jetbrains.sa.jdi.CompatibilityHelper;
import com.jetbrains.sa.jdi.DoubleValueImpl;
import com.jetbrains.sa.jdi.FloatValueImpl;
import com.jetbrains.sa.jdi.IntegerValueImpl;
import com.jetbrains.sa.jdi.LocationImpl;
import com.jetbrains.sa.jdi.LongValueImpl;
import com.jetbrains.sa.jdi.MethodImpl;
import com.jetbrains.sa.jdi.ObjectReferenceImpl;
import com.jetbrains.sa.jdi.ReferenceTypeImpl;
import com.jetbrains.sa.jdi.ShortValueImpl;
import com.jetbrains.sa.jdi.ThreadReferenceImpl;
import com.jetbrains.sa.jdi.ValueImpl;
import com.jetbrains.sa.jdi.VirtualMachineImpl;
import com.jetbrains.sa.jdi.VoidValueImpl;
import sun.jvm.hotspot.debugger.OopHandle;
import sun.jvm.hotspot.oops.Method;
import sun.jvm.hotspot.runtime.BasicType;
import sun.jvm.hotspot.runtime.JavaVFrame;
import sun.jvm.hotspot.runtime.StackValueCollection;
import sun.jvm.hotspot.utilities.Assert;

public class StackFrameImpl {
    private final boolean isValid = true;
    private final ThreadReferenceImpl thread;
    private final JavaVFrame saFrame;
    private StackValueCollection locals = null;
    private final int id;
    private final LocationImpl location;
    private ObjectReferenceImpl thisObject = null;

    StackFrameImpl(ThreadReferenceImpl thread, JavaVFrame jvf, int id) {
        this.thread = thread;
        this.saFrame = jvf;
        this.id = id;
        Method SAMethod = jvf.getMethod();
        ReferenceTypeImpl rt = thread.vm().referenceType(CompatibilityHelper.INSTANCE.getMethodHolder(SAMethod));
        this.location = new LocationImpl(rt, SAMethod, jvf.getBCI());
    }

    private void validateStackFrame() {
    }

    VirtualMachineImpl vm() {
        return this.thread.vm();
    }

    public int id() {
        return this.id;
    }

    public LocationImpl location() {
        this.validateStackFrame();
        return this.location;
    }

    public boolean equals(Object obj) {
        if (obj instanceof StackFrameImpl) {
            StackFrameImpl other = (StackFrameImpl)obj;
            return this.saFrame.equals((Object)other.saFrame);
        }
        return false;
    }

    public int hashCode() {
        return this.saFrame.hashCode();
    }

    public ObjectReferenceImpl thisObject() {
        this.validateStackFrame();
        MethodImpl currentMethod = this.location.method();
        if (currentMethod.isStatic() || currentMethod.isNative()) {
            return null;
        }
        if (this.thisObject == null) {
            StackValueCollection values = this.getLocals();
            if (Assert.ASSERTS_ENABLED) {
                Assert.that((values.size() > 0 ? 1 : 0) != 0, (String)"this is missing");
            }
            if (values.get(0).getType() == BasicType.getTConflict()) {
                return null;
            }
            this.thisObject = this.vm().objectMirror(values.oopHandleAt(0));
        }
        return this.thisObject;
    }

    private StackValueCollection getLocals() {
        if (this.locals == null) {
            this.locals = this.saFrame.getLocals();
        }
        return this.locals;
    }

    public int getAvailableSlots() {
        return this.getLocals().size();
    }

    public ValueImpl getSlotValue(int slot, byte sigbyte) {
        BasicType variableType = BasicType.charToBasicType((char)((char)sigbyte));
        return this.getSlotValue(this.getLocals(), variableType, slot);
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private ValueImpl getSlotValue(StackValueCollection values, BasicType variableType, int ss) {
        void var4_26;
        if (values.get(ss).getType() == BasicType.getTConflict()) {
            if (variableType == BasicType.T_BOOLEAN) {
                BooleanValueImpl booleanValueImpl = this.vm().mirrorOf(false);
                return var4_26;
            } else if (variableType == BasicType.T_CHAR) {
                CharValueImpl charValueImpl = this.vm().mirrorOf('\u0000');
                return var4_26;
            } else if (variableType == BasicType.T_FLOAT) {
                FloatValueImpl floatValueImpl = this.vm().mirrorOf(0.0f);
                return var4_26;
            } else if (variableType == BasicType.T_DOUBLE) {
                DoubleValueImpl doubleValueImpl = this.vm().mirrorOf(0.0);
                return var4_26;
            } else if (variableType == BasicType.T_BYTE) {
                ByteValueImpl byteValueImpl = this.vm().mirrorOf((byte)0);
                return var4_26;
            } else if (variableType == BasicType.T_SHORT) {
                ShortValueImpl shortValueImpl = this.vm().mirrorOf((short)0);
                return var4_26;
            } else if (variableType == BasicType.T_INT) {
                IntegerValueImpl integerValueImpl = this.vm().mirrorOf(0);
                return var4_26;
            } else if (variableType == BasicType.T_LONG) {
                LongValueImpl longValueImpl = this.vm().mirrorOf(0L);
                return var4_26;
            } else if (variableType == BasicType.T_OBJECT) {
                OopHandle handle = null;
                ObjectReferenceImpl objectReferenceImpl = this.vm().objectMirror(handle);
                return var4_26;
            } else if (variableType == BasicType.T_ARRAY) {
                OopHandle handle = null;
                ObjectReferenceImpl objectReferenceImpl = this.vm().objectMirror(handle);
                return var4_26;
            } else {
                if (variableType != BasicType.T_VOID) throw new RuntimeException("Should not read here");
                VoidValueImpl voidValueImpl = this.vm().voidVal;
            }
            return var4_26;
        } else if (variableType == BasicType.T_BOOLEAN) {
            BooleanValueImpl booleanValueImpl = this.vm().mirrorOf(values.booleanAt(ss));
            return var4_26;
        } else if (variableType == BasicType.T_CHAR) {
            CharValueImpl charValueImpl = this.vm().mirrorOf(values.charAt(ss));
            return var4_26;
        } else if (variableType == BasicType.T_FLOAT) {
            FloatValueImpl floatValueImpl = this.vm().mirrorOf(values.floatAt(ss));
            return var4_26;
        } else if (variableType == BasicType.T_DOUBLE) {
            DoubleValueImpl doubleValueImpl = this.vm().mirrorOf(values.doubleAt(ss));
            return var4_26;
        } else if (variableType == BasicType.T_BYTE) {
            ByteValueImpl byteValueImpl = this.vm().mirrorOf(values.byteAt(ss));
            return var4_26;
        } else if (variableType == BasicType.T_SHORT) {
            ShortValueImpl shortValueImpl = this.vm().mirrorOf(values.shortAt(ss));
            return var4_26;
        } else if (variableType == BasicType.T_INT) {
            IntegerValueImpl integerValueImpl = this.vm().mirrorOf(values.intAt(ss));
            return var4_26;
        } else if (variableType == BasicType.T_LONG) {
            LongValueImpl longValueImpl = this.vm().mirrorOf(values.longAt(ss));
            return var4_26;
        } else if (variableType == BasicType.T_OBJECT) {
            OopHandle handle = values.oopHandleAt(ss);
            ObjectReferenceImpl objectReferenceImpl = this.vm().objectMirror(handle);
            return var4_26;
        } else if (variableType == BasicType.T_ARRAY) {
            OopHandle handle = values.oopHandleAt(ss);
            ObjectReferenceImpl objectReferenceImpl = this.vm().objectMirror(handle);
            return var4_26;
        } else {
            if (variableType != BasicType.T_VOID) throw new RuntimeException("Should not read here");
            VoidValueImpl voidValueImpl = new VoidValueImpl();
        }
        return var4_26;
    }

    public String toString() {
        return this.location.toString() + " in thread " + this.thread.toString();
    }
}

