/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.editorActions.smartEnter;

import com.intellij.javadoc.AbstractBasicJavadocHelper;
import com.intellij.openapi.editor.CaretModel;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiFile;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractBasicJavadocFixer {
    private final AbstractBasicJavadocHelper myHelper;

    public AbstractBasicJavadocFixer(@NotNull AbstractBasicJavadocHelper helper) {
        if (helper == null) {
            AbstractBasicJavadocFixer.$$$reportNull$$$0(0);
        }
        this.myHelper = helper;
    }

    public boolean process(@NotNull Editor editor, @NotNull PsiFile psiFile) {
        if (editor == null) {
            AbstractBasicJavadocFixer.$$$reportNull$$$0(1);
        }
        if (psiFile == null) {
            AbstractBasicJavadocFixer.$$$reportNull$$$0(2);
        }
        CaretModel caretModel = editor.getCaretModel();
        Pair<AbstractBasicJavadocHelper.JavadocParameterInfo, List<AbstractBasicJavadocHelper.JavadocParameterInfo>> pair = this.myHelper.parse(psiFile, editor, caretModel.getOffset());
        if (pair.first == null) {
            return false;
        }
        AbstractBasicJavadocHelper.JavadocParameterInfo next = AbstractBasicJavadocFixer.findNext((Collection)pair.second, (AbstractBasicJavadocHelper.JavadocParameterInfo)pair.first);
        if (next == null) {
            int line = ((AbstractBasicJavadocHelper.JavadocParameterInfo)pair.first).lastLine + 1;
            Document document = editor.getDocument();
            if (line < document.getLineCount()) {
                StringBuilder indent = new StringBuilder();
                boolean insertIndent = true;
                CharSequence text = document.getCharsSequence();
                int max = document.getLineEndOffset(line);
                for (int i = document.getLineStartOffset(line); i < max; ++i) {
                    char c = text.charAt(i);
                    if (c != ' ' && c != '\t') {
                        if (c == '*') {
                            indent.append("* ");
                            if (i < max - 1 && text.charAt(i + 1) != '/') {
                                insertIndent = false;
                            }
                        }
                        indent.append("\n");
                        break;
                    }
                    indent.append(c);
                }
                if (insertIndent) {
                    document.insertString(document.getLineStartOffset(line), (CharSequence)indent);
                }
            }
            AbstractBasicJavadocFixer.moveCaretToTheLineEndIfPossible(editor, line);
            return true;
        }
        if (next.parameterDescriptionStartPosition != null) {
            this.myHelper.navigate(next.parameterDescriptionStartPosition, editor, psiFile.getProject());
        } else {
            LogicalPosition position = this.myHelper.calculateDescriptionStartPosition(psiFile, (Collection)pair.second, next);
            this.myHelper.navigate(position, editor, psiFile.getProject());
        }
        return true;
    }

    private static void moveCaretToTheLineEndIfPossible(@NotNull Editor editor, int line) {
        if (editor == null) {
            AbstractBasicJavadocFixer.$$$reportNull$$$0(3);
        }
        Document document = editor.getDocument();
        CaretModel caretModel = editor.getCaretModel();
        int offset = line >= document.getLineCount() ? document.getTextLength() : document.getLineEndOffset(line);
        caretModel.moveToOffset(offset);
    }

    @Nullable
    private static AbstractBasicJavadocHelper.JavadocParameterInfo findNext(@NotNull Collection<? extends AbstractBasicJavadocHelper.JavadocParameterInfo> data, @NotNull AbstractBasicJavadocHelper.JavadocParameterInfo anchor) {
        if (data == null) {
            AbstractBasicJavadocFixer.$$$reportNull$$$0(4);
        }
        if (anchor == null) {
            AbstractBasicJavadocFixer.$$$reportNull$$$0(5);
        }
        boolean returnNow = false;
        for (AbstractBasicJavadocHelper.JavadocParameterInfo javadocParameterInfo : data) {
            if (returnNow) {
                return javadocParameterInfo;
            }
            returnNow = javadocParameterInfo == anchor;
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "helper";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiFile";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "data";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "anchor";
                break;
            }
        }
        objectArray2[1] = "com/intellij/codeInsight/editorActions/smartEnter/AbstractBasicJavadocFixer";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "process";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "moveCaretToTheLineEndIfPossible";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "findNext";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

