/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rdserver.sshAgentProxy;

import com.intellij.openapi.diagnostic.Logger;
import com.jetbrains.codeWithMe.model.SshRequesterProcessInfo;
import com.jetbrains.rdserver.actions.ActionTimestamp;
import com.jetbrains.rdserver.portForwarding.utils.ProcessInfoUtil;
import com.jetbrains.rdserver.portForwarding.utils.WindowsProcessInfoUtil;
import com.jetbrains.rdserver.sshAgentProxy.SshAgentIpc;
import com.jetbrains.rdserver.sshAgentProxy.SshAgentIpcService;
import com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc;
import com.sun.jna.Native;
import com.sun.jna.Pointer;
import com.sun.jna.platform.win32.Kernel32;
import com.sun.jna.platform.win32.WinDef;
import com.sun.jna.platform.win32.WinNT;
import com.sun.jna.ptr.IntByReference;
import com.sun.jna.win32.W32APIOptions;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\u0018\u0000 '2\u00020\u0001:\u0005&'()*B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0011\u001a\u00020\u0012H\u0002J\b\u0010\u0013\u001a\u00020\u0012H\u0016J\b\u0010\u0017\u001a\u00020\u0018H\u0016J\u0006\u0010\u0019\u001a\u00020\u001aJ\u0010\u0010\u001b\u001a\u00020\u00152\u0006\u0010\u001c\u001a\u00020\u001dH\u0014J\b\u0010#\u001a\u00020\u0012H\u0002J\b\u0010$\u001a\u00020\u0012H\u0016J\b\u0010%\u001a\u00020\u0012H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0014\u001a\u00020\u00158VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0016R\u000e\u0010\u001e\u001a\u00020\u001fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010 \u001a\u00020\u001f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b!\u0010\"\u00a8\u0006+"}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc;", "Lcom/jetbrains/rdserver/sshAgentProxy/SshAgentIpc;", "pipePath", "", "WindowsNamedPipeAgentIpc", "(Ljava/lang/String;)V", "key", "getKey", "()Ljava/lang/String;", "hPipe", "Lcom/sun/jna/platform/win32/WinNT$HANDLE;", "lock", "", "connectionThread", "Ljava/lang/Thread;", "state", "Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$NamedPipeState;", "assertConnectionThread", "", "open", "isOpen", "", "()Z", "accept", "Lcom/jetbrains/rdserver/sshAgentProxy/SshAgentIpc$Streams;", "getRequesterPid", "", "isSshProcess", "process", "Lcom/jetbrains/rdserver/portForwarding/utils/ProcessInfoUtil$ProcessInfo;", "requestorProcessValue", "Lcom/jetbrains/codeWithMe/model/SshRequesterProcessInfo;", "requesterProcessInfo", "getRequesterProcessInfo", "()Lcom/jetbrains/codeWithMe/model/SshRequesterProcessInfo;", "disconnect", "close", "cleanup", "NamedPipeState", "Companion", "Kernel32Ex", "PipeReadableByteChannel", "PipeWritableByteChannel", "intellij.platform.backend.split"})
@SourceDebugExtension(value={"SMAP\nWindowsNamedPipeAgentIpc.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WindowsNamedPipeAgentIpc.kt\ncom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,391:1\n1#2:392\n24#3:393\n24#3:394\n24#3:395\n24#3:396\n24#3:397\n24#3:398\n24#3:399\n24#3:400\n24#3:401\n24#3:402\n24#3:403\n24#3:404\n24#3:405\n24#3:406\n24#3:407\n24#3:408\n*S KotlinDebug\n*F\n+ 1 WindowsNamedPipeAgentIpc.kt\ncom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc\n*L\n131#1:393\n142#1:394\n151#1:395\n161#1:396\n179#1:397\n203#1:398\n208#1:399\n228#1:400\n236#1:401\n238#1:402\n249#1:403\n264#1:404\n274#1:405\n284#1:406\n288#1:407\n290#1:408\n*E\n"})
public final class WindowsNamedPipeAgentIpc
extends SshAgentIpc {
    @NotNull
    public static final Companion Companion;
    @NotNull
    private final String pipePath;
    @NotNull
    private final String key;
    @NotNull
    private WinNT.HANDLE hPipe;
    @NotNull
    private final Object lock;
    @Nullable
    private Thread connectionThread;
    @NotNull
    private NamedPipeState state;
    @NotNull
    private SshRequesterProcessInfo requestorProcessValue;
    private static final String[] c;
    private static final String[] d;

    public WindowsNamedPipeAgentIpc(@NotNull String pipePath) {
        long l2 = 137755327034101L;
        Intrinsics.checkNotNullParameter((Object)pipePath, (String)WindowsNamedPipeAgentIpc.b(1454090580 - (char)-2575, -1454090580 - -((char)-12797), (int)l2));
        this.key = this.pipePath = pipePath;
        WinNT.HANDLE hANDLE = WinNT.INVALID_HANDLE_VALUE;
        Intrinsics.checkNotNullExpressionValue((Object)hANDLE, (String)WindowsNamedPipeAgentIpc.b(1454090580 - (char)-2574, 1453959510 + (char)-8633, (int)l2));
        this.hPipe = hANDLE;
        this.lock = new Object();
        this.state = NamedPipeState.Initial;
        this.requestorProcessValue = SshAgentIpc.Companion.getMissingProcessInfo();
    }

    @Override
    @NotNull
    public String getKey() {
        return this.key;
    }

    private final void assertConnectionThread() {
        block3: {
            boolean bl;
            Thread thread;
            long l2;
            block2: {
                l2 = 96331988826910L;
                thread = Thread.currentThread();
                boolean bl2 = SshAgentIpcService.Z();
                try {
                    bl = Intrinsics.areEqual((Object)thread, (Object)this.connectionThread);
                    if (!bl2) break block2;
                    if (bl) break block3;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                }
                bl = false;
            }
            boolean bl3 = bl;
            Thread thread2 = thread;
            Thread thread3 = this.connectionThread;
            String string = this.pipePath;
            String string2 = WindowsNamedPipeAgentIpc.b(-167376390 - -((char)-20336), 167376390 - (char)-7776, (int)l2) + string + WindowsNamedPipeAgentIpc.b(-167376390 - -((char)-20335), -167376390 - -((char)-30935), (int)l2) + thread3 + WindowsNamedPipeAgentIpc.b(-167376390 - -((char)-20334), -167376390 - -((char)-20583), (int)l2) + thread2;
            throw new IllegalArgumentException(string2.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void open() {
        block17: {
            boolean bl;
            block19: {
                block18: {
                    WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc;
                    boolean bl2;
                    long l2;
                    block15: {
                        block16: {
                            l2 = 49190464466606L;
                            Object object = this.lock;
                            synchronized (object) {
                                boolean bl3;
                                bl2 = SshAgentIpcService.C();
                                boolean bl4 = false;
                                try {
                                    bl3 = this.connectionThread == null;
                                }
                                catch (IllegalArgumentException illegalArgumentException) {
                                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                                }
                                if (!bl3) {
                                    boolean bl5 = false;
                                    String string = WindowsNamedPipeAgentIpc.b(-204075990 - -((char)-7405), -204075990 - -((char)-21745), (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-204075990 - -((char)-7404), -204075990 - -((char)-14707), (int)l2) + this.state;
                                    throw new IllegalArgumentException(string.toString());
                                }
                                this.connectionThread = Thread.currentThread();
                                Unit unit = Unit.INSTANCE;
                            }
                            try {
                                try {
                                    this.hPipe = Kernel32.INSTANCE.CreateNamedPipe(this.pipePath, 3, 0, 1, 16384, 16384, 0, null);
                                    windowsNamedPipeAgentIpc = this;
                                    if (bl2) break block15;
                                    if (Intrinsics.areEqual((Object)windowsNamedPipeAgentIpc.hPipe, (Object)WinNT.INVALID_HANDLE_VALUE)) {
                                    }
                                    break block16;
                                }
                                catch (IllegalArgumentException illegalArgumentException) {
                                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                                }
                                throw new RuntimeException(WindowsNamedPipeAgentIpc.b(-204075990 - -((char)-7403), -204075990 - -((char)-4146), (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-204075990 - -((char)-7418), -204075990 - -((char)-17814), (int)l2) + WindowsProcessInfoUtil.INSTANCE.kernel32LastError());
                            }
                            catch (IllegalArgumentException illegalArgumentException) {
                                throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                            }
                        }
                        this.state = NamedPipeState.Open;
                        windowsNamedPipeAgentIpc = this;
                    }
                    WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc2 = windowsNamedPipeAgentIpc;
                    boolean bl6 = false;
                    try {
                        try {
                            Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-204075990 - -((char)-7417), -204075990 - -((char)-11237), (int)l2));
                            logger.info(WindowsNamedPipeAgentIpc.b(-204075990 - -((char)-7403), -204075990 - -((char)-4146), (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-204075990 - -((char)-7416), -204075990 - -((char)-30412), (int)l2));
                            if (ActionTimestamp.C() == null) break block17;
                            if (!bl2) break block18;
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                        }
                        bl = false;
                        break block19;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                }
                bl = true;
            }
            SshAgentIpcService.C(bl);
        }
    }

    @Override
    public boolean isOpen() {
        int n2;
        block8: {
            block7: {
                boolean bl;
                block6: {
                    long l2 = 29914145602129L;
                    bl = SshAgentIpcService.C();
                    try {
                        try {
                            n2 = this.state.compareTo((Enum)NamedPipeState.Open);
                            if (bl) break block6;
                            if (n2 < 0) break block7;
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                        }
                        n2 = this.state.compareTo((Enum)NamedPipeState.Disconnecting);
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                }
                try {
                    if (bl) break block8;
                    if (n2 > 0) break block7;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                }
                n2 = 1;
                break block8;
            }
            n2 = 0;
        }
        return n2 != 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    @NotNull
    public SshAgentIpc.Streams accept() {
        SshAgentIpc.Streams streams;
        Object object;
        Object object2;
        boolean bl;
        long l2;
        block27: {
            block28: {
                l2 = 32908823319245L;
                boolean bl2 = SshAgentIpcService.C();
                this.assertConnectionThread();
                Object object3 = this.lock;
                bl = bl2;
                synchronized (object3) {
                    boolean bl3;
                    NamedPipeState namedPipeState;
                    NamedPipeState namedPipeState2;
                    block25: {
                        block26: {
                            boolean bl4 = false;
                            try {
                                namedPipeState2 = this.state;
                                namedPipeState = NamedPipeState.Closing;
                                if (bl) break block25;
                                if (namedPipeState2.compareTo((Enum)namedPipeState) < 0) break block26;
                            }
                            catch (IllegalArgumentException illegalArgumentException) {
                                throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                            }
                            WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc = this;
                            boolean bl5 = false;
                            Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-783929670 - -25750, -783929670 - -((char)-29770), (int)l2));
                            logger.info(WindowsNamedPipeAgentIpc.b(-783929670 - -25762, -783929670 - -22753, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-783929670 - -25757, -783929670 - -29555, (int)l2) + this.state);
                            throw new ClosedChannelException();
                        }
                        namedPipeState2 = this.state;
                        namedPipeState = NamedPipeState.Open;
                    }
                    try {
                        bl3 = namedPipeState2 == namedPipeState;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                    if (!bl3) {
                        boolean bl6 = false;
                        String string = WindowsNamedPipeAgentIpc.b(-783929670 - -25762, -783929670 - -22753, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-783929670 - -25756, -783929670 - -((char)-24356), (int)l2) + this.state;
                        throw new IllegalArgumentException(string.toString());
                    }
                    this.state = NamedPipeState.Connecting;
                    Unit unit = Unit.INSTANCE;
                }
                WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc = this;
                boolean bl7 = false;
                try {
                    Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-783929670 - -25750, -783929670 - -((char)-29770), (int)l2));
                    logger.info(WindowsNamedPipeAgentIpc.b(-783929670 - -25762, -783929670 - -22753, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-783929670 - -25755, 783929670 - 27407, (int)l2));
                    object2 = Kernel32.INSTANCE;
                    if (bl) break block27;
                    if (object2.ConnectNamedPipe(this.hPipe, null)) break block28;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                }
                int n2 = Kernel32.INSTANCE.GetLastError();
                if (n2 == 535) {
                    WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc2 = this;
                    boolean bl8 = false;
                    Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-783929670 - -25750, -783929670 - -((char)-29770), (int)l2));
                    logger.info(WindowsNamedPipeAgentIpc.b(-783929670 - -25762, -783929670 - -22753, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-783929670 - -25754, -783929670 - -((char)-15596), (int)l2));
                } else {
                    throw new IllegalStateException((WindowsNamedPipeAgentIpc.b(-783929670 - -25762, -783929670 - -22753, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-783929670 - -25745, -783929670 - -30137, (int)l2) + WindowsProcessInfoUtil.INSTANCE.prettyHRESULT(n2)).toString());
                }
            }
            object2 = this.lock;
        }
        Kernel32 kernel32 = object2;
        synchronized (kernel32) {
            boolean bl9;
            NamedPipeState namedPipeState;
            NamedPipeState namedPipeState3;
            block29: {
                block30: {
                    boolean bl10 = false;
                    namedPipeState3 = this.state;
                    namedPipeState = NamedPipeState.Closing;
                    if (bl) break block29;
                    try {
                        block31: {
                            if (namedPipeState3.compareTo((Enum)namedPipeState) < 0) break block30;
                            break block31;
                            catch (IllegalArgumentException illegalArgumentException) {
                                throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                            }
                        }
                        throw new ClosedChannelException();
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                }
                namedPipeState3 = this.state;
                namedPipeState = NamedPipeState.Connecting;
            }
            try {
                bl9 = namedPipeState3 == namedPipeState;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
            }
            if (!bl9) {
                boolean bl11 = false;
                String string = WindowsNamedPipeAgentIpc.b(-783929670 - -25762, -783929670 - -22753, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-783929670 - -25756, -783929670 - -((char)-24356), (int)l2) + this.state;
                throw new IllegalArgumentException(string.toString());
            }
            this.state = NamedPipeState.Connected;
            object = Unit.INSTANCE;
        }
        WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc = this;
        boolean bl12 = false;
        Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-783929670 - -25750, -783929670 - -((char)-29770), (int)l2));
        logger.info(WindowsNamedPipeAgentIpc.b(-783929670 - -25762, -783929670 - -22753, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-783929670 - -25744, 783929670 - (char)-18931, (int)l2));
        long l3 = this.getRequesterPid();
        this.requestorProcessValue = this.calcRequesterProcessInfo(l3);
        object = new PipeReadableByteChannel(this);
        PipeWritableByteChannel pipeWritableByteChannel = new PipeWritableByteChannel(this);
        try {
            streams = new SshAgentIpc.Streams((PipeReadableByteChannel)object, pipeWritableByteChannel, this){
                final /* synthetic */ PipeReadableByteChannel $read;
                final /* synthetic */ PipeWritableByteChannel $write;
                final /* synthetic */ WindowsNamedPipeAgentIpc this$0;
                private static final String[] a;
                private static final String[] b;
                {
                    this.$read = $read;
                    this.$write = $write;
                    this.this$0 = $receiver;
                }

                public InputStream getInputStream() {
                    long l2 = 75039442245528L;
                    InputStream inputStream = Channels.newInputStream(this.$read);
                    Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)accept.3.a(-2068677810 - -((char)-5686), -2068677810 - -((char)-15212), (int)l2));
                    return inputStream;
                }

                public OutputStream getOutputStream() {
                    long l2 = 2291572106078L;
                    OutputStream outputStream = Channels.newOutputStream(this.$write);
                    Intrinsics.checkNotNullExpressionValue((Object)outputStream, (String)accept.3.a(1940491350 - (char)-1417, 1940491350 - (char)-17624, (int)l2));
                    return outputStream;
                }

                public void close() {
                    WindowsNamedPipeAgentIpc.access$disconnect(this.this$0);
                }

                /*
                 * Unable to fully structure code
                 */
                static {
                    block13: {
                        var5 = new String[2];
                        var3_1 = 0;
                        var2_2 = ",*>u\u008d\u00ca\u00b8I>\u00c8<;\u00ae\u001c\u00aa\u00cc9\u00ecX\u0014\u0004\u0016;\u00f468\u00b2\u0092\u00fd\u00b5\u0081@\u00db\u008a\u00c5\u00959\u0001_\u0096";
                        var4_3 = ",*>u\u008d\u00ca\u00b8I>\u00c8<;\u00ae\u001c\u00aa\u00cc9\u00ecX\u0014\u0004\u0016;\u00f468\u00b2\u0092\u00fd\u00b5\u0081@\u00db\u008a\u00c5\u00959\u0001_\u0096".length();
                        var1_4 = 19;
                        var0_5 = -1;
lbl7:
                        // 2 sources

                        while (true) {
                            continue;
                            break;
                        }
lbl9:
                        // 1 sources

                        while (true) {
                            var5[var3_1++] = new String(v0).intern();
                            if ((var0_5 += var1_4) < var4_3) {
                                var1_4 = var2_2.charAt(var0_5);
                                ** continue;
                            }
                            break block13;
                            break;
                        }
                        v1 = ++var0_5;
                        v2 = var2_2.substring(v1, v1 + var1_4).toCharArray();
                        v3 = v2.length;
                        var6_6 = 0;
                        v4 = 32;
                        v5 = v2;
                        v6 = v3;
                        if (v3 > 1) ** GOTO lbl67
                        do {
                            v7 = v4;
                            v5 = v5;
                            v8 = v5;
                            v9 = v4;
                            v10 = var6_6;
                            while (true) {
                                switch (var6_6 % 7) {
                                    case 0: {
                                        v11 = 113;
                                        break;
                                    }
                                    case 1: {
                                        v11 = 46;
                                        break;
                                    }
                                    case 2: {
                                        v11 = 101;
                                        break;
                                    }
                                    case 3: {
                                        v11 = 81;
                                        break;
                                    }
                                    case 4: {
                                        v11 = 53;
                                        break;
                                    }
                                    case 5: {
                                        v11 = 122;
                                        break;
                                    }
                                    default: {
                                        v11 = 93;
                                    }
                                }
                                v8[v10] = (char)(v8[v10] ^ (v9 ^ v11));
                                ++var6_6;
                                v4 = v7;
                                if (v7 != 0) break;
                                v7 = v4;
                                v5 = v5;
                                v10 = v4;
                                v8 = v5;
                                v9 = v4;
                            }
lbl67:
                            // 2 sources

                            v0 = v5;
                            v6 = v6;
                        } while (v6 > var6_6);
                        ** while (true)
                    }
                    accept.3.a = var5;
                    accept.3.b = new String[2];
                }

                private static String a(int n2, int n3, int n4) {
                    int n5 = (n2 ^ n4 ^ 0xFFFFF280) & 0xFFFF;
                    if (b[n5] == null) {
                        int n6;
                        char[] cArray = a[n5].toCharArray();
                        int n7 = switch (cArray[0] & 0xFF) {
                            case 0 -> 168;
                            case 1 -> 221;
                            case 2 -> 63;
                            case 3 -> 196;
                            case 4 -> 12;
                            case 5 -> 167;
                            case 6 -> 59;
                            case 7 -> 48;
                            case 8 -> 152;
                            case 9 -> 4;
                            case 10 -> 127;
                            case 11 -> 161;
                            case 12 -> 136;
                            case 13 -> 217;
                            case 14 -> 39;
                            case 15 -> 78;
                            case 16 -> 228;
                            case 17 -> 119;
                            case 18 -> 213;
                            case 19 -> 18;
                            case 20 -> 13;
                            case 21 -> 220;
                            case 22 -> 52;
                            case 23 -> 214;
                            case 24 -> 82;
                            case 25 -> 188;
                            case 26 -> 34;
                            case 27 -> 101;
                            case 28 -> 159;
                            case 29 -> 149;
                            case 30 -> 207;
                            case 31 -> 151;
                            case 32 -> 57;
                            case 33 -> 170;
                            case 34 -> 43;
                            case 35 -> 17;
                            case 36 -> 216;
                            case 37 -> 16;
                            case 38 -> 26;
                            case 39 -> 69;
                            case 40 -> 169;
                            case 41 -> 23;
                            case 42 -> 41;
                            case 43 -> 243;
                            case 44 -> 147;
                            case 45 -> 44;
                            case 46 -> 144;
                            case 47 -> 124;
                            case 48 -> 28;
                            case 49 -> 46;
                            case 50 -> 145;
                            case 51 -> 160;
                            case 52 -> 224;
                            case 53 -> 42;
                            case 54 -> 40;
                            case 55 -> 83;
                            case 56 -> 0;
                            case 57 -> 138;
                            case 58 -> 239;
                            case 59 -> 141;
                            case 60 -> 227;
                            case 61 -> 208;
                            case 62 -> 24;
                            case 63 -> 210;
                            case 64 -> 111;
                            case 65 -> 183;
                            case 66 -> 226;
                            case 67 -> 102;
                            case 68 -> 95;
                            case 69 -> 176;
                            case 70 -> 233;
                            case 71 -> 15;
                            case 72 -> 179;
                            case 73 -> 229;
                            case 74 -> 137;
                            case 75 -> 19;
                            case 76 -> 191;
                            case 77 -> 114;
                            case 78 -> 253;
                            case 79 -> 212;
                            case 80 -> 247;
                            case 81 -> 198;
                            case 82 -> 64;
                            case 83 -> 45;
                            case 84 -> 242;
                            case 85 -> 53;
                            case 86 -> 236;
                            case 87 -> 255;
                            case 88 -> 66;
                            case 89 -> 189;
                            case 90 -> 218;
                            case 91 -> 54;
                            case 92 -> 113;
                            case 93 -> 193;
                            case 94 -> 195;
                            case 95 -> 202;
                            case 96 -> 47;
                            case 97 -> 182;
                            case 98 -> 38;
                            case 99 -> 249;
                            case 100 -> 199;
                            case 101 -> 187;
                            case 102 -> 25;
                            case 103 -> 11;
                            case 104 -> 120;
                            case 105 -> 204;
                            case 106 -> 88;
                            case 107 -> 49;
                            case 108 -> 71;
                            case 109 -> 254;
                            case 110 -> 132;
                            case 111 -> 6;
                            case 112 -> 206;
                            case 113 -> 77;
                            case 114 -> 246;
                            case 115 -> 163;
                            case 116 -> 186;
                            case 117 -> 211;
                            case 118 -> 74;
                            case 119 -> 84;
                            case 120 -> 7;
                            case 121 -> 30;
                            case 122 -> 14;
                            case 123 -> 50;
                            case 124 -> 93;
                            case 125 -> 103;
                            case 126 -> 184;
                            case 127 -> 192;
                            case 128 -> 175;
                            case 129 -> 142;
                            case 130 -> 10;
                            case 131 -> 171;
                            case 132 -> 35;
                            case 133 -> 190;
                            case 134 -> 33;
                            case 135 -> 109;
                            case 136 -> 241;
                            case 137 -> 126;
                            case 138 -> 91;
                            case 139 -> 205;
                            case 140 -> 252;
                            case 141 -> 86;
                            case 142 -> 115;
                            case 143 -> 21;
                            case 144 -> 97;
                            case 145 -> 55;
                            case 146 -> 135;
                            case 147 -> 3;
                            case 148 -> 27;
                            case 149 -> 158;
                            case 150 -> 128;
                            case 151 -> 116;
                            case 152 -> 230;
                            case 153 -> 133;
                            case 154 -> 118;
                            case 155 -> 73;
                            case 156 -> 223;
                            case 157 -> 100;
                            case 158 -> 203;
                            case 159 -> 150;
                            case 160 -> 245;
                            case 161 -> 153;
                            case 162 -> 31;
                            case 163 -> 177;
                            case 164 -> 157;
                            case 165 -> 117;
                            case 166 -> 89;
                            case 167 -> 65;
                            case 168 -> 79;
                            case 169 -> 96;
                            case 170 -> 180;
                            case 171 -> 122;
                            case 172 -> 134;
                            case 173 -> 112;
                            case 174 -> 143;
                            case 175 -> 173;
                            case 176 -> 174;
                            case 177 -> 106;
                            case 178 -> 166;
                            case 179 -> 22;
                            case 180 -> 172;
                            case 181 -> 62;
                            case 182 -> 61;
                            case 183 -> 164;
                            case 184 -> 219;
                            case 185 -> 215;
                            case 186 -> 197;
                            case 187 -> 104;
                            case 188 -> 154;
                            case 189 -> 123;
                            case 190 -> 209;
                            case 191 -> 2;
                            case 192 -> 105;
                            case 193 -> 75;
                            case 194 -> 99;
                            case 195 -> 37;
                            case 196 -> 146;
                            case 197 -> 98;
                            case 198 -> 56;
                            case 199 -> 148;
                            case 200 -> 94;
                            case 201 -> 222;
                            case 202 -> 9;
                            case 203 -> 5;
                            case 204 -> 72;
                            case 205 -> 156;
                            case 206 -> 140;
                            case 207 -> 107;
                            case 208 -> 60;
                            case 209 -> 108;
                            case 210 -> 90;
                            case 211 -> 165;
                            case 212 -> 36;
                            case 213 -> 139;
                            case 214 -> 58;
                            case 215 -> 251;
                            case 216 -> 80;
                            case 217 -> 244;
                            case 218 -> 181;
                            case 219 -> 130;
                            case 220 -> 70;
                            case 221 -> 110;
                            case 222 -> 240;
                            case 223 -> 129;
                            case 224 -> 81;
                            case 225 -> 225;
                            case 226 -> 67;
                            case 227 -> 51;
                            case 228 -> 237;
                            case 229 -> 194;
                            case 230 -> 87;
                            case 231 -> 121;
                            case 232 -> 131;
                            case 233 -> 68;
                            case 234 -> 92;
                            case 235 -> 162;
                            case 236 -> 235;
                            case 237 -> 20;
                            case 238 -> 8;
                            case 239 -> 234;
                            case 240 -> 178;
                            case 241 -> 248;
                            case 242 -> 1;
                            case 243 -> 125;
                            case 244 -> 231;
                            case 245 -> 200;
                            case 246 -> 232;
                            case 247 -> 29;
                            case 248 -> 250;
                            case 249 -> 32;
                            case 250 -> 85;
                            case 251 -> 201;
                            case 252 -> 185;
                            case 253 -> 238;
                            case 254 -> 76;
                            default -> 155;
                        };
                        int n8 = ((n3 ^= n4) & 0xFF) - n7;
                        if (n8 < 0) {
                            n8 += 256;
                        }
                        if ((n6 = ((n3 & 0xFFFF) >>> 8) - n7) < 0) {
                            n6 += 256;
                        }
                        int n9 = 0;
                        while (n9 < cArray.length) {
                            int n10 = n9 % 2;
                            int n11 = n9;
                            char[] cArray2 = cArray;
                            char c2 = cArray[n11];
                            if (n10 == 0) {
                                cArray2[n11] = (char)(c2 ^ n8);
                                n8 = ((n8 >>> 3 | n8 << 5) ^ cArray[n9]) & 0xFF;
                            } else {
                                cArray2[n11] = (char)(c2 ^ n6);
                                n6 = ((n6 >>> 3 | n6 << 5) ^ cArray[n9]) & 0xFF;
                            }
                            ++n9;
                        }
                        accept.3.b[n5] = new String(cArray).intern();
                    }
                    return b[n5];
                }
            };
            if (bl) {
                ActionTimestamp.C(new ActionTimestamp[5]);
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
        }
        return streams;
    }

    public final long getRequesterPid() {
        long l2;
        block4: {
            boolean bl;
            WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc;
            int n2;
            long l3;
            block2: {
                block3: {
                    l3 = 28026393437914L;
                    WinDef.ULONGByReference uLONGByReference = new WinDef.ULONGByReference();
                    boolean bl2 = SshAgentIpcService.C();
                    try {
                        n2 = Kernel32.INSTANCE.GetNamedPipeClientProcessId(this.hPipe, uLONGByReference);
                        if (bl2) break block2;
                        if (n2 == 0) break block3;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                    WinDef.ULONG uLONG = uLONGByReference.getValue();
                    windowsNamedPipeAgentIpc = this;
                    bl = false;
                    Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-1731827910 - -13, -1731827910 + -6355, (int)l3));
                    logger.info(WindowsNamedPipeAgentIpc.b(-1731827910 - -17, -1731827910 - -3154, (int)l3) + this.pipePath + WindowsNamedPipeAgentIpc.b(-1731827910 - -36, 1731827910 - 3240, (int)l3) + uLONG);
                    l2 = uLONGByReference.getValue().longValue();
                    break block4;
                }
                n2 = Kernel32.INSTANCE.GetLastError();
            }
            int n3 = n2;
            windowsNamedPipeAgentIpc = this;
            bl = false;
            Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-1731827910 - -13, -1731827910 + -6355, (int)l3));
            logger.warn(WindowsNamedPipeAgentIpc.b(-1731827910 - -17, -1731827910 - -3154, (int)l3) + this.pipePath + WindowsNamedPipeAgentIpc.b(-1731827910 - -37, -1731827910 + -1743, (int)l3) + WindowsProcessInfoUtil.INSTANCE.prettyHRESULT(n3));
            l2 = -1L;
        }
        long l4 = l2;
        return l4;
    }

    @Override
    protected boolean isSshProcess(@NotNull ProcessInfoUtil.ProcessInfo process2) {
        boolean bl;
        block14: {
            block12: {
                block15: {
                    String string;
                    Object object;
                    boolean bl2;
                    block13: {
                        long l2 = 13411935578490L;
                        boolean bl3 = SshAgentIpcService.Z();
                        Intrinsics.checkNotNullParameter((Object)process2, (String)WindowsNamedPipeAgentIpc.b(1247262120 + 29520, 1247262120 + (char)-20805, (int)l2));
                        bl2 = bl3;
                        try {
                            try {
                                try {
                                    try {
                                        if (!bl2 || (object = process2.getExecutable()) == null) break block12;
                                    }
                                    catch (IllegalArgumentException illegalArgumentException) {
                                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                                    }
                                    if ((object = object.getFileName()) == null) break block12;
                                }
                                catch (IllegalArgumentException illegalArgumentException) {
                                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                                }
                                String string2 = object.toString();
                                string = string2;
                                object = string2;
                                if (!bl2) break block13;
                            }
                            catch (IllegalArgumentException illegalArgumentException) {
                                throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                            }
                            if (string == null) break block12;
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                        }
                        string = WindowsNamedPipeAgentIpc.b(1247262120 + 29521, -1247262120 + -((char)-14599), (int)l2);
                    }
                    try {
                        try {
                            bl = StringsKt.equals((String)object, (String)string, (boolean)true);
                            if (!bl2) break block14;
                            if (!bl) break block15;
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                        }
                        bl = true;
                        break block14;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                }
                bl = false;
                break block14;
            }
            bl = false;
        }
        return bl;
    }

    @Override
    @NotNull
    public SshRequesterProcessInfo getRequesterProcessInfo() {
        return this.requestorProcessValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private final void disconnect() {
        Object object;
        WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc;
        boolean bl;
        long l2;
        block25: {
            block26: {
                l2 = 89842007717352L;
                this.assertConnectionThread();
                Object object2 = this.lock;
                bl = SshAgentIpcService.Z();
                synchronized (object2) {
                    boolean bl2;
                    NamedPipeState namedPipeState;
                    NamedPipeState namedPipeState2;
                    block23: {
                        block24: {
                            block21: {
                                block22: {
                                    boolean bl3 = false;
                                    namedPipeState2 = this.state;
                                    namedPipeState = NamedPipeState.Closing;
                                    if (!bl) break block21;
                                    try {
                                        block29: {
                                            if (namedPipeState2.compareTo((Enum)namedPipeState) < 0) break block22;
                                            break block29;
                                            catch (IllegalArgumentException illegalArgumentException) {
                                                throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                                            }
                                        }
                                        throw new ClosedChannelException();
                                    }
                                    catch (IllegalArgumentException illegalArgumentException) {
                                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                                    }
                                }
                                namedPipeState2 = this.state;
                                namedPipeState = NamedPipeState.Open;
                            }
                            try {
                                if (!bl) break block23;
                                if (namedPipeState2 != namedPipeState) break block24;
                            }
                            catch (IllegalArgumentException illegalArgumentException) {
                                throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                            }
                            WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc2 = this;
                            boolean bl4 = false;
                            Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(118225140 - (char)-31617, 118225140 - (char)-25697, (int)l2));
                            logger.info(WindowsNamedPipeAgentIpc.b(118225140 - (char)-31621, 118225140 - (char)-26570, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(118225140 - (char)-31604, 118225140 - (char)-29824, (int)l2));
                            return;
                        }
                        namedPipeState2 = this.state;
                        namedPipeState = NamedPipeState.Connected;
                    }
                    try {
                        bl2 = namedPipeState2 == namedPipeState;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                    if (!bl2) {
                        boolean bl5 = false;
                        String string = WindowsNamedPipeAgentIpc.b(118225140 - (char)-31621, 118225140 - (char)-26570, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(118225140 - (char)-31615, 118225140 - (char)-12223, (int)l2) + this.state;
                        throw new IllegalArgumentException(string.toString());
                    }
                    this.state = NamedPipeState.Disconnecting;
                    Unit unit = Unit.INSTANCE;
                }
                windowsNamedPipeAgentIpc = this;
                boolean bl6 = false;
                try {
                    Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(118225140 - (char)-31617, 118225140 - (char)-25697, (int)l2));
                    logger.info(WindowsNamedPipeAgentIpc.b(118225140 - (char)-31621, 118225140 - (char)-26570, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(118225140 - (char)-31605, 118225140 - (char)-4675, (int)l2));
                    object = Kernel32.INSTANCE;
                    if (!bl) break block25;
                    if (object.DisconnectNamedPipe(this.hPipe)) break block26;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                }
                windowsNamedPipeAgentIpc = this;
                bl6 = false;
                Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(118225140 - (char)-31617, 118225140 - (char)-25697, (int)l2));
                logger.warn(WindowsNamedPipeAgentIpc.b(118225140 - (char)-31621, 118225140 - (char)-26570, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(118225140 - (char)-31602, -118225140 - -((char)-19283), (int)l2) + WindowsProcessInfoUtil.INSTANCE.kernel32LastError());
                return;
            }
            object = this.lock;
        }
        Kernel32 kernel32 = object;
        synchronized (kernel32) {
            block27: {
                WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc3;
                block28: {
                    boolean bl7 = false;
                    windowsNamedPipeAgentIpc3 = this;
                    if (!bl) break block27;
                    try {
                        block30: {
                            if (windowsNamedPipeAgentIpc3.state.compareTo((Enum)NamedPipeState.Closing) < 0) break block28;
                            break block30;
                            catch (IllegalArgumentException illegalArgumentException) {
                                throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                            }
                        }
                        throw new ClosedChannelException();
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                }
                windowsNamedPipeAgentIpc3 = this;
            }
            windowsNamedPipeAgentIpc3.state = NamedPipeState.Open;
            Unit unit = Unit.INSTANCE;
        }
        windowsNamedPipeAgentIpc = this;
        boolean bl8 = false;
        Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(118225140 - (char)-31617, 118225140 - (char)-25697, (int)l2));
        logger.info(WindowsNamedPipeAgentIpc.b(118225140 - (char)-31621, 118225140 - (char)-26570, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(118225140 - (char)-31603, -118225140 - -((char)-8710), (int)l2));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        block17: {
            int n2;
            boolean bl;
            WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc;
            long l2;
            block15: {
                boolean bl2;
                block16: {
                    l2 = 67026757199104L;
                    Object object = this.lock;
                    bl2 = SshAgentIpcService.C();
                    synchronized (object) {
                        block13: {
                            WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc2;
                            block14: {
                                boolean bl3 = false;
                                try {
                                    windowsNamedPipeAgentIpc2 = this;
                                    if (bl2) break block13;
                                    if (windowsNamedPipeAgentIpc2.state.compareTo((Enum)NamedPipeState.Closing) < 0) break block14;
                                }
                                catch (IllegalArgumentException illegalArgumentException) {
                                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                                }
                                WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc3 = this;
                                boolean bl4 = false;
                                Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(502391310 + (char)-32113, 502391310 + 27567, (int)l2));
                                logger.info(WindowsNamedPipeAgentIpc.b(502391310 + (char)-32125, 502391310 + (char)-29112, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(502391310 + (char)-32130, 502391310 + 14433, (int)l2) + this.state + WindowsNamedPipeAgentIpc.b(502391310 + (char)-32129, -502391310 + -27788, (int)l2));
                                return;
                            }
                            windowsNamedPipeAgentIpc2 = this;
                        }
                        windowsNamedPipeAgentIpc2.state = NamedPipeState.Closing;
                        Unit unit = Unit.INSTANCE;
                    }
                    WindowsNamedPipeAgentIpc.Companion.connectToPipe(this.pipePath);
                    windowsNamedPipeAgentIpc = this;
                    bl = false;
                    try {
                        try {
                            Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(502391310 + (char)-32113, 502391310 + 27567, (int)l2));
                            logger.info(WindowsNamedPipeAgentIpc.b(502391310 + (char)-32125, 502391310 + (char)-29112, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(502391310 + (char)-32132, 502391310 + 21770, (int)l2));
                            n2 = Kernel32Ex.Companion.getINSTANCE().CancelIoEx(this.hPipe, null);
                            if (bl2) break block15;
                            if (n2 != 0) break block16;
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                        }
                        n2 = Kernel32.INSTANCE.GetLastError();
                        if (bl2) break block15;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                    int n3 = n2;
                    if (n3 != 1168) {
                        WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc4 = this;
                        boolean bl5 = false;
                        Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(502391310 + (char)-32113, 502391310 + 27567, (int)l2));
                        logger.info(WindowsNamedPipeAgentIpc.b(502391310 + (char)-32125, 502391310 + (char)-29112, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(502391310 + (char)-32131, -502391310 + -7856, (int)l2) + WindowsProcessInfoUtil.INSTANCE.prettyHRESULT(n3));
                    }
                }
                windowsNamedPipeAgentIpc = this;
                bl = false;
                try {
                    Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(502391310 + (char)-32113, 502391310 + 27567, (int)l2));
                    logger.info(WindowsNamedPipeAgentIpc.b(502391310 + (char)-32125, 502391310 + (char)-29112, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(502391310 + (char)-32134, -502391310 + -17798, (int)l2));
                    if (bl2) break block17;
                    n2 = Kernel32.INSTANCE.CloseHandle(this.hPipe) ? 1 : 0;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                }
            }
            if (n2 == 0) {
                windowsNamedPipeAgentIpc = this;
                bl = false;
                Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(502391310 + (char)-32113, 502391310 + 27567, (int)l2));
                logger.warn(WindowsNamedPipeAgentIpc.b(502391310 + (char)-32125, 502391310 + (char)-29112, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(502391310 + (char)-32133, 502391310 + (char)-26593, (int)l2) + WindowsProcessInfoUtil.INSTANCE.kernel32LastError());
            }
            this.hPipe = WinNT.INVALID_HANDLE_VALUE;
            this.state = NamedPipeState.Closed;
        }
    }

    @Override
    public void cleanup() {
    }

    public static final /* synthetic */ String access$getPipePath$p(WindowsNamedPipeAgentIpc $this) {
        return $this.pipePath;
    }

    /*
     * Unable to fully structure code
     */
    static {
        block20: {
            block19: {
                var5 = new String[32];
                var3_1 = 0;
                var2_2 = "PU\u00b7U\u00a7\u00fc\u00ffx\u0014\u00e0h\u0099\u0015\u009c|7rr\b\u009fS\u00c6\u00c6\u0080sV`\u0089r\u0006\u000e\u0014|}\u00b4\u00b8\u0018\u0016\u0004'\u00a8\u00c9\u000e\u009f\u00fc\u00af\u00a4+\u00b66\u0085\u00cc\u0099vT\u00a3i\u00ec\u0085\u0013\u00f7\t+\u00f4\u001e\u0007\u0085d\u000e\u00f9\u00a1\u0005\u00fb\u00f4\u00c2ay\b\u00e2\u0003\u00e1\u00ee?\u00ad\u00ea\u00b0\u0005Y\u00d9\u0096\u00c4\u00f3\u001e\u00c4\u00140\u0019\u00ba\u00fcS\u00d8\u00934\u00e7#\u00e3\u0017\u00d4\u00af\u0094\u0003-w\u0091i\u00b0\u00a7\u0090\u0003s\u0016\u00e2m\u0010Wn\u00a6\u0093?\u009f\u0015M&4\u00dc\u00de\u0082\u00fdWm\t U\u00a9\" \u00e7\u009c\u0016\u001d\u0010\"\u0005\b\u00fe\u00ea2\u00af\u00f8q\u00826\b\u00df'\u00fc6?xj\u00af\u00d6D\f\t\u00aa\u00a9\u00ab\u00e5+\u001c\u00e0\u0016h\t\u009e\u00e3\u0001\u00c6\u00f5!R\u00b2U:h\u00fc\u00f4\u00ab\u0016\u00a8cx\u00ce\u008d\u0081\u001cl\u00f2\u0003V5\u0018[\u00b0B\u0091\u0011e\u00bf\u0018\u00f7@\u008b\u0010\u00f9\u00e1\u009d\u00cde[\bl(0\u008b\u0005\u0001\u00ad%\f}1\u0002\u00b3^d(\u008e\u00a8\u0004_\u00dcFn\u00cc`\f\u0012\u0093\u00a1p\u0099\u00d7sbX\u00c1\u0081j\u0007\u00b9\"J\u00ec\u00ceg\u0007L\u00d4\u0016S\u00c6\u00ba\u00d6\u00e3;k\u00c8\u00eeA\u00c8.\u0081'\u00abg\u00db\u00e0\u0003\u00fb4\u001f'\u00d2\u00d3\u0001\u00ecu\u00f3)\u0082PN\u00c8v\u00a7\u00e6\u00cc\u00cb\u00de\u0087\u000f\u00f4\u001f\u000e\u00c4i\u0003\u0091\u00bf6\u00b0?9r\u0082Q>\u0089;DyJ\u00f2\u00b6Y\u0083\n\u0097f\u0084v\u0001\u0090,\u000b\u0085<\u001d\u0012\u00bdPT\b'\u00d8\u00a4\u0015?\u00dbJ\u00edP\u00c7\u0005\u00873\u00c9\u00eeW|(1\u00af\u00a8\u007f\nK\u0088)\u00ad\u0084\u001d\u000b\u001f\u00be\u00e7\u0090\u0005=5\u0002\u00bd$\u008a}{9v]\u00c1\u00d4\u00ab\u00a3\u00fd\u001a\u001e\u0081}\u009a!\u00d9;\u0089\u00ae?\u0093\u00ef\u00ff\u00cc\u00be\u0007c\u00f5\u00ce?Ae\u00b7\u0007\u00f25\u0098Kl\u0004\u0004(\u009f\u0012\u0017\u00f8\u00ee\u00aa/5l^2X~\u00ee\u00b0\u00a7;\u00cf\u00d0\u00c0tYr\u00d9V\u00e9\u00dd\u00842Z\u0013\u00d8\u0086\u00c2\u0087\u00fb\f\n\u009f\u0083\u000f\u0088\u00a9\u00bb\u00a6\u0093\r%\u0002X5\u0015d:=\u00a6\"\u00f07\u00b6}jpII\u00d0\u0006\u008fe\u00e9\u00c4d\u00afMJ:q\u00a2QgC\u00f7R\u0092V\u00c8R5\u00c7\u0097\u00b9\u000e\u00a95\u009f5\u0017\u007f\u00b5LJ\u00fcW]~\u0010\u001b<\u00ee*KZ\u0005\u0089_\u009a\u0019\u00c0\u00e0\u00dc\u0091\u00e4\u0013\u00f5w\u0090J\u00cc\u0002\u00d9\u008fk\u00a6T\n\u00d3\u0015\u00133i\u00ee<\b\u0087\u0091\u0018\u0017\u00afOn\u00f7\u001d\u001d\u0002\u0016{\u00933\u000f\u00b8b\u0017R\u00f6\u00b3\u0003\u00d0`\u0001\u0090)mG\u0005s\u001c\u00b1\u0087q\t\u0001\u00b4\u0085\u0089\u00dd\u00939&\u00c4\u0002'u\u008btDstR\u00a0\u00a7\u00e2\u00c1G\u0002\u0084\\\n\u0013m\u00ef\u009c\u00bc";
                var4_3 = "PU\u00b7U\u00a7\u00fc\u00ffx\u0014\u00e0h\u0099\u0015\u009c|7rr\b\u009fS\u00c6\u00c6\u0080sV`\u0089r\u0006\u000e\u0014|}\u00b4\u00b8\u0018\u0016\u0004'\u00a8\u00c9\u000e\u009f\u00fc\u00af\u00a4+\u00b66\u0085\u00cc\u0099vT\u00a3i\u00ec\u0085\u0013\u00f7\t+\u00f4\u001e\u0007\u0085d\u000e\u00f9\u00a1\u0005\u00fb\u00f4\u00c2ay\b\u00e2\u0003\u00e1\u00ee?\u00ad\u00ea\u00b0\u0005Y\u00d9\u0096\u00c4\u00f3\u001e\u00c4\u00140\u0019\u00ba\u00fcS\u00d8\u00934\u00e7#\u00e3\u0017\u00d4\u00af\u0094\u0003-w\u0091i\u00b0\u00a7\u0090\u0003s\u0016\u00e2m\u0010Wn\u00a6\u0093?\u009f\u0015M&4\u00dc\u00de\u0082\u00fdWm\t U\u00a9\" \u00e7\u009c\u0016\u001d\u0010\"\u0005\b\u00fe\u00ea2\u00af\u00f8q\u00826\b\u00df'\u00fc6?xj\u00af\u00d6D\f\t\u00aa\u00a9\u00ab\u00e5+\u001c\u00e0\u0016h\t\u009e\u00e3\u0001\u00c6\u00f5!R\u00b2U:h\u00fc\u00f4\u00ab\u0016\u00a8cx\u00ce\u008d\u0081\u001cl\u00f2\u0003V5\u0018[\u00b0B\u0091\u0011e\u00bf\u0018\u00f7@\u008b\u0010\u00f9\u00e1\u009d\u00cde[\bl(0\u008b\u0005\u0001\u00ad%\f}1\u0002\u00b3^d(\u008e\u00a8\u0004_\u00dcFn\u00cc`\f\u0012\u0093\u00a1p\u0099\u00d7sbX\u00c1\u0081j\u0007\u00b9\"J\u00ec\u00ceg\u0007L\u00d4\u0016S\u00c6\u00ba\u00d6\u00e3;k\u00c8\u00eeA\u00c8.\u0081'\u00abg\u00db\u00e0\u0003\u00fb4\u001f'\u00d2\u00d3\u0001\u00ecu\u00f3)\u0082PN\u00c8v\u00a7\u00e6\u00cc\u00cb\u00de\u0087\u000f\u00f4\u001f\u000e\u00c4i\u0003\u0091\u00bf6\u00b0?9r\u0082Q>\u0089;DyJ\u00f2\u00b6Y\u0083\n\u0097f\u0084v\u0001\u0090,\u000b\u0085<\u001d\u0012\u00bdPT\b'\u00d8\u00a4\u0015?\u00dbJ\u00edP\u00c7\u0005\u00873\u00c9\u00eeW|(1\u00af\u00a8\u007f\nK\u0088)\u00ad\u0084\u001d\u000b\u001f\u00be\u00e7\u0090\u0005=5\u0002\u00bd$\u008a}{9v]\u00c1\u00d4\u00ab\u00a3\u00fd\u001a\u001e\u0081}\u009a!\u00d9;\u0089\u00ae?\u0093\u00ef\u00ff\u00cc\u00be\u0007c\u00f5\u00ce?Ae\u00b7\u0007\u00f25\u0098Kl\u0004\u0004(\u009f\u0012\u0017\u00f8\u00ee\u00aa/5l^2X~\u00ee\u00b0\u00a7;\u00cf\u00d0\u00c0tYr\u00d9V\u00e9\u00dd\u00842Z\u0013\u00d8\u0086\u00c2\u0087\u00fb\f\n\u009f\u0083\u000f\u0088\u00a9\u00bb\u00a6\u0093\r%\u0002X5\u0015d:=\u00a6\"\u00f07\u00b6}jpII\u00d0\u0006\u008fe\u00e9\u00c4d\u00afMJ:q\u00a2QgC\u00f7R\u0092V\u00c8R5\u00c7\u0097\u00b9\u000e\u00a95\u009f5\u0017\u007f\u00b5LJ\u00fcW]~\u0010\u001b<\u00ee*KZ\u0005\u0089_\u009a\u0019\u00c0\u00e0\u00dc\u0091\u00e4\u0013\u00f5w\u0090J\u00cc\u0002\u00d9\u008fk\u00a6T\n\u00d3\u0015\u00133i\u00ee<\b\u0087\u0091\u0018\u0017\u00afOn\u00f7\u001d\u001d\u0002\u0016{\u00933\u000f\u00b8b\u0017R\u00f6\u00b3\u0003\u00d0`\u0001\u0090)mG\u0005s\u001c\u00b1\u0087q\t\u0001\u00b4\u0085\u0089\u00dd\u00939&\u00c4\u0002'u\u008btDstR\u00a0\u00a7\u00e2\u00c1G\u0002\u0084\\\n\u0013m\u00ef\u009c\u00bc".length();
                var1_4 = 8;
                var0_5 = -1;
lbl7:
                // 2 sources

                while (true) {
                    v0 = 106;
                    v1 = ++var0_5;
                    v2 = var2_2.substring(v1, v1 + var1_4);
                    v3 = -1;
                    break block19;
                    break;
                }
lbl13:
                // 1 sources

                while (true) {
                    var5[var3_1++] = v4.intern();
                    if ((var0_5 += var1_4) < var4_3) {
                        var1_4 = var2_2.charAt(var0_5);
                        ** continue;
                    }
                    var2_2 = "\u00cd0\u00d1U\u00e0\u0003\u0017\u0014\u0014\u001d\u00c2\u00925\f\u00df\u009b:\u00f1{\u00d4?\u00fa=\u00f7\u00c0\u00b9\u0089\u001db]\u00e9>\u00d1\u00e9\u00a9\u0018]\u00ad\u0013";
                    var4_3 = "\u00cd0\u00d1U\u00e0\u0003\u0017\u0014\u0014\u001d\u00c2\u00925\f\u00df\u009b:\u00f1{\u00d4?\u00fa=\u00f7\u00c0\u00b9\u0089\u001db]\u00e9>\u00d1\u00e9\u00a9\u0018]\u00ad\u0013".length();
                    var1_4 = 9;
                    var0_5 = -1;
lbl22:
                    // 2 sources

                    while (true) {
                        v0 = 38;
                        v5 = ++var0_5;
                        v2 = var2_2.substring(v5, v5 + var1_4);
                        v3 = 0;
                        break block19;
                        break;
                    }
                    break;
                }
lbl28:
                // 1 sources

                while (true) {
                    var5[var3_1++] = v4.intern();
                    if ((var0_5 += var1_4) < var4_3) {
                        var1_4 = var2_2.charAt(var0_5);
                        ** continue;
                    }
                    break block20;
                    break;
                }
            }
            v6 = v2.toCharArray();
            v7 = v6.length;
            var6_6 = 0;
            v8 = v0;
            v9 = v6;
            v10 = v7;
            if (v7 > 1) ** GOTO lbl85
            do {
                v11 = v8;
                v9 = v9;
                v12 = v9;
                v13 = v8;
                v14 = var6_6;
                while (true) {
                    switch (var6_6 % 7) {
                        case 0: {
                            v15 = 38;
                            break;
                        }
                        case 1: {
                            v15 = 62;
                            break;
                        }
                        case 2: {
                            v15 = 80;
                            break;
                        }
                        case 3: {
                            v15 = 62;
                            break;
                        }
                        case 4: {
                            v15 = 82;
                            break;
                        }
                        case 5: {
                            v15 = 30;
                            break;
                        }
                        default: {
                            v15 = 72;
                        }
                    }
                    v12[v14] = (char)(v12[v14] ^ (v13 ^ v15));
                    ++var6_6;
                    v8 = v11;
                    if (v11 != 0) break;
                    v11 = v8;
                    v9 = v9;
                    v14 = v8;
                    v12 = v9;
                    v13 = v8;
                }
lbl85:
                // 2 sources

                v16 = v9;
                v10 = v10;
            } while (v10 > var6_6);
            v4 = new String(v16);
            switch (v3) {
                default: {
                    ** continue;
                }
                ** case 0:
lbl95:
                // 1 sources

                ** continue;
            }
        }
        WindowsNamedPipeAgentIpc.c = var5;
        WindowsNamedPipeAgentIpc.d = new String[32];
        WindowsNamedPipeAgentIpc.Companion = new Companion(null);
    }

    private static IllegalArgumentException a(IllegalArgumentException illegalArgumentException) {
        return illegalArgumentException;
    }

    private static String b(int n2, int n3, int n4) {
        int n5 = (n2 ^ n4 ^ 0xFFFFC196) & 0xFFFF;
        if (d[n5] == null) {
            int n6;
            char[] cArray = c[n5].toCharArray();
            int n7 = switch (cArray[0] & 0xFF) {
                case 0 -> 168;
                case 1 -> 6;
                case 2 -> 221;
                case 3 -> 234;
                case 4 -> 41;
                case 5 -> 99;
                case 6 -> 46;
                case 7 -> 97;
                case 8 -> 245;
                case 9 -> 236;
                case 10 -> 42;
                case 11 -> 116;
                case 12 -> 242;
                case 13 -> 2;
                case 14 -> 30;
                case 15 -> 85;
                case 16 -> 165;
                case 17 -> 243;
                case 18 -> 156;
                case 19 -> 54;
                case 20 -> 187;
                case 21 -> 241;
                case 22 -> 129;
                case 23 -> 207;
                case 24 -> 36;
                case 25 -> 80;
                case 26 -> 201;
                case 27 -> 111;
                case 28 -> 238;
                case 29 -> 188;
                case 30 -> 56;
                case 31 -> 44;
                case 32 -> 65;
                case 33 -> 39;
                case 34 -> 235;
                case 35 -> 11;
                case 36 -> 4;
                case 37 -> 103;
                case 38 -> 161;
                case 39 -> 58;
                case 40 -> 5;
                case 41 -> 8;
                case 42 -> 78;
                case 43 -> 254;
                case 44 -> 140;
                case 45 -> 87;
                case 46 -> 48;
                case 47 -> 186;
                case 48 -> 189;
                case 49 -> 239;
                case 50 -> 98;
                case 51 -> 19;
                case 52 -> 210;
                case 53 -> 126;
                case 54 -> 52;
                case 55 -> 124;
                case 56 -> 141;
                case 57 -> 12;
                case 58 -> 226;
                case 59 -> 237;
                case 60 -> 250;
                case 61 -> 170;
                case 62 -> 23;
                case 63 -> 31;
                case 64 -> 16;
                case 65 -> 167;
                case 66 -> 70;
                case 67 -> 112;
                case 68 -> 244;
                case 69 -> 51;
                case 70 -> 252;
                case 71 -> 82;
                case 72 -> 143;
                case 73 -> 166;
                case 74 -> 240;
                case 75 -> 228;
                case 76 -> 33;
                case 77 -> 155;
                case 78 -> 249;
                case 79 -> 105;
                case 80 -> 151;
                case 81 -> 222;
                case 82 -> 3;
                case 83 -> 86;
                case 84 -> 255;
                case 85 -> 108;
                case 86 -> 101;
                case 87 -> 0;
                case 88 -> 171;
                case 89 -> 199;
                case 90 -> 195;
                case 91 -> 183;
                case 92 -> 159;
                case 93 -> 100;
                case 94 -> 142;
                case 95 -> 102;
                case 96 -> 125;
                case 97 -> 118;
                case 98 -> 127;
                case 99 -> 158;
                case 100 -> 61;
                case 101 -> 175;
                case 102 -> 71;
                case 103 -> 66;
                case 104 -> 205;
                case 105 -> 28;
                case 106 -> 211;
                case 107 -> 223;
                case 108 -> 154;
                case 109 -> 182;
                case 110 -> 180;
                case 111 -> 145;
                case 112 -> 37;
                case 113 -> 233;
                case 114 -> 215;
                case 115 -> 123;
                case 116 -> 43;
                case 117 -> 7;
                case 118 -> 83;
                case 119 -> 150;
                case 120 -> 193;
                case 121 -> 227;
                case 122 -> 173;
                case 123 -> 40;
                case 124 -> 63;
                case 125 -> 45;
                case 126 -> 49;
                case 127 -> 76;
                case 128 -> 13;
                case 129 -> 73;
                case 130 -> 219;
                case 131 -> 47;
                case 132 -> 91;
                case 133 -> 197;
                case 134 -> 60;
                case 135 -> 135;
                case 136 -> 136;
                case 137 -> 162;
                case 138 -> 35;
                case 139 -> 185;
                case 140 -> 18;
                case 141 -> 172;
                case 142 -> 200;
                case 143 -> 121;
                case 144 -> 59;
                case 145 -> 213;
                case 146 -> 202;
                case 147 -> 128;
                case 148 -> 115;
                case 149 -> 26;
                case 150 -> 137;
                case 151 -> 92;
                case 152 -> 21;
                case 153 -> 174;
                case 154 -> 248;
                case 155 -> 216;
                case 156 -> 75;
                case 157 -> 84;
                case 158 -> 106;
                case 159 -> 179;
                case 160 -> 247;
                case 161 -> 218;
                case 162 -> 190;
                case 163 -> 253;
                case 164 -> 134;
                case 165 -> 212;
                case 166 -> 164;
                case 167 -> 77;
                case 168 -> 196;
                case 169 -> 220;
                case 170 -> 157;
                case 171 -> 144;
                case 172 -> 131;
                case 173 -> 113;
                case 174 -> 133;
                case 175 -> 198;
                case 176 -> 32;
                case 177 -> 72;
                case 178 -> 107;
                case 179 -> 177;
                case 180 -> 38;
                case 181 -> 24;
                case 182 -> 246;
                case 183 -> 208;
                case 184 -> 232;
                case 185 -> 96;
                case 186 -> 22;
                case 187 -> 231;
                case 188 -> 203;
                case 189 -> 229;
                case 190 -> 88;
                case 191 -> 114;
                case 192 -> 149;
                case 193 -> 217;
                case 194 -> 53;
                case 195 -> 89;
                case 196 -> 225;
                case 197 -> 94;
                case 198 -> 153;
                case 199 -> 25;
                case 200 -> 138;
                case 201 -> 1;
                case 202 -> 104;
                case 203 -> 191;
                case 204 -> 93;
                case 205 -> 117;
                case 206 -> 184;
                case 207 -> 9;
                case 208 -> 120;
                case 209 -> 50;
                case 210 -> 192;
                case 211 -> 169;
                case 212 -> 176;
                case 213 -> 62;
                case 214 -> 68;
                case 215 -> 95;
                case 216 -> 29;
                case 217 -> 148;
                case 218 -> 79;
                case 219 -> 14;
                case 220 -> 90;
                case 221 -> 10;
                case 222 -> 122;
                case 223 -> 178;
                case 224 -> 132;
                case 225 -> 214;
                case 226 -> 224;
                case 227 -> 74;
                case 228 -> 57;
                case 229 -> 15;
                case 230 -> 119;
                case 231 -> 230;
                case 232 -> 130;
                case 233 -> 81;
                case 234 -> 64;
                case 235 -> 251;
                case 236 -> 146;
                case 237 -> 139;
                case 238 -> 55;
                case 239 -> 181;
                case 240 -> 209;
                case 241 -> 27;
                case 242 -> 147;
                case 243 -> 110;
                case 244 -> 152;
                case 245 -> 194;
                case 246 -> 69;
                case 247 -> 109;
                case 248 -> 206;
                case 249 -> 67;
                case 250 -> 163;
                case 251 -> 17;
                case 252 -> 20;
                case 253 -> 160;
                case 254 -> 34;
                default -> 204;
            };
            int n8 = ((n3 ^= n4) & 0xFF) - n7;
            if (n8 < 0) {
                n8 += 256;
            }
            if ((n6 = ((n3 & 0xFFFF) >>> 8) - n7) < 0) {
                n6 += 256;
            }
            int n9 = 0;
            while (n9 < cArray.length) {
                int n10 = n9 % 2;
                int n11 = n9;
                char[] cArray2 = cArray;
                char c2 = cArray[n11];
                if (n10 == 0) {
                    cArray2[n11] = (char)(c2 ^ n8);
                    n8 = ((n8 >>> 3 | n8 << 5) ^ cArray[n9]) & 0xFF;
                } else {
                    cArray2[n11] = (char)(c2 ^ n6);
                    n6 = ((n6 >>> 3 | n6 << 5) ^ cArray[n9]) & 0xFF;
                }
                ++n9;
            }
            WindowsNamedPipeAgentIpc.d[n5] = new String(cArray).intern();
        }
        return d[n5];
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0007J\u0010\u0010\b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\u00a8\u0006\t"}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$Companion;", "", "WindowsNamedPipeAgentIpc$Companion", "()V", "connectToPipeTest", "", "pipePath", "", "connectToPipe", "intellij.platform.backend.split"})
    @SourceDebugExtension(value={"SMAP\nWindowsNamedPipeAgentIpc.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WindowsNamedPipeAgentIpc.kt\ncom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$Companion\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,391:1\n24#2:392\n*S KotlinDebug\n*F\n+ 1 WindowsNamedPipeAgentIpc.kt\ncom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$Companion\n*L\n84#1:392\n*E\n"})
    public static final class Companion {
        private static final String[] a;
        private static final String[] b;

        private Companion() {
        }

        @TestOnly
        public final void connectToPipeTest(@NotNull String pipePath) {
            long l2 = 32648127262206L;
            Intrinsics.checkNotNullParameter((Object)pipePath, (String)com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.a(-2080867320 - -16625, -2080867320 - -18705, (int)l2));
            this.connectToPipe(pipePath);
        }

        private final void connectToPipe(String pipePath) {
            block6: {
                boolean bl;
                WinNT.HANDLE hANDLE;
                block7: {
                    long l2;
                    block5: {
                        WinNT.HANDLE hANDLE2;
                        boolean bl2;
                        block4: {
                            l2 = 22468514383775L;
                            hANDLE = Kernel32.INSTANCE.CreateFile(pipePath, -1073741824, 0, null, 3, 0, null);
                            bl2 = SshAgentIpcService.Z();
                            try {
                                hANDLE2 = hANDLE;
                                if (!bl2) break block4;
                                if (hANDLE2 == null) break block5;
                            }
                            catch (RuntimeException runtimeException) {
                                throw com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.a(runtimeException);
                            }
                            hANDLE2 = WinNT.INVALID_HANDLE_VALUE;
                        }
                        try {
                            bl = Intrinsics.areEqual((Object)hANDLE2, (Object)hANDLE);
                            if (!bl2) break block6;
                            if (!bl) break block7;
                        }
                        catch (RuntimeException runtimeException) {
                            throw com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.a(runtimeException);
                        }
                    }
                    Companion companion = this;
                    boolean bl3 = false;
                    Logger logger = Logger.getInstance(Companion.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.a(-1540465710 + -17721, -1540465710 - -3510, (int)l2));
                    logger.info(com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.a(-1540465710 + -17720, 1540465710 - 2795, (int)l2) + pipePath + com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.a(-1540465710 + -17719, 1540465710 + 9710, (int)l2));
                }
                bl = Kernel32.INSTANCE.CloseHandle(hANDLE);
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        private static RuntimeException a(RuntimeException runtimeException) {
            return runtimeException;
        }

        /*
         * Unable to fully structure code
         */
        static {
            block20: {
                block19: {
                    var5 = new String[4];
                    var3_1 = 0;
                    var2_2 = "k6%\u00e7} \u0004n\u0010\u00a3=\u00cd'\u00da\u0083\tC\u00fe\u0000\u0019\u00d0\u00b0\u009c\u009c\u001a";
                    var4_3 = "k6%\u00e7} \u0004n\u0010\u00a3=\u00cd'\u00da\u0083\tC\u00fe\u0000\u0019\u00d0\u00b0\u009c\u009c\u001a".length();
                    var1_4 = 8;
                    var0_5 = -1;
lbl7:
                    // 2 sources

                    while (true) {
                        v0 = 34;
                        v1 = ++var0_5;
                        v2 = var2_2.substring(v1, v1 + var1_4);
                        v3 = -1;
                        break block19;
                        break;
                    }
lbl13:
                    // 1 sources

                    while (true) {
                        var5[var3_1++] = v4.intern();
                        if ((var0_5 += var1_4) < var4_3) {
                            var1_4 = var2_2.charAt(var0_5);
                            ** continue;
                        }
                        var2_2 = "\u00d0\u00c8>T\u00025\u000e\u009d\u00f2\u0092I`\u000f\u00f8%\u00a0\u009ch\u009b\r\u0090\u00ce^1z\u0083%\u00c1\u00c6\u0019\u009dw&\u00ca\u000e\u00a7\u00bd\u0089r\u00ca\u00eb[\r\u0080\u00fa\u00c3x\u0015q(0\u00a1\u00a3i\u008bc\u0002M\u0003";
                        var4_3 = "\u00d0\u00c8>T\u00025\u000e\u009d\u00f2\u0092I`\u000f\u00f8%\u00a0\u009ch\u009b\r\u0090\u00ce^1z\u0083%\u00c1\u00c6\u0019\u009dw&\u00ca\u000e\u00a7\u00bd\u0089r\u00ca\u00eb[\r\u0080\u00fa\u00c3x\u0015q(0\u00a1\u00a3i\u008bc\u0002M\u0003".length();
                        var1_4 = 5;
                        var0_5 = -1;
lbl22:
                        // 2 sources

                        while (true) {
                            v0 = 66;
                            v5 = ++var0_5;
                            v2 = var2_2.substring(v5, v5 + var1_4);
                            v3 = 0;
                            break block19;
                            break;
                        }
                        break;
                    }
lbl28:
                    // 1 sources

                    while (true) {
                        var5[var3_1++] = v4.intern();
                        if ((var0_5 += var1_4) < var4_3) {
                            var1_4 = var2_2.charAt(var0_5);
                            ** continue;
                        }
                        break block20;
                        break;
                    }
                }
                v6 = v2.toCharArray();
                v7 = v6.length;
                var6_6 = 0;
                v8 = v0;
                v9 = v6;
                v10 = v7;
                if (v7 > 1) ** GOTO lbl85
                do {
                    v11 = v8;
                    v9 = v9;
                    v12 = v9;
                    v13 = v8;
                    v14 = var6_6;
                    while (true) {
                        switch (var6_6 % 7) {
                            case 0: {
                                v15 = 98;
                                break;
                            }
                            case 1: {
                                v15 = 33;
                                break;
                            }
                            case 2: {
                                v15 = 108;
                                break;
                            }
                            case 3: {
                                v15 = 66;
                                break;
                            }
                            case 4: {
                                v15 = 28;
                                break;
                            }
                            case 5: {
                                v15 = 90;
                                break;
                            }
                            default: {
                                v15 = 96;
                            }
                        }
                        v12[v14] = (char)(v12[v14] ^ (v13 ^ v15));
                        ++var6_6;
                        v8 = v11;
                        if (v11 != 0) break;
                        v11 = v8;
                        v9 = v9;
                        v14 = v8;
                        v12 = v9;
                        v13 = v8;
                    }
lbl85:
                    // 2 sources

                    v16 = v9;
                    v10 = v10;
                } while (v10 > var6_6);
                v4 = new String(v16);
                switch (v3) {
                    default: {
                        ** continue;
                    }
                    ** case 0:
lbl95:
                    // 1 sources

                    ** continue;
                }
            }
            com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.a = var5;
            com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.b = new String[4];
        }

        private static String a(int n2, int n3, int n4) {
            int n5 = (n2 ^ n4 ^ 0xFFFF9107) & 0xFFFF;
            if (b[n5] == null) {
                int n6;
                char[] cArray = a[n5].toCharArray();
                int n7 = switch (cArray[0] & 0xFF) {
                    case 0 -> 194;
                    case 1 -> 215;
                    case 2 -> 224;
                    case 3 -> 123;
                    case 4 -> 42;
                    case 5 -> 252;
                    case 6 -> 175;
                    case 7 -> 19;
                    case 8 -> 180;
                    case 9 -> 211;
                    case 10 -> 153;
                    case 11 -> 23;
                    case 12 -> 209;
                    case 13 -> 134;
                    case 14 -> 187;
                    case 15 -> 59;
                    case 16 -> 105;
                    case 17 -> 205;
                    case 18 -> 186;
                    case 19 -> 130;
                    case 20 -> 144;
                    case 21 -> 170;
                    case 22 -> 166;
                    case 23 -> 21;
                    case 24 -> 181;
                    case 25 -> 234;
                    case 26 -> 218;
                    case 27 -> 235;
                    case 28 -> 89;
                    case 29 -> 107;
                    case 30 -> 236;
                    case 31 -> 201;
                    case 32 -> 40;
                    case 33 -> 232;
                    case 34 -> 132;
                    case 35 -> 143;
                    case 36 -> 41;
                    case 37 -> 48;
                    case 38 -> 229;
                    case 39 -> 173;
                    case 40 -> 159;
                    case 41 -> 119;
                    case 42 -> 63;
                    case 43 -> 140;
                    case 44 -> 248;
                    case 45 -> 129;
                    case 46 -> 111;
                    case 47 -> 222;
                    case 48 -> 52;
                    case 49 -> 90;
                    case 50 -> 251;
                    case 51 -> 163;
                    case 52 -> 1;
                    case 53 -> 54;
                    case 54 -> 113;
                    case 55 -> 27;
                    case 56 -> 203;
                    case 57 -> 208;
                    case 58 -> 247;
                    case 59 -> 97;
                    case 60 -> 67;
                    case 61 -> 16;
                    case 62 -> 0;
                    case 63 -> 45;
                    case 64 -> 77;
                    case 65 -> 34;
                    case 66 -> 150;
                    case 67 -> 5;
                    case 68 -> 183;
                    case 69 -> 71;
                    case 70 -> 228;
                    case 71 -> 254;
                    case 72 -> 189;
                    case 73 -> 57;
                    case 74 -> 60;
                    case 75 -> 216;
                    case 76 -> 226;
                    case 77 -> 220;
                    case 78 -> 74;
                    case 79 -> 68;
                    case 80 -> 9;
                    case 81 -> 240;
                    case 82 -> 22;
                    case 83 -> 158;
                    case 84 -> 223;
                    case 85 -> 217;
                    case 86 -> 192;
                    case 87 -> 210;
                    case 88 -> 117;
                    case 89 -> 62;
                    case 90 -> 207;
                    case 91 -> 88;
                    case 92 -> 99;
                    case 93 -> 39;
                    case 94 -> 168;
                    case 95 -> 82;
                    case 96 -> 182;
                    case 97 -> 255;
                    case 98 -> 4;
                    case 99 -> 152;
                    case 100 -> 227;
                    case 101 -> 37;
                    case 102 -> 31;
                    case 103 -> 3;
                    case 104 -> 102;
                    case 105 -> 237;
                    case 106 -> 122;
                    case 107 -> 219;
                    case 108 -> 124;
                    case 109 -> 12;
                    case 110 -> 239;
                    case 111 -> 171;
                    case 112 -> 241;
                    case 113 -> 50;
                    case 114 -> 160;
                    case 115 -> 76;
                    case 116 -> 245;
                    case 117 -> 116;
                    case 118 -> 43;
                    case 119 -> 156;
                    case 120 -> 69;
                    case 121 -> 33;
                    case 122 -> 154;
                    case 123 -> 246;
                    case 124 -> 164;
                    case 125 -> 133;
                    case 126 -> 225;
                    case 127 -> 120;
                    case 128 -> 148;
                    case 129 -> 145;
                    case 130 -> 174;
                    case 131 -> 112;
                    case 132 -> 193;
                    case 133 -> 64;
                    case 134 -> 15;
                    case 135 -> 56;
                    case 136 -> 32;
                    case 137 -> 104;
                    case 138 -> 86;
                    case 139 -> 100;
                    case 140 -> 17;
                    case 141 -> 114;
                    case 142 -> 204;
                    case 143 -> 137;
                    case 144 -> 191;
                    case 145 -> 30;
                    case 146 -> 94;
                    case 147 -> 178;
                    case 148 -> 78;
                    case 149 -> 199;
                    case 150 -> 26;
                    case 151 -> 29;
                    case 152 -> 109;
                    case 153 -> 157;
                    case 154 -> 70;
                    case 155 -> 169;
                    case 156 -> 188;
                    case 157 -> 20;
                    case 158 -> 233;
                    case 159 -> 95;
                    case 160 -> 38;
                    case 161 -> 212;
                    case 162 -> 161;
                    case 163 -> 198;
                    case 164 -> 195;
                    case 165 -> 35;
                    case 166 -> 176;
                    case 167 -> 206;
                    case 168 -> 8;
                    case 169 -> 200;
                    case 170 -> 141;
                    case 171 -> 28;
                    case 172 -> 243;
                    case 173 -> 244;
                    case 174 -> 61;
                    case 175 -> 151;
                    case 176 -> 6;
                    case 177 -> 238;
                    case 178 -> 66;
                    case 179 -> 127;
                    case 180 -> 221;
                    case 181 -> 51;
                    case 182 -> 242;
                    case 183 -> 139;
                    case 184 -> 126;
                    case 185 -> 250;
                    case 186 -> 81;
                    case 187 -> 231;
                    case 188 -> 202;
                    case 189 -> 165;
                    case 190 -> 167;
                    case 191 -> 58;
                    case 192 -> 214;
                    case 193 -> 184;
                    case 194 -> 149;
                    case 195 -> 93;
                    case 196 -> 138;
                    case 197 -> 11;
                    case 198 -> 72;
                    case 199 -> 24;
                    case 200 -> 84;
                    case 201 -> 197;
                    case 202 -> 83;
                    case 203 -> 172;
                    case 204 -> 10;
                    case 205 -> 146;
                    case 206 -> 91;
                    case 207 -> 213;
                    case 208 -> 125;
                    case 209 -> 98;
                    case 210 -> 121;
                    case 211 -> 87;
                    case 212 -> 25;
                    case 213 -> 2;
                    case 214 -> 73;
                    case 215 -> 106;
                    case 216 -> 142;
                    case 217 -> 253;
                    case 218 -> 179;
                    case 219 -> 47;
                    case 220 -> 110;
                    case 221 -> 85;
                    case 222 -> 128;
                    case 223 -> 136;
                    case 224 -> 55;
                    case 225 -> 18;
                    case 226 -> 135;
                    case 227 -> 147;
                    case 228 -> 190;
                    case 229 -> 96;
                    case 230 -> 230;
                    case 231 -> 131;
                    case 232 -> 101;
                    case 233 -> 155;
                    case 234 -> 65;
                    case 235 -> 36;
                    case 236 -> 44;
                    case 237 -> 7;
                    case 238 -> 108;
                    case 239 -> 118;
                    case 240 -> 92;
                    case 241 -> 177;
                    case 242 -> 103;
                    case 243 -> 162;
                    case 244 -> 53;
                    case 245 -> 14;
                    case 246 -> 115;
                    case 247 -> 196;
                    case 248 -> 80;
                    case 249 -> 79;
                    case 250 -> 249;
                    case 251 -> 13;
                    case 252 -> 75;
                    case 253 -> 46;
                    case 254 -> 49;
                    default -> 185;
                };
                int n8 = ((n3 ^= n4) & 0xFF) - n7;
                if (n8 < 0) {
                    n8 += 256;
                }
                if ((n6 = ((n3 & 0xFFFF) >>> 8) - n7) < 0) {
                    n6 += 256;
                }
                int n9 = 0;
                while (n9 < cArray.length) {
                    int n10 = n9 % 2;
                    int n11 = n9;
                    char[] cArray2 = cArray;
                    char c2 = cArray[n11];
                    if (n10 == 0) {
                        cArray2[n11] = (char)(c2 ^ n8);
                        n8 = ((n8 >>> 3 | n8 << 5) ^ cArray[n9]) & 0xFF;
                    } else {
                        cArray2[n11] = (char)(c2 ^ n6);
                        n6 = ((n6 >>> 3 | n6 << 5) ^ cArray[n9]) & 0xFF;
                    }
                    ++n9;
                }
                com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.b[n5] = new String(cArray).intern();
            }
            return b[n5];
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\bf\u0018\u0000 \b2\u00020\u0001:\u0001\bJ\u001c\u0010\u0002\u001a\u00020\u00032\b\u0010\u0004\u001a\u0004\u0018\u00010\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007H&\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\t\u00c0\u0006\u0001"}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$Kernel32Ex;", "Lcom/sun/jna/platform/win32/Kernel32;", "CancelIoEx", "", "hFile", "Lcom/sun/jna/platform/win32/WinNT$HANDLE;", "lpOverlapped", "Lcom/sun/jna/Pointer;", "Companion", "intellij.platform.backend.split"})
    public static interface Kernel32Ex
    extends Kernel32 {
        @NotNull
        public static final Companion Companion = Companion.$$INSTANCE;

        public boolean CancelIoEx(@Nullable WinNT.HANDLE var1, @Nullable Pointer var2);

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$Kernel32Ex$Companion;", "", "WindowsNamedPipeAgentIpc$Kernel32Ex$Companion", "()V", "INSTANCE", "Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$Kernel32Ex;", "getINSTANCE", "()Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$Kernel32Ex;", "intellij.platform.backend.split"})
        public static final class Companion {
            static final /* synthetic */ Companion $$INSTANCE;
            @NotNull
            private static final Kernel32Ex INSTANCE;

            private Companion() {
            }

            @NotNull
            public final Kernel32Ex getINSTANCE() {
                return INSTANCE;
            }

            /*
             * Unable to fully structure code
             */
            static {
                block13: {
                    var7 = 30395005419086L;
                    var0_1 = new String[2];
                    var4_2 = 0;
                    var3_3 = "&-4:U>i\u007f\t!''0\u0018|tca";
                    var5_4 = "&-4:U>i\u007f\t!''0\u0018|tca".length();
                    var2_5 = 8;
                    var1_6 = -1;
lbl8:
                    // 2 sources

                    while (true) {
                        continue;
                        break;
                    }
lbl10:
                    // 1 sources

                    while (true) {
                        var0_1[var4_2++] = new String(v0).intern();
                        if ((var1_6 += var2_5) < var5_4) {
                            var2_5 = var3_3.charAt(var1_6);
                            ** continue;
                        }
                        break block13;
                        break;
                    }
                    v1 = ++var1_6;
                    v2 = var3_3.substring(v1, v1 + var2_5).toCharArray();
                    v3 = v2.length;
                    var6_7 = 0;
                    v4 = 108;
                    v5 = v2;
                    v6 = v3;
                    if (v3 > 1) ** GOTO lbl68
                    do {
                        v7 = v4;
                        v5 = v5;
                        v8 = v5;
                        v9 = v4;
                        v10 = var6_7;
                        while (true) {
                            switch (var6_7 % 7) {
                                case 0: {
                                    v11 = 33;
                                    break;
                                }
                                case 1: {
                                    v11 = 36;
                                    break;
                                }
                                case 2: {
                                    v11 = 42;
                                    break;
                                }
                                case 3: {
                                    v11 = 56;
                                    break;
                                }
                                case 4: {
                                    v11 = 92;
                                    break;
                                }
                                case 5: {
                                    v11 = 62;
                                    break;
                                }
                                default: {
                                    v11 = 54;
                                }
                            }
                            v8[v10] = (char)(v8[v10] ^ (v9 ^ v11));
                            ++var6_7;
                            v4 = v7;
                            if (v7 != 0) break;
                            v7 = v4;
                            v5 = v5;
                            v10 = v4;
                            v8 = v5;
                            v9 = v4;
                        }
lbl68:
                        // 2 sources

                        v0 = v5;
                        v6 = v6;
                    } while (v6 > var6_7);
                    ** while (true)
                }
                com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Kernel32Ex$Companion.$$INSTANCE = new Companion();
                v12 = Native.load((String)var0_1[0], Kernel32Ex.class, (Map)W32APIOptions.DEFAULT_OPTIONS);
                Intrinsics.checkNotNullExpressionValue((Object)v12, (String)var0_1[1]);
                com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Kernel32Ex$Companion.INSTANCE = (Kernel32Ex)v12;
            }
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\n\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006j\u0002\b\u0007j\u0002\b\bj\u0002\b\tj\u0002\b\n\u00a8\u0006\u000b"}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$NamedPipeState;", "", "WindowsNamedPipeAgentIpc$NamedPipeState", "(Ljava/lang/String;I)V", "Initial", "Open", "Connecting", "Connected", "Disconnecting", "Closing", "Closed", "intellij.platform.backend.split"})
    public static final class NamedPipeState
    extends Enum<NamedPipeState> {
        public static final /* enum */ NamedPipeState Initial;
        public static final /* enum */ NamedPipeState Open;
        public static final /* enum */ NamedPipeState Connecting;
        public static final /* enum */ NamedPipeState Connected;
        public static final /* enum */ NamedPipeState Disconnecting;
        public static final /* enum */ NamedPipeState Closing;
        public static final /* enum */ NamedPipeState Closed;
        private static final /* synthetic */ NamedPipeState[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static NamedPipeState[] values() {
            return (NamedPipeState[])$VALUES.clone();
        }

        public static NamedPipeState valueOf(String value) {
            return Enum.valueOf(NamedPipeState.class, value);
        }

        @NotNull
        public static EnumEntries<NamedPipeState> getEntries() {
            return $ENTRIES;
        }

        private static final /* synthetic */ NamedPipeState[] $values() {
            NamedPipeState[] namedPipeStateArray = new NamedPipeState[]{Initial, Open, Connecting, Connected, Disconnecting, Closing, Closed};
            return namedPipeStateArray;
        }

        /*
         * Unable to fully structure code
         */
        static {
            block20: {
                block19: {
                    var7 = 20521576507659L;
                    var0_1 = new String[7];
                    var4_2 = 0;
                    var3_3 = "f=}\"%?\u001a\u0004`#q8\nl<z8)=\u0002F=s\tl<z8)=\u0002J7\rk:g5#0\u0018J0`?\"9";
                    var5_4 = "f=}\"%?\u001a\u0004`#q8\nl<z8)=\u0002F=s\tl<z8)=\u0002J7\rk:g5#0\u0018J0`?\"9".length();
                    var2_5 = 7;
                    var1_6 = -1;
lbl8:
                    // 2 sources

                    while (true) {
                        v0 = 102;
                        v1 = ++var1_6;
                        v2 = var3_3.substring(v1, v1 + var2_5);
                        v3 = -1;
                        break block19;
                        break;
                    }
lbl14:
                    // 1 sources

                    while (true) {
                        var0_1[var4_2++] = v4.intern();
                        if ((var1_6 += var2_5) < var5_4) {
                            var2_5 = var3_3.charAt(var1_6);
                            ** continue;
                        }
                        var3_3 = "/|8ffsR\u0006/|8fjy";
                        var5_4 = "/|8ffsR\u0006/|8fjy".length();
                        var2_5 = 7;
                        var1_6 = -1;
lbl23:
                        // 2 sources

                        while (true) {
                            v0 = 37;
                            v5 = ++var1_6;
                            v2 = var3_3.substring(v5, v5 + var2_5);
                            v3 = 0;
                            break block19;
                            break;
                        }
                        break;
                    }
lbl29:
                    // 1 sources

                    while (true) {
                        var0_1[var4_2++] = v4.intern();
                        if ((var1_6 += var2_5) < var5_4) {
                            var2_5 = var3_3.charAt(var1_6);
                            ** continue;
                        }
                        break block20;
                        break;
                    }
                }
                v6 = v2.toCharArray();
                v7 = v6.length;
                var6_7 = 0;
                v8 = v0;
                v9 = v6;
                v10 = v7;
                if (v7 > 1) ** GOTO lbl86
                do {
                    v11 = v8;
                    v9 = v9;
                    v12 = v9;
                    v13 = v8;
                    v14 = var6_7;
                    while (true) {
                        switch (var6_7 % 7) {
                            case 0: {
                                v15 = 73;
                                break;
                            }
                            case 1: {
                                v15 = 53;
                                break;
                            }
                            case 2: {
                                v15 = 114;
                                break;
                            }
                            case 3: {
                                v15 = 48;
                                break;
                            }
                            case 4: {
                                v15 = 42;
                                break;
                            }
                            case 5: {
                                v15 = 56;
                                break;
                            }
                            default: {
                                v15 = 16;
                            }
                        }
                        v12[v14] = (char)(v12[v14] ^ (v13 ^ v15));
                        ++var6_7;
                        v8 = v11;
                        if (v11 != 0) break;
                        v11 = v8;
                        v9 = v9;
                        v14 = v8;
                        v12 = v9;
                        v13 = v8;
                    }
lbl86:
                    // 2 sources

                    v16 = v9;
                    v10 = v10;
                } while (v10 > var6_7);
                v4 = new String(v16);
                switch (v3) {
                    default: {
                        ** continue;
                    }
                    ** case 0:
lbl96:
                    // 1 sources

                    ** continue;
                }
            }
            NamedPipeState.Initial = new NamedPipeState();
            NamedPipeState.Open = new NamedPipeState();
            NamedPipeState.Connecting = new NamedPipeState();
            NamedPipeState.Connected = new NamedPipeState();
            NamedPipeState.Disconnecting = new NamedPipeState();
            NamedPipeState.Closing = new NamedPipeState();
            NamedPipeState.Closed = new NamedPipeState();
            NamedPipeState.$VALUES = NamedPipeState.$values();
            NamedPipeState.$ENTRIES = EnumEntriesKt.enumEntries((Enum[])NamedPipeState.$VALUES);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\b\u0010\n\u001a\u00020\u000bH\u0016J\b\u0010\f\u001a\u00020\rH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$PipeReadableByteChannel;", "Ljava/nio/channels/ReadableByteChannel;", "agent", "Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc;", "WindowsNamedPipeAgentIpc$PipeReadableByteChannel", "(Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc;)V", "read", "", "dst", "Ljava/nio/ByteBuffer;", "isOpen", "", "close", "", "intellij.platform.backend.split"})
    @SourceDebugExtension(value={"SMAP\nWindowsNamedPipeAgentIpc.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WindowsNamedPipeAgentIpc.kt\ncom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$PipeReadableByteChannel\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,391:1\n24#2:392\n24#2:393\n*S KotlinDebug\n*F\n+ 1 WindowsNamedPipeAgentIpc.kt\ncom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$PipeReadableByteChannel\n*L\n315#1:392\n320#1:393\n*E\n"})
    private static final class PipeReadableByteChannel
    implements ReadableByteChannel {
        @NotNull
        private final WindowsNamedPipeAgentIpc agent;
        private static final String[] a;
        private static final String[] b;

        public PipeReadableByteChannel(@NotNull WindowsNamedPipeAgentIpc agent) {
            long l2 = 130589985221031L;
            Intrinsics.checkNotNullParameter((Object)agent, (String)PipeReadableByteChannel.a(-1504552530 + -((char)-19245), -1504552530 + -((char)-10248), (int)l2));
            this.agent = agent;
        }

        /*
         * Exception decompiling
         */
        @Override
        public int read(@NotNull ByteBuffer dst) {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [2[TRYBLOCK]], but top level block is 5[SWITCH]
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        @Override
        public boolean isOpen() {
            boolean bl;
            long l2 = 22816592899531L;
            try {
                bl = this.agent.state == NamedPipeState.Connected;
            }
            catch (RuntimeException runtimeException) {
                throw PipeReadableByteChannel.a(runtimeException);
            }
            return bl;
        }

        @Override
        public void close() {
            this.agent.disconnect();
        }

        private static RuntimeException a(RuntimeException runtimeException) {
            return runtimeException;
        }

        /*
         * Unable to fully structure code
         */
        static {
            block20: {
                block19: {
                    var5 = new String[9];
                    var3_1 = 0;
                    var2_2 = "\u001a\u00b8=0\u00ad\u0003\bo\u00cb\u0005\u00a8\u0095MQ@\rJt''\u00f8\u001b'\u00c3\u00ff\u0084\u0018M{\u0010\u0096\u001f{\u00a1L^\u009aV\u0081\u00b24\u00c6\u0018\u001f'g\u0005+\u00a3=\u0097N3\u00a2}\u001d;UI\u0089\u00a0\u009e\u0091\\\u008b\u00d3\u00e7rgN\u00b1#\u00f2\u0084+\u00f5\u00b0\u009e\u00f1\u00ceao\u0007\u00d2nr\u00f1&\u0095/g\u00a0\u0019\u00cf9T\u00fe\u0099\u00a7\u00d4\u00e2\u00c1\u00e0\u00da";
                    var4_3 = "\u001a\u00b8=0\u00ad\u0003\bo\u00cb\u0005\u00a8\u0095MQ@\rJt''\u00f8\u001b'\u00c3\u00ff\u0084\u0018M{\u0010\u0096\u001f{\u00a1L^\u009aV\u0081\u00b24\u00c6\u0018\u001f'g\u0005+\u00a3=\u0097N3\u00a2}\u001d;UI\u0089\u00a0\u009e\u0091\\\u008b\u00d3\u00e7rgN\u00b1#\u00f2\u0084+\u00f5\u00b0\u009e\u00f1\u00ceao\u0007\u00d2nr\u00f1&\u0095/g\u00a0\u0019\u00cf9T\u00fe\u0099\u00a7\u00d4\u00e2\u00c1\u00e0\u00da".length();
                    var1_4 = 5;
                    var0_5 = -1;
lbl7:
                    // 2 sources

                    while (true) {
                        v0 = 119;
                        v1 = ++var0_5;
                        v2 = var2_2.substring(v1, v1 + var1_4);
                        v3 = -1;
                        break block19;
                        break;
                    }
lbl13:
                    // 1 sources

                    while (true) {
                        var5[var3_1++] = v4.intern();
                        if ((var0_5 += var1_4) < var4_3) {
                            var1_4 = var2_2.charAt(var0_5);
                            ** continue;
                        }
                        var2_2 = "U\u00e1\u0099\u00e4\u008al\u00d8\u008aS\u00b3\u00f4|\u009a\u00d2\u00edDL\u00dc\u0015_\u00b0x.\u00e8\u00ac\u00dc\u00e4\u00a9/?6\u00ca\u00a1\u00c6\"W\u00ec\u00f8\u0016\u00ca/\u00c0s\u00bam\u0081Uz\u00d1\u00edr>c\u0084\u00fdu\u00b6\u00d9\u00ab\u00c3K\u00e4U*\u001ev\u00d1^i\u00d6\u00a6{(\u00ca\u0095\n\u00af\u00d6F\u00eb,\u00fc\u00ed\u00a4p\u00f4&\u00e5s\u00ccG\u001b\u00d7";
                        var4_3 = "U\u00e1\u0099\u00e4\u008al\u00d8\u008aS\u00b3\u00f4|\u009a\u00d2\u00edDL\u00dc\u0015_\u00b0x.\u00e8\u00ac\u00dc\u00e4\u00a9/?6\u00ca\u00a1\u00c6\"W\u00ec\u00f8\u0016\u00ca/\u00c0s\u00bam\u0081Uz\u00d1\u00edr>c\u0084\u00fdu\u00b6\u00d9\u00ab\u00c3K\u00e4U*\u001ev\u00d1^i\u00d6\u00a6{(\u00ca\u0095\n\u00af\u00d6F\u00eb,\u00fc\u00ed\u00a4p\u00f4&\u00e5s\u00ccG\u001b\u00d7".length();
                        var1_4 = 16;
                        var0_5 = -1;
lbl22:
                        // 2 sources

                        while (true) {
                            v0 = 74;
                            v5 = ++var0_5;
                            v2 = var2_2.substring(v5, v5 + var1_4);
                            v3 = 0;
                            break block19;
                            break;
                        }
                        break;
                    }
lbl28:
                    // 1 sources

                    while (true) {
                        var5[var3_1++] = v4.intern();
                        if ((var0_5 += var1_4) < var4_3) {
                            var1_4 = var2_2.charAt(var0_5);
                            ** continue;
                        }
                        break block20;
                        break;
                    }
                }
                v6 = v2.toCharArray();
                v7 = v6.length;
                var6_6 = 0;
                v8 = v0;
                v9 = v6;
                v10 = v7;
                if (v7 > 1) ** GOTO lbl85
                do {
                    v11 = v8;
                    v9 = v9;
                    v12 = v9;
                    v13 = v8;
                    v14 = var6_6;
                    while (true) {
                        switch (var6_6 % 7) {
                            case 0: {
                                v15 = 53;
                                break;
                            }
                            case 1: {
                                v15 = 120;
                                break;
                            }
                            case 2: {
                                v15 = 105;
                                break;
                            }
                            case 3: {
                                v15 = 84;
                                break;
                            }
                            case 4: {
                                v15 = 3;
                                break;
                            }
                            case 5: {
                                v15 = 106;
                                break;
                            }
                            default: {
                                v15 = 61;
                            }
                        }
                        v12[v14] = (char)(v12[v14] ^ (v13 ^ v15));
                        ++var6_6;
                        v8 = v11;
                        if (v11 != 0) break;
                        v11 = v8;
                        v9 = v9;
                        v14 = v8;
                        v12 = v9;
                        v13 = v8;
                    }
lbl85:
                    // 2 sources

                    v16 = v9;
                    v10 = v10;
                } while (v10 > var6_6);
                v4 = new String(v16);
                switch (v3) {
                    default: {
                        ** continue;
                    }
                    ** case 0:
lbl95:
                    // 1 sources

                    ** continue;
                }
            }
            PipeReadableByteChannel.a = var5;
            PipeReadableByteChannel.b = new String[9];
        }

        private static String a(int n2, int n3, int n4) {
            int n5 = (n2 ^ n4 ^ 0xFFFF8D7C) & 0xFFFF;
            if (b[n5] == null) {
                int n6;
                char[] cArray = a[n5].toCharArray();
                int n7 = switch (cArray[0] & 0xFF) {
                    case 0 -> 172;
                    case 1 -> 120;
                    case 2 -> 222;
                    case 3 -> 84;
                    case 4 -> 106;
                    case 5 -> 40;
                    case 6 -> 111;
                    case 7 -> 197;
                    case 8 -> 252;
                    case 9 -> 141;
                    case 10 -> 191;
                    case 11 -> 183;
                    case 12 -> 233;
                    case 13 -> 97;
                    case 14 -> 91;
                    case 15 -> 17;
                    case 16 -> 1;
                    case 17 -> 145;
                    case 18 -> 149;
                    case 19 -> 115;
                    case 20 -> 152;
                    case 21 -> 192;
                    case 22 -> 182;
                    case 23 -> 202;
                    case 24 -> 179;
                    case 25 -> 75;
                    case 26 -> 19;
                    case 27 -> 128;
                    case 28 -> 249;
                    case 29 -> 50;
                    case 30 -> 163;
                    case 31 -> 250;
                    case 32 -> 175;
                    case 33 -> 79;
                    case 34 -> 66;
                    case 35 -> 25;
                    case 36 -> 77;
                    case 37 -> 7;
                    case 38 -> 46;
                    case 39 -> 102;
                    case 40 -> 81;
                    case 41 -> 204;
                    case 42 -> 71;
                    case 43 -> 55;
                    case 44 -> 124;
                    case 45 -> 42;
                    case 46 -> 242;
                    case 47 -> 53;
                    case 48 -> 166;
                    case 49 -> 92;
                    case 50 -> 219;
                    case 51 -> 200;
                    case 52 -> 223;
                    case 53 -> 174;
                    case 54 -> 214;
                    case 55 -> 232;
                    case 56 -> 23;
                    case 57 -> 138;
                    case 58 -> 135;
                    case 59 -> 36;
                    case 60 -> 113;
                    case 61 -> 147;
                    case 62 -> 99;
                    case 63 -> 167;
                    case 64 -> 107;
                    case 65 -> 190;
                    case 66 -> 144;
                    case 67 -> 193;
                    case 68 -> 131;
                    case 69 -> 51;
                    case 70 -> 148;
                    case 71 -> 95;
                    case 72 -> 49;
                    case 73 -> 130;
                    case 74 -> 30;
                    case 75 -> 6;
                    case 76 -> 156;
                    case 77 -> 47;
                    case 78 -> 13;
                    case 79 -> 198;
                    case 80 -> 173;
                    case 81 -> 32;
                    case 82 -> 239;
                    case 83 -> 38;
                    case 84 -> 236;
                    case 85 -> 76;
                    case 86 -> 221;
                    case 87 -> 206;
                    case 88 -> 216;
                    case 89 -> 54;
                    case 90 -> 56;
                    case 91 -> 108;
                    case 92 -> 64;
                    case 93 -> 116;
                    case 94 -> 237;
                    case 95 -> 255;
                    case 96 -> 196;
                    case 97 -> 69;
                    case 98 -> 121;
                    case 99 -> 117;
                    case 100 -> 87;
                    case 101 -> 78;
                    case 102 -> 114;
                    case 103 -> 48;
                    case 104 -> 31;
                    case 105 -> 155;
                    case 106 -> 136;
                    case 107 -> 143;
                    case 108 -> 129;
                    case 109 -> 210;
                    case 110 -> 41;
                    case 111 -> 205;
                    case 112 -> 146;
                    case 113 -> 104;
                    case 114 -> 201;
                    case 115 -> 244;
                    case 116 -> 11;
                    case 117 -> 68;
                    case 118 -> 58;
                    case 119 -> 227;
                    case 120 -> 85;
                    case 121 -> 22;
                    case 122 -> 220;
                    case 123 -> 185;
                    case 124 -> 90;
                    case 125 -> 27;
                    case 126 -> 98;
                    case 127 -> 184;
                    case 128 -> 207;
                    case 129 -> 100;
                    case 130 -> 186;
                    case 131 -> 57;
                    case 132 -> 72;
                    case 133 -> 35;
                    case 134 -> 188;
                    case 135 -> 89;
                    case 136 -> 83;
                    case 137 -> 119;
                    case 138 -> 230;
                    case 139 -> 3;
                    case 140 -> 21;
                    case 141 -> 215;
                    case 142 -> 8;
                    case 143 -> 158;
                    case 144 -> 139;
                    case 145 -> 169;
                    case 146 -> 171;
                    case 147 -> 161;
                    case 148 -> 165;
                    case 149 -> 80;
                    case 150 -> 94;
                    case 151 -> 213;
                    case 152 -> 61;
                    case 153 -> 10;
                    case 154 -> 59;
                    case 155 -> 122;
                    case 156 -> 65;
                    case 157 -> 137;
                    case 158 -> 37;
                    case 159 -> 132;
                    case 160 -> 248;
                    case 161 -> 212;
                    case 162 -> 246;
                    case 163 -> 151;
                    case 164 -> 5;
                    case 165 -> 123;
                    case 166 -> 245;
                    case 167 -> 160;
                    case 168 -> 235;
                    case 169 -> 178;
                    case 170 -> 127;
                    case 171 -> 168;
                    case 172 -> 189;
                    case 173 -> 228;
                    case 174 -> 181;
                    case 175 -> 70;
                    case 176 -> 52;
                    case 177 -> 60;
                    case 178 -> 199;
                    case 179 -> 176;
                    case 180 -> 157;
                    case 181 -> 253;
                    case 182 -> 125;
                    case 183 -> 195;
                    case 184 -> 73;
                    case 185 -> 110;
                    case 186 -> 29;
                    case 187 -> 187;
                    case 188 -> 251;
                    case 189 -> 247;
                    case 190 -> 177;
                    case 191 -> 34;
                    case 192 -> 153;
                    case 193 -> 43;
                    case 194 -> 162;
                    case 195 -> 4;
                    case 196 -> 133;
                    case 197 -> 14;
                    case 198 -> 103;
                    case 199 -> 9;
                    case 200 -> 238;
                    case 201 -> 164;
                    case 202 -> 134;
                    case 203 -> 208;
                    case 204 -> 159;
                    case 205 -> 109;
                    case 206 -> 0;
                    case 207 -> 28;
                    case 208 -> 112;
                    case 209 -> 39;
                    case 210 -> 170;
                    case 211 -> 209;
                    case 212 -> 16;
                    case 213 -> 62;
                    case 214 -> 82;
                    case 215 -> 2;
                    case 216 -> 224;
                    case 217 -> 20;
                    case 218 -> 140;
                    case 219 -> 101;
                    case 220 -> 241;
                    case 221 -> 26;
                    case 222 -> 67;
                    case 223 -> 154;
                    case 224 -> 218;
                    case 225 -> 15;
                    case 226 -> 44;
                    case 227 -> 217;
                    case 228 -> 229;
                    case 229 -> 225;
                    case 230 -> 118;
                    case 231 -> 86;
                    case 232 -> 150;
                    case 233 -> 24;
                    case 234 -> 180;
                    case 235 -> 231;
                    case 236 -> 96;
                    case 237 -> 105;
                    case 238 -> 234;
                    case 239 -> 226;
                    case 240 -> 243;
                    case 241 -> 194;
                    case 242 -> 93;
                    case 243 -> 45;
                    case 244 -> 126;
                    case 245 -> 211;
                    case 246 -> 63;
                    case 247 -> 203;
                    case 248 -> 254;
                    case 249 -> 74;
                    case 250 -> 12;
                    case 251 -> 240;
                    case 252 -> 18;
                    case 253 -> 88;
                    case 254 -> 33;
                    default -> 142;
                };
                int n8 = ((n3 ^= n4) & 0xFF) - n7;
                if (n8 < 0) {
                    n8 += 256;
                }
                if ((n6 = ((n3 & 0xFFFF) >>> 8) - n7) < 0) {
                    n6 += 256;
                }
                int n9 = 0;
                while (n9 < cArray.length) {
                    int n10 = n9 % 2;
                    int n11 = n9;
                    char[] cArray2 = cArray;
                    char c2 = cArray[n11];
                    if (n10 == 0) {
                        cArray2[n11] = (char)(c2 ^ n8);
                        n8 = ((n8 >>> 3 | n8 << 5) ^ cArray[n9]) & 0xFF;
                    } else {
                        cArray2[n11] = (char)(c2 ^ n6);
                        n6 = ((n6 >>> 3 | n6 << 5) ^ cArray[n9]) & 0xFF;
                    }
                    ++n9;
                }
                PipeReadableByteChannel.b[n5] = new String(cArray).intern();
            }
            return b[n5];
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\b\u0010\n\u001a\u00020\u000bH\u0016J\b\u0010\f\u001a\u00020\rH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$PipeWritableByteChannel;", "Ljava/nio/channels/WritableByteChannel;", "agent", "Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc;", "WindowsNamedPipeAgentIpc$PipeWritableByteChannel", "(Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc;)V", "write", "", "src", "Ljava/nio/ByteBuffer;", "isOpen", "", "close", "", "intellij.platform.backend.split"})
    private static final class PipeWritableByteChannel
    implements WritableByteChannel {
        @NotNull
        private final WindowsNamedPipeAgentIpc agent;
        private static final String[] a;
        private static final String[] b;

        public PipeWritableByteChannel(@NotNull WindowsNamedPipeAgentIpc agent) {
            long l2 = 90871086063386L;
            Intrinsics.checkNotNullParameter((Object)agent, (String)PipeWritableByteChannel.a(-1831965390 + -25720, -1831965390 + -1144, (int)l2));
            this.agent = agent;
        }

        @Override
        public int write(@NotNull ByteBuffer src) {
            int n2;
            block7: {
                IntByReference intByReference;
                block8: {
                    long l2 = 52881088229479L;
                    boolean bl = SshAgentIpcService.C();
                    Intrinsics.checkNotNullParameter((Object)src, (String)PipeWritableByteChannel.a(1450813830 + (char)-448, 1450813830 + (char)-5245, (int)l2));
                    boolean bl2 = bl;
                    try {
                        if (!this.agent.isOpen()) {
                            throw new ClosedChannelException();
                        }
                    }
                    catch (RuntimeException runtimeException) {
                        throw PipeWritableByteChannel.a(runtimeException);
                    }
                    intByReference = new IntByReference();
                    byte[] byArray = new byte[src.remaining()];
                    try {
                        try {
                            src.get(byArray);
                            n2 = Kernel32.INSTANCE.WriteFile(this.agent.hPipe, byArray, byArray.length, intByReference, null);
                            if (bl2) break block7;
                            if (n2 != 0) break block8;
                        }
                        catch (RuntimeException runtimeException) {
                            throw PipeWritableByteChannel.a(runtimeException);
                        }
                        return -1;
                    }
                    catch (RuntimeException runtimeException) {
                        throw PipeWritableByteChannel.a(runtimeException);
                    }
                }
                n2 = intByReference.getValue();
            }
            return n2;
        }

        @Override
        public boolean isOpen() {
            boolean bl;
            long l2 = 58417534867517L;
            try {
                bl = this.agent.state == NamedPipeState.Connected;
            }
            catch (RuntimeException runtimeException) {
                throw PipeWritableByteChannel.a(runtimeException);
            }
            return bl;
        }

        @Override
        public void close() {
            this.agent.disconnect();
        }

        private static RuntimeException a(RuntimeException runtimeException) {
            return runtimeException;
        }

        /*
         * Unable to fully structure code
         */
        static {
            block13: {
                var5 = new String[2];
                var3_1 = 0;
                var2_2 = "\u009b\u00cc\u00d2\u00ed\u00ee\u0003(\u009a\u00f2";
                var4_3 = "\u009b\u00cc\u00d2\u00ed\u00ee\u0003(\u009a\u00f2".length();
                var1_4 = 5;
                var0_5 = -1;
lbl7:
                // 2 sources

                while (true) {
                    continue;
                    break;
                }
lbl9:
                // 1 sources

                while (true) {
                    var5[var3_1++] = new String(v0).intern();
                    if ((var0_5 += var1_4) < var4_3) {
                        var1_4 = var2_2.charAt(var0_5);
                        ** continue;
                    }
                    break block13;
                    break;
                }
                v1 = ++var0_5;
                v2 = var2_2.substring(v1, v1 + var1_4).toCharArray();
                v3 = v2.length;
                var6_6 = 0;
                v4 = 107;
                v5 = v2;
                v6 = v3;
                if (v3 > 1) ** GOTO lbl67
                do {
                    v7 = v4;
                    v5 = v5;
                    v8 = v5;
                    v9 = v4;
                    v10 = var6_6;
                    while (true) {
                        switch (var6_6 % 7) {
                            case 0: {
                                v11 = 39;
                                break;
                            }
                            case 1: {
                                v11 = 77;
                                break;
                            }
                            case 2: {
                                v11 = 107;
                                break;
                            }
                            case 3: {
                                v11 = 62;
                                break;
                            }
                            case 4: {
                                v11 = 98;
                                break;
                            }
                            case 5: {
                                v11 = 48;
                                break;
                            }
                            default: {
                                v11 = 27;
                            }
                        }
                        v8[v10] = (char)(v8[v10] ^ (v9 ^ v11));
                        ++var6_6;
                        v4 = v7;
                        if (v7 != 0) break;
                        v7 = v4;
                        v5 = v5;
                        v10 = v4;
                        v8 = v5;
                        v9 = v4;
                    }
lbl67:
                    // 2 sources

                    v0 = v5;
                    v6 = v6;
                } while (v6 > var6_6);
                ** while (true)
            }
            PipeWritableByteChannel.a = var5;
            PipeWritableByteChannel.b = new String[2];
        }

        private static String a(int n2, int n3, int n4) {
            int n5 = (n2 ^ n4 ^ 0x17A0) & 0xFFFF;
            if (b[n5] == null) {
                int n6;
                char[] cArray = a[n5].toCharArray();
                int n7 = switch (cArray[0] & 0xFF) {
                    case 0 -> 34;
                    case 1 -> 185;
                    case 2 -> 242;
                    case 3 -> 186;
                    case 4 -> 70;
                    case 5 -> 232;
                    case 6 -> 75;
                    case 7 -> 162;
                    case 8 -> 117;
                    case 9 -> 121;
                    case 10 -> 115;
                    case 11 -> 84;
                    case 12 -> 141;
                    case 13 -> 228;
                    case 14 -> 101;
                    case 15 -> 198;
                    case 16 -> 114;
                    case 17 -> 2;
                    case 18 -> 88;
                    case 19 -> 139;
                    case 20 -> 240;
                    case 21 -> 98;
                    case 22 -> 216;
                    case 23 -> 178;
                    case 24 -> 170;
                    case 25 -> 218;
                    case 26 -> 230;
                    case 27 -> 134;
                    case 28 -> 110;
                    case 29 -> 74;
                    case 30 -> 13;
                    case 31 -> 174;
                    case 32 -> 123;
                    case 33 -> 50;
                    case 34 -> 100;
                    case 35 -> 82;
                    case 36 -> 94;
                    case 37 -> 151;
                    case 38 -> 44;
                    case 39 -> 193;
                    case 40 -> 30;
                    case 41 -> 59;
                    case 42 -> 255;
                    case 43 -> 201;
                    case 44 -> 26;
                    case 45 -> 95;
                    case 46 -> 171;
                    case 47 -> 103;
                    case 48 -> 47;
                    case 49 -> 40;
                    case 50 -> 64;
                    case 51 -> 120;
                    case 52 -> 229;
                    case 53 -> 161;
                    case 54 -> 15;
                    case 55 -> 36;
                    case 56 -> 11;
                    case 57 -> 130;
                    case 58 -> 199;
                    case 59 -> 18;
                    case 60 -> 46;
                    case 61 -> 90;
                    case 62 -> 158;
                    case 63 -> 81;
                    case 64 -> 27;
                    case 65 -> 107;
                    case 66 -> 188;
                    case 67 -> 19;
                    case 68 -> 58;
                    case 69 -> 148;
                    case 70 -> 38;
                    case 71 -> 10;
                    case 72 -> 31;
                    case 73 -> 43;
                    case 74 -> 72;
                    case 75 -> 172;
                    case 76 -> 207;
                    case 77 -> 69;
                    case 78 -> 150;
                    case 79 -> 96;
                    case 80 -> 191;
                    case 81 -> 177;
                    case 82 -> 164;
                    case 83 -> 212;
                    case 84 -> 226;
                    case 85 -> 53;
                    case 86 -> 168;
                    case 87 -> 78;
                    case 88 -> 195;
                    case 89 -> 156;
                    case 90 -> 20;
                    case 91 -> 208;
                    case 92 -> 137;
                    case 93 -> 182;
                    case 94 -> 73;
                    case 95 -> 152;
                    case 96 -> 213;
                    case 97 -> 142;
                    case 98 -> 125;
                    case 99 -> 165;
                    case 100 -> 87;
                    case 101 -> 167;
                    case 102 -> 166;
                    case 103 -> 235;
                    case 104 -> 187;
                    case 105 -> 241;
                    case 106 -> 71;
                    case 107 -> 49;
                    case 108 -> 109;
                    case 109 -> 16;
                    case 110 -> 127;
                    case 111 -> 175;
                    case 112 -> 211;
                    case 113 -> 6;
                    case 114 -> 200;
                    case 115 -> 202;
                    case 116 -> 132;
                    case 117 -> 9;
                    case 118 -> 21;
                    case 119 -> 224;
                    case 120 -> 219;
                    case 121 -> 51;
                    case 122 -> 179;
                    case 123 -> 102;
                    case 124 -> 8;
                    case 125 -> 136;
                    case 126 -> 108;
                    case 127 -> 7;
                    case 128 -> 214;
                    case 129 -> 91;
                    case 130 -> 126;
                    case 131 -> 23;
                    case 132 -> 248;
                    case 133 -> 209;
                    case 134 -> 83;
                    case 135 -> 12;
                    case 136 -> 181;
                    case 137 -> 14;
                    case 138 -> 204;
                    case 139 -> 62;
                    case 140 -> 144;
                    case 141 -> 252;
                    case 142 -> 155;
                    case 143 -> 223;
                    case 144 -> 184;
                    case 145 -> 85;
                    case 146 -> 52;
                    case 147 -> 133;
                    case 148 -> 149;
                    case 149 -> 106;
                    case 150 -> 39;
                    case 151 -> 217;
                    case 152 -> 143;
                    case 153 -> 157;
                    case 154 -> 67;
                    case 155 -> 254;
                    case 156 -> 251;
                    case 157 -> 61;
                    case 158 -> 189;
                    case 159 -> 76;
                    case 160 -> 41;
                    case 161 -> 97;
                    case 162 -> 238;
                    case 163 -> 77;
                    case 164 -> 250;
                    case 165 -> 119;
                    case 166 -> 245;
                    case 167 -> 244;
                    case 168 -> 140;
                    case 169 -> 1;
                    case 170 -> 183;
                    case 171 -> 63;
                    case 172 -> 48;
                    case 173 -> 176;
                    case 174 -> 131;
                    case 175 -> 222;
                    case 176 -> 89;
                    case 177 -> 215;
                    case 178 -> 92;
                    case 179 -> 32;
                    case 180 -> 192;
                    case 181 -> 236;
                    case 182 -> 221;
                    case 183 -> 146;
                    case 184 -> 225;
                    case 185 -> 154;
                    case 186 -> 17;
                    case 187 -> 246;
                    case 188 -> 4;
                    case 189 -> 194;
                    case 190 -> 113;
                    case 191 -> 66;
                    case 192 -> 54;
                    case 193 -> 138;
                    case 194 -> 173;
                    case 195 -> 210;
                    case 196 -> 203;
                    case 197 -> 5;
                    case 198 -> 99;
                    case 199 -> 145;
                    case 200 -> 124;
                    case 201 -> 153;
                    case 202 -> 65;
                    case 203 -> 243;
                    case 204 -> 116;
                    case 205 -> 147;
                    case 206 -> 86;
                    case 207 -> 249;
                    case 208 -> 105;
                    case 209 -> 128;
                    case 210 -> 37;
                    case 211 -> 55;
                    case 212 -> 122;
                    case 213 -> 0;
                    case 214 -> 190;
                    case 215 -> 234;
                    case 216 -> 206;
                    case 217 -> 160;
                    case 218 -> 29;
                    case 219 -> 111;
                    case 220 -> 233;
                    case 221 -> 68;
                    case 222 -> 3;
                    case 223 -> 112;
                    case 224 -> 231;
                    case 225 -> 220;
                    case 226 -> 45;
                    case 227 -> 118;
                    case 228 -> 197;
                    case 229 -> 169;
                    case 230 -> 239;
                    case 231 -> 205;
                    case 232 -> 22;
                    case 233 -> 56;
                    case 234 -> 80;
                    case 235 -> 247;
                    case 236 -> 35;
                    case 237 -> 129;
                    case 238 -> 180;
                    case 239 -> 57;
                    case 240 -> 227;
                    case 241 -> 237;
                    case 242 -> 163;
                    case 243 -> 33;
                    case 244 -> 79;
                    case 245 -> 93;
                    case 246 -> 28;
                    case 247 -> 159;
                    case 248 -> 104;
                    case 249 -> 135;
                    case 250 -> 253;
                    case 251 -> 196;
                    case 252 -> 60;
                    case 253 -> 42;
                    case 254 -> 24;
                    default -> 25;
                };
                int n8 = ((n3 ^= n4) & 0xFF) - n7;
                if (n8 < 0) {
                    n8 += 256;
                }
                if ((n6 = ((n3 & 0xFFFF) >>> 8) - n7) < 0) {
                    n6 += 256;
                }
                int n9 = 0;
                while (n9 < cArray.length) {
                    int n10 = n9 % 2;
                    int n11 = n9;
                    char[] cArray2 = cArray;
                    char c2 = cArray[n11];
                    if (n10 == 0) {
                        cArray2[n11] = (char)(c2 ^ n8);
                        n8 = ((n8 >>> 3 | n8 << 5) ^ cArray[n9]) & 0xFF;
                    } else {
                        cArray2[n11] = (char)(c2 ^ n6);
                        n6 = ((n6 >>> 3 | n6 << 5) ^ cArray[n9]) & 0xFF;
                    }
                    ++n9;
                }
                PipeWritableByteChannel.b[n5] = new String(cArray).intern();
            }
            return b[n5];
        }
    }
}

