/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.inline.completion.php;

import com.intellij.ml.inline.completion.impl.kit.MLCompletionMultilineSupporter;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.util.Condition;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiTreeUtilKt;
import com.jetbrains.php.codeInsight.PhpCodeInsightUtil;
import com.jetbrains.php.lang.lexer.PhpTokenTypes;
import com.jetbrains.php.lang.parser.PhpElementTypes;
import com.jetbrains.php.lang.psi.PhpFile;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.Else;
import com.jetbrains.php.lang.psi.elements.ElseIf;
import com.jetbrains.php.lang.psi.elements.Field;
import com.jetbrains.php.lang.psi.elements.For;
import com.jetbrains.php.lang.psi.elements.ForeachStatement;
import com.jetbrains.php.lang.psi.elements.Function;
import com.jetbrains.php.lang.psi.elements.GroupStatement;
import com.jetbrains.php.lang.psi.elements.If;
import com.jetbrains.php.lang.psi.elements.Parameter;
import com.jetbrains.php.lang.psi.elements.ParameterList;
import com.jetbrains.php.lang.psi.elements.PhpClass;
import com.jetbrains.php.lang.psi.elements.PhpPropertyHook;
import com.jetbrains.php.lang.psi.elements.PhpPsiElement;
import com.jetbrains.php.lang.psi.elements.Statement;
import com.jetbrains.php.lang.psi.elements.While;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J \u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0010\u0010\u0011\u001a\u00020\f2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0018\u0010\u0012\u001a\u00020\n2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J \u0010\u0015\u001a\u00020\n2\u0006\u0010\u0013\u001a\u00020\u00162\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0010\u0010\u0017\u001a\u00020\n2\u0006\u0010\u0013\u001a\u00020\u0018H\u0002J\u0018\u0010\u0019\u001a\u00020\n2\u0006\u0010\u0013\u001a\u00020\u001a2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0018\u0010\u001b\u001a\u00020\n2\u0006\u0010\u0013\u001a\u00020\u001c2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0018\u0010\u001d\u001a\u00020\n2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0018\u0010 \u001a\u00020\n2\u0006\u0010!\u001a\u00020\"2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u000e\u0010#\u001a\u0004\u0018\u00010\f*\u00020\fH\u0002R\u001e\u0010\u0004\u001a\u0010\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\u00070\u00060\u0005X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\b\u00a8\u0006$"}, d2={"Lcom/intellij/ml/inline/completion/php/PhpMultilineSupporter;", "Lcom/intellij/ml/inline/completion/impl/kit/MLCompletionMultilineSupporter;", "<init>", "()V", "parenScopeClasses", "", "Ljava/lang/Class;", "Lcom/jetbrains/php/lang/psi/elements/PhpPsiElement;", "[Ljava/lang/Class;", "isMultilineSuitable", "", "element", "Lcom/intellij/psi/PsiElement;", "document", "Lcom/intellij/openapi/editor/Document;", "offset", "", "getCurrentElement", "checkGroupStatement", "parent", "Lcom/jetbrains/php/lang/psi/elements/GroupStatement;", "checkPhpClass", "Lcom/jetbrains/php/lang/psi/elements/PhpClass;", "checkFunction", "Lcom/jetbrains/php/lang/psi/elements/Function;", "checkStatement", "Lcom/jetbrains/php/lang/psi/elements/Statement;", "checkPhpFile", "Lcom/jetbrains/php/lang/psi/PhpFile;", "checkField", "field", "Lcom/jetbrains/php/lang/psi/elements/Field;", "checkParameterList", "parameterList", "Lcom/jetbrains/php/lang/psi/elements/ParameterList;", "getNearestParent", "intellij.ml.inline.completion.php"})
public final class PhpMultilineSupporter
implements MLCompletionMultilineSupporter {
    @NotNull
    private final Class<? extends PhpPsiElement>[] parenScopeClasses;

    public PhpMultilineSupporter() {
        Class[] classArray = new Class[]{PhpClass.class, Field.class, Function.class, Statement.class, ParameterList.class, PhpFile.class, GroupStatement.class};
        this.parenScopeClasses = classArray;
    }

    @Override
    public boolean isMultilineSuitable(@NotNull PsiElement element, @NotNull Document document, int offset) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)document, (String)"document");
        PsiElement currentElement = this.getCurrentElement(element);
        PsiElement psiElement = this.getNearestParent(currentElement);
        if (psiElement == null) {
            return false;
        }
        PsiElement parent = psiElement;
        PsiElement psiElement2 = parent;
        return psiElement2 instanceof PhpFile ? this.checkPhpFile((PhpFile)parent, offset) : (psiElement2 instanceof PhpClass ? this.checkPhpClass((PhpClass)parent, currentElement, offset) : (psiElement2 instanceof Field ? this.checkField((Field)parent, offset) : (psiElement2 instanceof Function ? this.checkFunction((Function)parent) : (psiElement2 instanceof GroupStatement ? this.checkGroupStatement((GroupStatement)parent, offset) : (psiElement2 instanceof Statement ? this.checkStatement((Statement)parent, offset) : (psiElement2 instanceof ParameterList ? this.checkParameterList((ParameterList)parent, offset) : false))))));
    }

    private final PsiElement getCurrentElement(PsiElement element) {
        PsiElement prev;
        if (PhpPsiUtil.isOfType((PsiElement)element, (IElementType)PhpTokenTypes.chRPAREN) && ((prev = PhpPsiUtil.getPrevSiblingIgnoreWhitespace((PsiElement)element, (boolean)true)) instanceof Parameter || PhpPsiUtil.isOfType((PsiElement)prev, (IElementType)PhpTokenTypes.opCOMMA))) {
            PsiElement psiElement = element.getPrevSibling();
            Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"getPrevSibling(...)");
            return psiElement;
        }
        return element;
    }

    private final boolean checkGroupStatement(GroupStatement parent, int offset) {
        if (parent.getParent() instanceof PhpFile) {
            return true;
        }
        PsiElement psiElement = parent.getParent();
        Function function = psiElement instanceof Function ? (Function)psiElement : null;
        if (function == null) {
            return false;
        }
        Function function2 = function;
        if (PhpCodeInsightUtil.isEmptyBody((Function)function2)) {
            return true;
        }
        PsiElement[] psiElementArray = parent.getStatements();
        Intrinsics.checkNotNullExpressionValue((Object)psiElementArray, (String)"getStatements(...)");
        PsiElement psiElement2 = (PsiElement)ArraysKt.lastOrNull((Object[])psiElementArray);
        if (psiElement2 == null) {
            return true;
        }
        PsiElement lastStatement = psiElement2;
        return offset >= lastStatement.getTextRange().getEndOffset();
    }

    private final boolean checkPhpClass(PhpClass parent, PsiElement element, int offset) {
        if (parent.getNameIdentifier() == null) {
            return true;
        }
        if (element.getParent() instanceof PhpClass) {
            return true;
        }
        PsiElement lastChild = parent.getLastChild();
        Statement statement = (Statement)PhpPsiUtil.getPrevSiblingByCondition((PsiElement)lastChild, (Condition)Statement.INSTANCEOF);
        if (statement == null) {
            return true;
        }
        Statement statement2 = statement;
        return offset >= statement2.getTextRange().getEndOffset();
    }

    private final boolean checkFunction(Function parent) {
        if (parent.getNameIdentifier() == null) {
            return true;
        }
        return PhpCodeInsightUtil.isEmptyBody((Function)parent);
    }

    private final boolean checkStatement(Statement parent, int offset) {
        if (parent instanceof If || parent instanceof ElseIf || parent instanceof Else || parent instanceof While || parent instanceof For || parent instanceof ForeachStatement) {
            return PhpPsiUtil.getChildByCondition((PsiElement)((PsiElement)parent), (Condition)GroupStatement.INSTANCEOF) == null;
        }
        return offset >= PsiTreeUtilKt.getEndOffset((PsiElement)((PsiElement)parent));
    }

    private final boolean checkPhpFile(PhpFile parent, int offset) {
        return offset >= PsiTreeUtilKt.getEndOffset((PsiElement)((PsiElement)parent));
    }

    private final boolean checkField(Field field, int offset) {
        PsiElement lastChild = field.getLastChild();
        if (PhpPsiUtil.isOfType((PsiElement)lastChild, (IElementType)PhpElementTypes.PROPERTY_HOOKS) && PhpPsiUtil.getChildByCondition((PsiElement)lastChild, (Condition)PhpPropertyHook.INSTANCEOF) == null) {
            return true;
        }
        Intrinsics.checkNotNull((Object)lastChild);
        return offset >= PsiTreeUtilKt.getEndOffset((PsiElement)lastChild);
    }

    private final boolean checkParameterList(ParameterList parameterList, int offset) {
        PsiElement psiElement = parameterList.getParent();
        Function function = psiElement instanceof Function ? (Function)psiElement : null;
        if (function == null) {
            return false;
        }
        Function function2 = function;
        if (!PhpCodeInsightUtil.isEmptyBody((Function)function2)) {
            return false;
        }
        PsiElement[] psiElementArray = parameterList.getParameters();
        Intrinsics.checkNotNullExpressionValue((Object)psiElementArray, (String)"getParameters(...)");
        PsiElement psiElement2 = (PsiElement)ArraysKt.lastOrNull((Object[])psiElementArray);
        if (psiElement2 == null) {
            return true;
        }
        PsiElement lastParameter = psiElement2;
        return offset >= lastParameter.getTextRange().getEndOffset();
    }

    private final PsiElement getNearestParent(PsiElement $this$getNearestParent) {
        Class<? extends PhpPsiElement>[] classArray = this.parenScopeClasses;
        return PsiTreeUtil.getParentOfType((PsiElement)$this$getNearestParent, (boolean)false, (Class[])Arrays.copyOf(classArray, classArray.length));
    }
}

